/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.impl;

import org.jacorb.config.Configuration;
import org.jacorb.notification.filter.ETCLEvaluator;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.slf4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CosNotification.Property;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.DynUnionHelper;

public class DefaultETCLEvaluator
implements ETCLEvaluator {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private final Logger logger_;
    private final DynAnyFactory dynAnyFactory_;
    private final ORB orb_;
    private final Any TRUE_ANY;
    private final Any FALSE_ANY;

    public DefaultETCLEvaluator(ORB oRB, Configuration configuration, DynAnyFactory dynAnyFactory) {
        this.orb_ = oRB;
        this.logger_ = configuration.getLogger(this.getClass().getName());
        this.dynAnyFactory_ = dynAnyFactory;
        this.TRUE_ANY = this.orb_.create_any();
        this.FALSE_ANY = this.orb_.create_any();
        this.TRUE_ANY.insert_boolean(true);
        this.FALSE_ANY.insert_boolean(false);
    }

    public boolean hasDefaultDiscriminator(Any any) throws EvaluationException {
        try {
            return any.type().default_index() != -1;
        }
        catch (BadKind badKind) {
            throw DefaultETCLEvaluator.newEvaluationException(badKind);
        }
    }

    public Any evaluateExistIdentifier(Any any, String string) throws EvaluationException {
        try {
            this.evaluateIdentifier(any, string);
            return this.TRUE_ANY;
        }
        catch (EvaluationException evaluationException) {
            return this.FALSE_ANY;
        }
    }

    public Any evaluateTypeName(Any any) throws EvaluationException {
        try {
            TypeCode typeCode = any.type();
            Any any2 = this.orb_.create_any();
            any2.insert_string(typeCode.name());
            return any2;
        }
        catch (BadKind badKind) {
            throw DefaultETCLEvaluator.newEvaluationException(badKind);
        }
    }

    public Any evaluateRepositoryId(Any any) throws EvaluationException {
        try {
            TypeCode typeCode = any.type();
            Any any2 = this.orb_.create_any();
            any2.insert_string(typeCode.id());
            return any2;
        }
        catch (BadKind badKind) {
            throw DefaultETCLEvaluator.newEvaluationException(badKind);
        }
    }

    public Any evaluateListLength(Any any) throws EvaluationException {
        int n;
        IDLEntity iDLEntity;
        switch (any.type().kind().value()) {
            case 20: {
                iDLEntity = this.toDynAny(any);
                n = iDLEntity.component_count();
                break;
            }
            case 19: {
                DynSequence dynSequence = this.toDynSequence(any);
                n = dynSequence.get_length();
                break;
            }
            default: {
                throw new EvaluationException("Neither array nor sequence");
            }
        }
        iDLEntity = this.orb_.create_any();
        ((Any)iDLEntity).insert_long(n);
        return iDLEntity;
    }

    private String getDefaultUnionMemberName(TypeCode typeCode) throws EvaluationException {
        try {
            int n = typeCode.default_index();
            if (n != -1) {
                return typeCode.member_name(n);
            }
        }
        catch (BadKind badKind) {
            throw DefaultETCLEvaluator.newEvaluationException(badKind);
        }
        catch (Bounds bounds) {
            throw DefaultETCLEvaluator.newEvaluationException(bounds);
        }
        throw new EvaluationException();
    }

    private String getUnionMemberNameFromDiscriminator(TypeCode typeCode, int n) throws EvaluationException {
        try {
            Any any = this.orb_.create_any();
            switch (typeCode.discriminator_type().kind().value()) {
                case 3: {
                    any.insert_long(n);
                    break;
                }
                case 5: {
                    any.insert_ulong(n);
                    break;
                }
                case 2: {
                    any.insert_short((short)n);
                    break;
                }
                case 7: {
                    any.insert_double(n);
                    break;
                }
                case 4: {
                    any.insert_ushort((short)n);
                }
            }
            int n2 = typeCode.member_count();
            try {
                for (int i = 0; i < n2; ++i) {
                    if (!any.equal(typeCode.member_label(i))) continue;
                    return typeCode.member_name(i);
                }
            }
            catch (Bounds bounds) {
                throw new RuntimeException();
            }
        }
        catch (BadKind badKind) {
            throw DefaultETCLEvaluator.newEvaluationException(badKind);
        }
        throw new EvaluationException();
    }

    public Any evaluateUnion(Any any) throws EvaluationException {
        String string = this.getDefaultUnionMemberName(any.type());
        return this.evaluateIdentifier(any, string);
    }

    public Any evaluateUnion(Any any, int n) throws EvaluationException {
        DynUnion dynUnion = this.toDynUnion(any);
        dynUnion.seek(0);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extract idx: " + n + " from Union " + dynUnion.type());
        }
        String string = this.getUnionMemberNameFromDiscriminator(any.type(), n);
        return this.evaluateIdentifier((DynAny)dynUnion, string);
    }

    public Any evaluatePropertyList(Property[] propertyArray, String string) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluatePropertyList " + propertyArray);
            this.logger_.debug("list length: " + propertyArray.length);
        }
        for (int i = 0; i < propertyArray.length; ++i) {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug(i + ": " + propertyArray[i].name + " => " + propertyArray[i].value);
            }
            if (!string.equals(propertyArray[i].name)) continue;
            return propertyArray[i].value;
        }
        return null;
    }

    public Any evaluateNamedValueList(Any any, String string) throws EvaluationException {
        try {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluateNamedValueList(" + any + ", " + string + ")");
            }
            DynAny dynAny = this.toDynAny(any);
            int n = dynAny.component_count();
            Any any2 = null;
            dynAny.rewind();
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("Entries: " + n);
            }
            for (int i = 0; i < n; ++i) {
                dynAny.seek(i);
                DynAny dynAny2 = dynAny.current_component();
                any2 = this.evaluateNamedValue(dynAny2, string);
                if (any2 != null) break;
            }
            return any2;
        }
        catch (TypeMismatch typeMismatch) {
            throw DefaultETCLEvaluator.newEvaluationException(typeMismatch);
        }
    }

    private Any evaluateNamedValue(DynAny dynAny, String string) throws EvaluationException {
        Any any;
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluate assoc " + string + " on a Any of type: " + dynAny.type());
        }
        String string2 = this.evaluateIdentifier(dynAny, NAME).extract_string();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("test if " + string + " == " + string2);
        }
        if (string.equals(string2)) {
            this.logger_.debug("YES");
            any = this.evaluateIdentifier(dynAny, VALUE);
        } else {
            any = null;
        }
        return any;
    }

    public Any evaluateArrayIndex(Any any, int n) throws EvaluationException {
        try {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluate array idx " + n + " on a Any of type: " + any.type());
            }
            DynAny dynAny = this.toDynAny(any);
            dynAny.rewind();
            dynAny.seek(n);
            DynAny dynAny2 = dynAny.current_component();
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluation result is of type: " + dynAny2.type());
            }
            return dynAny2.to_any();
        }
        catch (TypeMismatch typeMismatch) {
            throw DefaultETCLEvaluator.newEvaluationException(typeMismatch);
        }
    }

    private Any evaluateIdentifier(DynAny dynAny, int n) throws EvaluationException {
        try {
            DynAny dynAny2;
            switch (dynAny.type().kind().value()) {
                case 15: {
                    dynAny.seek(n);
                    dynAny2 = dynAny.current_component();
                    break;
                }
                default: {
                    throw new EvaluationException("attempt to access member on non-struct");
                }
            }
            return dynAny2.to_any();
        }
        catch (TypeMismatch typeMismatch) {
            throw DefaultETCLEvaluator.newEvaluationException(typeMismatch);
        }
    }

    public Any evaluateIdentifier(Any any, int n) throws EvaluationException {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluate idx " + n + " on Any");
        }
        DynAny dynAny = this.toDynAny(any);
        return this.evaluateIdentifier(dynAny, n);
    }

    public Any evaluateDiscriminator(Any any) throws EvaluationException {
        switch (any.type().kind().value()) {
            case 16: {
                DynUnion dynUnion = this.toDynUnion(any);
                return dynUnion.get_discriminator().to_any();
            }
        }
        throw new EvaluationException("any does not contain member _d");
    }

    public EvaluationResult evaluateElementInSequence(EvaluationContext evaluationContext, EvaluationResult evaluationResult, Any any) throws EvaluationException {
        try {
            DynSequence dynSequence = DynSequenceHelper.narrow(this.toDynAny(any));
            dynSequence.rewind();
            do {
                DynAny dynAny;
                EvaluationResult evaluationResult2;
                if (evaluationResult.compareTo(evaluationResult2 = EvaluationResult.fromAny((dynAny = dynSequence.current_component()).to_any())) != 0) continue;
                return EvaluationResult.BOOL_TRUE;
            } while (dynSequence.next());
            return EvaluationResult.BOOL_FALSE;
        }
        catch (TypeMismatch typeMismatch) {
            throw DefaultETCLEvaluator.newEvaluationException(typeMismatch);
        }
    }

    public Any evaluateIdentifier(Any any, String string) throws EvaluationException {
        DynAny dynAny = this.toDynAny(any);
        return this.evaluateIdentifier(dynAny, string);
    }

    private Any evaluateIdentifier(DynAny dynAny, String string) throws EvaluationException {
        try {
            String string2 = DefaultETCLEvaluator.stripBackslash(string);
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluate " + string2 + " on Any");
            }
            DynAny dynAny2 = dynAny;
            block1 : switch (dynAny.type().kind().value()) {
                case 15: {
                    this.logger_.debug("Any is a struct");
                    DynStruct dynStruct = DynStructHelper.narrow(dynAny);
                    dynStruct.rewind();
                    do {
                        String string3 = dynStruct.current_member_name();
                        if (this.logger_.isDebugEnabled()) {
                            this.logger_.debug(" => " + string3);
                        }
                        if (!string3.equals(string2)) continue;
                        dynAny2 = dynStruct.current_component();
                        break block1;
                    } while (dynStruct.next());
                    throw new EvaluationException("struct has no member " + string2);
                }
                case 16: {
                    DynUnion dynUnion;
                    if (this.logger_.isDebugEnabled()) {
                        this.logger_.debug("Any is a Union");
                    }
                    if ((dynUnion = this.toDynUnion(dynAny)).member_name().equals(string2)) {
                        dynAny2 = dynUnion.member();
                        break;
                    }
                    if (this.logger_.isDebugEnabled()) {
                        this.logger_.debug(dynUnion.member_name() + " != " + string2);
                    }
                    throw new EvaluationException("member " + string2 + " is not active on struct");
                }
                case 11: {
                    this.logger_.debug("encapsulated any");
                    return this.evaluateIdentifier(dynAny.get_any(), string2);
                }
                default: {
                    this.logger_.debug("unknown " + dynAny.type());
                    return null;
                }
            }
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("Result: " + dynAny2);
            }
            if (dynAny2 != null && this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluation result is of type: " + dynAny2.type());
            }
            if (dynAny2 == null) {
                this.logger_.debug("Member not found");
                throw new EvaluationException("member not found");
            }
            return dynAny2.to_any();
        }
        catch (InvalidValue invalidValue) {
            throw DefaultETCLEvaluator.newEvaluationException(invalidValue);
        }
        catch (TypeMismatch typeMismatch) {
            throw DefaultETCLEvaluator.newEvaluationException(typeMismatch);
        }
    }

    private DynAny toDynAny(Any any) throws EvaluationException {
        try {
            return this.dynAnyFactory_.create_dyn_any(any);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            throw DefaultETCLEvaluator.newEvaluationException(inconsistentTypeCode);
        }
    }

    private DynUnion toDynUnion(Any any) throws EvaluationException {
        return DynUnionHelper.narrow(this.toDynAny(any));
    }

    private DynUnion toDynUnion(DynAny dynAny) {
        return DynUnionHelper.narrow(dynAny);
    }

    private DynSequence toDynSequence(Any any) throws EvaluationException {
        return DynSequenceHelper.narrow(this.toDynAny(any));
    }

    private static String stripBackslash(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '\\') continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static EvaluationException newEvaluationException(Exception exception) {
        return new EvaluationException(exception.toString());
    }
}

