/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.EmptyQueueException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.joram.mom.dest.DistributionHandler;
import org.objectweb.joram.mom.dest.DistributionQueue;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.dest.TxDestination;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DistributionDaemon
extends Daemon {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)DistributionDaemon.class.getName());
    private DistributionHandler distributionHandler;
    private fr.dyade.aaa.common.Queue distributeQueue;
    private fr.dyade.aaa.common.Queue ackQueue;
    private TxDestination txDest;

    public DistributionDaemon(DistributionHandler distributionHandler, String destinationName, TxDestination txDest) {
        super("DistributionDaemon_" + destinationName, logger);
        this.distributionHandler = distributionHandler;
        this.distributeQueue = new fr.dyade.aaa.common.Queue();
        this.ackQueue = new fr.dyade.aaa.common.Queue();
        this.txDest = txDest;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon<> distributionHandler = " + distributionHandler + ", txDest = " + txDest));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"DistributionDaemon run()");
        }
        while (this.running) {
            this.canStop = true;
            Message msg = null;
            try {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon run: distributeQueue.size() = " + this.distributeQueue.size()));
                }
                msg = (Message)this.distributeQueue.get();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon run: distributeQueue.get() = " + msg.id));
                }
                if (this.isUndeliverable(msg)) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon run: the message " + msg.id + " is undeliverable."));
                    }
                    this.distributeQueue.pop();
                    continue;
                }
            }
            catch (InterruptedException exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
                return;
            }
            this.canStop = false;
            try {
                this.distributionHandler.distribute(msg);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon run: distributeQueue.pop = " + msg.id));
                }
                this.distributeQueue.pop();
                this.ackQueue.push((Object)msg.id);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon run: ackQueue.push : " + msg.id));
                }
                String txName = this.txDest.getTxName(msg.id);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon run: txName(" + msg.id + ")=" + txName));
                }
                if (txName != null) {
                    org.objectweb.joram.mom.messages.Message momMsg = new org.objectweb.joram.mom.messages.Message(msg);
                    momMsg.setTxName(txName);
                    momMsg.delete();
                    AgentServer.getTransaction().begin();
                    AgentServer.getTransaction().commit(true);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon run: " + msg.id + " deleted."));
                    continue;
                }
                if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                logger.log(BasicLevel.ERROR, (Object)("DistributionDaemon run: txName == null for msg " + msg.id + " can't be delete."));
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"DistributionDaemon run()", (Throwable)e);
                }
                if (e instanceof EmptyQueueException) continue;
                this.incDeliveryCount(msg);
                this.canStop = true;
                DistributionDaemon distributionDaemon = this;
                synchronized (distributionDaemon) {
                    block23: {
                        try {
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)"DistributionDaemon run: wait.");
                            }
                            ((Object)((Object)this)).wait();
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)"DistributionDaemon run: wakeup.");
                            }
                        }
                        catch (InterruptedException e1) {
                            if (!logger.isLoggable(BasicLevel.DEBUG)) break block23;
                            logger.log(BasicLevel.DEBUG, (Object)"DistributionDaemon run wait InterruptedException.");
                        }
                    }
                }
            }
        }
    }

    protected void shutdown() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"DistributionDaemon shutdown()");
        }
    }

    protected void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"DistributionDaemon close()");
        }
        this.distributeQueue.clear();
        this.ackQueue.clear();
        this.distributeQueue.close();
        this.ackQueue.close();
    }

    public void push(Message msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon distributeQueue.push(" + msg.id + ')'));
        }
        this.distributeQueue.push((Object)msg);
    }

    public List getAckList() {
        ArrayList<Object> ackList = new ArrayList<Object>();
        while (!this.ackQueue.isEmpty()) {
            try {
                ackList.add(this.ackQueue.getAndPop());
            }
            catch (InterruptedException interruptedException) {}
        }
        return ackList;
    }

    public boolean isEmpty() {
        return this.distributeQueue.isEmpty();
    }

    private boolean isUndeliverable(Message message) {
        if (!this.isValid(message)) {
            return true;
        }
        int threshold = 0;
        if (this.txDest instanceof DistributionQueue) {
            threshold = ((DistributionQueue)this.txDest).getThreshold();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionDaemon isUndeliverable: deliveryCount = " + message.deliveryCount + ", threshold = " + threshold));
        }
        if (threshold == 0) {
            return false;
        }
        if (threshold > 0) {
            return message.deliveryCount >= threshold;
        }
        if (Queue.getDefaultThreshold() > 0) {
            return message.deliveryCount >= Queue.getDefaultThreshold();
        }
        return false;
    }

    private boolean isValid(Message message) {
        return message.expiration <= 0L || message.expiration > System.currentTimeMillis();
    }

    private void incDeliveryCount(Message message) {
        ++message.deliveryCount;
    }
}

