/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.common.Debug;
import java.util.List;
import java.util.Properties;
import org.objectweb.joram.mom.dest.DistributionDaemon;
import org.objectweb.joram.mom.dest.DistributionModule;
import org.objectweb.joram.mom.dest.Topic;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DistributionTopic
extends Topic {
    public static Logger logger = Debug.getLogger((String)DistributionTopic.class.getName());
    private static final long serialVersionUID = 1L;
    private transient DistributionModule distributionModule;
    private String distributionClassName;
    private Properties properties;
    private transient DistributionDaemon distributionDaemon;
    private boolean isAsyncDistribution;

    public void setProperties(Properties properties, boolean firstTime) throws Exception {
        super.setProperties(properties, firstTime);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionTopic.<init> prop = " + properties));
        }
        this.properties = properties;
        if (properties != null) {
            this.isAsyncDistribution = this.isAsyncDistribution(properties);
        }
        if (firstTime) {
            if (properties != null) {
                this.distributionClassName = properties.getProperty("distribution.className");
                properties.remove("distribution.className");
            }
            if (this.distributionClassName == null) {
                throw new RequestException("Distribution class name not found: distribution.className property must be set on topic creation.");
            }
            try {
                Class.forName(this.distributionClassName).getConstructor(new Class[0]);
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)"DistributionTopic: error with distribution class.", (Throwable)exc);
                throw new RequestException(exc.getMessage());
            }
        } else {
            this.distributionModule.setProperties(properties, firstTime);
            if (this.distributionDaemon == null && this.isAsyncDistribution) {
                this.distributionDaemon = new DistributionDaemon(this.distributionModule.getDistributionHandler(), this.getName(), this);
                this.distributionDaemon.start();
            } else if (this.distributionDaemon != null && !this.isAsyncDistribution) {
                this.distributionDaemon.close();
                this.distributionDaemon = null;
            }
        }
    }

    private boolean isAsyncDistribution(Properties properties) {
        if (properties.containsKey("distribution.async")) {
            try {
                return ConversionHelper.toBoolean((Object)properties.get("distribution.async"));
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"DistributionModule: can't parse DaemonDistribution option.", (Throwable)exc);
            }
        }
        return false;
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
        if (this.distributionModule == null) {
            this.distributionModule = new DistributionModule(this.distributionClassName, this.properties, firstTime);
        }
        if (this.properties != null) {
            this.isAsyncDistribution = this.isAsyncDistribution(this.properties);
        }
        if (this.distributionDaemon == null && this.isAsyncDistribution) {
            this.distributionDaemon = new DistributionDaemon(this.distributionModule.getDistributionHandler(), this.getName(), this);
            this.distributionDaemon.start();
        }
    }

    public void agentFinalize(boolean lastTime) {
        super.agentFinalize(lastTime);
        if (this.distributionModule != null) {
            this.distributionModule.close();
        }
        if (this.distributionDaemon != null) {
            this.distributionDaemon.close();
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionTopic. preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        List msgs = cm.getMessages();
        DMQManager dmqManager = null;
        for (int i = 0; i < msgs.size(); ++i) {
            Message msg = (Message)msgs.get(i);
            try {
                this.distributionModule.processMessage(msg);
                ++this.nbMsgsDeliverSinceCreation;
                continue;
            }
            catch (Exception exc) {
                if (!this.isAsyncDistribution) {
                    if (logger.isLoggable(BasicLevel.WARN)) {
                        logger.log(BasicLevel.WARN, (Object)"DistributionTopic: distribution error.", (Throwable)exc);
                    }
                } else if (this.distributionDaemon != null) {
                    this.distributionDaemon.push(msg);
                } else if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"DistributionTopic.preProcess: distribution distributionDaemon = null but we are in async distribution mode.", (Throwable)exc);
                }
                if (dmqManager == null) {
                    dmqManager = new DMQManager(cm.getDMQId(), this.getDMQAgentId(), this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(msg, (short)2);
            }
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        return null;
    }

    protected void postProcess(ClientMessages msgs) {
        super.postProcess(msgs);
        if (this.distributionDaemon != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"DistributionTopic postProcess(...)");
            }
            this.distributionDaemon.getAckList();
        }
    }

    public String toString() {
        return "DistributionTopic:" + this.getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpNot(WakeUpNot not) {
        Object object;
        if (logger.isLoggable(BasicLevel.DEBUG) && !this.isAsyncDistribution) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionTopic.wakeUpNot(" + (Object)((Object)not) + ')'));
        }
        super.wakeUpNot(not);
        if (this.distributionDaemon != null) {
            object = this.distributionDaemon.getAckList();
        }
        if (this.distributionDaemon != null) {
            object = this.distributionDaemon;
            synchronized (object) {
                ((Object)((Object)this.distributionDaemon)).notify();
            }
        }
    }
}

