/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.messages;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.stream.StreamUtil;
import fr.dyade.aaa.util.Transaction;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.objectweb.joram.mom.messages.MessageView;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class Message
implements Serializable,
MessageView {
    private static final long serialVersionUID = 2L;
    public static Logger logger = Debug.getLogger((String)Message.class.getName());
    public transient long order;
    public transient int acksCounter;
    public transient int durableAcksCounter;
    private transient org.objectweb.joram.shared.messages.Message msg;
    private transient SoftReference bodySoftRef = null;
    private transient boolean soft;
    private static final boolean globalUseSoftRef = AgentServer.getBoolean((String)"org.objectweb.joram.mom.messages.SWAPALLOWED");
    transient String txname = null;

    public Message(org.objectweb.joram.shared.messages.Message msg) {
        this.msg = msg;
        Boolean msgUseSoftRef = (Boolean)msg.getProperty("JMS_JORAM_SWAPALLOWED");
        this.soft = msgUseSoftRef != null ? msgUseSoftRef != false && msg.persistent && msg.body != null : globalUseSoftRef && msg.persistent && msg.body != null;
    }

    public org.objectweb.joram.shared.messages.Message getHeaderMessage() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.getHeaderMessage() -> " + this.msg));
        }
        return this.msg;
    }

    public org.objectweb.joram.shared.messages.Message getFullMessage() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.getFullMessage() " + this.txname));
        }
        if (!this.soft || this.msg.body != null) {
            return this.msg;
        }
        if (this.bodySoftRef != null) {
            this.msg.body = (byte[])this.bodySoftRef.get();
            this.bodySoftRef = null;
            if (this.msg.body != null) {
                return this.msg;
            }
        }
        try {
            this.msg.body = AgentServer.getTransaction().loadByteArray(this.txname + "B");
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Body loaded.");
            }
            this.bodySoftRef = null;
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)("Body of message named [" + this.txname + "] could not be loaded"), (Throwable)exc);
        }
        return this.msg;
    }

    public void releaseFullMessage() {
        if (this.soft) {
            this.bodySoftRef = new SoftReference<byte[]>(this.msg.body);
            this.msg.body = null;
        }
    }

    public int getType() {
        return this.msg.type;
    }

    public String getId() {
        return this.msg.id;
    }

    public void setIdentifier(String id) {
        this.msg.id = id;
    }

    public boolean isPersistent() {
        return this.msg.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.msg.persistent = persistent;
    }

    public int getPriority() {
        return this.msg.priority;
    }

    public void setPriority(int priority) {
        if (priority >= 0 && priority <= 9) {
            this.msg.priority = priority;
        }
    }

    public long getExpiration() {
        return this.msg.expiration;
    }

    public void setExpiration(long expiration) {
        if (expiration >= 0L) {
            this.msg.expiration = expiration;
        }
    }

    public long getTimestamp() {
        return this.msg.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.msg.timestamp = timestamp;
    }

    public final String getCorrelationId() {
        return this.msg.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.msg.correlationId = correlationId;
    }

    public int getDeliveryCount() {
        return this.msg.deliveryCount;
    }

    public void setDeliveryCount(int deliveryCount) {
        this.msg.deliveryCount = deliveryCount;
    }

    public void incDeliveryCount() {
        ++this.msg.deliveryCount;
    }

    public void setRedelivered() {
        this.msg.redelivered = true;
    }

    public void setObjectProperty(String name, Object value) {
        this.msg.setProperty(name, value);
    }

    public boolean isValid(long currentTime) {
        return this.msg.expiration <= 0L || this.msg.expiration > currentTime;
    }

    public void setTxName(String txname) {
        this.txname = txname;
    }

    public String getTxName() {
        return this.txname;
    }

    public static Message load(String txname) throws IOException, ClassNotFoundException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Message.load:" + txname));
        }
        Message msg = (Message)AgentServer.getTransaction().load(txname);
        msg.txname = txname;
        return msg;
    }

    public void save() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Message.save:" + this.txname));
        }
        if (!this.isPersistent()) {
            return;
        }
        if (this.soft) {
            byte[] body = this.msg.body;
            this.msg.body = null;
            try {
                AgentServer.getTransaction().create((Serializable)this, this.txname);
            }
            catch (IOException exc) {
                logger.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
            try {
                AgentServer.getTransaction().saveByteArray(body, null, this.txname + "B", false, true);
            }
            catch (IOException exc) {
                logger.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
            this.msg.body = body;
        } else {
            try {
                AgentServer.getTransaction().create((Serializable)this, this.txname);
            }
            catch (IOException exc) {
                logger.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
        }
    }

    public void saveHeader() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Message.saveHeader:" + this.txname));
        }
        if (!this.isPersistent()) {
            return;
        }
        if (this.soft) {
            byte[] body = this.msg.body;
            this.msg.body = null;
            try {
                AgentServer.getTransaction().save((Serializable)this, this.txname);
            }
            catch (IOException exc) {
                logger.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
            this.msg.body = body;
        } else {
            try {
                AgentServer.getTransaction().save((Serializable)this, this.txname);
            }
            catch (IOException exc) {
                logger.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
            }
        }
    }

    public void delete() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Message.delete:" + this.txname));
        }
        if (!this.isPersistent()) {
            return;
        }
        AgentServer.getTransaction().delete(this.txname);
        if (this.soft) {
            AgentServer.getTransaction().delete(this.txname + "B");
        }
    }

    public static Vector loadAll(String msgTxname) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Message.loadAll() " + msgTxname));
        }
        Vector<Message> messages = new Vector<Message>();
        Transaction tx = AgentServer.getTransaction();
        String[] names = tx.getList(msgTxname);
        for (int i = 0; i < names.length; ++i) {
            if (names[i].charAt(names[i].length() - 1) == 'B') continue;
            try {
                Message msg = (Message)tx.load(names[i]);
                msg.txname = names[i];
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("loadAll: names[" + i + "] = " + msg.txname));
                }
                messages.add(msg);
                continue;
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)("Message named [" + names[i] + "] could not be loaded"), (Throwable)exc);
            }
        }
        return messages;
    }

    public static void deleteAll(String msgTxname) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.deleteAll() " + msgTxname));
        }
        Transaction tx = AgentServer.getTransaction();
        String[] names = tx.getList(msgTxname);
        for (int i = 0; i < names.length; ++i) {
            tx.delete(names[i]);
            tx.delete(names[i] + "B");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.order);
        out.writeBoolean(this.soft);
        this.msg.writeHeaderTo((OutputStream)out);
        StreamUtil.writeTo((byte[])this.msg.body, (OutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.order = in.readLong();
        this.soft = in.readBoolean();
        this.acksCounter = 0;
        this.durableAcksCounter = 0;
        this.msg = new org.objectweb.joram.shared.messages.Message();
        this.msg.readHeaderFrom((InputStream)in);
        this.msg.body = StreamUtil.readByteArrayFrom((InputStream)in);
    }

    public String getText() {
        try {
            return this.msg.getText();
        }
        catch (Exception e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"getText()", (Throwable)e);
            }
            return null;
        }
    }

    public boolean isRedelivered() {
        return this.msg.redelivered;
    }

    public Map getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.msg.properties == null) {
            return null;
        }
        Enumeration enu = this.msg.properties.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            props.put(key, this.msg.properties.get(key).toString());
        }
        return props;
    }
}

