/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.notifications;

import fr.dyade.aaa.agent.AgentId;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.joram.mom.notifications.AbstractRequestNot;
import org.objectweb.joram.shared.messages.Message;

public class ClientMessages
extends AbstractRequestNot {
    private static final long serialVersionUID = 1L;
    private Message message = null;
    private List messages = null;
    private boolean asyncSend;

    public ClientMessages(int clientContext, int requestId) {
        super(clientContext, requestId);
    }

    public ClientMessages(int clientContext, int requestId, Message message) {
        super(clientContext, requestId);
        this.message = message;
        this.setExpiration(message.expiration);
        this.setPriority(message.priority);
    }

    public ClientMessages(int clientContext, int requestId, List messages) {
        super(clientContext, requestId);
        if (messages.size() == 1) {
            this.message = (Message)messages.get(0);
            this.setExpiration(this.message.expiration);
            this.setPriority(this.message.priority);
        } else {
            long newExpiration = -1L;
            int newPriority = 0;
            for (Message msg : messages) {
                if (newExpiration != 0L && (msg.expiration > newExpiration || msg.expiration == 0L)) {
                    newExpiration = msg.expiration;
                }
                if (msg.priority <= newPriority) continue;
                newPriority = msg.priority;
            }
            this.messages = messages;
            this.setExpiration(newExpiration);
            this.setPriority(newPriority);
        }
    }

    public ClientMessages() {
    }

    public void addMessage(Message msg) {
        if (this.message == null && this.messages == null) {
            this.message = msg;
            this.setExpiration(this.message.expiration);
            this.setPriority(this.message.priority);
        } else {
            if (this.messages == null) {
                this.messages = new ArrayList();
                this.messages.add(this.message);
                this.message = null;
            }
            if (this.getExpiration() != 0L && (msg.expiration > this.getExpiration() || msg.expiration == 0L)) {
                this.setExpiration(msg.expiration);
            }
            if (msg.priority > this.getPriority()) {
                this.setPriority(msg.priority);
            }
            this.messages.add(msg);
        }
    }

    public void setDMQId(AgentId dmqId) {
        this.setDeadNotificationAgentId(dmqId);
    }

    public List getMessages() {
        if (this.messages == null) {
            ArrayList<Message> msgs = new ArrayList<Message>();
            if (this.message != null) {
                msgs.add(this.message);
            }
            return msgs;
        }
        return this.messages;
    }

    public void setAsyncSend(boolean b) {
        this.asyncSend = b;
    }

    public final boolean getAsyncSend() {
        return this.asyncSend;
    }

    public int getMessageCount() {
        if (this.messages == null) {
            if (this.message == null) {
                return 0;
            }
            return 1;
        }
        return this.messages.size();
    }

    public AgentId getDMQId() {
        return this.getDeadNotificationAgentId();
    }

    public StringBuffer toString(StringBuffer output) {
        output.append('(');
        super.toString(output);
        output.append(",message=").append(this.message);
        output.append(",messages=").append(this.messages);
        output.append(",asyncSend=").append(this.asyncSend);
        output.append(')');
        return output;
    }
}

