/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BagSerializer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.WakeUpTask;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.Vector;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.dest.Topic;
import org.objectweb.joram.mom.notifications.AbortReceiveRequest;
import org.objectweb.joram.mom.notifications.AbstractReplyNot;
import org.objectweb.joram.mom.notifications.AbstractRequestNot;
import org.objectweb.joram.mom.notifications.AcknowledgeRequest;
import org.objectweb.joram.mom.notifications.AdminReplyNot;
import org.objectweb.joram.mom.notifications.BrowseReply;
import org.objectweb.joram.mom.notifications.BrowseRequest;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.DenyRequest;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.QueueMsgReply;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.notifications.SubscribeReply;
import org.objectweb.joram.mom.notifications.SubscribeRequest;
import org.objectweb.joram.mom.notifications.TopicMsgsReply;
import org.objectweb.joram.mom.notifications.UnsubscribeRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.proxies.ClientContext;
import org.objectweb.joram.mom.proxies.ClientSubscription;
import org.objectweb.joram.mom.proxies.CloseConnectionNot;
import org.objectweb.joram.mom.proxies.ConnectionContext;
import org.objectweb.joram.mom.proxies.GetConnectionNot;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.ProxyAgentItf;
import org.objectweb.joram.mom.proxies.ProxyRequestGroupNot;
import org.objectweb.joram.mom.proxies.ReliableConnectionContext;
import org.objectweb.joram.mom.proxies.RequestBuffer;
import org.objectweb.joram.mom.proxies.RequestNot;
import org.objectweb.joram.mom.proxies.ResetCollocatedConnectionsNot;
import org.objectweb.joram.mom.proxies.ReturnConnectionNot;
import org.objectweb.joram.mom.proxies.SendRepliesNot;
import org.objectweb.joram.mom.proxies.SendReplyNot;
import org.objectweb.joram.mom.proxies.StandardConnectionContext;
import org.objectweb.joram.mom.proxies.SyncReply;
import org.objectweb.joram.mom.proxies.TopicSubscription;
import org.objectweb.joram.mom.proxies.UserAgentMBean;
import org.objectweb.joram.mom.proxies.Xid;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.mom.util.InterceptorsHelper;
import org.objectweb.joram.mom.util.MessageInterceptor;
import org.objectweb.joram.shared.DestinationConstants;
import org.objectweb.joram.shared.admin.AbstractAdminMessage;
import org.objectweb.joram.shared.admin.AdminCommandConstant;
import org.objectweb.joram.shared.admin.AdminCommandReply;
import org.objectweb.joram.shared.admin.AdminCommandRequest;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearSubscription;
import org.objectweb.joram.shared.admin.DeleteSubscriptionMessage;
import org.objectweb.joram.shared.admin.DeleteUser;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.GetNumberReply;
import org.objectweb.joram.shared.admin.GetSubscription;
import org.objectweb.joram.shared.admin.GetSubscriptionMessage;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIds;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIdsRep;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageRep;
import org.objectweb.joram.shared.admin.GetSubscriptionRep;
import org.objectweb.joram.shared.admin.GetSubscriptions;
import org.objectweb.joram.shared.admin.GetSubscriptionsRep;
import org.objectweb.joram.shared.admin.SetDMQRequest;
import org.objectweb.joram.shared.admin.SetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.SetThresholdRequest;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.ActivateConsumerRequest;
import org.objectweb.joram.shared.client.CnxCloseReply;
import org.objectweb.joram.shared.client.CnxCloseRequest;
import org.objectweb.joram.shared.client.CnxConnectReply;
import org.objectweb.joram.shared.client.CnxConnectRequest;
import org.objectweb.joram.shared.client.CnxStartRequest;
import org.objectweb.joram.shared.client.CnxStopRequest;
import org.objectweb.joram.shared.client.CommitRequest;
import org.objectweb.joram.shared.client.ConsumerAckRequest;
import org.objectweb.joram.shared.client.ConsumerCloseSubRequest;
import org.objectweb.joram.shared.client.ConsumerDenyRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.ConsumerReceiveRequest;
import org.objectweb.joram.shared.client.ConsumerSetListRequest;
import org.objectweb.joram.shared.client.ConsumerSubRequest;
import org.objectweb.joram.shared.client.ConsumerUnsetListRequest;
import org.objectweb.joram.shared.client.ConsumerUnsubRequest;
import org.objectweb.joram.shared.client.GetAdminTopicReply;
import org.objectweb.joram.shared.client.GetAdminTopicRequest;
import org.objectweb.joram.shared.client.JmsRequestGroup;
import org.objectweb.joram.shared.client.MomExceptionReply;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.joram.shared.client.QBrowseReply;
import org.objectweb.joram.shared.client.QBrowseRequest;
import org.objectweb.joram.shared.client.ServerReply;
import org.objectweb.joram.shared.client.SessAckRequest;
import org.objectweb.joram.shared.client.SessCreateDestReply;
import org.objectweb.joram.shared.client.SessCreateDestRequest;
import org.objectweb.joram.shared.client.SessDenyRequest;
import org.objectweb.joram.shared.client.TempDestDeleteRequest;
import org.objectweb.joram.shared.client.XACnxCommit;
import org.objectweb.joram.shared.client.XACnxPrepare;
import org.objectweb.joram.shared.client.XACnxRecoverReply;
import org.objectweb.joram.shared.client.XACnxRecoverRequest;
import org.objectweb.joram.shared.client.XACnxRollback;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.DestinationException;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.excepts.StateException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.messages.MessageHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class UserAgent
extends Agent
implements UserAgentMBean,
BagSerializer,
ProxyAgentItf {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)UserAgent.class.getName());
    private String interceptors_in = null;
    private String interceptors_out = null;
    private transient List interceptorsOUT = null;
    private transient List interceptorsIN = null;
    private long period = 60000L;
    private long nbMsgsSentToDMQSinceCreation = 0L;
    private AgentId dmqId = null;
    private int threshold = -1;
    private int nbMaxMsg = -1;
    private Map contexts = new Hashtable();
    private Map subsTable = new Hashtable();
    private Map recoveredTransactions;
    private long arrivalsCounter = 0L;
    private transient Map topicsTable;
    private transient Map messagesTable;
    private transient int activeCtxId;
    private transient ClientContext activeCtx;
    private transient Hashtable connections;
    private transient Hashtable heartBeatTasks;
    private int keyCounter = 0;
    private transient WakeUpTask cleaningTask;
    transient String msgTxname = null;

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        if (this.period != period) {
            WakeUpNot not = new WakeUpNot();
            not.update = true;
            Channel.sendTo((AgentId)this.getId(), (Notification)not);
            this.period = period;
        }
    }

    public String getDMQId() {
        if (this.dmqId != null) {
            return this.dmqId.toString();
        }
        return null;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getNbMaxMsg() {
        return this.nbMaxMsg;
    }

    public void setNbMaxMsg(int nbMaxMsg) {
        this.nbMaxMsg = nbMaxMsg;
    }

    public void agentInitialize(boolean firstTime) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.agentInitialize(" + firstTime + ')'));
        }
        super.agentInitialize(firstTime);
        this.initialize(firstTime);
        if (this.getPeriod() > 0L) {
            this.cleaningTask = new WakeUpTask(this.getId(), WakeUpNot.class, this.getPeriod());
        }
        try {
            MXWrapper.registerMBean((Object)this, (String)this.getMBeanName().toString());
        }
        catch (Exception exc) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " jmx failed"), (Throwable)exc);
        }
    }

    public void agentFinalize(boolean lastTime) {
        if (this.cleaningTask != null) {
            this.cleaningTask.cancel();
        }
        try {
            MXWrapper.unregisterMBean((String)this.getMBeanName().toString());
        }
        catch (Exception exc) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " jmx failed"), (Throwable)exc);
        }
        super.agentFinalize(lastTime);
    }

    private StringBuffer getMBeanName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Joram#").append(AgentServer.getServerId());
        strbuf.append(':');
        strbuf.append("type=User,name=").append(this.getName());
        return strbuf;
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.react(" + from + ',' + not + ')'));
        }
        this.setNoSave();
        if (not instanceof OpenConnectionNot) {
            this.doReact((OpenConnectionNot)not);
        } else if (not instanceof GetConnectionNot) {
            this.doReact((GetConnectionNot)not);
        } else if (not instanceof CloseConnectionNot) {
            this.doReact((CloseConnectionNot)not);
        } else if (not instanceof ResetCollocatedConnectionsNot) {
            this.doReact((ResetCollocatedConnectionsNot)not);
        } else if (not instanceof SendReplyNot) {
            this.doReact((SendReplyNot)not);
        } else if (not instanceof RequestNot) {
            this.doReact((RequestNot)not);
        } else if (not instanceof ReturnConnectionNot) {
            this.doReact((ReturnConnectionNot)not);
        } else if (not instanceof SendRepliesNot) {
            this.doReact((SendRepliesNot)not);
        } else if (not instanceof ProxyRequestGroupNot) {
            this.doReact((ProxyRequestGroupNot)not);
        } else if (not instanceof WakeUpNot) {
            if (this.cleaningTask == null || ((WakeUpNot)not).update) {
                this.doSetPeriod(this.getPeriod());
            }
            if (this.getPeriod() > 0L) {
                this.cleanPendingMessages(System.currentTimeMillis());
            }
        } else if (not instanceof SyncReply) {
            this.doReact((SyncReply)not);
        } else if (not instanceof AbstractReplyNot) {
            this.doFwd(from, (AbstractReplyNot)not);
        } else if (not instanceof AdminReplyNot) {
            this.doReact((AdminReplyNot)not);
        } else if (not instanceof UnknownAgent) {
            this.doReact((UnknownAgent)not);
        } else if (not instanceof FwdAdminRequestNot) {
            this.doReact((FwdAdminRequestNot)not);
        } else {
            super.react(from, not);
        }
    }

    private void doSetPeriod(long period) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": setPeriod(" + period + ")." + " -> task " + this.cleaningTask));
        }
        if (this.cleaningTask == null) {
            this.cleaningTask = new WakeUpTask(this.getId(), WakeUpNot.class, period);
        } else {
            this.cleaningTask.cancel();
            if (period > 0L) {
                this.cleaningTask = new WakeUpTask(this.getId(), WakeUpNot.class, period);
            }
        }
    }

    private void doReact(OpenConnectionNot not) {
        ConnectionContext ctx;
        this.setSave();
        if (this.connections == null) {
            this.connections = new Hashtable();
            this.heartBeatTasks = new Hashtable();
        }
        Integer objKey = new Integer(this.keyCounter);
        if (not.getReliable()) {
            ctx = new ReliableConnectionContext(this.keyCounter, not.getHeartBeat());
            this.connections.put(objKey, ctx);
        } else {
            ctx = new StandardConnectionContext(this.keyCounter);
            this.connections.put(objKey, ctx);
        }
        if (not.getHeartBeat() > 0) {
            HeartBeatTask heartBeatTask = new HeartBeatTask(2 * not.getHeartBeat(), objKey);
            this.heartBeatTasks.put(objKey, heartBeatTask);
            try {
                heartBeatTask.start();
            }
            catch (IOException exc) {
                this.heartBeatTasks.remove(objKey);
            }
        }
        this.sendTo(this.getId(), new ReturnConnectionNot(not, ctx));
        ++this.keyCounter;
    }

    private void doReact(ReturnConnectionNot not) {
        not.Return();
    }

    private void doReact(GetConnectionNot not) {
        int key = not.getKey();
        if (this.connections == null) {
            not.Throw(new Exception("Connection " + key + " not found"));
        } else {
            Integer objKey = new Integer(key);
            ReliableConnectionContext ctx = (ReliableConnectionContext)this.connections.get(objKey);
            if (ctx == null) {
                not.Throw(new Exception("Connection " + key + " not found"));
            } else {
                not.Return(ctx);
            }
        }
    }

    private void doReact(RequestNot not) {
        ConnectionContext ctx;
        Integer key = new Integer(not.getConnectionKey());
        if (this.connections != null && (ctx = (ConnectionContext)this.connections.get(key)) != null) {
            HeartBeatTask heartBeatTask = (HeartBeatTask)this.heartBeatTasks.get(key);
            if (heartBeatTask != null) {
                heartBeatTask.touch();
            }
            AbstractJmsRequest request = ctx.getRequest(not.getMessage());
            this.reactToClientRequest((int)key, request);
            if (ctx.isClosed()) {
                this.connections.remove(key);
                HeartBeatTask hbt = (HeartBeatTask)this.heartBeatTasks.remove(key);
                if (hbt != null) {
                    hbt.cancel();
                }
            }
        }
    }

    private void doReact(ProxyRequestGroupNot not) {
        RequestNot[] requests = not.getRequests();
        RequestBuffer rm = new RequestBuffer(this);
        for (int i = 0; i < requests.length; ++i) {
            ConnectionContext ctx;
            RequestNot req = requests[i];
            Integer key = new Integer(req.getConnectionKey());
            HeartBeatTask heartBeatTask = (HeartBeatTask)this.heartBeatTasks.get(key);
            if (heartBeatTask != null) {
                heartBeatTask.touch();
            }
            if ((ctx = (ConnectionContext)this.connections.get(key)) == null) continue;
            AbstractJmsRequest request = ctx.getRequest(req.getMessage());
            if (request instanceof ProducerMessages) {
                ProducerMessages pm = (ProducerMessages)request;
                rm.put(req.getConnectionKey(), pm);
                continue;
            }
            if (request instanceof JmsRequestGroup) {
                JmsRequestGroup jrg = (JmsRequestGroup)request;
                AbstractJmsRequest[] groupedRequests = jrg.getRequests();
                for (int j = 0; j < groupedRequests.length; ++j) {
                    if (groupedRequests[i] instanceof ProducerMessages) {
                        ProducerMessages pm = (ProducerMessages)groupedRequests[i];
                        rm.put(req.getConnectionKey(), pm);
                        continue;
                    }
                    this.reactToClientRequest((int)key, groupedRequests[i]);
                }
                continue;
            }
            this.reactToClientRequest((int)key, request);
        }
        rm.flush();
    }

    private void doReact(CloseConnectionNot not) {
        Integer key;
        if (this.connections != null && this.connections.remove(key = new Integer(not.getKey())) != null) {
            this.reactToClientRequest(not.getKey(), (AbstractJmsRequest)new CnxCloseRequest());
            this.heartBeatTasks.remove(key);
        }
    }

    private void doReact(ResetCollocatedConnectionsNot not) {
        if (this.connections != null) {
            Collection values = this.connections.values();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof StandardConnectionContext)) continue;
                ConnectionContext cc = (ConnectionContext)obj;
                this.reactToClientRequest(cc.getKey(), (AbstractJmsRequest)new CnxCloseRequest());
                iterator.remove();
            }
        }
    }

    private void doReact(SendRepliesNot not) {
        Enumeration en = not.getReplies();
        while (en.hasMoreElements()) {
            SendReplyNot sr = (SendReplyNot)((Object)en.nextElement());
            this.doReact(sr);
        }
    }

    private void doReact(SendReplyNot not) {
        ClientContext cc;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.doReact(" + (Object)((Object)not) + ')'));
        }
        if ((cc = this.getClientContext(not.getKey())) != null) {
            if (cc.setReply(not.getRequestId()) == 0) {
                this.sendToClient(not.getKey(), (AbstractJmsReply)new ServerReply(not.getRequestId()));
            }
        } else if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent: unknown client context for " + (Object)((Object)not)));
        }
    }

    public void sendNot(AgentId to, Notification not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.sendNot(" + to + ',' + not + ')'));
        }
        this.sendTo(to, not);
    }

    public void sendToClient(int key, AbstractJmsReply reply) {
        ConnectionContext ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.sendToClient(" + key + ',' + reply + ')'));
        }
        Integer objKey = new Integer(key);
        if (this.connections != null && (ctx = (ConnectionContext)this.connections.get(objKey)) != null) {
            if (this.interceptorsOUT != null && !this.interceptorsOUT.isEmpty() && reply instanceof ConsumerMessages) {
                Message m = null;
                Vector msgs = ((ConsumerMessages)reply).getMessages();
                Vector<Message> newMsgs = new Vector<Message>();
                Vector<String> acks = new Vector<String>();
                for (int i = 0; i < msgs.size(); ++i) {
                    m = (Message)msgs.elementAt(i);
                    for (MessageInterceptor interceptor : this.interceptorsOUT) {
                        if (interceptor.handle(m)) continue;
                        m = null;
                        break;
                    }
                    if (m != null) {
                        newMsgs.add(m);
                        continue;
                    }
                    acks.add(((Message)msgs.elementAt((int)i)).id);
                    this.sendToDMQ((Message)msgs.elementAt(i), (short)7);
                }
                if (newMsgs.size() == 0 && !msgs.isEmpty()) {
                    Message msg = (Message)msgs.firstElement();
                    this.sendNot(AgentId.fromString((String)msg.toId), new AcknowledgeRequest(this.activeCtxId, reply.getCorrelationId(), acks));
                }
                ((ConsumerMessages)reply).setMessages(newMsgs);
            }
            ctx.pushReply(reply);
        }
    }

    public void setNoSave() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"setNoSave()");
        }
        super.setNoSave();
    }

    public void setSave() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"UserAgent.setSave()");
        }
        super.setSave();
    }

    public UserAgent() {
        super(true);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public UserAgent(String name, int stamp) {
        super(name, true, stamp);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public String toString() {
        return "UserAgent:" + this.getId();
    }

    public void setInterceptors(Properties prop) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " initInterceptors(" + prop + ')'));
        }
        if (prop == null) {
            return;
        }
        this.interceptors_out = (String)prop.get("jms_joram_interceptors_out");
        this.interceptors_in = (String)prop.get("jms_joram_interceptors_in");
    }

    private void initialize(boolean firstTime) throws Exception {
        AgentId destId;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " (re)initializing..."));
        }
        this.topicsTable = new Hashtable();
        this.messagesTable = new Hashtable();
        this.setActiveCtxId(-1);
        if (this.interceptors_out != null) {
            this.interceptorsOUT = new ArrayList();
            InterceptorsHelper.addInterceptors(this.interceptors_out, this.interceptorsOUT);
        }
        if (this.interceptors_in != null) {
            this.interceptorsIN = new ArrayList();
            InterceptorsHelper.addInterceptors(this.interceptors_in, this.interceptorsIN);
        }
        Iterator ctxs = this.contexts.values().iterator();
        while (ctxs.hasNext()) {
            ClientContext activeCtx = (ClientContext)ctxs.next();
            activeCtx.setProxyAgent(this);
            ctxs.remove();
            Iterator queueIds = activeCtx.getDeliveringQueues();
            while (queueIds.hasNext()) {
                destId = (AgentId)queueIds.next();
                this.sendNot(destId, new DenyRequest(activeCtx.getId()));
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Denies messages on queue " + destId.toString()));
            }
            Iterator xids = activeCtx.getTxIds();
            while (xids.hasNext()) {
                if (this.recoveredTransactions == null) {
                    this.recoveredTransactions = new Hashtable();
                }
                Xid xid = (Xid)xids.next();
                XACnxPrepare recoveredPrepare = (XACnxPrepare)this.recoveredTransactions.get(xid);
                XACnxPrepare prepare = activeCtx.getTxPrepare(xid);
                if (recoveredPrepare == null) {
                    this.recoveredTransactions.put(xid, prepare);
                    continue;
                }
                recoveredPrepare.getSendings().addAll(prepare.getSendings());
                recoveredPrepare.getAcks().addAll(prepare.getAcks());
            }
            Iterator tempDests = activeCtx.getTempDestinations();
            while (tempDests.hasNext()) {
                destId = (AgentId)tempDests.next();
                this.deleteTemporaryDestination(destId);
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Deletes temporary destination " + destId.toString()));
            }
        }
        Vector messages = org.objectweb.joram.mom.messages.Message.loadAll(this.getMsgTxname());
        if (this.subsTable.isEmpty()) {
            org.objectweb.joram.mom.messages.Message.deleteAll(this.getMsgTxname());
        }
        ArrayList<AgentId> topics = new ArrayList<AgentId>();
        Iterator subs = this.subsTable.entrySet().iterator();
        while (subs.hasNext()) {
            ClientSubscription cSub;
            Map.Entry subEntry;
            block19: {
                subEntry = subs.next();
                cSub = (ClientSubscription)subEntry.getValue();
                destId = cSub.getTopicId();
                if (!topics.contains(destId)) {
                    topics.add(destId);
                }
                if (!cSub.getDurable()) {
                    subs.remove();
                    try {
                        MXWrapper.unregisterMBean((String)this.getSubMBeanName((String)subEntry.getKey()));
                    }
                    catch (Exception e1) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                        logger.log(BasicLevel.DEBUG, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e1);
                    }
                    continue;
                }
                cSub.setProxyAgent(this);
                cSub.reinitialize(this.messagesTable, messages, true);
                try {
                    MXWrapper.registerMBean((Object)cSub, (String)this.getSubMBeanName((String)subEntry.getKey()));
                }
                catch (Exception e1) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block19;
                    logger.log(BasicLevel.WARN, (Object)"  - Could not register ClientSubscriptionMbean", (Throwable)e1);
                }
            }
            TopicSubscription tSub = (TopicSubscription)this.topicsTable.get(destId);
            if (tSub == null) {
                tSub = new TopicSubscription();
                this.topicsTable.put(destId, tSub);
            }
            tSub.putSubscription((String)subEntry.getKey(), cSub.getSelector());
        }
        Iterator topicIds = topics.iterator();
        while (topicIds.hasNext()) {
            this.updateSubscriptionToTopic((AgentId)topicIds.next(), -1, -1);
        }
    }

    private void setActiveCtxId(int activeCtxId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.setActiveCtxId(" + activeCtxId + ')'));
        }
        this.activeCtxId = activeCtxId;
    }

    protected void reactToClientRequest(int key, AbstractJmsRequest request) {
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " got " + request.getClass().getName() + " with id: " + request.getRequestId() + " through activeCtx: " + key));
            }
            if (request instanceof ProducerMessages) {
                this.reactToClientRequest(key, (ProducerMessages)request);
            } else if (request instanceof ConsumerReceiveRequest) {
                this.reactToClientRequest(key, (ConsumerReceiveRequest)request);
            } else if (request instanceof ConsumerSetListRequest) {
                this.reactToClientRequest(key, (ConsumerSetListRequest)request);
            } else if (request instanceof QBrowseRequest) {
                this.reactToClientRequest(key, (QBrowseRequest)request);
            } else if (request instanceof JmsRequestGroup) {
                this.reactToClientRequest(key, (JmsRequestGroup)request);
            } else {
                this.doReact(key, request);
            }
        }
        catch (IllegalArgumentException iE) {
            DestinationException dE = new DestinationException("Incorrect destination identifier: " + iE);
            this.sendToClient(key, (AbstractJmsReply)new MomExceptionReply(request.getRequestId(), (MomException)dE));
        }
        catch (RequestException exc) {
            this.sendToClient(key, (AbstractJmsReply)new MomExceptionReply(request.getRequestId(), (MomException)((Object)exc)));
        }
    }

    private void reactToClientRequest(int key, ProducerMessages req) throws RequestException {
        AgentId destId;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.reactToClientRequest(" + key + ',' + req + ')'));
        }
        if ((destId = AgentId.fromString((String)req.getTarget())) == null) {
            throw new RequestException("Request to an undefined destination (null).");
        }
        ProducerMessages pm = req;
        if (this.interceptorsIN != null && !this.interceptorsIN.isEmpty()) {
            Message m = null;
            Vector msgs = req.getMessages();
            Vector<Message> newMsgs = new Vector<Message>();
            for (int i = 0; i < msgs.size(); ++i) {
                m = (Message)msgs.elementAt(i);
                for (MessageInterceptor interceptor : this.interceptorsIN) {
                    if (interceptor.handle(m)) continue;
                    m = null;
                    break;
                }
                if (m != null) {
                    newMsgs.add(m);
                    continue;
                }
                this.sendToDMQ((Message)msgs.elementAt(i), (short)7);
            }
            if (newMsgs.size() == 0 && !msgs.isEmpty()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"UserAgent.reactToClientRequest : no message to send.");
                }
                if (destId.getTo() == this.getId().getTo() && !pm.getAsyncSend()) {
                    this.sendNot(this.getId(), new SendReplyNot(key, pm.getRequestId()));
                }
                return;
            }
            pm.setMessages(newMsgs);
            pm = req;
        }
        ClientMessages not = new ClientMessages(key, pm.getRequestId(), pm.getMessages());
        this.setDmq(not);
        if (destId.getTo() == this.getId().getTo()) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> local sending");
            }
            not.setPersistent(false);
            not.setExpiration(0L);
            if (pm.getAsyncSend()) {
                not.setAsyncSend(true);
            }
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> remote sending");
            }
            if (!pm.getAsyncSend()) {
                this.sendNot(this.getId(), new SendReplyNot(key, pm.getRequestId()));
            }
        }
        this.sendNot(destId, not);
    }

    private void sendToDMQ(Message msg, short messageError) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("sendToDMQ(" + msg + ',' + messageError + ')'));
        }
        DMQManager dmqManager = new DMQManager(this.dmqId, null);
        ++this.nbMsgsSentToDMQSinceCreation;
        dmqManager.addDeadMessage(msg, messageError);
        dmqManager.sendToDMQ();
    }

    private void setDmq(ClientMessages not) {
        if (this.dmqId != null) {
            not.setDMQId(this.dmqId);
        } else {
            not.setDMQId(Queue.getDefaultDMQId());
        }
    }

    private void reactToClientRequest(int key, ConsumerReceiveRequest req) throws RequestException {
        if (req.getQueueMode()) {
            ReceiveRequest not = new ReceiveRequest(key, req.getRequestId(), req.getSelector(), req.getTimeToLive(), req.getReceiveAck(), null, 1);
            AgentId destId = AgentId.fromString((String)req.getTarget());
            if (destId == null) {
                throw new RequestException("Request to an undefined destination (null).");
            }
            if (destId.getTo() == this.getId().getTo()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> local receiving");
                }
                not.setPersistent(false);
                this.sendNot(destId, not);
            } else {
                this.sendNot(destId, not);
            }
        } else {
            this.doReact(key, (AbstractJmsRequest)req);
        }
    }

    private void reactToClientRequest(int key, ConsumerSetListRequest req) throws RequestException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImp.reactToClientRequest(" + key + ',' + req + ')'));
        }
        if (req.getQueueMode()) {
            ReceiveRequest not = new ReceiveRequest(key, req.getRequestId(), req.getSelector(), 0L, false, req.getMessageIdsToAck(), req.getMessageCount());
            AgentId destId = AgentId.fromString((String)req.getTarget());
            if (destId == null) {
                throw new RequestException("Request to an undefined destination (null).");
            }
            if (destId.getTo() == this.getId().getTo()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> local sending");
                }
                not.setPersistent(false);
                this.sendNot(destId, not);
            } else {
                this.sendNot(destId, not);
            }
        } else {
            this.doReact(key, (AbstractJmsRequest)req);
        }
    }

    private void reactToClientRequest(int key, QBrowseRequest req) throws RequestException {
        AgentId destId = AgentId.fromString((String)req.getTarget());
        if (destId == null) {
            throw new RequestException("Request to an undefined destination (null).");
        }
        this.sendNot(destId, new BrowseRequest(key, req.getRequestId(), req.getSelector()));
    }

    private void reactToClientRequest(int key, JmsRequestGroup request) {
        AbstractJmsRequest[] requests = request.getRequests();
        RequestBuffer rm = new RequestBuffer(this);
        for (int i = 0; i < requests.length; ++i) {
            if (requests[i] instanceof ProducerMessages) {
                ProducerMessages pm = (ProducerMessages)requests[i];
                rm.put(key, pm);
                continue;
            }
            this.reactToClientRequest(key, requests[i]);
        }
        rm.flush();
    }

    private void doReact(int key, AbstractJmsRequest request) {
        try {
            if (!(request instanceof CnxConnectRequest)) {
                this.setCtx(key);
            }
            if (request instanceof GetAdminTopicRequest) {
                this.doReact(key, (GetAdminTopicRequest)request);
            } else if (request instanceof CnxConnectRequest) {
                this.doReact(key, (CnxConnectRequest)request);
            } else if (request instanceof CnxStartRequest) {
                this.doReact((CnxStartRequest)request);
            } else if (request instanceof CnxStopRequest) {
                this.doReact((CnxStopRequest)request);
            } else if (request instanceof SessCreateDestRequest) {
                this.doReact((SessCreateDestRequest)request);
            } else if (request instanceof ConsumerSubRequest) {
                this.doReact((ConsumerSubRequest)request);
            } else if (request instanceof ConsumerUnsubRequest) {
                this.doReact((ConsumerUnsubRequest)request);
            } else if (request instanceof ConsumerCloseSubRequest) {
                this.doReact((ConsumerCloseSubRequest)request);
            } else if (request instanceof ConsumerSetListRequest) {
                this.doReact((ConsumerSetListRequest)request);
            } else if (request instanceof ConsumerUnsetListRequest) {
                this.doReact((ConsumerUnsetListRequest)request);
            } else if (request instanceof ConsumerReceiveRequest) {
                this.doReact((ConsumerReceiveRequest)request);
            } else if (request instanceof ConsumerAckRequest) {
                this.doReact((ConsumerAckRequest)request);
            } else if (request instanceof ConsumerDenyRequest) {
                this.doReact((ConsumerDenyRequest)request);
            } else if (request instanceof SessAckRequest) {
                this.doReact((SessAckRequest)request);
            } else if (request instanceof SessDenyRequest) {
                this.doReact((SessDenyRequest)request);
            } else if (request instanceof TempDestDeleteRequest) {
                this.doReact((TempDestDeleteRequest)request);
            } else if (request instanceof XACnxPrepare) {
                this.doReact((XACnxPrepare)request);
            } else if (request instanceof XACnxCommit) {
                this.doReact((XACnxCommit)request);
            } else if (request instanceof XACnxRollback) {
                this.doReact((XACnxRollback)request);
            } else if (request instanceof XACnxRecoverRequest) {
                this.doReact((XACnxRecoverRequest)request);
            } else if (request instanceof CnxCloseRequest) {
                this.doReact(key, (CnxCloseRequest)request);
            } else if (request instanceof ActivateConsumerRequest) {
                this.doReact(key, (ActivateConsumerRequest)request);
            } else if (request instanceof CommitRequest) {
                this.doReact(key, (CommitRequest)request);
            }
        }
        catch (MomException mE) {
            logger.log(BasicLevel.ERROR, (Object)(this + " - error during request: " + request), (Throwable)mE);
            this.doReply((AbstractJmsReply)new MomExceptionReply(request.getRequestId(), mE));
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)(this + " - unexpected error during request: " + request), (Throwable)exc);
            this.doReply((AbstractJmsReply)new MomExceptionReply(request.getRequestId(), new MomException(exc.getMessage())));
        }
    }

    private void doReact(int key, GetAdminTopicRequest req) throws AccessException {
        this.sendToClient(key, (AbstractJmsReply)new GetAdminTopicReply(req, AdminTopic.getDefault().toString()));
    }

    private void doReact(int key, CnxConnectRequest req) throws DestinationException {
        this.setSave();
        this.setActiveCtxId(key);
        this.activeCtx = new ClientContext(this.getId(), key);
        this.activeCtx.setProxyAgent(this);
        this.contexts.put(new Integer(key), this.activeCtx);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Connection " + key + " opened."));
        }
        this.doReply((AbstractJmsReply)new CnxConnectReply(req, key, this.getId().toString()));
    }

    private void doReact(CnxStartRequest req) {
        this.activeCtx.setActivated(true);
        Iterator deliveries = this.activeCtx.getPendingDeliveries();
        while (deliveries.hasNext()) {
            this.doReply((AbstractJmsReply)deliveries.next());
        }
        this.activeCtx.clearPendingDeliveries();
    }

    private void doReact(CnxStopRequest req) {
        this.activeCtx.setActivated(false);
        this.doReply((AbstractJmsReply)new ServerReply((AbstractJmsRequest)req));
    }

    private void doReact(SessCreateDestRequest req) throws RequestException {
        AgentId destId = null;
        AdminTopic.DestinationDesc desc = AdminTopic.lookupDest(req.getName(), req.getType());
        if (desc == null) {
            Destination dest = null;
            if (DestinationConstants.isQueue((byte)req.getType())) {
                dest = new Queue();
            } else if (DestinationConstants.isTopic((byte)req.getType())) {
                dest = new Topic();
            } else {
                throw new RequestException("Could not create destination, unknown type:" + req.getType());
            }
            dest.setName(req.getName());
            dest.setAdminId(this.getId());
            dest.setFreeWriting(true);
            if (!DestinationConstants.isTemporary((byte)req.getType())) {
                dest.setFreeReading(true);
            }
            destId = dest.getId();
            try {
                dest.deploy();
            }
            catch (IOException exc) {
                throw new RequestException("Could not create destination:" + exc.getMessage());
            }
            AdminTopic.registerDest(destId, req.getName() == null ? destId.toString() : req.getName(), req.getType());
            if (DestinationConstants.isTemporary((byte)req.getType())) {
                this.activeCtx.addTemporaryDestination(destId);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("UserAgent, new destination created: " + destId));
            }
        } else {
            destId = desc.getId();
        }
        SessCreateDestReply reply = new SessCreateDestReply((AbstractJmsRequest)req, destId.toString());
        this.sendNot(this.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)reply));
    }

    private void doReact(ConsumerSubRequest req) throws StateException, RequestException {
        TopicSubscription tSub;
        AgentId topicId = AgentId.fromString((String)req.getTarget());
        String subName = req.getSubName();
        if (topicId == null) {
            throw new RequestException("Cannot subscribe to an undefined topic (null).");
        }
        if (subName == null) {
            throw new RequestException("Unauthorized null subscription name.");
        }
        boolean newTopic = !this.topicsTable.containsKey(topicId);
        boolean newSub = !this.subsTable.containsKey(subName);
        boolean sent = false;
        if (newTopic) {
            tSub = new TopicSubscription();
            this.topicsTable.put(topicId, tSub);
        } else {
            tSub = (TopicSubscription)this.topicsTable.get(topicId);
        }
        if (newSub) {
            block14: {
                this.setSave();
                ClientSubscription cSub = new ClientSubscription(this.getId(), this.activeCtxId, req.getRequestId(), req.getDurable(), topicId, req.getSubName(), req.getSelector(), req.getNoLocal(), this.dmqId, this.threshold, this.nbMaxMsg, this.messagesTable);
                cSub.setProxyAgent(this);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Subscription " + subName + " created."));
                }
                this.subsTable.put(subName, cSub);
                try {
                    MXWrapper.registerMBean((Object)cSub, (String)this.getSubMBeanName(subName));
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block14;
                    logger.log(BasicLevel.WARN, (Object)"  - Could not register ClientSubscriptionMbean", (Throwable)e);
                }
            }
            tSub.putSubscription(subName, req.getSelector());
            sent = this.updateSubscriptionToTopic(topicId, this.activeCtxId, req.getRequestId(), req.isAsyncSubscription());
        } else {
            boolean updatedTopic;
            ClientSubscription cSub = (ClientSubscription)this.subsTable.get(subName);
            if (cSub.getActive() > 0) {
                throw new StateException("The durable subscription " + subName + " has already been activated.");
            }
            boolean bl = updatedTopic = !topicId.equals((Object)cSub.getTopicId());
            if (updatedTopic) {
                TopicSubscription oldTSub = (TopicSubscription)this.topicsTable.get(cSub.getTopicId());
                oldTSub.removeSubscription(subName);
                this.updateSubscriptionToTopic(cSub.getTopicId(), -1, -1, req.isAsyncSubscription());
            }
            boolean updatedSelector = req.getSelector() == null && cSub.getSelector() != null ? true : (req.getSelector() != null && cSub.getSelector() == null ? true : (req.getSelector() == null && cSub.getSelector() == null ? false : !req.getSelector().equals(cSub.getSelector())));
            cSub.reactivate(this.activeCtxId, req.getRequestId(), topicId, req.getSelector(), req.getNoLocal());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Subscription " + subName + " reactivated."));
            }
            if (updatedTopic || updatedSelector) {
                tSub.putSubscription(subName, req.getSelector());
                sent = this.updateSubscriptionToTopic(topicId, this.activeCtxId, req.getRequestId(), req.isAsyncSubscription());
            }
        }
        this.activeCtx.addSubName(subName);
        if (!sent) {
            this.sendNot(this.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
        }
    }

    private void doReact(ConsumerSetListRequest req) throws DestinationException {
        String subName = req.getTarget();
        ClientSubscription sub = null;
        if (subName != null) {
            sub = (ClientSubscription)this.subsTable.get(subName);
        }
        if (sub == null) {
            throw new DestinationException("Can't set a listener on the non existing subscription: " + subName);
        }
        sub.setListener(req.getRequestId());
        ConsumerMessages consM = sub.deliver();
        if (consM != null) {
            if (this.activeCtx.getActivated()) {
                this.doReply((AbstractJmsReply)consM);
            } else {
                this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
            }
        }
    }

    private void doReact(ConsumerUnsetListRequest req) throws DestinationException {
        if (req.getQueueMode()) {
            this.activeCtx.cancelReceive(req.getCancelledRequestId());
            AgentId to = AgentId.fromString((String)req.getTarget());
            this.sendNot(to, new AbortReceiveRequest(this.activeCtx.getId(), req.getRequestId(), req.getCancelledRequestId()));
        }
    }

    private void doReact(ConsumerCloseSubRequest req) throws DestinationException {
        String subName = req.getTarget();
        ClientSubscription sub = null;
        if (subName != null) {
            sub = (ClientSubscription)this.subsTable.get(subName);
        }
        if (sub == null) {
            throw new DestinationException("Can't desactivate non existing subscription: " + subName);
        }
        this.activeCtx.removeSubName(subName);
        sub.deactivate(false);
        this.doReply((AbstractJmsReply)new ServerReply((AbstractJmsRequest)req));
    }

    private void doReact(ConsumerUnsubRequest req) throws DestinationException {
        block5: {
            this.setSave();
            String subName = req.getTarget();
            ClientSubscription sub = null;
            if (subName != null) {
                sub = (ClientSubscription)this.subsTable.get(subName);
            }
            if (sub == null) {
                throw new DestinationException("Can't unsubscribe non existing subscription: " + subName);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Deleting subscription " + subName));
            }
            AgentId topicId = sub.getTopicId();
            TopicSubscription tSub = (TopicSubscription)this.topicsTable.get(topicId);
            tSub.removeSubscription(subName);
            this.updateSubscriptionToTopic(topicId, -1, -1);
            sub.delete();
            this.activeCtx.removeSubName(subName);
            this.subsTable.remove(subName);
            try {
                MXWrapper.unregisterMBean((String)this.getSubMBeanName(subName));
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block5;
                logger.log(BasicLevel.DEBUG, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e);
            }
        }
        this.sendNot(this.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
    }

    private void doReact(ConsumerReceiveRequest req) throws DestinationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.doReact(" + req + ')'));
        }
        String subName = req.getTarget();
        ClientSubscription sub = null;
        if (subName != null) {
            sub = (ClientSubscription)this.subsTable.get(subName);
        }
        if (sub == null) {
            throw new DestinationException("Can't request a message from the unknown subscription: " + subName);
        }
        sub.setReceiver(req.getRequestId(), req.getTimeToLive());
        ConsumerMessages consM = sub.deliver();
        if (consM != null && req.getReceiveAck()) {
            Vector messageList = consM.getMessages();
            for (int i = 0; i < messageList.size(); ++i) {
                org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)messageList.elementAt(i);
                sub.acknowledge(msg.getId());
            }
        }
        if (consM == null && req.getTimeToLive() == -1L) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> immediate delivery");
            }
            sub.unsetReceiver();
            consM = new ConsumerMessages(req.getRequestId(), subName, false);
        }
        if (consM != null && this.activeCtx.getActivated()) {
            this.doReply((AbstractJmsReply)consM);
        } else if (consM != null) {
            this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
        }
    }

    private void doReact(SessAckRequest req) {
        if (req.getQueueMode()) {
            AgentId qId = AgentId.fromString((String)req.getTarget());
            Vector ids = req.getIds();
            AcknowledgeRequest not = new AcknowledgeRequest(this.activeCtxId, req.getRequestId(), ids);
            if (qId.getTo() == this.getId().getTo()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> local acking");
                }
                not.setPersistent(false);
            }
            this.sendNot(qId, not);
        } else {
            String subName = req.getTarget();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub != null) {
                sub.acknowledge(req.getIds().iterator());
            }
        }
    }

    private void doReact(SessDenyRequest req) {
        if (req.getQueueMode()) {
            AgentId qId = AgentId.fromString((String)req.getTarget());
            Vector ids = req.getIds();
            DenyRequest dr = new DenyRequest(this.activeCtxId, req.getRequestId(), ids);
            if (req.isRedelivered()) {
                dr.setRedelivered(true);
            }
            this.sendNot(qId, dr);
            if (!req.getDoNotAck()) {
                this.sendNot(this.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
            }
        } else {
            String subName = req.getTarget();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null) {
                return;
            }
            sub.deny(req.getIds().iterator(), req.isRedelivered());
            ConsumerMessages consM = sub.deliver();
            if (consM != null && this.activeCtx.getActivated()) {
                this.doReply((AbstractJmsReply)consM);
            } else if (consM != null) {
                this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
            }
        }
    }

    private void doReact(ConsumerAckRequest req) {
        if (req.getQueueMode()) {
            AgentId qId = AgentId.fromString((String)req.getTarget());
            AcknowledgeRequest not = new AcknowledgeRequest(this.activeCtxId, req.getRequestId(), req.getIds());
            if (qId.getTo() == this.getId().getTo()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> local acking");
                }
                not.setPersistent(false);
                this.sendNot(qId, not);
            } else {
                this.sendNot(qId, not);
            }
        } else {
            String subName = req.getTarget();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub != null) {
                sub.acknowledge(req.getIds().iterator());
            }
        }
    }

    private void doReact(ConsumerDenyRequest req) {
        if (req.getQueueMode()) {
            AgentId qId = AgentId.fromString((String)req.getTarget());
            String id = req.getId();
            DenyRequest denyRequest = new DenyRequest(this.activeCtxId, req.getRequestId(), id);
            denyRequest.setRedelivered(req.isRedelivered());
            this.sendNot(qId, denyRequest);
            if (!req.getDoNotAck()) {
                this.sendNot(this.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
            }
        } else {
            String subName = req.getTarget();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null) {
                return;
            }
            Vector<String> ids = new Vector<String>();
            ids.add(req.getId());
            sub.deny(ids.iterator(), req.isRedelivered());
            ConsumerMessages consM = sub.deliver();
            if (consM != null && this.activeCtx.getActivated()) {
                this.doReply((AbstractJmsReply)consM);
            } else if (consM != null) {
                this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
            }
        }
    }

    private void doReact(TempDestDeleteRequest req) {
        AgentId tempId = AgentId.fromString((String)req.getTarget());
        this.activeCtx.removeTemporaryDestination(tempId);
        this.deleteTemporaryDestination(tempId);
        this.sendNot(this.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
    }

    private void deleteTemporaryDestination(AgentId destId) {
        this.sendNot(destId, (Notification)new DeleteNot());
        AdminTopic.unregisterDest(destId.toString());
    }

    private void doReact(XACnxPrepare req) throws StateException {
        try {
            Xid xid = new Xid(req.getBQ(), req.getFI(), req.getGTI());
            this.activeCtx.registerTxPrepare(xid, req);
            this.doReply((AbstractJmsReply)new ServerReply((AbstractJmsRequest)req));
        }
        catch (Exception exc) {
            throw new StateException(exc.getMessage());
        }
    }

    private void doReact(XACnxCommit req) throws StateException {
        Xid xid = new Xid(req.getBQ(), req.getFI(), req.getGTI());
        XACnxPrepare prepare = this.activeCtx.getTxPrepare(xid);
        if (prepare == null) {
            throw new StateException("Unknown transaction identifier.");
        }
        Vector sendings = prepare.getSendings();
        Vector acks = prepare.getAcks();
        while (!sendings.isEmpty()) {
            ProducerMessages pM = (ProducerMessages)sendings.remove(0);
            ClientMessages not = new ClientMessages(this.activeCtxId, pM.getRequestId(), pM.getMessages());
            this.sendNot(AgentId.fromString((String)pM.getTarget()), not);
        }
        while (!acks.isEmpty()) {
            this.doReact((SessAckRequest)acks.remove(0));
        }
        this.doReply((AbstractJmsReply)new ServerReply((AbstractJmsRequest)req));
    }

    private void doReact(XACnxRollback req) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("doReact(" + req + ')'));
        }
        Xid xid = new Xid(req.getBQ(), req.getFI(), req.getGTI());
        Enumeration queues = req.getQueues();
        while (queues.hasMoreElements()) {
            String queueName = (String)queues.nextElement();
            AgentId qId = AgentId.fromString((String)queueName);
            Vector ids = req.getQueueIds(queueName);
            DenyRequest deny = new DenyRequest(this.activeCtxId, req.getRequestId(), ids);
            deny.setRedelivered(true);
            this.sendNot(qId, deny);
        }
        Enumeration subs = req.getSubs();
        while (subs.hasMoreElements()) {
            String subName = (String)subs.nextElement();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null) continue;
            sub.deny(req.getSubIds(subName).iterator(), true);
            ConsumerMessages consM = sub.deliver();
            if (consM != null && this.activeCtx.getActivated()) {
                this.doReply((AbstractJmsReply)consM);
                continue;
            }
            if (consM == null) continue;
            this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
        }
        XACnxPrepare prepare = this.activeCtx.getTxPrepare(xid);
        if (prepare != null) {
            Vector acks = prepare.getAcks();
            while (!acks.isEmpty()) {
                SessAckRequest ack = (SessAckRequest)acks.remove(0);
                SessDenyRequest deny = new SessDenyRequest(ack.getTarget(), ack.getIds(), ack.getQueueMode(), true);
                deny.setRedelivered(true);
                this.doReact(deny);
            }
        }
        this.sendNot(this.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
    }

    private void doReact(XACnxRecoverRequest req) throws StateException {
        this.setSave();
        Vector<byte[]> bqs = new Vector<byte[]>();
        Vector<Integer> fis = new Vector<Integer>();
        Vector<byte[]> gtis = new Vector<byte[]>();
        if (this.recoveredTransactions != null) {
            Iterator txs = this.recoveredTransactions.entrySet().iterator();
            while (txs.hasNext()) {
                Map.Entry txEntry = txs.next();
                Xid xid = (Xid)txEntry.getKey();
                bqs.add(xid.bq);
                fis.add(new Integer(xid.fi));
                gtis.add(xid.gti);
                try {
                    txs.remove();
                    this.activeCtx.registerTxPrepare(xid, (XACnxPrepare)txEntry.getValue());
                }
                catch (Exception exc) {
                    throw new StateException("Recovered transaction branch has already been prepared by the RM.");
                }
            }
        }
        this.recoveredTransactions = null;
        this.doReply((AbstractJmsReply)new XACnxRecoverReply(req, bqs, fis, gtis));
    }

    private void doReact(SyncReply not) {
        this.sendToClient(not.key, not.reply);
    }

    private void doReact(int key, CnxCloseRequest req) {
        this.setSave();
        boolean prepared = false;
        Iterator ids = this.activeCtx.getDeliveringQueues();
        while (ids.hasNext()) {
            AgentId id = (AgentId)ids.next();
            Iterator xids = this.activeCtx.getTxIds();
            while (xids.hasNext()) {
                Xid xid = (Xid)xids.next();
                if (!this.activeCtx.isPrepared(xid)) continue;
                prepared = true;
                break;
            }
            if (!prepared) {
                this.sendNot(id, new DenyRequest(key));
            }
            prepared = false;
        }
        String subName = null;
        Vector<AgentId> topics = new Vector<AgentId>();
        Iterator subs = this.activeCtx.getActiveSubs();
        while (subs.hasNext()) {
            ClientSubscription sub;
            block15: {
                subName = (String)subs.next();
                sub = (ClientSubscription)this.subsTable.get(subName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Deactivate subscription " + subName + ", topic id = " + sub.getTopicId()));
                }
                if (sub.getDurable()) {
                    sub.deactivate(true);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Durable subscription" + subName + " de-activated."));
                    continue;
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable = " + this.topicsTable));
                }
                sub.delete();
                this.subsTable.remove(subName);
                try {
                    MXWrapper.unregisterMBean((String)this.getSubMBeanName(subName));
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block15;
                    logger.log(BasicLevel.DEBUG, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e);
                }
            }
            TopicSubscription tSub = (TopicSubscription)this.topicsTable.get(sub.getTopicId());
            tSub.removeSubscription(subName);
            if (!topics.contains(sub.getTopicId())) {
                topics.add(sub.getTopicId());
            }
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)("Temporary subscription" + subName + " deleted."));
        }
        Iterator topicIds = topics.iterator();
        while (topicIds.hasNext()) {
            this.updateSubscriptionToTopic((AgentId)topicIds.next(), -1, -1);
        }
        Iterator dests = this.activeCtx.getTempDestinations();
        while (dests.hasNext()) {
            AgentId destId = (AgentId)dests.next();
            this.activeCtx.removeTemporaryDestination(destId);
            this.deleteTemporaryDestination(destId);
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)("Deletes temporary destination " + destId.toString()));
        }
        Iterator xids = this.activeCtx.getTxIds();
        while (xids.hasNext()) {
            if (this.recoveredTransactions == null) {
                this.recoveredTransactions = new Hashtable();
            }
            Xid xid = (Xid)xids.next();
            XACnxPrepare recoveredPrepare = (XACnxPrepare)this.recoveredTransactions.get(xid);
            XACnxPrepare prepare = this.activeCtx.getTxPrepare(xid);
            if (recoveredPrepare == null) {
                this.recoveredTransactions.put(xid, prepare);
                continue;
            }
            recoveredPrepare.getSendings().addAll(prepare.getSendings());
            recoveredPrepare.getAcks().addAll(prepare.getAcks());
        }
        this.contexts.remove(new Integer(key));
        this.activeCtx = null;
        this.setActiveCtxId(-1);
        CnxCloseReply reply = new CnxCloseReply();
        reply.setCorrelationId(req.getRequestId());
        this.sendToClient(key, (AbstractJmsReply)reply);
    }

    private void doReact(int key, ActivateConsumerRequest req) {
        ConsumerMessages consM;
        String subName = req.getTarget();
        ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
        sub.setActive(req.getActivate());
        if (sub.getActive() > 0 && (consM = sub.deliver()) != null) {
            try {
                this.setCtx(sub.getContextId());
                if (this.activeCtx.getActivated()) {
                    this.doReply((AbstractJmsReply)consM);
                } else {
                    this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
                }
            }
            catch (StateException pE) {
                // empty catch block
            }
        }
    }

    private void doReact(int key, CommitRequest req) {
        Enumeration acks;
        int asyncReplyCount = 0;
        Enumeration pms = req.getProducerMessages();
        if (pms != null) {
            while (pms.hasMoreElements()) {
                ProducerMessages pm = (ProducerMessages)pms.nextElement();
                AgentId destId = AgentId.fromString((String)pm.getTarget());
                ClientMessages not = new ClientMessages(key, req.getRequestId(), pm.getMessages());
                this.setDmq(not);
                if (destId.getTo() == this.getId().getTo()) {
                    not.setPersistent(false);
                    if (req.getAsyncSend()) {
                        not.setAsyncSend(true);
                    } else {
                        ++asyncReplyCount;
                    }
                }
                this.sendNot(destId, not);
            }
        }
        if ((acks = req.getAckRequests()) != null) {
            while (acks.hasMoreElements()) {
                SessAckRequest sar = (SessAckRequest)acks.nextElement();
                if (sar.getQueueMode()) {
                    AgentId qId = AgentId.fromString((String)sar.getTarget());
                    Vector ids = sar.getIds();
                    AcknowledgeRequest not = new AcknowledgeRequest(this.activeCtxId, req.getRequestId(), ids);
                    if (qId.getTo() == this.getId().getTo()) {
                        not.setPersistent(false);
                    }
                    this.sendNot(qId, not);
                    continue;
                }
                String subName = sar.getTarget();
                ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
                if (sub == null) continue;
                sub.acknowledge(sar.getIds().iterator());
                this.setSave();
            }
        }
        if (!req.getAsyncSend()) {
            if (asyncReplyCount == 0) {
                this.sendNot(this.getId(), new SendReplyNot(key, req.getRequestId()));
            } else {
                this.activeCtx.addMultiReplyContext(req.getRequestId(), asyncReplyCount);
            }
        }
    }

    private void doFwd(AgentId from, AbstractReplyNot rep) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " got " + ((Object)((Object)rep)).getClass().getName() + " with id: " + rep.getCorrelationId() + " from: " + from));
        }
        if (rep instanceof QueueMsgReply) {
            this.doFwd(from, (QueueMsgReply)rep);
        } else if (rep instanceof BrowseReply) {
            this.doFwd((BrowseReply)rep);
        } else if (rep instanceof SubscribeReply) {
            this.doFwd((SubscribeReply)rep);
        } else if (rep instanceof TopicMsgsReply) {
            this.doFwd(from, (TopicMsgsReply)rep);
        } else if (rep instanceof ExceptionReply) {
            this.doReact(from, (ExceptionReply)rep);
        } else if (logger.isLoggable(BasicLevel.ERROR)) {
            logger.log(BasicLevel.ERROR, (Object)("Unexpected reply: " + (Object)((Object)rep)));
        }
    }

    private void doFwd(AgentId from, QueueMsgReply rep) {
        block18: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("UserAgent.doFwd(" + from + ',' + (Object)((Object)rep) + ')'));
            }
            try {
                this.setCtx(rep.getClientContext());
                if (rep.getCorrelationId() == this.activeCtx.getCancelledReceive()) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)(" -> cancelled receive: id=" + this.activeCtx.getCancelledReceive()));
                    }
                    if (rep.getSize() > 0) {
                        Vector msgList = rep.getMessages();
                        for (int i = 0; i < msgList.size(); ++i) {
                            org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgList.elementAt(i));
                            String msgId = msg.getId();
                            if (logger.isLoggable(BasicLevel.INFO)) {
                                logger.log(BasicLevel.INFO, (Object)(" -> denying message: " + msgId));
                            }
                            this.sendNot(from, new DenyRequest(0, rep.getCorrelationId(), msgId));
                        }
                    }
                } else {
                    ConsumerMessages jRep;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)" -> reply");
                    }
                    if (rep.getSize() > 0) {
                        jRep = new ConsumerMessages(rep.getCorrelationId(), rep.getMessages(), from.toString(), true);
                        this.activeCtx.addDeliveringQueue(from);
                    } else {
                        jRep = new ConsumerMessages(rep.getCorrelationId(), (Vector)null, from.toString(), true);
                    }
                    if (this.activeCtx.getActivated()) {
                        this.doReply((AbstractJmsReply)jRep);
                    } else {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)" -> buffer the reply");
                        }
                        this.activeCtx.addPendingDelivery((AbstractJmsReply)jRep);
                    }
                }
            }
            catch (StateException pE) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)pE);
                }
                if (rep.getMessages().size() <= 0) break block18;
                Vector msgList = rep.getMessages();
                for (int i = 0; i < msgList.size(); ++i) {
                    org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgList.elementAt(i));
                    String msgId = msg.getId();
                    if (logger.isLoggable(BasicLevel.INFO)) {
                        logger.log(BasicLevel.INFO, (Object)("Denying message: " + msgId));
                    }
                    this.sendNot(from, new DenyRequest(0, rep.getCorrelationId(), msgId));
                }
            }
        }
    }

    private void doFwd(BrowseReply rep) {
        try {
            this.setCtx(rep.getClientContext());
            this.doReply((AbstractJmsReply)new QBrowseReply(rep.getCorrelationId(), rep.getMessages()));
        }
        catch (StateException stateException) {
            // empty catch block
        }
    }

    private void doFwd(SubscribeReply rep) {
        try {
            this.setCtx(rep.getClientContext());
            this.doReply((AbstractJmsReply)new ServerReply(rep.getCorrelationId()));
        }
        catch (StateException stateException) {
            // empty catch block
        }
    }

    protected final String getMsgTxname() {
        if (this.msgTxname == null) {
            this.msgTxname = 'M' + this.getId().toString() + '_';
        }
        return this.msgTxname;
    }

    protected final void setMsgTxName(org.objectweb.joram.mom.messages.Message msg) {
        if (msg.getTxName() == null) {
            msg.setTxName(this.getMsgTxname() + msg.order);
        }
    }

    private void doFwd(AgentId from, TopicMsgsReply rep) {
        ClientSubscription sub;
        String subName;
        TopicSubscription tSub = (TopicSubscription)this.topicsTable.get(from);
        if (tSub == null || tSub.isEmpty()) {
            return;
        }
        ArrayList<org.objectweb.joram.mom.messages.Message> messages = new ArrayList<org.objectweb.joram.mom.messages.Message>();
        Iterator msgs = rep.getMessages().iterator();
        while (msgs.hasNext()) {
            org.objectweb.joram.mom.messages.Message message = new org.objectweb.joram.mom.messages.Message((Message)msgs.next());
            ++this.arrivalsCounter;
            message.order = message.order;
            messages.add(message);
        }
        Iterator names = tSub.getNames();
        while (names.hasNext()) {
            subName = (String)names.next();
            sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null) continue;
            sub.browseNewMessages(messages);
        }
        for (org.objectweb.joram.mom.messages.Message message : messages) {
            if (message.durableAcksCounter <= 0) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> save message " + message));
            }
            this.setSave();
            this.setMsgTxName(message);
            message.save();
            message.releaseFullMessage();
        }
        names = tSub.getNames();
        while (names.hasNext()) {
            ConsumerMessages consM;
            subName = (String)names.next();
            sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null || sub.getActive() <= 0 || (consM = sub.deliver()) == null) continue;
            try {
                this.setCtx(sub.getContextId());
                if (this.activeCtx.getActivated()) {
                    this.doReply((AbstractJmsReply)consM);
                    continue;
                }
                this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
            }
            catch (StateException pE) {}
        }
    }

    private void doReact(AgentId from, ExceptionReply rep) {
        MomException exc;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.doReact(" + from + ',' + (Object)((Object)rep) + ')'));
        }
        if ((exc = rep.getException()) instanceof AccessException) {
            TopicSubscription tSub;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable.remove(" + from + ')'));
            }
            if ((tSub = (TopicSubscription)this.topicsTable.remove(from)) != null) {
                Iterator e = tSub.getNames();
                while (e.hasNext()) {
                    ClientSubscription sub;
                    String name;
                    block11: {
                        name = (String)e.next();
                        sub = (ClientSubscription)this.subsTable.remove(name);
                        try {
                            MXWrapper.unregisterMBean((String)this.getSubMBeanName(name));
                        }
                        catch (Exception e1) {
                            if (!logger.isLoggable(BasicLevel.DEBUG)) break block11;
                            logger.log(BasicLevel.DEBUG, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e1);
                        }
                    }
                    sub.delete();
                    try {
                        this.setCtx(sub.getContextId());
                        this.activeCtx.removeSubName(name);
                        this.doReply((AbstractJmsReply)new MomExceptionReply(rep.getCorrelationId(), exc));
                    }
                    catch (StateException pExc) {}
                }
                return;
            }
        }
        try {
            this.setCtx(rep.getClientContext());
            this.doReply((AbstractJmsReply)new MomExceptionReply(rep.getCorrelationId(), exc));
        }
        catch (StateException pExc) {
            // empty catch block
        }
    }

    private String getSubMBeanName(String name) {
        return this.getMBeanName().append(",sub=").append(name).toString();
    }

    private void doReact(AdminReplyNot reply) {
    }

    private void doReact(UnknownAgent uA) {
        TopicSubscription tSub;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.doReact(" + uA + ')'));
        }
        Notification not = uA.not;
        AgentId agId = uA.agent;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("--- " + this + " notified of invalid destination: " + agId.toString()));
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable.remove(" + agId + ')'));
        }
        if ((tSub = (TopicSubscription)this.topicsTable.remove(agId)) != null) {
            DestinationException exc = new DestinationException("Destination " + agId + " does not exist.");
            Iterator e = tSub.getNames();
            while (e.hasNext()) {
                ClientSubscription sub;
                String name;
                block24: {
                    name = (String)e.next();
                    sub = (ClientSubscription)this.subsTable.remove(name);
                    try {
                        MXWrapper.unregisterMBean((String)this.getSubMBeanName(name));
                    }
                    catch (Exception e1) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break block24;
                        logger.log(BasicLevel.DEBUG, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e1);
                    }
                }
                sub.delete();
                try {
                    this.setCtx(sub.getContextId());
                    this.activeCtx.removeSubName(name);
                    this.doReply((AbstractJmsReply)new MomExceptionReply(sub.getSubRequestId(), (MomException)exc));
                }
                catch (StateException pExc) {}
            }
            return;
        }
        if (not instanceof AbstractRequestNot) {
            AbstractRequestNot req;
            block25: {
                req = (AbstractRequestNot)not;
                if (req instanceof ClientMessages) {
                    if (this.dmqId != null && agId.equals((Object)this.dmqId)) {
                        this.setSave();
                        this.dmqId = null;
                        Iterator subs = this.subsTable.values().iterator();
                        while (subs.hasNext()) {
                            ((ClientSubscription)subs.next()).setDMQId(null);
                        }
                    }
                    if (Queue.getDefaultDMQId() != null && !agId.equals((Object)Queue.getDefaultDMQId())) {
                        DMQManager dmqManager = new DMQManager(this.dmqId, null);
                        for (Message msg : ((ClientMessages)req).getMessages()) {
                            ++this.nbMsgsSentToDMQSinceCreation;
                            dmqManager.addDeadMessage(msg, (short)4);
                        }
                        dmqManager.sendToDMQ();
                    }
                    DestinationException exc = new DestinationException("Destination " + agId + " does not exist.");
                    MomExceptionReply mer = new MomExceptionReply(req.getRequestId(), (MomException)exc);
                    try {
                        this.setCtx(req.getClientContext());
                        this.doReply((AbstractJmsReply)mer);
                    }
                    catch (StateException se) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)se);
                        }
                        break block25;
                    }
                }
                if (req instanceof ReceiveRequest) {
                    DestinationException exc = new DestinationException("Destination " + agId + " does not exist.");
                    MomExceptionReply mer = new MomExceptionReply(req.getRequestId(), (MomException)exc);
                    try {
                        this.setCtx(req.getClientContext());
                        if (this.activeCtx.getActivated()) {
                            this.doReply((AbstractJmsReply)mer);
                        } else {
                            this.activeCtx.addPendingDelivery((AbstractJmsReply)mer);
                        }
                    }
                    catch (StateException se) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break block25;
                        logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)se);
                    }
                }
            }
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("Connection " + req.getClientContext() + " notified of the deletion of destination " + agId));
            }
        }
    }

    private void doReact(FwdAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof GetSubscriptions) {
            this.doReact((GetSubscriptions)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetSubscriptionMessageIds) {
            this.doReact((GetSubscriptionMessageIds)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetSubscriptionMessage) {
            this.doReact((GetSubscriptionMessage)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof DeleteSubscriptionMessage) {
            this.doReact((DeleteSubscriptionMessage)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetSubscription) {
            this.doReact((GetSubscription)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof ClearSubscription) {
            this.doReact((ClearSubscription)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetNbMaxMsgRequest) {
            GetNbMaxMsgRequest request = (GetNbMaxMsgRequest)adminRequest;
            int nbMaxMsg = -1;
            if (request.getSubName() == null) {
                nbMaxMsg = this.nbMaxMsg;
            } else {
                ClientSubscription sub = (ClientSubscription)this.subsTable.get(request.getSubName());
                if (sub != null) {
                    nbMaxMsg = sub.getNbMaxMsg();
                }
            }
            this.replyToTopic((AdminReply)new GetNumberReply(nbMaxMsg), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetDMQSettingsRequest) {
            String subName = ((GetDMQSettingsRequest)adminRequest).getSubName();
            String dmq = this.dmqId != null ? this.dmqId.toString() : null;
            int threshold = -1;
            if (subName == null) {
                threshold = this.threshold;
            } else {
                ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
                if (sub != null) {
                    threshold = sub.getThreshold();
                }
            }
            this.replyToTopic((AdminReply)new GetDMQSettingsReply(dmq, threshold), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetDMQRequest) {
            this.setSave();
            this.dmqId = ((SetDMQRequest)adminRequest).getDmqId() != null ? AgentId.fromString((String)((SetDMQRequest)adminRequest).getDmqId()) : null;
            Iterator subs = this.subsTable.values().iterator();
            while (subs.hasNext()) {
                ((ClientSubscription)subs.next()).setDMQId(this.dmqId);
            }
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetThresholdRequest) {
            this.setSave();
            int threshold = ((SetThresholdRequest)adminRequest).getThreshold();
            AdminReply reply = null;
            String subName = ((SetThresholdRequest)adminRequest).getSubName();
            if (subName == null) {
                this.threshold = threshold;
                reply = new AdminReply(true, null);
            } else {
                ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
                if (sub != null) {
                    sub.setThreshold(threshold);
                    reply = new AdminReply(true, null);
                } else {
                    reply = new AdminReply(6, "Subscription unknow: " + subName);
                }
            }
            this.replyToTopic(reply, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetNbMaxMsgRequest) {
            this.setSave();
            int nbMaxMsg = ((SetNbMaxMsgRequest)adminRequest).getNbMaxMsg();
            AdminReply reply = null;
            String subName = ((SetNbMaxMsgRequest)adminRequest).getSubName();
            if (subName == null) {
                this.nbMaxMsg = nbMaxMsg;
                reply = new AdminReply(true, null);
            } else {
                ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
                if (sub != null) {
                    sub.setNbMaxMsg(nbMaxMsg);
                    reply = new AdminReply(true, null);
                } else {
                    reply = new AdminReply(6, "Subscription unknow: " + subName);
                }
            }
            this.replyToTopic(reply, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof DeleteUser) {
            this.deleteProxy(not);
        } else if (adminRequest instanceof AdminCommandRequest) {
            this.doReact((AdminCommandRequest)adminRequest, not.getReplyTo(), not.getRequestMsgId());
        } else {
            logger.log(BasicLevel.ERROR, (Object)("Unknown administration request for proxy " + this.getId()));
            this.replyToTopic(new AdminReply(5, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        }
    }

    private void doReact(AdminCommandRequest request, AgentId replyTo, String requestMsgId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("doReact(" + request + ", " + replyTo + ", " + requestMsgId + ')'));
        }
        Properties prop = null;
        Properties replyProp = null;
        try {
            switch (request.getCommand()) {
                case 1: {
                    prop = request.getProp();
                    if (this.interceptorsOUT == null) {
                        this.interceptorsOUT = new ArrayList();
                    }
                    InterceptorsHelper.addInterceptors((String)prop.get("jms_joram_interceptors_out"), this.interceptorsOUT);
                    this.interceptors_out = InterceptorsHelper.getListInterceptors(this.interceptorsOUT);
                    if (this.interceptorsIN == null) {
                        this.interceptorsIN = new ArrayList();
                    }
                    InterceptorsHelper.addInterceptors((String)prop.get("jms_joram_interceptors_in"), this.interceptorsIN);
                    this.interceptors_in = InterceptorsHelper.getListInterceptors(this.interceptorsIN);
                    this.setSave();
                    break;
                }
                case 2: {
                    prop = request.getProp();
                    InterceptorsHelper.removeInterceptors((String)prop.get("jms_joram_interceptors_out"), this.interceptorsOUT);
                    this.interceptors_out = InterceptorsHelper.getListInterceptors(this.interceptorsOUT);
                    InterceptorsHelper.removeInterceptors((String)prop.get("jms_joram_interceptors_in"), this.interceptorsIN);
                    this.interceptors_in = InterceptorsHelper.getListInterceptors(this.interceptorsIN);
                    if (this.interceptorsIN != null && this.interceptorsIN.isEmpty()) {
                        this.interceptorsIN = null;
                    }
                    if (this.interceptorsOUT != null && this.interceptorsOUT.isEmpty()) {
                        this.interceptorsOUT = null;
                    }
                    this.setSave();
                    break;
                }
                case 3: {
                    replyProp = new Properties();
                    if (this.interceptors_in == null) {
                        replyProp.put("jms_joram_interceptors_in", "");
                    } else {
                        replyProp.put("jms_joram_interceptors_in", InterceptorsHelper.getListInterceptors(this.interceptorsIN));
                    }
                    if (this.interceptors_out == null) {
                        replyProp.put("jms_joram_interceptors_out", "");
                        break;
                    }
                    replyProp.put("jms_joram_interceptors_out", InterceptorsHelper.getListInterceptors(this.interceptorsOUT));
                    break;
                }
                case 4: {
                    prop = request.getProp();
                    if (this.interceptorsIN == null && prop.containsKey("jms_joram_interceptors_in_new")) {
                        throw new Exception("interceptorsIN == null.");
                    }
                    if (this.interceptorsOUT == null && prop.containsKey("jms_joram_interceptors_out_new")) {
                        throw new Exception("interceptorsOUT == null.");
                    }
                    InterceptorsHelper.replaceInterceptor((String)prop.get("jms_joram_interceptors_in_new"), (String)prop.get("jms_joram_interceptors_in_old"), this.interceptorsIN);
                    this.interceptors_in = InterceptorsHelper.getListInterceptors(this.interceptorsIN);
                    InterceptorsHelper.replaceInterceptor((String)prop.get("jms_joram_interceptors_out_new"), (String)prop.get("jms_joram_interceptors_out_old"), this.interceptorsOUT);
                    this.interceptors_out = InterceptorsHelper.getListInterceptors(this.interceptorsOUT);
                    this.setSave();
                    break;
                }
                default: {
                    throw new Exception("Bad command : \"" + request.getCommand() + "\"");
                }
            }
            this.replyToTopic((AdminReply)new AdminCommandReply(true, AdminCommandConstant.commandNames[request.getCommand()] + " done.", replyProp), replyTo, requestMsgId, requestMsgId);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)exc);
            }
            this.replyToTopic(new AdminReply(-1, exc.getMessage()), replyTo, requestMsgId, requestMsgId);
        }
    }

    private void doReact(GetSubscriptions request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        Iterator subsIterator = this.subsTable.entrySet().iterator();
        String[] subNames = new String[this.subsTable.size()];
        String[] topicIds = new String[this.subsTable.size()];
        int[] messageCounts = new int[this.subsTable.size()];
        int[] ackCounts = new int[this.subsTable.size()];
        boolean[] durable = new boolean[this.subsTable.size()];
        int i = 0;
        while (subsIterator.hasNext()) {
            Map.Entry subEntry = subsIterator.next();
            subNames[i] = (String)subEntry.getKey();
            ClientSubscription cs = (ClientSubscription)subEntry.getValue();
            topicIds[i] = cs.getTopicId().toString();
            messageCounts[i] = cs.getPendingMessageCount();
            ackCounts[i] = cs.getDeliveredMessageCount();
            durable[i] = cs.getDurable();
            ++i;
        }
        GetSubscriptionsRep reply = new GetSubscriptionsRep(subNames, topicIds, messageCounts, ackCounts, durable);
        this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
    }

    public String[] getSubscriptionNames() {
        return this.subsTable.keySet().toArray(new String[this.subsTable.size()]);
    }

    private void doReact(GetSubscriptionMessageIds request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String subName = request.getSubscriptionName();
        ClientSubscription cs = null;
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            GetSubscriptionMessageIdsRep reply = new GetSubscriptionMessageIdsRep(cs.getMessageIds());
            this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + request.getSubscriptionName()), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void doReact(GetSubscription request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String subName = request.getSubscriptionName();
        ClientSubscription cs = null;
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            GetSubscriptionRep reply = new GetSubscriptionRep(cs.getTopicId().toString(), cs.getPendingMessageCount(), cs.getDeliveredMessageCount(), cs.getDurable());
            this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + request.getSubscriptionName()), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void doReact(GetSubscriptionMessage request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        ClientSubscription cs = null;
        String subName = request.getSubscriptionName();
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            String msgId = request.getMessageId();
            org.objectweb.joram.mom.messages.Message message = null;
            if (msgId != null) {
                message = cs.getSubscriptionMessage(msgId);
            }
            if (message != null) {
                GetSubscriptionMessageRep reply = null;
                reply = request.getFullMessage() ? new GetSubscriptionMessageRep(message.getFullMessage()) : new GetSubscriptionMessageRep(message.getHeaderMessage());
                this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
            } else {
                this.replyToTopic(new AdminReply(false, "Message not found: " + request.getMessageId()), replyTo, requestMsgId, replyMsgId);
            }
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + subName), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void doReact(DeleteSubscriptionMessage request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String subName = request.getSubscriptionName();
        ClientSubscription cs = null;
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            cs.deleteMessage(request.getMessageId());
            this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + request.getSubscriptionName()), replyTo, requestMsgId, replyMsgId);
        }
    }

    public void deleteSubscriptionMessage(String subName, String msgId) {
        ClientSubscription cs = (ClientSubscription)this.subsTable.get(subName);
        if (cs != null) {
            cs.deleteMessage(msgId);
        }
    }

    private void doReact(ClearSubscription request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String subName = request.getSubscriptionName();
        ClientSubscription cs = null;
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            cs.clear();
            this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + request.getSubscriptionName()), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void replyToTopic(AdminReply reply, AgentId replyTo, String requestMsgId, String replyMsgId) {
        if (replyTo == null) {
            return;
        }
        Message message = MessageHelper.createMessage((String)replyMsgId, (String)requestMsgId, (String)replyTo.toString(), (byte)1);
        try {
            message.setAdminMessage((AbstractAdminMessage)reply);
            ClientMessages clientMessages = new ClientMessages(-1, -1, message);
            Channel.sendTo((AgentId)replyTo, (Notification)clientMessages);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new Error(exc.getMessage());
        }
    }

    private void setCtx(int key) throws StateException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.setCtx(" + key + ')'));
        }
        if (key < 0) {
            throw new StateException("Invalid context: " + key);
        }
        if (key == this.activeCtxId) {
            return;
        }
        this.setActiveCtxId(key);
        this.activeCtx = (ClientContext)this.contexts.get(new Integer(key));
        if (this.activeCtx == null) {
            this.setActiveCtxId(-1);
            this.activeCtx = null;
            throw new StateException("Context " + key + " is closed or broken.");
        }
    }

    private void doReply(AbstractJmsReply reply) {
        this.sendToClient(this.activeCtxId, reply);
    }

    protected ClientContext getClientContext(int ctxId) {
        return (ClientContext)this.contexts.get(new Integer(ctxId));
    }

    protected void cleanPendingMessages(long currentTime) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.cleanPendingMessages(" + this.messagesTable.size() + ')'));
        }
        org.objectweb.joram.mom.messages.Message message = null;
        DMQManager dmqManager = null;
        Iterator values = this.messagesTable.values().iterator();
        while (values.hasNext()) {
            message = (org.objectweb.joram.mom.messages.Message)values.next();
            if (message == null || message.isValid(currentTime)) continue;
            values.remove();
            if (message.durableAcksCounter > 0) {
                message.delete();
            }
            if (dmqManager == null) {
                dmqManager = new DMQManager(this.dmqId, null);
            }
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)0);
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent expired message " + message.getId()));
        }
        Iterator subs = this.subsTable.values().iterator();
        while (subs.hasNext()) {
            ((ClientSubscription)subs.next()).cleanMessageIds();
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.cleanPendingMessages -> " + this.messagesTable.size()));
        }
    }

    public void delete() {
        DeleteUser request = new DeleteUser(this.getName(), this.getId().toString());
        FwdAdminRequestNot deleteNot = new FwdAdminRequestNot((AdminRequest)request, null, null);
        Channel.sendTo((AgentId)AdminTopic.getDefault(), (Notification)deleteNot);
    }

    private void deleteProxy(FwdAdminRequestNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " notified to be deleted."));
        }
        String userName = ((DeleteUser)not.getRequest()).getUserName();
        if (this.contexts.size() > 0) {
            String info = "Delete proxy request successful [false]: proxy [" + this.getId() + "] of user [" + userName + "] is currently in use.";
            if (not.getReplyTo() != null) {
                this.replyToTopic(new AdminReply(4, info), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
            }
            return;
        }
        AdminTopic.deleteUser(userName);
        String info = "Delete proxy request successful [true]: proxy [" + this.getId() + "] of user [" + userName + "] has been notified of deletion";
        if (not.getReplyTo() != null) {
            this.replyToTopic(new AdminReply(true, info), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        }
        Iterator topics = this.topicsTable.keySet().iterator();
        while (topics.hasNext()) {
            AgentId destId = (AgentId)topics.next();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable.remove(" + destId + ')'));
            }
            topics.remove();
            this.updateSubscriptionToTopic(destId, -1, -1);
        }
        for (Map.Entry subEntry : this.subsTable.entrySet()) {
            String subName = (String)subEntry.getKey();
            ClientSubscription sub = (ClientSubscription)subEntry.getValue();
            sub.delete();
            try {
                MXWrapper.unregisterMBean((String)this.getSubMBeanName(subName));
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e);
            }
        }
        Channel.sendTo((AgentId)this.getId(), (Notification)new DeleteNot());
    }

    private boolean updateSubscriptionToTopic(AgentId topicId, int contextId, int requestId) {
        return this.updateSubscriptionToTopic(topicId, contextId, requestId, false);
    }

    private boolean updateSubscriptionToTopic(AgentId topicId, int contextId, int requestId, boolean asyncSub) {
        TopicSubscription tSub;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.updateSubscriptionToTopic(" + topicId + ',' + contextId + ',' + requestId + ',' + asyncSub + ')'));
        }
        if ((tSub = (TopicSubscription)this.topicsTable.get(topicId)) == null || tSub.isEmpty()) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable.remove(" + topicId + ')'));
            }
            this.topicsTable.remove(topicId);
            this.sendNot(topicId, new UnsubscribeRequest(contextId, requestId));
            return false;
        }
        String builtSelector = tSub.buildSelector();
        if (tSub.getLastSelector() != null && builtSelector.equals(tSub.getLastSelector())) {
            return false;
        }
        tSub.setLastSelector(builtSelector);
        SubscribeRequest req = new SubscribeRequest(contextId, requestId, builtSelector, asyncSub);
        this.sendNot(topicId, req);
        if (asyncSub) {
            this.doFwd(new SubscribeReply(req));
        }
        return true;
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int j;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent[" + this.getId() + "].readbag()"));
        }
        this.connections = (Hashtable)in.readObject();
        this.heartBeatTasks = (Hashtable)in.readObject();
        if (this.heartBeatTasks != null && this.heartBeatTasks.size() > 0) {
            Enumeration tasks = this.heartBeatTasks.elements();
            while (tasks.hasMoreElements()) {
                ((HeartBeatTask)tasks.nextElement()).start();
            }
        }
        this.activeCtxId = in.readInt();
        int size = in.readInt();
        Object obj = null;
        for (j = 0; j < size; ++j) {
            obj = in.readObject();
            ClientContext cc = (ClientContext)this.contexts.get(obj);
            cc.setProxyAgent(this);
            cc.readBag(in);
        }
        size = in.readInt();
        for (j = 0; j < size; ++j) {
            obj = in.readObject();
            ClientSubscription cs = (ClientSubscription)this.subsTable.get(obj);
            cs.setProxyAgent(this);
            cs.readBag(in);
        }
        this.activeCtx = (ClientContext)this.contexts.get(new Integer(this.activeCtxId));
        Vector messages = (Vector)in.readObject();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> messages = " + messages));
        }
        this.topicsTable = new Hashtable();
        this.messagesTable = new Hashtable();
        for (Map.Entry subEntry : this.subsTable.entrySet()) {
            TopicSubscription tSub;
            String subName = (String)subEntry.getKey();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> subName = " + subName));
            }
            ClientSubscription cSub = (ClientSubscription)subEntry.getValue();
            AgentId destId = cSub.getTopicId();
            cSub.reinitialize(this.messagesTable, messages, false);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> destId = " + destId + ')'));
            }
            if ((tSub = (TopicSubscription)this.topicsTable.get(destId)) == null) {
                tSub = new TopicSubscription();
                this.topicsTable.put(destId, tSub);
            }
            tSub.putSubscription(subName, cSub.getSelector());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable = " + this.topicsTable));
        }
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent[" + this.getId() + "].writeBag()"));
        }
        out.writeObject(this.connections);
        out.writeObject(this.heartBeatTasks);
        out.writeInt(this.activeCtxId);
        out.writeInt(this.contexts.size());
        for (Map.Entry ctxEntry : this.contexts.entrySet()) {
            out.writeObject(ctxEntry.getKey());
            ((ClientContext)ctxEntry.getValue()).writeBag(out);
        }
        out.writeInt(this.subsTable.size());
        for (Map.Entry subEntry : this.subsTable.entrySet()) {
            out.writeObject(subEntry.getKey());
            ((ClientSubscription)subEntry.getValue()).writeBag(out);
        }
        Vector messages = new Vector();
        Iterator msgs = this.messagesTable.values().iterator();
        while (msgs.hasNext()) {
            messages.add(msgs.next());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> messages = " + messages + ')'));
        }
        out.writeObject(messages);
    }

    public long getNbMsgsSentToDMQSinceCreation() {
        return this.nbMsgsSentToDMQSinceCreation;
    }

    class HeartBeatTask
    extends TimerTask
    implements Externalizable {
        private transient int timeout;
        private transient Integer key;
        private transient long lastRequestDate;

        HeartBeatTask(int timeout, Integer key) {
            this.timeout = timeout;
            this.key = key;
        }

        public void run() {
            long date = System.currentTimeMillis();
            if (date - this.lastRequestDate > (long)this.timeout) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"HeartBeatTask: close connection");
                }
                ConnectionContext ctx = (ConnectionContext)UserAgent.this.connections.remove(this.key);
                UserAgent.this.heartBeatTasks.remove(this.key);
                UserAgent.this.reactToClientRequest((int)this.key, (AbstractJmsRequest)new CnxCloseRequest());
                if (ctx != null) {
                    MomException exc = new MomException(99999, "Connection " + UserAgent.this.getId() + ':' + this.key + " closed");
                    ctx.pushError(exc);
                }
            }
        }

        public void start() throws IOException {
            this.lastRequestDate = System.currentTimeMillis();
            try {
                AgentServer.getTimer().schedule((TimerTask)this, this.timeout, (long)this.timeout);
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)("HeartBeatTask: cannot schedule task " + this.key), (Throwable)exc);
                }
                throw new IOException(exc.getMessage());
            }
        }

        public void touch() {
            this.lastRequestDate = System.currentTimeMillis();
        }

        public HeartBeatTask() {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.timeout = in.readInt();
            this.key = new Integer(in.readInt());
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.timeout);
            out.writeInt(this.key);
        }
    }
}

