/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.util;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearQueue;
import org.objectweb.joram.shared.admin.ClearSubscription;
import org.objectweb.joram.shared.admin.CreateDestinationRequest;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.DeleteDestination;
import org.objectweb.joram.shared.admin.DeleteQueueMessage;
import org.objectweb.joram.shared.admin.DeleteSubscriptionMessage;
import org.objectweb.joram.shared.admin.DeleteUser;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SynchronousAgent
extends Agent {
    public static Logger logger = Debug.getLogger((String)SynchronousAgent.class.getName());
    private static SynchronousAgent INSTANCE = null;
    private static final long serialVersionUID = 3842240802167239809L;
    private int nextReqMsgId = 0;
    private Map<String, Message> requests = new HashMap<String, Message>();

    public static synchronized SynchronousAgent getSynchronousAgent() throws IOException, InterruptedException {
        if (INSTANCE == null) {
            SynchronousAgent syncAgent = new SynchronousAgent();
            syncAgent.deploy();
            while (INSTANCE == null) {
                Thread.sleep(100L);
            }
        }
        return INSTANCE;
    }

    public SynchronousAgent() {
        super(true);
    }

    protected void agentInitialize(boolean firstTime) throws Exception {
        super.agentInitialize(firstTime);
        INSTANCE = this;
    }

    public void agentFinalize(boolean lastTime) {
        super.agentFinalize(lastTime);
        INSTANCE = null;
    }

    public synchronized boolean createDestination(short serverId, String name, String className, Properties props, byte expectedType) throws InterruptedException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("createDestination(" + serverId + "," + name + "," + className + "," + props + "," + expectedType + ")"));
        }
        CreateDestinationRequest req = new CreateDestinationRequest((int)serverId, name, className, props, expectedType);
        String reqId = this.nextReqMsgId();
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, this.getId(), reqId, null);
        this.sendTo(AdminTopic.getDefault(), not);
        while (!this.requests.containsKey(reqId)) {
            ((Object)((Object)this)).wait();
        }
        Message msg = this.requests.get(reqId);
        AdminReply reply = (AdminReply)msg.getAdminMessage();
        return reply.succeeded();
    }

    public synchronized boolean createUser(short serverId, String userName, String password, String identityClass, Properties props) throws Exception {
        Identity identity = (Identity)(identityClass == null ? SimpleIdentity.class.newInstance() : Class.forName(identityClass).newInstance());
        if (password == null) {
            identity.setUserName(userName);
        } else {
            identity.setIdentity(userName, password);
        }
        CreateUserRequest req = new CreateUserRequest(identity, (int)serverId, props);
        String reqId = this.nextReqMsgId();
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, this.getId(), reqId, null);
        this.sendTo(AdminTopic.getDefault(), not);
        while (!this.requests.containsKey(reqId)) {
            ((Object)((Object)this)).wait();
        }
        Message msg = this.requests.remove(reqId);
        AdminReply reply = (AdminReply)msg.getAdminMessage();
        return reply.succeeded();
    }

    public synchronized boolean deleteUser(String userName, String agentId) throws Exception {
        DeleteUser req = new DeleteUser(userName, agentId);
        String reqId = this.nextReqMsgId();
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, this.getId(), reqId, null);
        this.sendTo(AdminTopic.getDefault(), not);
        while (!this.requests.containsKey(reqId)) {
            ((Object)((Object)this)).wait();
        }
        Message msg = this.requests.remove(reqId);
        AdminReply reply = (AdminReply)msg.getAdminMessage();
        return reply.succeeded();
    }

    public synchronized boolean deleteDest(String agentId) throws Exception {
        DeleteDestination req = new DeleteDestination(agentId);
        String reqId = this.nextReqMsgId();
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, this.getId(), reqId, null);
        this.sendTo(AdminTopic.getDefault(), not);
        while (!this.requests.containsKey(reqId)) {
            ((Object)((Object)this)).wait();
        }
        Message msg = this.requests.remove(reqId);
        AdminReply reply = (AdminReply)msg.getAdminMessage();
        return reply.succeeded();
    }

    public synchronized boolean deleteQueueMessage(String queueName, String msgId) throws InterruptedException {
        AdminTopic.DestinationDesc queueDesc;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".deleteQueueMessage(" + queueName + ", " + msgId + ")" + ": Method called"));
        }
        try {
            queueDesc = AdminTopic.lookupDest(queueName, (byte)2);
        }
        catch (RequestException e) {
            return false;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".deleteQueueMessage(" + queueName + ", " + msgId + ")" + ": Queue found=" + queueDesc != null ? 1 : 0));
        }
        if (queueDesc == null) {
            return false;
        }
        String reqId = this.nextReqMsgId();
        DeleteQueueMessage req = new DeleteQueueMessage(queueDesc.getId().toString(), msgId);
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, this.getId(), reqId, null);
        this.sendTo(queueDesc.getId(), not);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".deleteQueueMessage(" + queueName + ", " + msgId + ")" + ": Request sent to " + queueDesc.getId()));
        }
        while (!this.requests.containsKey(reqId)) {
            ((Object)((Object)this)).wait();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".deleteQueueMessage(" + queueName + ", " + msgId + ")" + ": Reply received"));
        }
        Message msg = this.requests.remove(reqId);
        AdminReply reply = (AdminReply)msg.getAdminMessage();
        return reply.succeeded();
    }

    public boolean deleteSubMessage(String userName, String subName, String msgId) throws InterruptedException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".deleteSubMessage(" + userName + ", " + subName + ", " + msgId + ")" + ": Method called."));
        }
        AgentId userId = AdminTopic.lookupUser(userName);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".deleteSubMessage(" + userName + ", " + subName + ", " + msgId + ")" + ": User found=" + userId != null ? 1 : 0));
        }
        if (userId == null) {
            return false;
        }
        String reqId = this.nextReqMsgId();
        DeleteSubscriptionMessage req = new DeleteSubscriptionMessage(userId.toString(), subName, msgId);
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, this.getId(), reqId, null);
        this.sendTo(userId, not);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".deleteSubMessage(" + userName + ", " + subName + ", " + msgId + ")" + ": Request sent to " + userId));
        }
        while (!this.requests.containsKey(reqId)) {
            ((Object)((Object)this)).wait();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".deleteSubMessage(" + userName + ", " + subName + ", " + msgId + ")" + ": Reply received"));
        }
        Message msg = this.requests.remove(reqId);
        AdminReply reply = (AdminReply)msg.getAdminMessage();
        return reply.succeeded();
    }

    public boolean clearQueue(String queueName) throws InterruptedException {
        AdminTopic.DestinationDesc queueDesc;
        try {
            queueDesc = AdminTopic.lookupDest(queueName, (byte)2);
            if (queueDesc == null) {
                return false;
            }
        }
        catch (RequestException e) {
            return false;
        }
        String reqId = this.nextReqMsgId();
        ClearQueue req = new ClearQueue(queueDesc.getId().toString());
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, this.getId(), reqId, null);
        this.sendTo(queueDesc.getId(), not);
        while (!this.requests.containsKey(reqId)) {
            ((Object)((Object)this)).wait();
        }
        Message msg = this.requests.remove(reqId);
        AdminReply reply = (AdminReply)msg.getAdminMessage();
        return reply.succeeded();
    }

    public boolean clearSubscription(String userName, String subName) throws InterruptedException {
        AgentId userId = AdminTopic.lookupUser(userName);
        if (userId == null) {
            return false;
        }
        String reqId = this.nextReqMsgId();
        ClearSubscription req = new ClearSubscription(userId.toString(), subName);
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, this.getId(), reqId, null);
        this.sendTo(userId, not);
        while (!this.requests.containsKey(reqId)) {
            ((Object)((Object)this)).wait();
        }
        Message msg = this.requests.remove(reqId);
        AdminReply reply = (AdminReply)msg.getAdminMessage();
        return reply.succeeded();
    }

    private synchronized String nextReqMsgId() {
        return "ID:" + this.getAgentId() + "m" + this.nextReqMsgId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void react(AgentId from, Notification not) throws Exception {
        if (not instanceof ClientMessages) {
            ClientMessages clientMsg = (ClientMessages)not;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".react(" + from + ", " + not + "): Reply received."));
            }
            SynchronousAgent synchronousAgent = this;
            synchronized (synchronousAgent) {
                block9: {
                    try {
                        for (Object o : clientMsg.getMessages()) {
                            Message msg = (Message)o;
                            this.requests.put(msg.correlationId, msg);
                        }
                        ((Object)((Object)this)).notifyAll();
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)(this.toString() + ".react(" + from + ", " + not + "): Notified."));
                        }
                    }
                    catch (IllegalMonitorStateException e) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break block9;
                        logger.log(BasicLevel.ERROR, (Object)e);
                    }
                }
            }
        }
        super.react(from, not);
    }
}

