/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty6;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.osgi.framework.BundleContext;
import org.ow2.jonas.addon.deploy.api.config.IAddonConfig;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.base.War;
import org.ow2.jonas.web.base.osgi.httpservice.HttpServiceFactory;
import org.ow2.jonas.web.jetty6.AnnotationProcessorServletHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetty6Service
extends BaseWebContainerService
implements JWebContainerService,
Pojo {
    private InstanceManager __IM;
    public static final String JETTY6_WEB_FILENAME = "jetty6-web.xml";
    public static final String JETTY6_CONF_FILENAME = "jetty6.xml";
    private static final String JETTY_CONFIGURATION_FILE = BaseWebContainerService.JONAS_BASE + File.separator + "conf" + File.separator + "jetty6.xml";
    private static final String JETTY_DEFAULT_WEB_XML_FILE = BaseWebContainerService.JONAS_BASE + File.separator + "conf" + File.separator + "jetty6-web.xml";
    private boolean __Fjetty6ConfPath;
    private String jetty6ConfPath;
    private boolean __Fjetty6WebConfPath;
    private String jetty6WebConfPath;
    private static String config = null;
    private boolean __Fserver;
    private Server server;
    private boolean __FdefaultHandler;
    private DefaultHandler defaultHandler;
    private boolean __FrequestLogHandler;
    private RequestLogHandler requestLogHandler;
    private boolean __FwebAppContexts;
    private ContextHandlerCollection webAppContexts;
    private boolean __Fhandlers;
    private HandlerCollection handlers;
    private boolean __FjettyStarted;
    private boolean jettyStarted;
    private boolean __MinitHandlers;
    private boolean __MdoStart;
    private boolean __MstartInternalWebContainer;
    private boolean __MisInternalContainerStarted;
    private boolean __MdoStop;
    private boolean __MdoRegisterWar$javax_naming_Context;
    private boolean __MgetDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MgetJOnASClassPath$java_lang_ClassLoader;
    private boolean __MdoUnRegisterWar$javax_naming_Context;
    private boolean __MupdateServerInfos;
    private boolean __MgetDefaultHost;
    private boolean __MgetDefaultHttpPort;
    private boolean __MgetDefaultHttpsPort;
    private boolean __MgetFirstListenerFromScheme$java_lang_String;
    private boolean __McreateHttpServiceFactory;
    private boolean __MregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig;
    private boolean __MunregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig;

    String __getjetty6ConfPath() {
        if (!this.__Fjetty6ConfPath) {
            return this.jetty6ConfPath;
        }
        return (String)this.__IM.onGet((Object)this, "jetty6ConfPath");
    }

    void __setjetty6ConfPath(String string) {
        if (!this.__Fjetty6ConfPath) {
            this.jetty6ConfPath = string;
            return;
        }
        this.__IM.onSet((Object)this, "jetty6ConfPath", (Object)string);
    }

    String __getjetty6WebConfPath() {
        if (!this.__Fjetty6WebConfPath) {
            return this.jetty6WebConfPath;
        }
        return (String)this.__IM.onGet((Object)this, "jetty6WebConfPath");
    }

    void __setjetty6WebConfPath(String string) {
        if (!this.__Fjetty6WebConfPath) {
            this.jetty6WebConfPath = string;
            return;
        }
        this.__IM.onSet((Object)this, "jetty6WebConfPath", (Object)string);
    }

    Server __getserver() {
        if (!this.__Fserver) {
            return this.server;
        }
        return (Server)this.__IM.onGet((Object)this, "server");
    }

    void __setserver(Server server) {
        if (!this.__Fserver) {
            this.server = server;
            return;
        }
        this.__IM.onSet((Object)this, "server", (Object)server);
    }

    DefaultHandler __getdefaultHandler() {
        if (!this.__FdefaultHandler) {
            return this.defaultHandler;
        }
        return (DefaultHandler)this.__IM.onGet((Object)this, "defaultHandler");
    }

    void __setdefaultHandler(DefaultHandler defaultHandler) {
        if (!this.__FdefaultHandler) {
            this.defaultHandler = defaultHandler;
            return;
        }
        this.__IM.onSet((Object)this, "defaultHandler", (Object)defaultHandler);
    }

    RequestLogHandler __getrequestLogHandler() {
        if (!this.__FrequestLogHandler) {
            return this.requestLogHandler;
        }
        return (RequestLogHandler)this.__IM.onGet((Object)this, "requestLogHandler");
    }

    void __setrequestLogHandler(RequestLogHandler requestLogHandler) {
        if (!this.__FrequestLogHandler) {
            this.requestLogHandler = requestLogHandler;
            return;
        }
        this.__IM.onSet((Object)this, "requestLogHandler", (Object)requestLogHandler);
    }

    ContextHandlerCollection __getwebAppContexts() {
        if (!this.__FwebAppContexts) {
            return this.webAppContexts;
        }
        return (ContextHandlerCollection)this.__IM.onGet((Object)this, "webAppContexts");
    }

    void __setwebAppContexts(ContextHandlerCollection contextHandlerCollection) {
        if (!this.__FwebAppContexts) {
            this.webAppContexts = contextHandlerCollection;
            return;
        }
        this.__IM.onSet((Object)this, "webAppContexts", (Object)contextHandlerCollection);
    }

    HandlerCollection __gethandlers() {
        if (!this.__Fhandlers) {
            return this.handlers;
        }
        return (HandlerCollection)this.__IM.onGet((Object)this, "handlers");
    }

    void __sethandlers(HandlerCollection handlerCollection) {
        if (!this.__Fhandlers) {
            this.handlers = handlerCollection;
            return;
        }
        this.__IM.onSet((Object)this, "handlers", (Object)handlerCollection);
    }

    boolean __getjettyStarted() {
        if (!this.__FjettyStarted) {
            return this.jettyStarted;
        }
        Object object = this.__IM.onGet((Object)this, "jettyStarted");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setjettyStarted(boolean bl) {
        if (!this.__FjettyStarted) {
            this.jettyStarted = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "jettyStarted", (Object)bl2);
    }

    public Jetty6Service(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private Jetty6Service(InstanceManager _manager, BundleContext bundleContext) {
        super(bundleContext);
        this._setInstanceManager(_manager);
        this.__setserver(null);
        this.__setdefaultHandler(null);
        this.__setrequestLogHandler(null);
        this.__setwebAppContexts(null);
        this.__setjettyStarted(false);
    }

    private void initHandlers() {
        if (!this.__MinitHandlers) {
            this.__M_initHandlers();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initHandlers", new Object[0]);
            this.__M_initHandlers();
            this.__IM.onExit((Object)this, "initHandlers", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initHandlers", throwable);
            throw throwable;
        }
    }

    private void __M_initHandlers() {
        this.__setdefaultHandler(new DefaultHandler());
        this.__setrequestLogHandler(new RequestLogHandler());
        this.__setwebAppContexts(new ContextHandlerCollection());
        this.__sethandlers(new HandlerCollection());
        this.__gethandlers().setHandlers(new Handler[]{this.__getwebAppContexts(), this.__getdefaultHandler(), this.__getrequestLogHandler()});
        this.__getserver().setHandler((Handler)this.__gethandlers());
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)"");
        }
        if (!this.isOnDemandFeatureEnabled()) {
            this.startInternalWebContainer();
        }
        super.doStart();
    }

    public synchronized void startInternalWebContainer() throws JWebContainerServiceException {
        if (!this.__MstartInternalWebContainer) {
            this.__M_startInternalWebContainer();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startInternalWebContainer", new Object[0]);
            this.__M_startInternalWebContainer();
            this.__IM.onExit((Object)this, "startInternalWebContainer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startInternalWebContainer", throwable);
            throw throwable;
        }
    }

    private void __M_startInternalWebContainer() throws JWebContainerServiceException {
        if (this.__getjettyStarted()) {
            return;
        }
        config = this.__getjetty6ConfPath() != null ? this.__getjetty6ConfPath() : JETTY_CONFIGURATION_FILE;
        Jetty6Service.getLogger().log(BasicLevel.LEVEL_DEBUG, (Object)("Using configuration file " + config));
        this.__setserver(new Server());
        this.initHandlers();
        if (this.__getserver() != null) {
            if (config != null) {
                IExecution<Server> jettyServerConfiguration = new IExecution<Server>(){

                    public Server execute() throws Exception {
                        Connector[] connectors;
                        XmlConfiguration configuration = new XmlConfiguration(new File(config).toURL());
                        configuration.configure((Object)Jetty6Service.this.__getserver());
                        if (Jetty6Service.this.isOnDemandFeatureEnabled() && (connectors = Jetty6Service.this.__getserver().getConnectors()).length >= 1) {
                            Connector connector = connectors[0];
                            connector.setPort(Jetty6Service.this.getOnDemandRedirectPort());
                        }
                        Jetty6Service.this.__getserver().start();
                        return Jetty6Service.this.__getserver();
                    }
                };
                ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)jettyServerConfiguration);
                if (result.hasException()) {
                    Jetty6Service.getLogger().log(BasicLevel.LEVEL_ERROR, (Object)("Error has occured while starting Jetty server using configuration file " + config), (Throwable)result.getException());
                }
            }
        } else {
            throw new ServiceException("Cannot start Jetty server.");
        }
        Jetty6Service.getLogger().log(BasicLevel.INFO, (Object)"Jetty6 Service started");
        this.__setjettyStarted(true);
    }

    public boolean isInternalContainerStarted() {
        boolean bl;
        if (!this.__MisInternalContainerStarted) {
            return this.__M_isInternalContainerStarted();
        }
        try {
            this.__IM.onEntry((Object)this, "isInternalContainerStarted", new Object[0]);
            bl = this.__M_isInternalContainerStarted();
            this.__IM.onExit((Object)this, "isInternalContainerStarted", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isInternalContainerStarted", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isInternalContainerStarted() {
        return this.__getjettyStarted();
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        super.doStop();
        if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.isStarted() && this.__getserver() != null) {
            try {
                this.__getserver().stop();
                this.__getserver().destroy();
                this.__setserver(null);
                Jetty6Service.getLogger().log(BasicLevel.INFO, (Object)"Jetty6 Service stopped");
            }
            catch (Exception eExc) {
                Jetty6Service.getLogger().log(BasicLevel.LEVEL_ERROR, (Object)("error has occured while stopping Jetty server using configuration file " + config), (Throwable)eExc);
            }
        }
        this.__setjettyStarted(false);
    }

    protected void doRegisterWar(Context context) throws JWebContainerServiceException {
        if (!this.__MdoRegisterWar$javax_naming_Context) {
            this.__M_doRegisterWar(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doRegisterWar$javax_naming_Context", new Object[]{context});
            this.__M_doRegisterWar(context);
            this.__IM.onExit((Object)this, "doRegisterWar$javax_naming_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doRegisterWar$javax_naming_Context", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void __M_doRegisterWar(Context ctx) throws JWebContainerServiceException {
        unpackedWarURL = null;
        contextRoot = null;
        war = null;
        java2DelegationModel = true;
        try {
            war = (War)ctx.lookup("war");
            unpackedWarURL = (URL)ctx.lookup("unpackedWarURL");
        }
        catch (NamingException e) {
            err = "Error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        webClassLoader = null;
        try {
            webClassLoader = (ClassLoader)ctx.lookup("parentCL");
        }
        catch (NamingException e) {
            err = "error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        hostName = null;
        earAppName = null;
        try {
            earAppName = (String)ctx.lookup("earAppName");
        }
        catch (NamingException e) {
            earAppName = null;
        }
        webDD = null;
        try {
            webDD = (WebContainerDeploymentDesc)ctx.lookup("webDD");
        }
        catch (NamingException e) {
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)"Unable to get default parameters", (Throwable)e);
            throw new JWebContainerServiceException("Unable to get default parameters", (Throwable)e);
        }
        contextRoot = war.getContextRoot();
        java2DelegationModel = war.getJava2DelegationModel();
        hostName = war.getHostName();
        if (hostName == null) {
            hostName = "";
        }
        if (contextRoot.equals("/")) {
            contextRoot = "";
        } else if (contextRoot.equalsIgnoreCase("ROOT")) {
            contextRoot = "";
        }
        fWar = new File(unpackedWarURL.getFile());
        fileName = fWar.getAbsolutePath();
        if (this.__getserver() != null) {
            try {
                securityHandler = new SecurityHandler();
                sessionHandler = new SessionHandler();
                errorHandler = new ErrorPageErrorHandler();
                envCtx = null;
                try {
                    envCtx = (Context)this.getNaming().getComponentContext(webClassLoader).lookup("comp/env");
                }
                catch (NamingException e) {
                    Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot get the context of the webapplication '" + war.getWarURL() + "'."), (Throwable)e);
                }
                servletHandler = new AnnotationProcessorServletHandler(envCtx);
                servletHandler.setEncBindingHolder(webDD.getENCBindingHolder());
                webAppContext = new WebAppContext(securityHandler, sessionHandler, (ServletHandler)servletHandler, (ErrorHandler)errorHandler);
                webAppContext.setContextPath("/" + contextRoot);
                webAppContext.setWar(unpackedWarURL.toString());
                if (hostName != null && hostName.length() > 0) {
                    webAppContext.setConnectorNames(new String[]{hostName});
                }
                webAppContext.setAttribute("J2EEDomainName", (Object)this.getDomainName());
                webAppContext.setAttribute("J2EEServerName", (Object)this.getJonasServerName());
                webAppContext.setAttribute("J2EEApplicationName", (Object)earAppName);
                webConf = this.__getjetty6WebConfPath() != null ? this.__getjetty6WebConfPath() : Jetty6Service.JETTY_DEFAULT_WEB_XML_FILE;
                webDefaults = new File(webConf);
                if (webDefaults.exists()) {
                    webAppContext.setDefaultsDescriptor(webDefaults.toURL().toExternalForm());
                } else {
                    Jetty6Service.getLogger().log(BasicLevel.WARN, (Object)("The file '" + webConf + "' is not present. Check that your JONAS_BASE is up-to-date."));
                }
                webAppContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)this.getJOnASClassPath(webClassLoader));
                webAppContext.setParentLoaderPriority(java2DelegationModel);
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Webapp class loader java 2 delegation model set to " + java2DelegationModel));
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server starting web app " + fileName));
                }
                this.__getwebAppContexts().addHandler((Handler)webAppContext);
                oldCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(webClassLoader);
                try {
                    webAppContext.start();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                war.setClassLoader(webAppContext.getClassLoader());
                if (!Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) ** GOTO lbl103
                Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server is running web app " + fileName));
            }
            catch (IOException ioeExc) {
                err = "Cannot install this web application " + ioeExc;
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new JWebContainerServiceException(err, (Throwable)ioeExc);
            }
            catch (Exception eExc) {
                err = "Cannot start this web application " + eExc;
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new JWebContainerServiceException(err, (Throwable)eExc);
            }
        } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("No Jetty server to install web app " + fileName));
        }
lbl103:
        // 5 sources

        try {
            ctx.rebind("WebModule", (Object)this.getDummyJSR77ObjectName(hostName, contextRoot, earAppName));
        }
        catch (Exception e) {
            err = "Cannot rebind WebModule ObjectName in Context";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
    }

    private ObjectName getDummyJSR77ObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        ObjectName objectName;
        if (!this.__MgetDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_getDummyJSR77ObjectName(string, string2, string3);
        }
        try {
            this.__IM.onEntry((Object)this, "getDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            objectName = this.__M_getDummyJSR77ObjectName(string, string2, string3);
            this.__IM.onExit((Object)this, "getDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String", (Object)objectName);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return objectName;
    }

    private ObjectName __M_getDummyJSR77ObjectName(String hostName, String contextRoot, String earAppName) throws MalformedObjectNameException {
        return ObjectName.getInstance(this.getDomainName() + ":j2eeType=WebModule,name=" + "/" + contextRoot + ",J2EEApplication=" + earAppName + ",J2EEServer=" + this.getJonasServerName());
    }

    public String getJOnASClassPath(ClassLoader classLoader) {
        String string;
        if (!this.__MgetJOnASClassPath$java_lang_ClassLoader) {
            return this.__M_getJOnASClassPath(classLoader);
        }
        try {
            this.__IM.onEntry((Object)this, "getJOnASClassPath$java_lang_ClassLoader", new Object[]{classLoader});
            string = this.__M_getJOnASClassPath(classLoader);
            this.__IM.onExit((Object)this, "getJOnASClassPath$java_lang_ClassLoader", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJOnASClassPath$java_lang_ClassLoader", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJOnASClassPath(ClassLoader webClassLoader) {
        StringBuffer classpath = new StringBuffer();
        int n = 0;
        for (ClassLoader tmpLoader = webClassLoader; tmpLoader != null && tmpLoader instanceof URLClassLoader; tmpLoader = tmpLoader.getParent()) {
            URL[] repositories = ((URLClassLoader)tmpLoader).getURLs();
            for (int i = 0; i < repositories.length; ++i) {
                String repository = repositories[i].toString();
                if (repository.startsWith("file://")) {
                    repository = repository.substring("file://".length());
                } else {
                    if (!repository.startsWith("file:")) continue;
                    repository = repository.substring("file:".length());
                }
                if (repository == null) continue;
                if (n > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(repository);
                ++n;
            }
        }
        return classpath.toString();
    }

    protected void doUnRegisterWar(Context context) throws JWebContainerServiceException {
        if (!this.__MdoUnRegisterWar$javax_naming_Context) {
            this.__M_doUnRegisterWar(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doUnRegisterWar$javax_naming_Context", new Object[]{context});
            this.__M_doUnRegisterWar(context);
            this.__IM.onExit((Object)this, "doUnRegisterWar$javax_naming_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doUnRegisterWar$javax_naming_Context", throwable);
            throw throwable;
        }
    }

    private void __M_doUnRegisterWar(Context ctx) throws JWebContainerServiceException {
        String contextRoot = null;
        try {
            contextRoot = (String)ctx.lookup("contextRoot");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        if (contextRoot.equals("/")) {
            contextRoot = "";
        } else if (contextRoot.equalsIgnoreCase("ROOT")) {
            contextRoot = "";
        }
        if (this.__getserver() != null) {
            Handler[] handlers;
            WebAppContext webAppContext = null;
            for (Handler handler : handlers = this.__getwebAppContexts().getHandlers()) {
                WebAppContext tmpContext;
                String contextPath;
                if (!(handler instanceof WebAppContext) || (contextPath = (tmpContext = (WebAppContext)handler).getContextPath()) == null || !contextPath.equals("/" + contextRoot)) continue;
                webAppContext = tmpContext;
                break;
            }
            if (webAppContext != null) {
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server found and is stopping web app at context " + contextRoot));
                }
                try {
                    webAppContext.stop();
                }
                catch (Exception e) {
                    Jetty6Service.getLogger().log(BasicLevel.LEVEL_DEBUG, (Object)"Jetty server encoutered exception while stopping web application ", (Throwable)e);
                }
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server stopped and is removing web app at context " + contextRoot));
                }
                this.__getwebAppContexts().removeHandler(webAppContext);
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server removed and is destroying web app at context " + contextRoot));
                }
                webAppContext.destroy();
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server unloaded web app at context " + contextRoot));
                }
            } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.ERROR)) {
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)("Jetty server didn't find web app at context " + contextRoot));
            }
        } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.ERROR)) {
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)("No Jetty server to uninstall web app at context " + contextRoot));
        }
    }

    protected void updateServerInfos() {
        if (!this.__MupdateServerInfos) {
            this.__M_updateServerInfos();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateServerInfos", new Object[0]);
            this.__M_updateServerInfos();
            this.__IM.onExit((Object)this, "updateServerInfos", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateServerInfos", throwable);
            throw throwable;
        }
    }

    private void __M_updateServerInfos() {
        this.setServerName("Jetty");
        this.setServerVersion(Server.getVersion());
    }

    public String getDefaultHost() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHost) {
            return this.__M_getDefaultHost();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHost", new Object[0]);
            string = this.__M_getDefaultHost();
            this.__IM.onExit((Object)this, "getDefaultHost", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHost", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultHost() throws JWebContainerServiceException {
        Connector[] connectors = this.__getserver().getConnectors();
        if (connectors.length == 0) {
            String err = "Cannot determine default host : Jetty server has no host!";
            throw new JWebContainerServiceException(err);
        }
        return connectors[0].getHost();
    }

    public String getDefaultHttpPort() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHttpPort) {
            return this.__M_getDefaultHttpPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHttpPort", new Object[0]);
            string = this.__M_getDefaultHttpPort();
            this.__IM.onExit((Object)this, "getDefaultHttpPort", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHttpPort", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultHttpPort() throws JWebContainerServiceException {
        if (!this.__getjettyStarted()) {
            return System.getProperty("jetty.port", "9000");
        }
        return String.valueOf(this.getFirstListenerFromScheme("http").getPort());
    }

    public String getDefaultHttpsPort() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHttpsPort) {
            return this.__M_getDefaultHttpsPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHttpsPort", new Object[0]);
            string = this.__M_getDefaultHttpsPort();
            this.__IM.onExit((Object)this, "getDefaultHttpsPort", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHttpsPort", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultHttpsPort() throws JWebContainerServiceException {
        return String.valueOf(this.getFirstListenerFromScheme("https").getPort());
    }

    private Connector getFirstListenerFromScheme(String string) {
        Connector connector;
        if (!this.__MgetFirstListenerFromScheme$java_lang_String) {
            return this.__M_getFirstListenerFromScheme(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getFirstListenerFromScheme$java_lang_String", new Object[]{string});
            connector = this.__M_getFirstListenerFromScheme(string);
            this.__IM.onExit((Object)this, "getFirstListenerFromScheme$java_lang_String", (Object)connector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFirstListenerFromScheme$java_lang_String", throwable);
            throw throwable;
        }
        return connector;
    }

    private Connector __M_getFirstListenerFromScheme(String myScheme) {
        Connector[] connectors = this.__getserver().getConnectors();
        ArrayList<Connector> matchingConnectors = new ArrayList<Connector>();
        for (int i = 0; i < connectors.length; ++i) {
            Connector connector = connectors[i];
            String scheme = connector.getIntegralScheme();
            if (!scheme.equalsIgnoreCase(myScheme)) continue;
            matchingConnectors.add(connector);
        }
        if (matchingConnectors.isEmpty()) {
            String err = "Cannot determine default '" + myScheme + "' port :" + " Jetty server has 0 '" + myScheme + "' Listener";
            throw new JWebContainerServiceException(err);
        }
        Connector firstConnector = (Connector)matchingConnectors.get(0);
        if (matchingConnectors.size() > 1 && Jetty6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Jetty6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Listener for scheme '" + myScheme + "'" + ", using first by default! (port:" + firstConnector.getPort() + ")"));
        }
        return firstConnector;
    }

    protected HttpServiceFactory<Jetty6Service> createHttpServiceFactory() {
        HttpServiceFactory<Jetty6Service> httpServiceFactory;
        if (!this.__McreateHttpServiceFactory) {
            return this.__M_createHttpServiceFactory();
        }
        try {
            this.__IM.onEntry((Object)this, "createHttpServiceFactory", new Object[0]);
            httpServiceFactory = this.__M_createHttpServiceFactory();
            this.__IM.onExit((Object)this, "createHttpServiceFactory", httpServiceFactory);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createHttpServiceFactory", throwable);
            throw throwable;
        }
        return httpServiceFactory;
    }

    private HttpServiceFactory<Jetty6Service> __M_createHttpServiceFactory() {
        return null;
    }

    public void registerAddonConfig(IAddonConfig iAddonConfig) {
        if (!this.__MregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig) {
            this.__M_registerAddonConfig(iAddonConfig);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig", new Object[]{iAddonConfig});
            this.__M_registerAddonConfig(iAddonConfig);
            this.__IM.onExit((Object)this, "registerAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig", throwable);
            throw throwable;
        }
    }

    private void __M_registerAddonConfig(IAddonConfig addonConfig) {
        super.registerAddonConfig(addonConfig);
        File file = addonConfig.getConfigurationFile(JETTY6_WEB_FILENAME);
        if (file != null) {
            this.__setjetty6WebConfPath(file.getAbsolutePath());
        }
        if ((file = addonConfig.getConfigurationFile(JETTY6_CONF_FILENAME)) != null) {
            this.__setjetty6ConfPath(file.getAbsolutePath());
        }
    }

    public void unregisterAddonConfig(IAddonConfig iAddonConfig) {
        if (!this.__MunregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig) {
            this.__M_unregisterAddonConfig(iAddonConfig);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig", new Object[]{iAddonConfig});
            this.__M_unregisterAddonConfig(iAddonConfig);
            this.__IM.onExit((Object)this, "unregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig", throwable);
            throw throwable;
        }
    }

    private void __M_unregisterAddonConfig(IAddonConfig addonConfig) {
        super.unregisterAddonConfig(addonConfig);
        this.__setjetty6ConfPath(null);
        this.__setjetty6WebConfPath(null);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("defaultHandler")) {
                this.__FdefaultHandler = true;
            }
            if (set.contains("handlers")) {
                this.__Fhandlers = true;
            }
            if (set.contains("jetty6ConfPath")) {
                this.__Fjetty6ConfPath = true;
            }
            if (set.contains("jetty6WebConfPath")) {
                this.__Fjetty6WebConfPath = true;
            }
            if (set.contains("jettyStarted")) {
                this.__FjettyStarted = true;
            }
            if (set.contains("requestLogHandler")) {
                this.__FrequestLogHandler = true;
            }
            if (set.contains("server")) {
                this.__Fserver = true;
            }
            if (set.contains("webAppContexts")) {
                this.__FwebAppContexts = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initHandlers")) {
                this.__MinitHandlers = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("startInternalWebContainer")) {
                this.__MstartInternalWebContainer = true;
            }
            if (set.contains("isInternalContainerStarted")) {
                this.__MisInternalContainerStarted = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("doRegisterWar$javax_naming_Context")) {
                this.__MdoRegisterWar$javax_naming_Context = true;
            }
            if (set.contains("getDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgetDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getJOnASClassPath$java_lang_ClassLoader")) {
                this.__MgetJOnASClassPath$java_lang_ClassLoader = true;
            }
            if (set.contains("doUnRegisterWar$javax_naming_Context")) {
                this.__MdoUnRegisterWar$javax_naming_Context = true;
            }
            if (set.contains("updateServerInfos")) {
                this.__MupdateServerInfos = true;
            }
            if (set.contains("getDefaultHost")) {
                this.__MgetDefaultHost = true;
            }
            if (set.contains("getDefaultHttpPort")) {
                this.__MgetDefaultHttpPort = true;
            }
            if (set.contains("getDefaultHttpsPort")) {
                this.__MgetDefaultHttpsPort = true;
            }
            if (set.contains("getFirstListenerFromScheme$java_lang_String")) {
                this.__MgetFirstListenerFromScheme$java_lang_String = true;
            }
            if (set.contains("createHttpServiceFactory")) {
                this.__McreateHttpServiceFactory = true;
            }
            if (set.contains("registerAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig")) {
                this.__MregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig = true;
            }
            if (set.contains("unregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig")) {
                this.__MunregisterAddonConfig$org_ow2_jonas_addon_deploy_api_config_IAddonConfig = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

