/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.maven2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.util.base64.Base64;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;

public final class Maven2Utils {
    private static final Log LOGGER = LogFactory.getLog(Maven2Utils.class);

    private Maven2Utils() {
    }

    public static String getMaven2Location(String repository, String groupId, String artifactId, String version, String maven2Version, String classifier, String type) {
        String appendedClassifier = "";
        if (classifier != null) {
            appendedClassifier = appendedClassifier.concat("-").concat(classifier);
        }
        String fileExtension = null;
        fileExtension = "deployment-plan".equals(type) ? "xml" : type;
        String path = Maven2Utils.constructDirectoryPath(groupId, artifactId, version);
        String location = repository.concat("/").concat(path.concat("/").concat(artifactId).concat("-").concat(maven2Version).concat(appendedClassifier).concat(".").concat(fileExtension));
        return location;
    }

    public static File getMaven2File(String repository, String groupId, String artifactId, String version, String maven2Version, String classifier, String type) {
        return new File(Maven2Utils.getMaven2Location(repository, groupId, artifactId, version, maven2Version, classifier, type));
    }

    public static URL getMaven2URL(String repository, String groupId, String artifactId, String version, String maven2Version, String classifier, String type) throws MalformedURLException {
        return new URL(Maven2Utils.getMaven2Location(repository, groupId, artifactId, version, maven2Version, classifier, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readChecksum(InputStream inputStream) throws IOException {
        String checksum = "";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            checksum = bufferedReader.readLine().trim();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.reset();
                    bufferedReader.close();
                }
                catch (IOException e) {}
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.read();
                    inputStreamReader.close();
                }
                catch (IOException e) {}
            }
        }
        return checksum.split(" ")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMaven2Version(String repository, String groupId, String artifactId, String version, int timeout) {
        String maven2Version = version;
        if (version.endsWith("SNAPSHOT")) {
            String path = Maven2Utils.constructDirectoryPath(groupId, artifactId, version);
            InputStream inputStream = null;
            URL mavenMetadataURL = null;
            try {
                String repositoryVal = repository;
                if (!repository.endsWith("/")) {
                    repositoryVal = repository.concat("/");
                }
                mavenMetadataURL = new URL(repositoryVal.concat(path.concat("/")).concat("maven-metadata.xml"));
                URLConnection connection = mavenMetadataURL.openConnection();
                Maven2Utils.addAuthenticationOnURL(connection);
                connection.setReadTimeout(timeout);
                inputStream = connection.getInputStream();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                Document document = parser.parse(inputStream);
                String timestamp = document.getElementsByTagName("timestamp").item(0).getTextContent();
                String buildNumber = document.getElementsByTagName("buildNumber").item(0).getTextContent();
                maven2Version = version.replace("SNAPSHOT", timestamp.concat("-").concat(buildNumber));
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                LOGGER.debug((Object)"Unable to analyze metadata.xml file ''{0}''", new Object[]{mavenMetadataURL, e});
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return maven2Version;
    }

    private static String constructDirectoryPath(String groupId, String artifactId, String version) {
        String transformed = groupId.replace('.', '/');
        return transformed.concat("/").concat(artifactId).concat("/").concat(version);
    }

    protected static void addAuthenticationOnURL(URLConnection urlConnection) {
        String userInfo = urlConnection.getURL().getUserInfo();
        if (userInfo == null) {
            return;
        }
        String username = null;
        String password = null;
        int i = userInfo.indexOf(58);
        if (i >= 0) {
            username = userInfo.substring(0, i);
            password = userInfo.substring(i + 1);
        } else {
            username = userInfo;
        }
        String token = username.concat(":").concat(password);
        String auth = "Basic ".concat(String.valueOf(Base64.encode(token.getBytes())));
        urlConnection.setRequestProperty("Authorization", auth.toString());
    }
}

