/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.easybeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import org.jboss.weld.manager.api.WeldManager;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.jonas.cdi.weld.internal.easybeans.InjectionItemHolder;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.annotation.processor.handler.AbstractInjectionHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldInjectAnnotationHandler
extends AbstractInjectionHandler {
    private static Log logger = LogFactory.getLog(WeldInjectAnnotationHandler.class);
    private WeldManager beanManager;
    Map<EasyBeansBean, Set<InjectionItemHolder>> injectionTargets;

    public WeldInjectAnnotationHandler(WeldManager beanManager, Map<EasyBeansBean, Set<InjectionItemHolder>> injectionTargets) {
        this.beanManager = beanManager;
        this.injectionTargets = injectionTargets;
    }

    public boolean isSupported(Class<? extends Annotation> aClass) {
        return Inject.class.equals(aClass);
    }

    public void process(Annotation annotation, Field field, Object target) throws ProcessorException {
        Set<Object> injectionItemHolders;
        AnnotatedType annotatedType = this.beanManager.createAnnotatedType(field.getType());
        InjectionTarget injectionTarget = this.beanManager.fireProcessInjectionTarget(annotatedType);
        CreationalContext cc = this.beanManager.createCreationalContext(null);
        Object instance = injectionTarget.produce(cc);
        injectionTarget.inject(instance, cc);
        injectionTarget.postConstruct(instance);
        this.doInjectField(field, target, instance);
        EasyBeansBean bean = (EasyBeansBean)target;
        if (!this.injectionTargets.containsKey(bean)) {
            injectionItemHolders = new HashSet();
            this.injectionTargets.put(bean, injectionItemHolders);
        } else {
            injectionItemHolders = this.injectionTargets.get(bean);
        }
        injectionItemHolders.add(new InjectionItemHolder(injectionTarget, instance));
    }

    public void process(Annotation annotation, Method method, Object target) throws ProcessorException {
        Set<Object> injectionItemHolders;
        EasyBeansBean bean = (EasyBeansBean)target;
        if (!this.injectionTargets.containsKey(bean)) {
            injectionItemHolders = new HashSet();
            this.injectionTargets.put(bean, injectionItemHolders);
        } else {
            injectionItemHolders = this.injectionTargets.get(bean);
        }
        Object[] parameters = new Object[method.getTypeParameters().length];
        int i = 0;
        for (Class<?> parameterType : method.getParameterTypes()) {
            AnnotatedType annotatedType = this.beanManager.createAnnotatedType(parameterType);
            InjectionTarget injectionTarget = this.beanManager.fireProcessInjectionTarget(annotatedType);
            CreationalContext cc = this.beanManager.createCreationalContext(null);
            Object instance = injectionTarget.produce(cc);
            injectionTarget.inject(instance, cc);
            injectionTarget.postConstruct(instance);
            injectionItemHolders.add(new InjectionItemHolder(injectionTarget, instance));
            parameters[i] = instance;
            ++i;
        }
        this.doInjectMethod(method, target, parameters);
    }
}

