/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class NestedTable
extends DatabaseTable {
    private QueryKeyExpression queryKeyExpression;

    public NestedTable() {
    }

    public NestedTable(QueryKeyExpression queryKeyExpression) {
        this.queryKeyExpression = queryKeyExpression;
        this.name = queryKeyExpression.getMapping().getDescriptor().getTables().firstElement().getName();
        this.tableQualifier = queryKeyExpression.getMapping().getDescriptor().getTables().firstElement().getQualifiedName();
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            DatabaseMapping mapping = this.queryKeyExpression.getMapping();
            DatabaseTable nestedTable = mapping.getDescriptor().getTables().firstElement();
            DatabaseTable tableAlias = this.queryKeyExpression.getBaseExpression().aliasForTable(nestedTable);
            DatabaseTable nestedTableAlias = this.queryKeyExpression.aliasForTable(this);
            StringBuffer name = new StringBuffer();
            name.append("TABLE(");
            name.append(tableAlias.getName());
            name.append(".");
            name.append(mapping.getField().getName());
            name.append(")");
            this.qualifiedName = name.toString();
        }
        return this.qualifiedName;
    }

    public QueryKeyExpression getQuerykeyExpression() {
        return this.queryKeyExpression;
    }

    public void setQuerykeyExpression(QueryKeyExpression queryKeyExpression) {
        this.queryKeyExpression = queryKeyExpression;
    }
}

