/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.tenant.interceptor.jmx;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.interceptor.InvocationContext;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.ow2.jonas.jmx.Interceptor;
import org.ow2.jonas.lib.tenant.context.TenantCurrent;

public class JMXTenantIdInterceptor
implements Interceptor {
    private String tenantIdAttributeName;
    private boolean allowToAccessPlatformMBeans;
    private Map<String, List<ObjectName>> tenantBeans = new HashMap<String, List<ObjectName>>();
    private boolean isJMXSession;

    public JMXTenantIdInterceptor(String tenantIdAttributeName, boolean allowToAccessPlatformMBeans) {
        this.tenantIdAttributeName = tenantIdAttributeName;
        this.allowToAccessPlatformMBeans = allowToAccessPlatformMBeans;
    }

    public Object invoke(InvocationContext invocationContext) throws Exception {
        String methodName = invocationContext.getMethod().getName();
        Object[] parameters = invocationContext.getParameters();
        Integer index = null;
        boolean saveBean = false;
        this.isJMXSession = false;
        if (methodName.equals("registerMBean") || methodName.equals("createMBean")) {
            index = 1;
            saveBean = true;
        } else if (methodName.equals("unregisterMBean") || methodName.equals("getObjectInstance") || methodName.equals("queryMBeans") || methodName.equals("queryNames") || methodName.equals("isRegistered") || methodName.equals("getAttribute") || methodName.equals("getAttributes") || methodName.equals("setAttribute") || methodName.equals("setAttributes") || methodName.equals("invoke") || methodName.equals("addNotificationListener") || methodName.equals("removeNotificationListener") || methodName.equals("getMBeanInfo") || methodName.equals("isInstanceOf")) {
            index = 0;
        }
        if (index != null) {
            ObjectName oldObjectName = (ObjectName)parameters[index];
            ObjectName newObjectName = null;
            if (methodName.equals("queryMBeans") || methodName.equals("queryNames")) {
                newObjectName = this.updateNamePattern(oldObjectName, invocationContext);
            } else if (methodName.equals("registerMBean") || methodName.equals("createMBean")) {
                newObjectName = this.updateObjectName(oldObjectName, saveBean);
            } else if (this.isTenantBean(oldObjectName)) {
                newObjectName = this.updateObjectName(oldObjectName, saveBean);
            }
            if (newObjectName != null) {
                parameters[index.intValue()] = newObjectName;
                invocationContext.setParameters(parameters);
            }
        }
        return invocationContext.proceed();
    }

    private ObjectName updateObjectName(ObjectName old, boolean saveBean) {
        if (this.isObjectNameUpdated(old) || old == null) {
            return null;
        }
        String tenantId = this.getTenantId(false);
        if (tenantId != null && !tenantId.equals("T0")) {
            try {
                if (saveBean) {
                    if (this.tenantBeans.get(tenantId) == null) {
                        LinkedList<ObjectName> list = new LinkedList<ObjectName>();
                        list.add(old);
                        this.tenantBeans.put(tenantId, list);
                    } else {
                        List<ObjectName> list = this.tenantBeans.get(tenantId);
                        list.add(old);
                    }
                }
                return new ObjectName(old.toString() + ("," + this.tenantIdAttributeName + "=") + tenantId);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException("Failed to format ObjectName [" + old + "]", e);
            }
        }
        return null;
    }

    private ObjectName updateNamePattern(ObjectName old, InvocationContext invocationContext) throws Exception {
        String tenantId = this.getTenantId(true);
        ObjectName newObjectName = null;
        if (tenantId == null || tenantId.equals("T0")) {
            return null;
        }
        if (this.isJMXSession || this.isTenantQuery(invocationContext)) {
            newObjectName = this.updateObjectName(old, false);
        }
        if (old == null) {
            try {
                newObjectName = new ObjectName("*:" + this.tenantIdAttributeName + "=" + tenantId + ",*");
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException("Failed to format Name Pattern [" + old + "]", e);
            }
        }
        return newObjectName;
    }

    private String getTenantId(boolean query) {
        String tenantId = null;
        if (TenantCurrent.getCurrent().getTenantContext() != null) {
            String jmxSessionTenantId;
            if (query && (jmxSessionTenantId = TenantCurrent.getCurrent().getTenantContext().getJmxSessionTenantId()) != null) {
                this.isJMXSession = true;
                return jmxSessionTenantId;
            }
            tenantId = TenantCurrent.getCurrent().getTenantContext().getTenantId();
        }
        return tenantId;
    }

    private boolean isObjectNameUpdated(ObjectName objectName) {
        if (objectName == null) {
            return false;
        }
        Hashtable<String, String> properties = objectName.getKeyPropertyList();
        return properties.containsKey(this.tenantIdAttributeName);
    }

    private boolean isTenantBean(ObjectName name) {
        String tenantId = this.getTenantId(false);
        if (tenantId == null) {
            return false;
        }
        List<ObjectName> list = this.tenantBeans.get(tenantId);
        if (list == null) {
            return false;
        }
        return list.contains(name);
    }

    private boolean isTenantQuery(InvocationContext invocationContext) throws Exception {
        Object[] args = invocationContext.getParameters();
        ObjectName oldObjectName = (ObjectName)args[0];
        QueryExp queryExp = (QueryExp)args[1];
        Set<ObjectName> mbeans = ((MBeanServer)invocationContext.getTarget()).queryNames(oldObjectName, queryExp);
        for (ObjectName mbean : mbeans) {
            if (mbean.getKeyProperty(this.tenantIdAttributeName) == null) continue;
            return true;
        }
        return false;
    }
}

