/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared_impl.resource.ResourceLoader;
import org.apache.myfaces.shared_impl.resource.ResourceMeta;
import org.apache.myfaces.shared_impl.util.WebConfigParamUtils;

public class ResourceHandlerCache {
    private static final Logger log = Logger.getLogger(ResourceHandlerCache.class.getName());
    private Boolean _resourceCacheEnabled = null;
    private Map<ResourceKey, ResourceValue> _resourceCacheMap = null;
    private static final String RESOURCE_HANDLER_CACHE_SIZE_ATTRIBUTE = "org.apache.myfaces.RESOURCE_HANDLER_CACHE_SIZE";
    private static final int RESOURCE_HANDLER_CACHE_DEFAULT_SIZE = 500;
    private static final String RESOURCE_HANDLER_CACHE_ENABLED_ATTRIBUTE = "org.apache.myfaces.RESOURCE_HANDLER_CACHE_ENABLED";
    private static final boolean RESOURCE_HANDLER_CACHE_ENABLED_DEFAULT = true;

    public ResourceValue getResource(String resourceName, String libraryName, String contentType) {
        if (!this.isResourceCachingEnabled() || this._resourceCacheMap == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceName);
        }
        ResourceKey key = new ResourceKey(resourceName, libraryName, contentType);
        return this._resourceCacheMap.get(key);
    }

    public boolean containsResource(String resourceName, String libraryName, String contentType) {
        if (!this.isResourceCachingEnabled() || this._resourceCacheMap == null) {
            return false;
        }
        ResourceKey key = new ResourceKey(resourceName, libraryName, contentType);
        return this._resourceCacheMap.containsKey(key);
    }

    public void putResource(String resourceName, String libraryName, String contentType, ResourceMeta resource, ResourceLoader loader) {
        if (!this.isResourceCachingEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to put resource to cache for " + resourceName);
        }
        if (this._resourceCacheMap == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Initializing resource cache map");
            }
            this._resourceCacheMap = Collections.synchronizedMap(new _ResourceMap(this.getMaxSize()));
        }
        this._resourceCacheMap.put(new ResourceKey(resourceName, libraryName, contentType), new ResourceValue(resource, loader));
    }

    private boolean isResourceCachingEnabled() {
        if (this._resourceCacheEnabled == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!facesContext.isProjectStage(ProjectStage.Production)) {
                this._resourceCacheEnabled = Boolean.FALSE;
                return this._resourceCacheEnabled;
            }
            ExternalContext externalContext = facesContext.getExternalContext();
            if (externalContext == null) {
                return false;
            }
            this._resourceCacheEnabled = WebConfigParamUtils.getBooleanInitParameter(externalContext, RESOURCE_HANDLER_CACHE_ENABLED_ATTRIBUTE, true);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "MyFaces Resource Caching Enabled=" + this._resourceCacheEnabled);
            }
        }
        return this._resourceCacheEnabled;
    }

    private int getMaxSize() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return WebConfigParamUtils.getIntegerInitParameter(externalContext, RESOURCE_HANDLER_CACHE_SIZE_ATTRIBUTE, 500);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _ResourceMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int maxCapacity;

        public _ResourceMap(int cacheSize) {
            super(cacheSize + 1, 1.1f, true);
            this.maxCapacity = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxCapacity;
        }
    }

    public static class ResourceValue {
        private ResourceMeta resourceMeta;
        private ResourceLoader resourceLoader;

        public ResourceValue(ResourceMeta resourceMeta, ResourceLoader resourceLoader) {
            this.resourceMeta = resourceMeta;
            this.resourceLoader = resourceLoader;
        }

        public ResourceMeta getResourceMeta() {
            return this.resourceMeta;
        }

        public ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }
    }

    public static class ResourceKey {
        private String resourceName;
        private String libraryName;
        private String contentType;

        public ResourceKey(String resourceName, String libraryName, String contentType) {
            this.resourceName = resourceName;
            this.libraryName = libraryName;
            this.contentType = contentType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
            result = 31 * result + (this.libraryName == null ? 0 : this.libraryName.hashCode());
            result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceKey other = (ResourceKey)obj;
            if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
                return false;
            }
            if (this.libraryName == null ? other.libraryName != null : !this.libraryName.equals(other.libraryName)) {
                return false;
            }
            return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
        }
    }
}

