/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.http;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;

public class JOnASDestination
extends AbstractHTTPDestination {
    private static Logger jdkLogger = Logger.getLogger(JOnASDestination.class.getName());

    public JOnASDestination(Bus bus, DestinationRegistry registry, EndpointInfo endpointInfo) throws IOException {
        super(bus, registry, endpointInfo, endpointInfo.getAddress(), false);
        registry.addDestination((AbstractHTTPDestination)this);
    }

    protected Logger getLogger() {
        return jdkLogger;
    }

    public Bus getBus() {
        return this.bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        MessageImpl inMessage = new MessageImpl();
        this.setupMessage((Message)inMessage, context, req, resp);
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setInMessage((Message)inMessage);
        exchange.setSession((Session)new HTTPSession(req));
        inMessage.setDestination((Destination)this);
        String oldAddress = this.endpointInfo.getAddress();
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        try {
            this.endpointInfo.setAddress((String)inMessage.get((Object)"org.apache.cxf.request.url"));
            Thread.currentThread().setContextClassLoader(MessageFactory.class.getClassLoader());
            this.incomingObserver.onMessage((Message)inMessage);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCCL);
            this.endpointInfo.setAddress(oldAddress);
        }
    }

    public EndpointInfo getEndpointInfo() {
        return this.endpointInfo;
    }

    protected String getBasePath(String contextPath) throws IOException {
        String address = this.getAddress().getAddress().getValue();
        if (address == null) {
            return contextPath;
        }
        if (address.startsWith("http")) {
            return URI.create(address).getPath();
        }
        return contextPath + address;
    }
}

