/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.substitution.engine.element;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.engine.IResolvableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeElement
implements IResolvableElement {
    private List<IResolvableElement> elements = new ArrayList<IResolvableElement>();

    public List<IResolvableElement> getElements() {
        return this.elements;
    }

    @Override
    public String getValue(IPropertyResolver resolver) {
        StringBuilder builder = new StringBuilder();
        for (IResolvableElement element : this.elements) {
            String resolved = element.getValue(resolver);
            if (resolved == null) {
                throw new IllegalArgumentException("Cannot resolve: " + element);
            }
            builder.append(resolved);
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (IResolvableElement element : this.elements) {
            sb.append(element.toString(indent + 1));
            sb.append("\n");
        }
        return sb.toString();
    }
}

