/**
 * OW2 Util
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

importPackage(org.osgi.framework);

/**
 * ServiceInfo acts as a facade to ease service browsing and testing
 * @param interfaceName Java interface name
 * @constructor
 */
function ServiceInfo(interfaceName) {

    // Kind of parameter default value support
    this._interface = typeof interfaceName !== "undefined" ? interfaceName : null;
    this._filter = null;
    this._reference = null;

    // Look for the service
    this.update();

}

ServiceInfo.prototype.update = function() {

    // Reset the old reference (if any)
    this._reference = null;
    try {
        var references = bundleContext.getAllServiceReferences(this._interface, this._filter);
        if (references != null) {
            this._reference = references[0];
        }
    } catch (e) {
        if (e.javaException instanceof org.osgi.framework.InvalidSyntaxException) {
           print("LDAP Syntax error " + e.javaException.message);
        }
    }

    // Update the available field
    this.available = (this._reference != null);

}

ServiceInfo.prototype.filter = function(filterValue) {
    this._filter = filterValue;
    this.update();
    return this;
}
