/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ejb.internal.EntityManagerMessageLogger;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.event.spi.EventSource;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

public abstract class EJB3CascadingAction
extends CascadingAction {
    private static final EntityManagerMessageLogger LOG = Logger.getMessageLogger(EntityManagerMessageLogger.class, EJB3CascadingAction.class.getName());
    public static final CascadingAction PERSIST_SKIPLAZY = new CascadingAction(){

        @Override
        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.trace("Cascading to persist: " + entityName);
            session.persist(entityName, child, (Map)anything);
        }

        @Override
        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getLoadedElementsIterator(session, collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        @Override
        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST_SKIPLAZY";
        }
    };
}

