/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NRTWorkspaceImpl
extends AbstractWorkspaceImpl
implements DirectoryBasedReaderProvider {
    private static final Log log = LoggerFactory.make();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    private final String indexName;
    private IndexReader currentReferenceReader = null;

    public NRTWorkspaceImpl(DirectoryBasedIndexManager indexManager, ErrorHandler errorHandler, Properties cfg) {
        super(indexManager, errorHandler);
        this.indexName = indexManager.getIndexName();
    }

    @Override
    public void afterTransactionApplied(boolean someFailureHappened) {
        if (someFailureHappened) {
            this.writerHolder.forceLockRelease();
        } else {
            IndexReader newIndexReader = this.writerHolder.openNRTIndexReader(true);
            this.writeLock.lock();
            IndexReader oldReader = this.currentReferenceReader;
            this.currentReferenceReader = newIndexReader;
            this.writeLock.unlock();
            try {
                oldReader.close();
            }
            catch (IOException e) {
                log.unableToCLoseLuceneIndexReader(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader openIndexReader() {
        this.readLock.lock();
        boolean readlockAcquired = true;
        try {
            if (this.currentReferenceReader == null) {
                this.readLock.unlock();
                readlockAcquired = false;
                this.writeLock.lock();
                try {
                    if (this.currentReferenceReader == null) {
                        this.currentReferenceReader = this.writerHolder.openDirectoryIndexReader();
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
                this.readLock.lock();
                readlockAcquired = true;
            }
            IndexReader indexReader = this.cloneReader(this.currentReferenceReader);
            return indexReader;
        }
        finally {
            if (readlockAcquired) {
                this.readLock.unlock();
            }
        }
    }

    private IndexReader cloneReader(IndexReader indexReader) {
        try {
            return indexReader.clone(true);
        }
        catch (CorruptIndexException cie) {
            throw log.cantOpenCorruptedIndex(cie, this.indexName);
        }
        catch (IOException ioe) {
            throw log.ioExceptionOnIndex(ioe, this.indexName);
        }
    }

    @Override
    public void closeIndexReader(IndexReader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            log.unableToCLoseLuceneIndexReader(e);
        }
    }

    @Override
    public void initialize(DirectoryBasedIndexManager indexManager, Properties props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.writeLock.lock();
        try {
            this.closeIndexReader(this.currentReferenceReader);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

