/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.Date;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.query.dsl.impl.AbstractFacet;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.facet.RangeFacet;

public class RangeFacetImpl<T>
extends AbstractFacet
implements RangeFacet<T> {
    private final FacetRange<T> range;
    private final int rangeIndex;
    private final DocumentBuilderIndexedEntity<?> documentBuilder;

    RangeFacetImpl(String facetingName, String fieldName, FacetRange<T> range, int count, int index, DocumentBuilderIndexedEntity<?> documentBuilder) {
        super(facetingName, fieldName, range.getRangeString(), count);
        this.range = range;
        this.rangeIndex = index;
        this.documentBuilder = documentBuilder;
    }

    @Override
    public Query getFacetQuery() {
        Object minOrMax = this.getNonNullMinOrMax(this.range);
        if (minOrMax instanceof Number) {
            return this.createNumericRangeQuery();
        }
        if (minOrMax instanceof String) {
            return this.createRangeQuery((String)this.range.getMin(), (String)this.range.getMax(), this.range.isMinIncluded(), this.range.isMaxIncluded());
        }
        if (minOrMax instanceof Date) {
            return this.createRangeQuery(this.documentBuilder.objectToString(this.getFieldName(), this.range.getMin()), this.documentBuilder.objectToString(this.getFieldName(), this.range.getMax()), this.range.isMinIncluded(), this.range.isMaxIncluded());
        }
        throw new AssertionFailure("Unsupported range type");
    }

    public int getRangeIndex() {
        return this.rangeIndex;
    }

    @Override
    public T getMin() {
        return this.range.getMin();
    }

    @Override
    public T getMax() {
        return this.range.getMax();
    }

    @Override
    public boolean isIncludeMin() {
        return this.range.isMinIncluded();
    }

    @Override
    public boolean isIncludeMax() {
        return this.range.isMaxIncluded();
    }

    private Object getNonNullMinOrMax(FacetRange<T> range) {
        T o = range.getMin();
        if (o == null) {
            o = range.getMax();
        }
        return o;
    }

    private Query createNumericRangeQuery() {
        NumericRangeQuery<Number> query;
        Object minOrMax = this.getNonNullMinOrMax(this.range);
        if (minOrMax instanceof Double) {
            query = NumericRangeQuery.newDoubleRange(this.getFieldName(), (Double)this.range.getMin(), (Double)this.range.getMax(), this.range.isMinIncluded(), this.range.isMaxIncluded());
        } else if (minOrMax instanceof Float) {
            query = NumericRangeQuery.newFloatRange(this.getFieldName(), (Float)this.range.getMin(), (Float)this.range.getMax(), this.range.isMinIncluded(), this.range.isMaxIncluded());
        } else if (minOrMax instanceof Integer) {
            query = NumericRangeQuery.newIntRange(this.getFieldName(), (Integer)this.range.getMin(), (Integer)this.range.getMax(), this.range.isMinIncluded(), this.range.isMaxIncluded());
        } else if (minOrMax instanceof Long) {
            query = NumericRangeQuery.newLongRange(this.getFieldName(), (Long)this.range.getMin(), (Long)this.range.getMax(), this.range.isMinIncluded(), this.range.isMaxIncluded());
        } else {
            throw new AssertionFailure("Unsupported range type");
        }
        return query;
    }

    private Query createRangeQuery(String min, String max, boolean includeMin, boolean includeMax) {
        return new TermRangeQuery(this.getFieldName(), min, max, includeMin, includeMax);
    }
}

