/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message;

import javax.security.auth.message.MessageInfo;

public class MessagePolicy {
    private TargetPolicy[] targetPolicies;
    private boolean isMandatory;

    public MessagePolicy(TargetPolicy[] targetPolicies, boolean mandatory) {
        if (targetPolicies == null) {
            throw new IllegalArgumentException("targetPolicies argument cannot be null");
        }
        this.targetPolicies = (TargetPolicy[])targetPolicies.clone();
        this.isMandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public TargetPolicy[] getTargetPolicies() {
        return (TargetPolicy[])this.targetPolicies.clone();
    }

    public static interface ProtectionPolicy {
        public static final String AUTHENTICATE_SENDER = "#authenticateSender";
        public static final String AUTHENTICATE_CONTENT = "#authenticateContent";
        public static final String AUTHENTICATE_RECIPIENT = "#authenticateRecipient";

        public String getID();
    }

    public static interface Target {
        public Object get(MessageInfo var1);

        public void remove(MessageInfo var1);

        public void put(MessageInfo var1, Object var2);
    }

    public static class TargetPolicy {
        private Target[] targets;
        private ProtectionPolicy policy;

        public TargetPolicy(Target[] targets, ProtectionPolicy protectionPolicy) {
            if (protectionPolicy == null) {
                throw new IllegalArgumentException("protectionPolicy argument cannot be null");
            }
            this.policy = protectionPolicy;
            this.targets = targets == null || targets.length == 0 ? null : (Target[])targets.clone();
        }

        public Target[] getTargets() {
            return this.targets;
        }

        public ProtectionPolicy getProtectionPolicy() {
            return this.policy;
        }
    }
}

