/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.osgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.ow2.jonas.dbm.internal.osgi.JOnASDataSourceFactory;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDriverBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private static Log logger = LogFactory.getLog(JDBCDriverBundleTrackerCustomizer.class);
    private static final String SQL_DRIVER_ENTRY = "/META-INF/services/java.sql.Driver";
    private BundleContext bundleContext = null;
    private TransactionService txService = null;

    public JDBCDriverBundleTrackerCustomizer(BundleContext bundleContext, TransactionService txService) {
        this.bundleContext = bundleContext;
        this.txService = txService;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        return this.register(bundle, null);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        logger.debug((Object)"modifiedBundle Bundle ''{0}'' with event ''{1}''", new Object[]{bundle, event});
        if (bundle.getState() == 16 || bundle.getState() == 32) {
            this.unregister(bundle, (List)object);
        }
        if (bundle.getState() == 32) {
            this.register(bundle, (List)object);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.unregister(bundle, (List)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<ServiceRegistration> register(Bundle bundle, List<ServiceRegistration> existingServiceRegistrations) {
        ArrayList<String> driverClassNames;
        block38: {
            BufferedReader reader;
            InputStream inputStream;
            block36: {
                URLConnection urlConnection;
                URL urlSqlDriver = bundle.getEntry(SQL_DRIVER_ENTRY);
                if (urlSqlDriver == null) {
                    return null;
                }
                try {
                    urlConnection = urlSqlDriver.openConnection();
                }
                catch (IOException e) {
                    logger.error((Object)"Unable to analyze the entry ''{0}'' in bundle ''{1}'' ''{2}''", new Object[]{SQL_DRIVER_ENTRY, bundle.getBundleId(), bundle.getSymbolicName(), e});
                    return null;
                }
                urlConnection.setDefaultUseCaches(false);
                try {
                    inputStream = urlConnection.getInputStream();
                }
                catch (IOException e) {
                    logger.error((Object)"Unable to analyze the entry ''{0}'' in bundle ''{1}'' ''{2}''", new Object[]{SQL_DRIVER_ENTRY, bundle.getBundleId(), bundle.getSymbolicName(), e});
                    return null;
                }
                reader = null;
                driverClassNames = new ArrayList<String>();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                String driverClassName = null;
                while ((driverClassName = reader.readLine()) != null) {
                    driverClassNames.add(driverClassName);
                    logger.debug((Object)"Found driver classname ''{0}'' in bundle ID ''{1}'' with symbolic name ''{2}''.", new Object[]{driverClassName, bundle.getBundleId(), bundle.getSymbolicName()});
                }
                if (reader == null) break block36;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.debug((Object)"Unable to close resource", new Object[]{e});
                }
                reader = null;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.debug((Object)"Unable to close stream", new Object[]{e});
                }
                inputStream = null;
            }
            break block38;
            catch (IOException e) {
                List<ServiceRegistration> list;
                block37: {
                    try {
                        logger.error((Object)"Unable to analyze the entry ''{0}'' in bundle ''{1}'' ''{2}''", new Object[]{SQL_DRIVER_ENTRY, bundle.getBundleId(), bundle.getSymbolicName(), e});
                        list = null;
                        if (reader == null) break block37;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                logger.debug((Object)"Unable to close resource", new Object[]{e2});
                            }
                            reader = null;
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e3) {
                                logger.debug((Object)"Unable to close stream", new Object[]{e3});
                            }
                            inputStream = null;
                        }
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e4) {
                        logger.debug((Object)"Unable to close resource", new Object[]{e4});
                    }
                    reader = null;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e5) {
                        logger.debug((Object)"Unable to close stream", new Object[]{e5});
                    }
                    inputStream = null;
                }
                return list;
            }
        }
        if (driverClassNames.size() == 0) {
            return null;
        }
        ArrayList<String> driverFactoriesToCreate = new ArrayList<String>();
        for (String driverClassName : driverClassNames) {
            Filter filter = null;
            try {
                filter = this.bundleContext.createFilter("(&(objectClass=" + DataSourceFactory.class.getName() + ")(" + DataSourceFactory.class.getCanonicalName() + "=" + driverClassName + "))");
            }
            catch (InvalidSyntaxException e) {
                logger.error((Object)"Unable to create a filter for the driver classname ''{0}'', skipping registration", new Object[]{driverClassName, e});
                continue;
            }
            ServiceTracker tracker = new ServiceTracker(this.bundleContext, filter, null);
            tracker.open();
            DataSourceFactory datasourceFactory = (DataSourceFactory)tracker.getService();
            if (datasourceFactory != null) continue;
            driverFactoriesToCreate.add(driverClassName);
        }
        List<ServiceRegistration> serviceRegistrations = null;
        serviceRegistrations = existingServiceRegistrations == null ? new ArrayList<ServiceRegistration>() : existingServiceRegistrations;
        for (String driverClassName : driverFactoriesToCreate) {
            Driver driver;
            Class driverClass = null;
            try {
                driverClass = bundle.loadClass(driverClassName);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"No JDBC DS Factory as driver class ''{0}'' can't be loaded from ''{1}'' ''{2}''", new Object[]{driverClassName, bundle.getBundleId(), bundle.getSymbolicName()});
                return null;
            }
            try {
                driver = (Driver)driverClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)"Aborting JDBC DataSource Factory registration as driver class ''{0}'' can't be loaded.", new Object[]{driverClass});
                return null;
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"Aborting JDBC DataSource Factory registration as driver class ''{0}'' can't be loaded.", new Object[]{driverClass});
                return null;
            }
            int majorVersion = driver.getMajorVersion();
            int minorVersion = driver.getMinorVersion();
            JOnASDataSourceFactory dataSourceFactory = new JOnASDataSourceFactory(driverClass, this.txService);
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("osgi.jdbc.driver.class", driverClassName);
            ((Dictionary)dictionary).put("osgi.jdbc.driver.name", driverClassName);
            ((Dictionary)dictionary).put("osgi.jdbc.driver.version", majorVersion + "." + minorVersion);
            ServiceRegistration serviceRegistration = this.bundleContext.registerService(new String[]{DataSourceFactory.class.getName()}, (Object)dataSourceFactory, dictionary);
            serviceRegistrations.add(serviceRegistration);
            logger.info((Object)"Registering OSGi DataSource Factory for the driver ''{0}'' v{1}.{2}", new Object[]{driverClass.getName(), majorVersion, minorVersion});
        }
        return serviceRegistrations;
    }

    public void unregister(Bundle bundle, List<ServiceRegistration> serviceRegistrations) {
        if (serviceRegistrations != null) {
            for (ServiceRegistration serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
    }
}

