/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty6.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.UserRealm;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.security.auth.callback.NoInputCallbackHandler;
import org.ow2.jonas.web.jetty6.security.JettyPrincipal;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Realm
implements UserRealm {
    private static final String JAAS_CONFIG_NAME = "jetty";
    private Log logger = LogFactory.getLog(Realm.class);
    private String name;
    private Map<String, JettyPrincipal> users = new ConcurrentHashMap<String, JettyPrincipal>();

    public Realm() {
        this("Jetty Realm");
    }

    public Realm(String name) {
        this.setName(name);
    }

    public Principal authenticate(String username, Object credentials, Request request) {
        if (username == null) {
            return null;
        }
        Principal jettyPrincipal = this.getUsers().get(username);
        if (jettyPrincipal != null) {
            this.removeUser(username);
        }
        NoInputCallbackHandler noInputCH = null;
        LoginContext loginContext = null;
        noInputCH = new NoInputCallbackHandler(username, (String)credentials, null);
        try {
            loginContext = new LoginContext(JAAS_CONFIG_NAME, (CallbackHandler)noInputCH);
        }
        catch (LoginException e) {
            this.logger.error((Object)"Cannot create a login context for the user ''{0}''", new Object[]{username, e});
            return null;
        }
        Subject subject = null;
        try {
            loginContext.login();
            subject = loginContext.getSubject();
            if (subject == null) {
                this.logger.error((Object)"No Subject for user ''{0}''", new Object[]{username});
                return null;
            }
        }
        catch (AccountExpiredException e) {
            this.logger.error((Object)"Account expired for user ''{0}''", new Object[]{username, e});
            return null;
        }
        catch (CredentialExpiredException e) {
            this.logger.error((Object)"Credential Expired for user ''{0}''", new Object[]{username, e});
            return null;
        }
        catch (FailedLoginException e) {
            this.logger.error((Object)"Failed Login exception for user ''{0}''", new Object[]{username, e});
            return null;
        }
        catch (LoginException e) {
            this.logger.error((Object)"Login exception for user ''{0}''", new Object[]{username, e});
            return null;
        }
        Iterator<Principal> iterator = subject.getPrincipals(Principal.class).iterator();
        String userName = null;
        while (iterator.hasNext() && userName == null) {
            Principal principal = iterator.next();
            if (principal instanceof Group) continue;
            userName = principal.getName();
        }
        if (userName == null) {
            this.logger.error((Object)"No Username found in the subject", new Object[0]);
            return null;
        }
        Set<Group> groups = subject.getPrincipals(Group.class);
        ArrayList<String> roles = new ArrayList<String>();
        for (Group group : groups) {
            Enumeration e = group.members();
            while (e.hasMoreElements()) {
                Principal p = (Principal)e.nextElement();
                roles.add(p.getName());
            }
        }
        JettyPrincipal principal = new JettyPrincipal(userName, roles);
        SecurityContext ctx = new SecurityContext(userName, roles);
        SecurityCurrent current = SecurityCurrent.getCurrent();
        current.setSecurityContext(ctx);
        this.addUser(username, principal);
        return principal;
    }

    protected Map<String, JettyPrincipal> getUsers() {
        return this.users;
    }

    protected void addUser(String username, JettyPrincipal principal) {
        this.users.put(username, principal);
    }

    protected void removeUser(String username) {
        this.users.remove(username);
    }

    public synchronized boolean isUserInRole(Principal user, String roleName) {
        if (user == null) {
            return false;
        }
        if (user instanceof JettyPrincipal) {
            return ((JettyPrincipal)user).isUserInRole(roleName);
        }
        this.logger.error((Object)"The user ''{0}'' is not instance of JettyPrincipal", new Object[]{user});
        return false;
    }

    public Principal getPrincipal(String username) {
        this.logger.debug((Object)"Get principal with username ''{0}''", new Object[]{username});
        JettyPrincipal principal = this.users.get(username);
        SecurityContext ctx = new SecurityContext(principal.getName(), principal.getRoles());
        SecurityCurrent current = SecurityCurrent.getCurrent();
        current.setSecurityContext(ctx);
        return principal;
    }

    public void disassociate(Principal user) {
        SecurityCurrent.getCurrent().setSecurityContext(new SecurityContext());
    }

    public Principal pushRole(Principal user, String role) {
        return user;
    }

    public Principal popRole(Principal user) {
        return user;
    }

    public void logout(Principal user) {
    }

    public boolean reauthenticate(Principal user) {
        if (user instanceof JettyPrincipal) {
            return ((JettyPrincipal)user).isAuthenticated();
        }
        return false;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

