/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm.sql.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.resource.internal.cm.sql.PreparedStatementWrapper;
import org.ow2.jonas.resource.internal.cm.sql.cache.AbstractPreparedStatementCacheImpl;
import org.ow2.jonas.resource.internal.cm.sql.cache.CacheException;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementCache;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementCacheStatistics;

public class PreparedStatementListCacheImpl
extends AbstractPreparedStatementCacheImpl
implements PreparedStatementCache {
    public List<PreparedStatementWrapper> pStmts = new ArrayList<PreparedStatementWrapper>();

    public PreparedStatementListCacheImpl(int maxCacheSize, PreparedStatementCacheStatistics pstmtStats, Logger logger) {
        super(maxCacheSize, pstmtStats, logger);
    }

    public synchronized PreparedStatementWrapper get(PreparedStatementWrapper psw) {
        int jumpNb = 0;
        PreparedStatementWrapper outputPsw = null;
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)("MC pStmts: " + this.pStmts));
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        int indexPstmt = this.pStmts.lastIndexOf(psw);
        while (indexPstmt != -1) {
            outputPsw = this.pStmts.get(indexPstmt);
            if (outputPsw.isClosed()) {
                outputPsw = this.pStmts.remove(indexPstmt);
                outputPsw.clearPstmtValues();
                this.pStmts.add(outputPsw);
                break;
            }
            outputPsw = null;
            ++jumpNb;
            if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                cacheLogger.log(BasicLevel.DEBUG, (Object)"Statement in cache but already used, search another one");
                cacheLogger.log(BasicLevel.DEBUG, (Object)("sql=" + psw.getSql() + ", count=" + jumpNb));
            }
            indexPstmt = this.pStmts.subList(0, indexPstmt).lastIndexOf(psw);
        }
        if (indexPstmt != -1) {
            if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                cacheLogger.log(BasicLevel.DEBUG, (Object)("Statement found in cache " + outputPsw));
            }
            this.stats.incrementPrepStmtCacheHitCount();
        } else {
            if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                cacheLogger.log(BasicLevel.DEBUG, (Object)"No statement in cache (or not closed)");
            }
            this.stats.incrementPrepStmtCacheMissCount();
        }
        return outputPsw;
    }

    public synchronized void put(PreparedStatementWrapper psw) throws CacheException, SQLException {
        if (this.maxPstmtCacheSize < 0) {
            throw new CacheException("Cache disabled");
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        if (this.pstmtCacheSize >= this.maxPstmtCacheSize && this.maxPstmtCacheSize != 0) {
            int offset = this.findFreeStmt();
            if (offset >= 0) {
                PreparedStatementWrapper toRemovePsw = this.pStmts.remove(offset);
                toRemovePsw.destroy();
                if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                    cacheLogger.log(BasicLevel.DEBUG, (Object)("Cache is full : removing an entry PStmt: " + toRemovePsw));
                }
                --this.pstmtCacheSize;
                this.stats.incrementPrepStmtCacheDeleteCount();
                this.stats.decrementPrepStmtCacheCurrentSize();
            } else {
                if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                    cacheLogger.log(BasicLevel.DEBUG, (Object)"No more space in cache");
                }
                throw new CacheException("No more space in cache");
            }
        }
        this.pStmts.add(psw);
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)("Adding PStmt: " + psw));
        }
        ++this.pstmtCacheSize;
        this.stats.incrementPrepStmtCacheAddCount();
        this.stats.incrementPrepStmtCacheCurrentSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getState(String prefix) {
        String res = "";
        PreparedStatementListCacheImpl preparedStatementListCacheImpl = this;
        synchronized (preparedStatementListCacheImpl) {
            res = res + prefix + "size of pStmts:" + this.pstmtCacheSize + "\n";
            Iterator<PreparedStatementWrapper> it = this.pStmts.iterator();
            while (it.hasNext()) {
                res = res + prefix + "\t" + it.next() + "\n";
            }
        }
        return res;
    }

    public synchronized void destroy() {
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)"Destroy the cache entries");
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        PreparedStatementWrapper pw = null;
        while (this.pStmts != null && this.pStmts.size() > 0) {
            pw = this.pStmts.remove(0);
            this.stats.incrementPrepStmtCacheDeleteCount();
            this.stats.decrementPrepStmtCacheCurrentSize();
            try {
                pw.destroy();
            }
            catch (Exception exception) {}
        }
        this.pstmtCacheSize = 0;
    }

    public synchronized void reallyClose() {
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)"Close physically the cache entries");
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        PreparedStatementWrapper pw = null;
        while (this.pStmts != null && this.pStmts.size() > 0) {
            pw = this.pStmts.remove(0);
            this.stats.incrementPrepStmtCacheDeleteCount();
            this.stats.decrementPrepStmtCacheCurrentSize();
            try {
                pw.closePstmt();
            }
            catch (Exception exception) {}
        }
        this.pstmtCacheSize = 0;
    }

    public synchronized void close() {
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)"Close the cache entries");
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        PreparedStatementWrapper pw = null;
        int stmtSize = this.pStmts.size();
        try {
            for (int i = 0; i < stmtSize; ++i) {
                pw = this.pStmts.get(i);
                pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int findFreeStmt() {
        int offset = -1;
        int size = this.pStmts.size();
        PreparedStatementWrapper psw = null;
        if (this.pStmts != null) {
            for (int i = 0; i < size; ++i) {
                psw = this.pStmts.get(i);
                if (!psw.isClosed()) continue;
                offset = i;
                break;
            }
        }
        return offset;
    }
}

