/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class PropertyMetadata
extends ORMetadata {
    private String m_name;
    private String m_value;
    private MetadataClass m_valueType;
    private String m_valueTypeName;

    public PropertyMetadata() {
        super("<property>");
    }

    public PropertyMetadata(MetadataAnnotation property, MetadataAccessibleObject accessibleObject) {
        super(property, accessibleObject);
        this.m_name = (String)property.getAttributeString("name");
        this.m_value = (String)property.getAttributeString("value");
        this.m_valueType = this.getMetadataClass((String)property.getAttributeString("valueType"));
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PropertyMetadata) {
            PropertyMetadata property = (PropertyMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, property.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_value, property.getValue())) {
                return false;
            }
            return this.valuesMatch(this.m_valueTypeName, property.getValueTypeName());
        }
        return false;
    }

    public String getIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public MetadataClass getValueType() {
        return this.m_valueType;
    }

    public String getValueTypeName() {
        return this.m_valueTypeName;
    }

    public Object getConvertedValue() {
        if (this.m_valueType.isVoid() || this.m_valueType.equals(String.class)) {
            return this.m_value;
        }
        return ConversionManager.getDefaultManager().convertObject(this.m_value, this.getJavaClass(this.m_valueType));
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_valueType = this.initXMLClassName(this.m_valueTypeName);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void setValueType(MetadataClass valueType) {
        this.m_valueType = valueType;
    }

    public void setValueTypeName(String valueTypeName) {
        this.m_valueTypeName = valueTypeName;
    }
}

