/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderReader;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBUnmarshalListener;
import org.eclipse.persistence.jaxb.JAXBUnmarshallerHandler;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.attachment.AttachmentUnmarshallerAdapter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JAXBUnmarshaller
implements Unmarshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLUnmarshaller xmlUnmarshaller;
    private JAXBContext jaxbContext;
    private XMLInputFactory xmlInputFactory;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    public static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";

    public JAXBUnmarshaller(XMLUnmarshaller newXMLUnmarshaller) {
        this.xmlUnmarshaller = newXMLUnmarshaller;
        this.xmlUnmarshaller.setValidationMode(0);
        this.xmlUnmarshaller.setUnmarshalListener(new JAXBUnmarshalListener(this));
        try {
            this.xmlInputFactory = XMLInputFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            // empty catch block
        }
    }

    public XMLUnmarshaller getXMLUnmarshaller() {
        return this.xmlUnmarshaller;
    }

    public Object unmarshal(File file) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(file);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        try {
            if (null == this.xmlInputFactory || 0 != this.xmlUnmarshaller.getValidationMode()) {
                return this.createJAXBElementIfRequired(this.xmlUnmarshaller.unmarshal(inputStream));
            }
            if (null == inputStream) {
                throw XMLMarshalException.nullArgumentException();
            }
            XMLStreamReader xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(inputStream);
            return this.unmarshal(xmlStreamReader);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (XMLStreamException xmlStreamException) {
            throw new UnmarshalException((Throwable)xmlStreamException);
        }
    }

    public Object unmarshal(URL url) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(url);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(inputSource);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        try {
            if (null == this.xmlInputFactory || 0 != this.xmlUnmarshaller.getValidationMode()) {
                return this.createJAXBElementIfRequired(this.xmlUnmarshaller.unmarshal(reader));
            }
            if (null == reader) {
                throw XMLMarshalException.nullArgumentException();
            }
            XMLStreamReader xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(reader);
            return this.unmarshal(xmlStreamReader);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (XMLStreamException xmlStreamException) {
            throw new JAXBException((Throwable)xmlStreamException);
        }
    }

    public Object unmarshal(Node node) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(node);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    private JAXBElement buildJAXBElementFromObject(Object obj, Class declaredClass) {
        if (obj instanceof XMLRoot) {
            JAXBElement jaxbElement = this.createJAXBElementFromXMLRoot((XMLRoot)obj, declaredClass);
            jaxbElement.setNil(((XMLRoot)obj).isNil());
            return jaxbElement;
        }
        if (obj instanceof JAXBElement) {
            return (JAXBElement)obj;
        }
        AbstractSession sess = this.xmlUnmarshaller.getXMLContext().getSession(obj);
        XMLDescriptor desc = (XMLDescriptor)sess.getClassDescriptor(obj);
        String rootName = desc.getDefaultRootElement();
        if (rootName == null) {
            return this.createJAXBElement(new QName(""), obj.getClass(), obj);
        }
        String rootNamespaceUri = null;
        int idx = rootName.indexOf(":");
        if (idx != -1) {
            rootNamespaceUri = desc.getNamespaceResolver().resolveNamespacePrefix(rootName.substring(0, idx));
            rootName = rootName.substring(idx + 1);
        }
        QName qname = rootNamespaceUri == null ? new QName(rootName) : new QName(rootNamespaceUri, rootName);
        return this.createJAXBElement(qname, obj.getClass(), obj);
    }

    public JAXBElement unmarshal(Node node, Class javaClass) throws JAXBException {
        if (null == javaClass) {
            throw new IllegalArgumentException();
        }
        try {
            Class generatedClass;
            Class classToUnmarshalTo = javaClass;
            if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName())) != null) {
                classToUnmarshalTo = generatedClass;
            }
            return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(node, classToUnmarshalTo), javaClass);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(Source source) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(source);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(Source source, Class javaClass) throws JAXBException {
        if (null == javaClass) {
            throw new IllegalArgumentException();
        }
        try {
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, classToUnmarshalTo), javaClass);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    private JAXBElement unmarshal(Source source, Class javaClass, Class declaredType) {
        Class generatedClass;
        Class classToUnmarshalTo = javaClass;
        if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName())) != null) {
            classToUnmarshalTo = generatedClass;
        }
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, classToUnmarshalTo), declaredType);
    }

    public JAXBElement unmarshal(Source source, Type type) throws JAXBException {
        if (null == type) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(source, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(source, unmarshalClass, Object.class);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(source, (Class)type, Object.class);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(Source source, TypeMappingInfo type) throws JAXBException {
        try {
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(source, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(source, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(source, (Class)type.getType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Class javaClass) throws JAXBException {
        if (null == streamReader || null == javaClass) {
            throw new IllegalArgumentException();
        }
        try {
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
            staxReader.setErrorHandler(this.xmlUnmarshaller.getErrorHandler());
            XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
            JAXBElement unmarshalled = this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(staxReader, inputSource, classToUnmarshalTo), javaClass);
            if (classToUnmarshalTo != javaClass) {
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), javaClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            return unmarshalled;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Type type) throws JAXBException {
        if (null == streamReader || null == type) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(streamReader, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(streamReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(streamReader, (Class)type);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, TypeMappingInfo type) throws JAXBException {
        try {
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
                return this.unmarshal(streamReader, type.getType());
            }
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(streamReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(streamReader, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(streamReader, (Class)type.getType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(XMLStreamReader streamReader) throws JAXBException {
        if (null == streamReader) {
            throw new IllegalArgumentException();
        }
        try {
            XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
            staxReader.setErrorHandler(this.xmlUnmarshaller.getErrorHandler());
            XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
            Object value = this.xmlUnmarshaller.unmarshal(staxReader, inputSource);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Class javaClass) throws JAXBException {
        if (null == eventReader || null == javaClass) {
            throw new IllegalArgumentException();
        }
        try {
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            XMLEventReaderReader staxReader = new XMLEventReaderReader(this.xmlUnmarshaller);
            XMLEventReaderInputSource inputSource = new XMLEventReaderInputSource(eventReader);
            JAXBElement unmarshalled = this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(staxReader, inputSource, classToUnmarshalTo), javaClass);
            if (classToUnmarshalTo != javaClass) {
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), javaClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            return unmarshalled;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Type type) throws JAXBException {
        if (null == eventReader || null == type) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(eventReader, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(eventReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(eventReader, (Class)type);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, TypeMappingInfo type) throws JAXBException {
        try {
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
                return this.unmarshal(eventReader, type.getType());
            }
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(eventReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(eventReader, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException(ex));
                    }
                }
                return this.unmarshal(eventReader, (Class)type.getType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(XMLEventReader eventReader) throws JAXBException {
        if (null == eventReader) {
            throw new IllegalArgumentException();
        }
        try {
            XMLEventReaderReader staxReader = new XMLEventReaderReader(this.xmlUnmarshaller);
            XMLEventReaderInputSource inputSource = new XMLEventReaderInputSource(eventReader);
            Object value = this.xmlUnmarshaller.unmarshal(staxReader, inputSource);
            return this.createJAXBElementIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new JAXBUnmarshallerHandler(this);
    }

    public void setValidating(boolean validate) throws JAXBException {
        if (validate) {
            this.xmlUnmarshaller.setValidationMode(3);
        } else {
            this.xmlUnmarshaller.setValidationMode(0);
        }
    }

    public boolean isValidating() throws JAXBException {
        return this.xmlUnmarshaller.getValidationMode() != 0;
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = null == newValidationEventHandler ? new DefaultValidationEventHandler() : newValidationEventHandler;
        this.xmlUnmarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public void setProperty(String key, Object value) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException(key, value);
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException("Unsupported Property");
    }

    public Unmarshaller.Listener getListener() {
        return ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).getListener();
    }

    public void setListener(Unmarshaller.Listener listener) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setListener(listener);
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlUnmarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlUnmarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlUnmarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public void setSchema(Schema schema) {
        this.xmlUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.xmlUnmarshaller.getSchema();
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        if (this.xmlUnmarshaller.getAttachmentUnmarshaller() == null) {
            return null;
        }
        return ((AttachmentUnmarshallerAdapter)this.xmlUnmarshaller.getAttachmentUnmarshaller()).getAttachmentUnmarshaller();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller unmarshaller) {
        if (unmarshaller == null) {
            this.xmlUnmarshaller.setAttachmentUnmarshaller(null);
        } else {
            this.xmlUnmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerAdapter(unmarshaller));
        }
    }

    public void setUnmarshalCallbacks(HashMap callbacks) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setClassBasedUnmarshalEvents(callbacks);
    }

    private Object createJAXBElementIfRequired(Object value) {
        if (value instanceof XMLRoot) {
            JAXBElement jaxbElement = this.createJAXBElementFromXMLRoot((XMLRoot)value, Object.class);
            jaxbElement.setNil(((XMLRoot)value).isNil());
            return jaxbElement;
        }
        return value;
    }

    private JAXBElement createJAXBElementFromXMLRoot(XMLRoot xmlRoot, Class declaredType) {
        Class declaredClass;
        HashMap<QName, Class> qNamesToDeclaredClasses;
        Object value = xmlRoot.getObject();
        if (value instanceof WrappedValue) {
            QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
            return new JAXBElement(qname, ((WrappedValue)((Object)value)).getDeclaredType(), ((WrappedValue)((Object)value)).getValue());
        }
        if (value instanceof JAXBElement) {
            return (JAXBElement)value;
        }
        QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
        if (value instanceof ManyValue) {
            value = ((ManyValue)value).getItem();
        }
        if ((qNamesToDeclaredClasses = this.jaxbContext.getQNamesToDeclaredClasses()) != null && (declaredClass = (Class)qNamesToDeclaredClasses.get(qname)) != null) {
            return this.createJAXBElement(qname, declaredClass, value);
        }
        XMLDescriptor descriptorForQName = this.xmlUnmarshaller.getXMLContext().getDescriptor(qname);
        if (descriptorForQName != null) {
            return this.createJAXBElement(qname, descriptorForQName.getJavaClass(), value);
        }
        if (value != null) {
            XMLConversionManager xcm = (XMLConversionManager)this.xmlUnmarshaller.getXMLContext().getSession(0).getDatasourcePlatform().getConversionManager();
            if (xcm.getDefaultJavaTypes().get(value.getClass()) != null) {
                return this.createJAXBElement(qname, declaredType, value);
            }
        }
        return this.createJAXBElement(qname, declaredType, value);
    }

    private JAXBElement createJAXBElement(QName qname, Class theClass, Object value) {
        if (theClass == null) {
            return new JAXBElement(qname, Object.class, value);
        }
        if (ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(theClass)) {
            theClass = ClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (ClassConstants.DURATION.isAssignableFrom(theClass)) {
            theClass = ClassConstants.DURATION;
        }
        return new JAXBElement(qname, theClass, value);
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    private Class getClassToUnmarshalTo(Class originalClass) {
        Class generatedClass;
        TypeMappingInfo tmi;
        Class generatedClass2;
        Class classToUnmarshalTo = originalClass;
        if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass2 = this.jaxbContext.getArrayClassesToGeneratedClasses().get(originalClass.getCanonicalName())) != null) {
            classToUnmarshalTo = generatedClass2;
        }
        if (this.jaxbContext.getCollectionClassesToGeneratedClasses() != null && (generatedClass2 = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(originalClass)) != null) {
            classToUnmarshalTo = generatedClass2;
        }
        if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(originalClass)) != null && this.jaxbContext.getTypeMappingInfoToGeneratedType() != null && (generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi)) != null) {
            classToUnmarshalTo = generatedClass;
        }
        return classToUnmarshalTo;
    }

    private JAXBException handleXMLMarshalException(XMLMarshalException xmlMarshalException) {
        if (xmlMarshalException.getErrorCode() == 25011) {
            throw new IllegalArgumentException(xmlMarshalException);
        }
        return new UnmarshalException((Throwable)xmlMarshalException);
    }
}

