/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetailData;
import org.ow2.easybeans.component.quartz.EasyBeansTimerHandle;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansTimer
implements Timer {
    private JobDetail jobDetail = null;
    private Trigger trigger = null;
    private Scheduler scheduler = null;
    private Factory<?, ?> factory = null;
    private boolean cancelled = false;

    public EasyBeansTimer(JobDetail jobDetail, Trigger trigger, Scheduler scheduler, Factory<?, ?> factory) {
        this.jobDetail = jobDetail;
        this.trigger = trigger;
        this.scheduler = scheduler;
        this.factory = factory;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The cancel() method cannot be called within the operation state '" + operationState + "'.");
        }
        this.checkNotCancelled();
        try {
            this.scheduler.deleteJob(this.jobDetail.getKey());
        }
        catch (SchedulerException e) {
            throw new EJBException("Cannot cancel job with name '" + this.jobDetail.getKey().getName() + "'.", (Exception)e);
        }
        this.cancelled = true;
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getTimeRemaining() method cannot be called within the operation state '" + operationState + "'.");
        }
        this.checkNotCancelled();
        return this.getNextTimeout().getTime() - System.currentTimeMillis();
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getNextTimeout() method cannot be called within the operation state '" + operationState + "'.");
        }
        this.checkNotCancelled();
        boolean noNextTimeout = false;
        Date nextFireTime = this.trigger.getNextFireTime();
        Date now = new Date();
        if (nextFireTime != null && (now.after(nextFireTime) || now.equals(nextFireTime))) {
            Date newTime = this.trigger.getFireTimeAfter(now);
            if (newTime != null && nextFireTime.equals(newTime)) {
                noNextTimeout = true;
            } else {
                return newTime;
            }
        }
        if (nextFireTime == null) {
            noNextTimeout = true;
        }
        if (noNextTimeout) {
            throw new NoSuchObjectLocalException("No next timeout for this timer");
        }
        return nextFireTime;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getInfo() method cannot be called within the operation state '" + operationState + "'.");
        }
        this.checkNotCancelled();
        EasyBeansJobDetailData data = (EasyBeansJobDetailData)this.jobDetail.getJobDataMap().get("data");
        return data.getInfo();
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getHandle() method cannot be called within the operation state '" + operationState + "'.");
        }
        this.checkNotCancelled();
        if (!this.isPersistent()) {
            throw new IllegalStateException("Cannot call getHandle on a non-persistent timer");
        }
        return new EasyBeansTimerHandle(this.jobDetail);
    }

    public ScheduleExpression getSchedule() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkNotCancelled();
        EasyBeansJobDetailData data = (EasyBeansJobDetailData)this.jobDetail.getJobDataMap().get("data");
        ScheduleExpression scheduleExpression = data.getScheduleExpression();
        if (scheduleExpression == null) {
            throw new IllegalStateException("Not a calendar based timer");
        }
        return scheduleExpression;
    }

    public boolean isCalendarTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getHandle() method cannot be called within the operation state '" + operationState + "'.");
        }
        this.checkNotCancelled();
        EasyBeansJobDetailData data = (EasyBeansJobDetailData)this.jobDetail.getJobDataMap().get("data");
        return data.getScheduleExpression() != null;
    }

    public boolean isPersistent() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkNotCancelled();
        EasyBeansJobDetailData data = (EasyBeansJobDetailData)this.jobDetail.getJobDataMap().get("data");
        return data.isPersistent();
    }

    protected Trigger getTrigger() {
        return this.trigger;
    }

    protected void checkNotCancelled() throws NoSuchObjectLocalException {
        if (this.cancelled) {
            throw new NoSuchObjectLocalException("This timer has been cancelled");
        }
    }

    public void setInvalid() {
        this.cancelled = true;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof EasyBeansTimer)) {
            return false;
        }
        EasyBeansTimer otherTimer = (EasyBeansTimer)other;
        return this.jobDetail.getKey().equals(otherTimer.jobDetail.getKey());
    }

    public int hashCode() {
        return this.jobDetail.hashCode();
    }
}

