/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.ow2.easybeans.component.quartz.SchedulePatterns;
import org.ow2.easybeans.component.quartz.ValueResult;

public abstract class ScheduleValue {
    public static final int SUNDAY_7 = 7;
    private int calendarField;
    private Map<String, Integer> weekDaysToInt = null;
    private Calendar calendar = null;

    public ScheduleValue(int calendarField) {
        this.calendarField = calendarField;
        this.calendar = new GregorianCalendar();
        this.weekDaysToInt = new HashMap<String, Integer>();
        this.weekDaysToInt.put("sun", 1);
        this.weekDaysToInt.put("mon", 2);
        this.weekDaysToInt.put("tue", 3);
        this.weekDaysToInt.put("wed", 4);
        this.weekDaysToInt.put("thu", 5);
        this.weekDaysToInt.put("fri", 6);
        this.weekDaysToInt.put("sat", 7);
    }

    protected String[] getNDays(String input) {
        Matcher matcher = SchedulePatterns.PATTERN_NDAYS.matcher(input);
        if (matcher.matches()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return null;
    }

    protected Integer computeNDays(String number, String day, Calendar calendar) {
        int dayToGet = this.weekDaysToInt.get(day);
        Calendar newCalendar = (Calendar)calendar.clone();
        if ("last".equals(number)) {
            newCalendar.set(7, dayToGet);
            newCalendar.set(8, -1);
            return newCalendar.get(5);
        }
        int wantedNumber = Integer.parseInt(Character.valueOf(number.charAt(0)).toString());
        newCalendar.set(7, dayToGet);
        newCalendar.set(8, wantedNumber);
        if (calendar.get(2) != newCalendar.get(2)) {
            return null;
        }
        return newCalendar.get(5);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public abstract ValueResult getTimeAfter(Calendar var1);
}

