/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.Calendar;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.ow2.easybeans.component.quartz.ScheduleValue;
import org.ow2.easybeans.component.quartz.ValueResult;

public class ScheduleValueIncrements
extends ScheduleValue {
    private int startingPoint;
    private int interval;
    private NavigableSet<Integer> allValues = null;

    public ScheduleValueIncrements(String startingPoint, int interval, int calendarField) {
        super(calendarField);
        this.startingPoint = "*".equals(startingPoint) ? Calendar.getInstance().getMinimum(calendarField) : Integer.parseInt(startingPoint);
        this.interval = interval;
        this.allValues = new TreeSet<Integer>();
        this.init();
    }

    private void init() {
        int current = this.startingPoint;
        this.allValues.add(current);
        current += this.interval;
        while (current < this.getCalendar().getMaximum(this.getCalendarField())) {
            this.allValues.add(current);
            current += this.interval;
        }
    }

    public ValueResult getTimeAfter(Calendar afterTimeCalendar) {
        ValueResult valueResult = new ValueResult();
        int currentFieldValue = afterTimeCalendar.get(this.getCalendarField());
        Integer foundValue = this.allValues.ceiling(currentFieldValue);
        if (foundValue != null) {
            valueResult.setResult(foundValue);
        } else {
            valueResult.setResult((Integer)this.allValues.first());
            valueResult.setNeedsIncrement(true);
        }
        return valueResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[startingPoint=");
        sb.append(this.startingPoint);
        sb.append(", interval=");
        sb.append(this.interval);
        sb.append(", calendarField=");
        sb.append(this.getCalendarField());
        sb.append(", allValues=");
        sb.append(this.allValues);
        sb.append("]");
        return sb.toString();
    }
}

