/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.ow2.jonas.audit.internal.logger.NodeReportType;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.InvocationAuditReport;
import org.ow2.util.auditreport.impl.JNDIAuditReport;
import org.ow2.util.auditreport.impl.JaxwsAuditReport;
import org.ow2.util.auditreport.impl.WebInvocationAuditReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeReport
implements Serializable {
    private static final long serialVersionUID = -4591802637765669254L;
    private static final int THIRD = 3;
    private String id;
    private String desc;
    private boolean leaf = true;
    private boolean missingParent = false;
    private Date date = null;
    private NodeReportType type = NodeReportType.UNKNOWN;
    private String name = null;
    private String application = null;
    private String details = null;
    private double execTime = 0.0;
    private TreeMap<Integer, NodeReport> treeMap = null;

    public NodeReport(String id, boolean leaf) {
        this.id = id;
        this.leaf = leaf;
        this.treeMap = new TreeMap();
    }

    public TreeMap<Integer, NodeReport> getTreeMap() {
        return this.treeMap;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public String getID() {
        return this.id;
    }

    public boolean isMissingParent() {
        return this.missingParent;
    }

    public void setMissingParent(boolean missingParent) {
        this.missingParent = missingParent;
    }

    public String getDesc() {
        return this.desc;
    }

    public NodeReportType getType() {
        return this.type;
    }

    public void setType(NodeReportType type) {
        this.type = type;
    }

    public void setReport(GenericAuditReport report) {
        this.date = new Date(report.getRequestTimeStamp());
        String txt = "";
        if (report instanceof InvocationAuditReport) {
            String[] parts;
            InvocationAuditReport invocationAuditReport = (InvocationAuditReport)report;
            String target = invocationAuditReport.getTarget();
            if (target.startsWith("/easybeans/")) {
                target = target.substring("/easybeans/".length());
            }
            if ((parts = target.split("/")).length >= 3) {
                this.name = parts[2] + "::" + parts[3];
                this.application = parts[0] + "::" + parts[1];
                txt = parts[2] + "::" + parts[3] + "\n" + parts[0] + "::" + parts[1] + "\n" + txt;
            }
            this.execTime = invocationAuditReport.getRequestDuration();
            if (invocationAuditReport.getBusinessMethod().contains("@Local")) {
                this.setType(NodeReportType.EJB_LOCAL);
            } else if (invocationAuditReport.getBusinessMethod().contains("@Remote")) {
                this.setType(NodeReportType.EJB_REMOTE);
            } else {
                this.setType(NodeReportType.EJB);
            }
        } else if (report instanceof WebInvocationAuditReport) {
            String[] parts;
            WebInvocationAuditReport webInvocationAuditReport = (WebInvocationAuditReport)report;
            String target = webInvocationAuditReport.getTarget();
            if (target.startsWith("/webcontainer/")) {
                target = target.substring("/webcontainer/".length());
            }
            if ((parts = target.split("/")).length >= 3) {
                this.name = report.getBeanName();
                this.application = "root".equals(parts[1]) ? "standalone::" + parts[0] : parts[0] + "::" + parts[1];
                txt = parts[0] + "::" + parts[1] + "\n" + txt;
            }
            txt = report.getBeanName() + "\n" + txt;
            this.setType(NodeReportType.HTTP_GET);
            this.execTime = webInvocationAuditReport.getRequestDuration();
        } else if (report instanceof JNDIAuditReport) {
            JNDIAuditReport jndiAuditReport = (JNDIAuditReport)report;
            txt = jndiAuditReport.getBusinessMethod();
            txt = jndiAuditReport.getContextParameters() == null ? txt + "()" : txt + "(" + Arrays.asList(jndiAuditReport.getContextParameters()) + ")";
            this.name = txt;
            this.execTime = jndiAuditReport.getRequestDuration();
            this.setType(NodeReportType.JNDI);
        } else if (report instanceof JaxwsAuditReport) {
            JaxwsAuditReport auditReport = (JaxwsAuditReport)report;
            QName service = QName.valueOf(auditReport.getServiceQName());
            QName port = QName.valueOf(auditReport.getPortQName());
            QName operation = QName.valueOf(auditReport.getOperationQName());
            StringBuilder sb = new StringBuilder();
            sb.append("Service QName: ");
            sb.append(service);
            sb.append('\n');
            sb.append("Port QName: ");
            sb.append(port);
            sb.append('\n');
            sb.append("Operation QName: ");
            sb.append(operation);
            txt = sb.toString();
            this.name = service.getLocalPart() + "/" + port.getLocalPart() + ":" + operation.getLocalPart();
            this.execTime = auditReport.getEndProcessingTimestamp() - auditReport.getStartProcessingTimestamp();
            this.setType(NodeReportType.JAXWS_ENDPOINT);
        } else {
            txt = report.getBeanName();
        }
        this.desc = txt;
    }

    public double getExecTime() {
        return this.execTime;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getDetails() {
        return this.details;
    }

    public String getName() {
        return this.name;
    }

    public String getApplication() {
        return this.application;
    }

    public Date getDate() {
        return this.date;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.id);
        if (this.treeMap != null && this.treeMap.size() > 0) {
            sb.append(this.treeMap.toString());
        }
        if (this.desc != null) {
            sb.append(", desc=");
            sb.append(this.desc);
        }
        sb.append("]");
        return sb.toString();
    }
}

