/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Collection;
import java.util.Map;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.search.engine.impl.HibernateStatelessInitializer;
import org.hibernate.search.engine.spi.EntityInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionLoadingInitializer
extends HibernateStatelessInitializer
implements EntityInitializer {
    private final SessionImplementor hibernateSession;

    public HibernateSessionLoadingInitializer(SessionImplementor hibernateSession) {
        this.hibernateSession = hibernateSession;
    }

    @Override
    public <T> Collection<T> initializeCollection(Collection<T> value) {
        if (value instanceof PersistentCollection) {
            this.preparePersistentCollection((PersistentCollection)((Object)value));
        }
        return value;
    }

    @Override
    public <K, V> Map<K, V> initializeMap(Map<K, V> value) {
        if (value instanceof PersistentCollection) {
            this.preparePersistentCollection((PersistentCollection)((Object)value));
        }
        return value;
    }

    private void preparePersistentCollection(PersistentCollection value) {
        if (value.setCurrentSession(this.hibernateSession)) {
            String role = value.getRole();
            CollectionPersister collectionPersister = this.hibernateSession.getFactory().getCollectionPersister(role);
            this.hibernateSession.getPersistenceContext().addInitializedDetachedCollection(collectionPersister, value);
        }
    }
}

