/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.impl.SolrAnalyzerBuilder;
import org.hibernate.search.util.ClassLoaderHelper;
import org.hibernate.search.util.DelegateNamedAnalyzer;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigContext {
    private static final Logger log = LoggerFactory.make();
    private static final Version DEFAULT_LUCENE_MATCH_VERSION = Version.LUCENE_30;
    private static final String DEFAULT_NULL_INDEX_TOKEN = "_null_";
    private static final String PROGRAMMATIC_ANALYZER_DEFINITION = "PROGRAMMATIC_ANALYZER_DEFINITION";
    private final Map<String, String> analyzerDefinitionPoints = new HashMap<String, String>();
    private final Map<String, AnalyzerDef> analyzerDefs = new HashMap<String, AnalyzerDef>();
    private final Collection<String> facetFieldNames = new HashSet<String>();
    private final List<DelegateNamedAnalyzer> lazyAnalyzers = new ArrayList<DelegateNamedAnalyzer>();
    private final Analyzer defaultAnalyzer;
    private final Similarity defaultSimilarity;
    private final boolean solrPresent;
    private final boolean jpaPresent;
    private final Version luceneMatchVersion;
    private final String nullToken;

    public ConfigContext(SearchConfiguration cfg) {
        this.luceneMatchVersion = this.getLuceneMatchVersion(cfg);
        this.defaultAnalyzer = this.initAnalyzer(cfg);
        this.defaultSimilarity = this.initSimilarity(cfg);
        this.solrPresent = this.isPresent("org.apache.solr.analysis.TokenizerFactory");
        this.jpaPresent = this.isPresent("javax.persistence.Id");
        this.nullToken = this.initNullToken(cfg);
    }

    public void addAnalyzerDef(AnalyzerDef analyzerDef, XAnnotatedElement annotatedElement) {
        if (analyzerDef == null) {
            return;
        }
        this.addAnalyzerDef(analyzerDef, this.buildAnnotationDefinitionPoint(annotatedElement));
    }

    public void addFacetFieldName(String facetFieldName) {
        this.facetFieldNames.add(facetFieldName);
    }

    public Collection<String> getFacetFieldNames() {
        return this.facetFieldNames;
    }

    public void addGlobalAnalyzerDef(AnalyzerDef analyzerDef) {
        this.addAnalyzerDef(analyzerDef, PROGRAMMATIC_ANALYZER_DEFINITION);
    }

    private void addAnalyzerDef(AnalyzerDef analyzerDef, String annotationDefinitionPoint) {
        String analyzerDefinitionName = analyzerDef.name();
        if (this.analyzerDefinitionPoints.containsKey(analyzerDefinitionName)) {
            if (!this.analyzerDefinitionPoints.get(analyzerDefinitionName).equals(annotationDefinitionPoint)) {
                throw new SearchException("Multiple analyzer definitions with the same name: " + analyzerDef.name());
            }
        } else {
            this.analyzerDefs.put(analyzerDefinitionName, analyzerDef);
            this.analyzerDefinitionPoints.put(analyzerDefinitionName, annotationDefinitionPoint);
        }
    }

    public Analyzer buildLazyAnalyzer(String name) {
        DelegateNamedAnalyzer delegateNamedAnalyzer = new DelegateNamedAnalyzer(name);
        this.lazyAnalyzers.add(delegateNamedAnalyzer);
        return delegateNamedAnalyzer;
    }

    public List<DelegateNamedAnalyzer> getLazyAnalyzers() {
        return this.lazyAnalyzers;
    }

    private Analyzer initAnalyzer(SearchConfiguration cfg) {
        Class analyzerClass;
        String analyzerClassName = cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ReflectHelper.classForName(analyzerClassName);
            }
            catch (Exception e) {
                return this.buildLazyAnalyzer(analyzerClassName);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        return ClassLoaderHelper.analyzerInstanceFromClass(analyzerClass, this.luceneMatchVersion);
    }

    private Similarity initSimilarity(SearchConfiguration cfg) {
        String similarityClassName = cfg.getProperty("hibernate.search.similarity");
        Similarity defaultSimilarity = StringHelper.isEmpty(similarityClassName) ? Similarity.getDefault() : ClassLoaderHelper.instanceFromName(Similarity.class, similarityClassName, ConfigContext.class, "default similarity");
        log.debug("Using default similarity implementation: {}", (Object)defaultSimilarity.getClass().getName());
        return defaultSimilarity;
    }

    private String initNullToken(SearchConfiguration cfg) {
        String defaultNullIndexToken = cfg.getProperty("hibernate.search.default_null_token");
        if (StringHelper.isEmpty(defaultNullIndexToken)) {
            defaultNullIndexToken = DEFAULT_NULL_INDEX_TOKEN;
        }
        return defaultNullIndexToken;
    }

    public String getDefaultNullToken() {
        return this.nullToken;
    }

    public Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    public Version getLuceneMatchVersion() {
        return this.luceneMatchVersion;
    }

    public Map<String, Analyzer> initLazyAnalyzers() {
        HashMap<String, Analyzer> initializedAnalyzers = new HashMap<String, Analyzer>(this.analyzerDefs.size());
        for (DelegateNamedAnalyzer delegateNamedAnalyzer : this.lazyAnalyzers) {
            String name = delegateNamedAnalyzer.getName();
            if (initializedAnalyzers.containsKey(name)) {
                delegateNamedAnalyzer.setDelegate((Analyzer)initializedAnalyzers.get(name));
                continue;
            }
            if (this.analyzerDefs.containsKey(name)) {
                Analyzer analyzer = this.buildAnalyzer(this.analyzerDefs.get(name));
                delegateNamedAnalyzer.setDelegate(analyzer);
                initializedAnalyzers.put(name, analyzer);
                continue;
            }
            throw new SearchException("Analyzer found with an unknown definition: " + name);
        }
        for (Map.Entry entry : this.analyzerDefs.entrySet()) {
            if (initializedAnalyzers.containsKey(entry.getKey())) continue;
            Analyzer analyzer = this.buildAnalyzer((AnalyzerDef)entry.getValue());
            initializedAnalyzers.put((String)entry.getKey(), analyzer);
        }
        return Collections.unmodifiableMap(initializedAnalyzers);
    }

    private Analyzer buildAnalyzer(AnalyzerDef analyzerDef) {
        if (!this.solrPresent) {
            throw new SearchException("Use of @AnalyzerDef while Solr is not present in the classpath. Add apache-solr-analyzer.jar");
        }
        return SolrAnalyzerBuilder.buildAnalyzer(analyzerDef, this.luceneMatchVersion);
    }

    public boolean isJpaPresent() {
        return this.jpaPresent;
    }

    private boolean isPresent(String className) {
        try {
            ReflectHelper.classForName(className, ConfigContext.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Version getLuceneMatchVersion(SearchConfiguration cfg) {
        Version version;
        String tmp = cfg.getProperty("hibernate.search.lucene_version");
        if (StringHelper.isEmpty(tmp)) {
            version = DEFAULT_LUCENE_MATCH_VERSION;
        } else {
            try {
                version = Version.valueOf(tmp);
            }
            catch (IllegalArgumentException e) {
                StringBuilder msg = new StringBuilder(tmp);
                msg.append(" is a invalid value for the Lucene match version. Possible values are: ");
                for (Version v : Version.values()) {
                    msg.append(v.toString());
                    msg.append(", ");
                }
                msg.delete(msg.lastIndexOf(","), msg.length() - 1);
                throw new SearchException(msg.toString());
            }
        }
        return version;
    }

    private String buildAnnotationDefinitionPoint(XAnnotatedElement annotatedElement) {
        if (annotatedElement instanceof XClass) {
            return ((XClass)annotatedElement).getName();
        }
        if (annotatedElement instanceof XMember) {
            XMember member = (XMember)annotatedElement;
            return member.getType().getName() + '.' + member.getName();
        }
        if (annotatedElement instanceof XPackage) {
            return ((XPackage)annotatedElement).getName();
        }
        throw new SearchException("Unknown XAnnoatedElement: " + annotatedElement);
    }
}

