/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.deployment.api.EZBInjectionHolder;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.api.PersistenceXmlFileAnalyzerException;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIResolver;
import org.ow2.jonas.Version;
import org.ow2.jonas.deployment.client.wrapper.ClientManagerWrapper;
import org.ow2.jonas.deployment.ear.EarDeploymentDesc;
import org.ow2.jonas.deployment.ear.EarDeploymentDescException;
import org.ow2.jonas.deployment.ear.wrapper.EarManagerWrapper;
import org.ow2.jonas.deployment.ejb.wrapper.EjbManagerWrapper;
import org.ow2.jonas.deployment.web.wrapper.WebManagerWrapper;
import org.ow2.jonas.ear.EarServiceException;
import org.ow2.jonas.ear.internal.EARModule;
import org.ow2.jonas.ejb2.EJBService;
import org.ow2.jonas.ejb3.IEasyBeansService;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genclientstub.ClientStubGen;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.loader.FilteringClassLoader;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.security.mapping.JPolicyUserRoleMapping;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.multitenant.MultitenantService;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.resource.ResourceServiceException;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.ws.jaxrpc.IJAXRPCService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarDeployer
extends AbsDeployer<EARDeployable> {
    public static final String DEFAULT_FOLDER = "JOnAS-Deployer";
    private Log logger = LogFactory.getLog(EarDeployer.class);
    private IJAXRPCService jaxrpcService = null;
    private JmxService jmxService = null;
    private ResourceService resourceService = null;
    private EJBService ejb21Service = null;
    private IEasyBeansService ejb3Service = null;
    private JWebContainerService webContainerService = null;
    private ClassLoader appsClassLoader;
    private Map<URL, EARDeployable> ears = new HashMap<URL, EARDeployable>();
    private ServerProperties serverProperties = null;
    private VersioningService versioningService;
    private MultitenantService multitenantService;
    private ServiceManager serviceManager;
    private String appsWorkDirectory = null;
    private String webappsWorkDirectory = null;
    protected static final String INEAR_WORK_WEBAPPS_DIR_SUFFIX = "ear";
    private EZBServer embedded = null;
    private DeployerLog deployerLog;
    private static final String WSDL_DIRECTORY = "META-INF/wsdl/";
    private boolean genClientStubEnabled = false;
    private boolean useEJB3ChildClassloader = false;
    private JComponentContextFactory contextFactory;

    public EZBServer getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(EZBServer embedded) {
        this.embedded = embedded;
    }

    public void enableGenClientStub() {
        this.genClientStubEnabled = true;
    }

    public void useEJB3ChildClassloader() {
        this.useEJB3ChildClassloader = true;
    }

    protected EARDeployable applyGenClientStubIfNeeded(final EARDeployable deployable) throws DeployerException {
        if (!this.genClientStubEnabled) {
            return deployable;
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"Cannot sleep in  GenClientStub", new Object[0]);
        }
        IExecution<EARDeployable> exec = new IExecution<EARDeployable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public EARDeployable execute() throws Exception {
                EARDeployable earDeployable = deployable;
                ClientStubGen stubGen = new ClientStubGen();
                Config config = new Config();
                String inputName = URLUtils.urlToFile((URL)deployable.getArchive().getURL()).getPath();
                config.setInputname(inputName);
                config.setOut(new File(EarDeployer.this.getServerProperties().getWorkDirectory(), "genclientstub"));
                try {
                    String path = stubGen.execute(config, (IDeployable)deployable);
                    if (stubGen.isInputModified()) {
                        IArchive archive = ArchiveManager.getInstance().getArchive((Object)new File(path));
                        EARDeployable newDeployable = (EARDeployable)EARDeployable.class.cast(DeployableHelper.getDeployable((IArchive)archive));
                        File folder = new File(EarDeployer.this.appsWorkDirectory, EarDeployer.this.getServerProperties().getServerName());
                        String archiveName = URLUtils.urlToFile((URL)deployable.getArchive().getURL()).getName();
                        earDeployable = (EARDeployable)UnpackDeployableHelper.unpack((IDeployable)newDeployable, (File)folder, (String)archiveName, (boolean)false);
                        earDeployable.setOriginalDeployable(deployable.getOriginalDeployable());
                    }
                }
                catch (Throwable e) {
                    EarDeployer.this.logger.error((Object)("Cannot execute GenClientStub on archive '" + deployable.getArchive() + "'"), new Object[]{e});
                }
                finally {
                    FileUtils.delete((File)config.getOut());
                }
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e1) {
                    EarDeployer.this.logger.error((Object)"Cannot sleep in  GenClientStub", new Object[0]);
                }
                return earDeployable;
            }
        };
        ExecutionResult result = null;
        try {
            result = RunnableHelper.execute((ClassLoader)LoaderManager.getInstance().getExternalLoader(), (IExecution)exec);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get the 'external' ClassLoader", (Throwable)e);
        }
        if (result.hasException()) {
            throw new DeployerException(result.getException().getMessage(), (Throwable)result.getException());
        }
        return (EARDeployable)result.getResult();
    }

    private void applyWSGenIfNeeded(EARDeployable deployable) throws DeployerException {
        if (this.jaxrpcService == null) {
            this.logger.debug((Object)"The JAX-RPC service is not present, no need to call WSGen", new Object[0]);
            return;
        }
        if (!this.jaxrpcService.isAutoWsGenEngaged()) {
            this.logger.debug((Object)"Automatic WsGen is not enabled, no need to call WSGen", new Object[0]);
            return;
        }
        String jonasVersionWsGen = deployable.getArchive().getMetadata().get("WsGen-JOnAS-Version");
        if (Version.getNumber().equals(jonasVersionWsGen)) {
            this.logger.debug((Object)BasicLevel.DEBUG, new Object[]{"Manifest version up-to-date, no need to call WSGen"});
            return;
        }
        try {
            this.jaxrpcService.applyWSGen((IDeployable)deployable);
        }
        catch (Exception e) {
            throw new DeployerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeploy(IDeployable<EARDeployable> deployable) throws DeployerException {
        URL originalURL;
        File unpackedFile;
        URL unpackedURL;
        long startTime = System.currentTimeMillis();
        EARDeployable unpackedDeployable = null;
        File originalFile = null;
        try {
            File folder = new File(this.appsWorkDirectory, this.getServerProperties().getServerName());
            originalFile = URLUtils.urlToFile((URL)deployable.getArchive().getURL());
            String archiveName = FileUtils.lastModifiedFileName((File)originalFile);
            boolean keepArchives = false;
            File unpackedFolder = new File(folder, archiveName);
            if (unpackedFolder.exists() && originalFile.lastModified() <= unpackedFolder.lastModified()) {
                keepArchives = true;
            }
            unpackedDeployable = (EARDeployable)UnpackDeployableHelper.unpack((IDeployable)((IDeployable)EARDeployable.class.cast(deployable)), (File)folder, (String)archiveName, (boolean)keepArchives);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy archive for '" + deployable.getArchive() + "'", (Throwable)e);
        }
        this.logger.info((Object)"Deploying ''{0}''", new Object[]{unpackedDeployable});
        this.serviceManager.startRequiredServices((IDeployable)unpackedDeployable);
        IArchive earArchive = unpackedDeployable.getArchive();
        this.applyWSGenIfNeeded(unpackedDeployable);
        unpackedDeployable = this.applyGenClientStubIfNeeded(unpackedDeployable);
        try {
            unpackedURL = earArchive.getURL();
            unpackedFile = URLUtils.urlToFile((URL)unpackedURL);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get URL from archive '" + earArchive + "'", (Throwable)e);
        }
        try {
            originalURL = deployable.getArchive().getURL();
            if (this.deployerLog != null) {
                this.deployerLog.addEntry(originalFile, unpackedFile);
            }
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get the url of the initial deployable for the EAR Module '" + deployable + "'.", (Throwable)e);
        }
        URLClassLoader loaderCls = new URLClassLoader(new URL[]{unpackedURL}, this.appsClassLoader);
        EarDeploymentDesc earDD = null;
        URL applicationXML = null;
        try {
            applicationXML = earArchive.getResource("META-INF/application.xml");
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get resource META-INF/application.xml", (Throwable)e);
        }
        URL jonasApplicationXML = null;
        try {
            jonasApplicationXML = earArchive.getResource("META-INF/jonas-application.xml");
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get resource META-INF/jonas-application.xml", (Throwable)e);
        }
        if (applicationXML != null || jonasApplicationXML != null) {
            try {
                earDD = EarManagerWrapper.getDeploymentDesc((EARDeployable)unpackedDeployable, (ClassLoader)loaderCls);
            }
            catch (EarDeploymentDescException e) {
                String err = "Error in the Deployment descriptor '" + deployable + "': " + (Object)((Object)e);
                this.logger.error((Object)err, new Object[0]);
                throw new EarServiceException(err, (Throwable)e);
            }
        }
        String[] securityRoles = new String[]{};
        if (earDD != null) {
            securityRoles = earDD.getSecurityRolesNames();
        }
        String tenantId = null;
        if (this.isMultitenantEnabled()) {
            tenantId = this.multitenantService.getTenantIdFromContext();
            if ((tenantId == null || tenantId != null && tenantId.equals("")) && ((tenantId = earDD.getTenantId()) == null || tenantId != null && tenantId.equals(""))) {
                tenantId = this.multitenantService.getDefaultTenantID();
            }
            if (tenantId != null) {
                this.multitenantService.addTenantIdDeployableInfo((IDeployable)unpackedDeployable, tenantId);
            } else {
                this.logger.debug((Object)"Fail to bind object tenantId ''{0}''", new Object[]{tenantId});
            }
        }
        FilteringClassLoader filteringClassLoader = this.createFilteringClassLoader(earArchive);
        this.logger.debug((Object)"Creating the EAR classLoader", new Object[0]);
        JClassLoader earClassLoader = new JClassLoader(unpackedURL.toExternalForm(), new URL[0], (ClassLoader)filteringClassLoader);
        String[] roleNames = new String[securityRoles.length];
        String affRoleNames = "";
        for (int i = 0; i < securityRoles.length; ++i) {
            roleNames[i] = securityRoles[i];
            affRoleNames = affRoleNames + roleNames[i] + ";";
        }
        this.logger.debug((Object)"role names = ''{0}''", new Object[]{affRoleNames});
        LinkedList<URL> urlsEJB = new LinkedList<URL>();
        LinkedList<URL> urlsAltDDEJB = new LinkedList<URL>();
        for (EJBDeployable ejb : unpackedDeployable.getEJBDeployables()) {
            try {
                URL ejbURL = ejb.getArchive().getURL();
                urlsEJB.add(ejbURL);
                urlsAltDDEJB.add(unpackedDeployable.getAltDDURL((IDeployable)ejb));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the archive '" + ejb.getArchive() + "'", (Throwable)e);
            }
        }
        LinkedList<URL> urlsWAR = new LinkedList<URL>();
        LinkedList<URL> urlslAtDDWAR = new LinkedList<URL>();
        for (WARDeployable war : unpackedDeployable.getWARDeployables()) {
            try {
                URL warURL = war.getArchive().getURL();
                urlsWAR.add(warURL);
                urlslAtDDWAR.add(unpackedDeployable.getAltDDURL((IDeployable)war));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the archive '" + war.getArchive() + "'", (Throwable)e);
            }
        }
        if (urlsWAR.size() > 0 && this.deployerLog != null && this.getServerProperties().isDevelopment()) {
            try {
                File unpackedWarFile = new File(new File(new File(this.webappsWorkDirectory, this.getServerProperties().getServerName()), INEAR_WORK_WEBAPPS_DIR_SUFFIX), unpackedFile.getName());
                this.deployerLog.addEntry(originalFile, unpackedWarFile);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Error when adding the log entry for unpacked wars directory.", new Object[0]);
            }
        }
        LinkedList<URL> urlsRAR = new LinkedList<URL>();
        LinkedList<URL> urlsAtDDRAR = new LinkedList<URL>();
        for (RARDeployable rar : unpackedDeployable.getRARDeployables()) {
            try {
                URL rarURL = rar.getArchive().getURL();
                urlsRAR.add(rarURL);
                urlsAtDDRAR.add(unpackedDeployable.getAltDDURL((IDeployable)rar));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the archive '" + rar.getArchive() + "'", (Throwable)e);
            }
        }
        LinkedList<URL> urlsClient = new LinkedList<URL>();
        LinkedList<URL> urlsAtDDClient = new LinkedList<URL>();
        for (CARDeployable car : unpackedDeployable.getCARDeployables()) {
            try {
                URL carURL = car.getArchive().getURL();
                urlsClient.add(carURL);
                urlsAtDDClient.add(unpackedDeployable.getAltDDURL((IDeployable)car));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the archive '" + car.getArchive() + "'", (Throwable)e);
            }
        }
        EjbManagerWrapper.setAvailableEjbJarsAndAltDDs((URLClassLoader)earClassLoader, (URL[])urlsEJB.toArray(new URL[urlsEJB.size()]), (URL[])urlsAltDDEJB.toArray(new URL[urlsAltDDEJB.size()]));
        WebManagerWrapper.setAltDD((URLClassLoader)earClassLoader, (URL[])urlsWAR.toArray(new URL[urlsWAR.size()]), (URL[])urlslAtDDWAR.toArray(new URL[urlslAtDDWAR.size()]));
        ClientManagerWrapper.setAltDD((URLClassLoader)earClassLoader, (URL[])urlsClient.toArray(new URL[urlsClient.size()]), (URL[])urlsAtDDClient.toArray(new URL[urlsAtDDClient.size()]));
        this.deployRARs(unpackedDeployable, unpackedURL, (ClassLoader)earClassLoader);
        List ejb3s = unpackedDeployable.getEJB3Deployables();
        List ejbs = unpackedDeployable.getEJBDeployables();
        List libs = unpackedDeployable.getLibDeployables();
        LinkedList<URL> urls = new LinkedList<URL>();
        for (EJBDeployable ejb : ejbs) {
            try {
                urls.add(ejb.getArchive().getURL());
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + ejb.getArchive() + "'.", (Throwable)e);
            }
        }
        for (LibDeployable lib : libs) {
            try {
                urls.add(lib.getArchive().getURL());
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + lib.getArchive() + "'.", (Throwable)e);
            }
        }
        URL[] arrayURLs = urls.toArray(new URL[urls.size()]);
        ClassLoader ejbClassLoader = null;
        FilteringClassLoader filteringClassLoaderEAR = new FilteringClassLoader((ClassLoader)earClassLoader);
        filteringClassLoaderEAR.setTransparent(true);
        filteringClassLoaderEAR.start();
        ejbClassLoader = this.ejb3Service != null ? this.ejb3Service.buildByteCodeEnhancementClassLoader(arrayURLs, (ClassLoader)filteringClassLoaderEAR) : new URLClassLoader(arrayURLs, (ClassLoader)filteringClassLoaderEAR);
        URL[] compilationURLs = null;
        URL[] myApplicationJars = earClassLoader.getURLs();
        URL[] appsJars = ((URLClassLoader)earClassLoader.getParent()).getURLs();
        compilationURLs = new URL[myApplicationJars.length + appsJars.length + urls.size()];
        System.arraycopy(urls.toArray(new URL[urls.size()]), 0, compilationURLs, 0, urls.size());
        System.arraycopy(appsJars, 0, compilationURLs, urls.size(), appsJars.length);
        System.arraycopy(myApplicationJars, 0, compilationURLs, urls.size() + appsJars.length, myApplicationJars.length);
        if (this.ejb21Service != null) {
            for (EJB21Deployable ejb : unpackedDeployable.getEJB21Deployables()) {
                URL ejbURL = null;
                try {
                    ejbURL = ejb.getArchive().getURL();
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL on the deployable '" + ejb + "'", (Throwable)e);
                }
                if (this.ejb21Service == null) {
                    this.logger.warn((Object)"Unable to call checkGenIC on the EJB ''{0}'' because the EJB 2.1 service is not available", new Object[]{ejbURL});
                    return;
                }
                this.logger.debug((Object)"Calling GenIC on the EJB ''{0}'' with compilation URL ''{1}''.", new Object[]{ejbURL, Arrays.asList(compilationURLs)});
                this.ejb21Service.checkGenIC(URLUtils.urlToFile((URL)ejbURL).getPath(), compilationURLs);
            }
        }
        if (this.contextFactory == null) {
            throw new DeployerException("Cannot deploy archive for '" + deployable.getArchive() + "'. Component context factory missing.");
        }
        Context appContext = null;
        try {
            appContext = this.contextFactory.createComponentContext("application:".concat(unpackedURL.toExternalForm()));
            appContext.rebind("AppName", (Object)unpackedDeployable.getModuleName());
        }
        catch (NamingException e) {
            this.logger.warn((Object)"Failed to initiate java:app context for EAR ''{0}''", new Object[]{deployable, e});
        }
        EZBInjectionHolder ejbInjectionHolder = null;
        if (this.getEmbedded() == null) {
            if (!ejb3s.isEmpty()) {
                this.logger.warn((Object)"There are EJB 3 files in the EAR ''{0}'' but the EJB 3 service is not available", new Object[]{deployable});
            }
        } else {
            List<IArchive> libArchives = this.getLibArchives(unpackedDeployable);
            EZBPersistenceUnitManager persistenceUnitManager = null;
            try {
                persistenceUnitManager = this.ejb3Service.getPersistenceUnitManager(unpackedDeployable, ejbClassLoader);
            }
            catch (PersistenceXmlFileAnalyzerException e) {
                throw new DeployerException("Unable to get Persistence unit Manager on '" + unpackedDeployable.getArchive() + "'.", (Throwable)e);
            }
            if (this.isMultitenantEnabled() && this.multitenantService.isMultitenant((IDeployable)unpackedDeployable)) {
                if (persistenceUnitManager != null) {
                    this.multitenantService.updatePersistenceUnitManager(persistenceUnitManager, tenantId);
                } else {
                    this.logger.debug((Object)"Persistence unit manager is null !", new Object[0]);
                }
            }
            this.addEjbContextIdToList(unpackedDeployable, new LinkedList<String>(), true);
            String prefix = null;
            if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
                prefix = this.versioningService.getPrefix((IDeployable)unpackedDeployable);
            }
            if (this.isMultitenantEnabled() && this.multitenantService.isMultitenant((IDeployable)unpackedDeployable)) {
                if (prefix == null) {
                    prefix = tenantId + "/";
                } else {
                    prefix.concat(tenantId + "/");
                }
            }
            String javaEEApplicationName = unpackedDeployable.getModuleName();
            LinkedList<EZBContainer> containers = new LinkedList<EZBContainer>();
            for (EJB3Deployable ejb : ejb3s) {
                if (this.getEmbedded() == null) {
                    throw new DeployerException("No EJB3 service, but there are EJB3s in the given EAR archive '" + deployable + "'.");
                }
                EZBContainer container = this.getEmbedded().createContainer((IDeployable)ejb);
                if (prefix != null) {
                    List namingStrategies = container.getConfiguration().getNamingStrategies();
                    ArrayList<EZBNamingStrategy> newNamingStrategies = new ArrayList<EZBNamingStrategy>();
                    for (EZBNamingStrategy oldNamingStrategy : namingStrategies) {
                        newNamingStrategies.add(this.ejb3Service.getNamingStrategy(prefix, oldNamingStrategy));
                    }
                    container.getConfiguration().setNamingStrategies(newNamingStrategies);
                }
                container.getConfiguration().setApplicationName(javaEEApplicationName);
                container.getConfiguration().setAppContext(appContext);
                container.setExtraArchives(libArchives);
                containers.add(container);
            }
            EZBApplicationJNDIResolver applicationJNDIResolver = this.ejb3Service.buildApplicationJNDIResolver();
            for (EZBContainer container : containers) {
                ClassLoader ejb3ClassLoader = ejbClassLoader;
                if (this.useEJB3ChildClassloader) {
                    ejb3ClassLoader = this.ejb3Service.buildByteCodeEnhancementClassLoader(new URL[0], ejbClassLoader);
                }
                container.setClassLoader(ejb3ClassLoader);
                container.setPersistenceUnitManager(persistenceUnitManager);
                EZBContainerJNDIResolver containerJNDIResolver = container.getConfiguration().getContainerJNDIResolver();
                containerJNDIResolver.setApplicationJNDIResolver(applicationJNDIResolver);
                applicationJNDIResolver.addContainerJNDIResolver(containerJNDIResolver);
                try {
                    container.resolve();
                }
                catch (EZBContainerException e) {
                    throw new DeployerException("Cannot resolve the container '" + container.getArchive() + "'.", (Throwable)e);
                }
            }
            ejbInjectionHolder = this.ejb3Service.buildInjectionHolder(persistenceUnitManager, (EZBJNDIResolver)applicationJNDIResolver);
            for (EZBContainer container : containers) {
                Object oldTenantContext = null;
                if (this.isMultitenantEnabled()) {
                    oldTenantContext = this.multitenantService.getTenantContext();
                }
                try {
                    if (this.isMultitenantEnabled()) {
                        this.multitenantService.setTenantIdInContext(tenantId);
                    }
                    container.start();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Cannot start container {0}", new Object[]{container.getName(), e});
                    try {
                        container.stop();
                        this.getEmbedded().removeContainer(container);
                    }
                    catch (Exception se) {
                        this.logger.error((Object)"Cannot stop failing container {0}", new Object[]{container.getName(), se});
                    }
                    throw new DeployerException("Container '" + container.getName() + "' has failed", (Throwable)e);
                }
                finally {
                    if (this.isMultitenantEnabled()) {
                        this.multitenantService.setTenantContext(oldTenantContext);
                    }
                }
                if (!this.isMultitenantEnabled() || !this.multitenantService.isMultitenant((IDeployable)unpackedDeployable)) continue;
                if (container.getPersistenceUnitManager() != null) {
                    this.multitenantService.updatePersistenceUnitManager(container.getPersistenceUnitManager(), tenantId);
                    continue;
                }
                this.logger.debug((Object)"Persistence unit manager is null !", new Object[0]);
            }
            if (this.isMultitenantEnabled() && this.multitenantService.isMultitenant((IDeployable)unpackedDeployable) && tenantId != null && containers.size() > 0) {
                Object oldTenantContext = this.multitenantService.getTenantContext();
                try {
                    this.multitenantService.setTenantIdInContext(tenantId);
                    this.multitenantService.createJNDIBindingMBeans((IDeployable)unpackedDeployable, prefix);
                }
                finally {
                    this.multitenantService.setTenantContext(oldTenantContext);
                }
            }
            if (this.versioningService != null && this.versioningService.isVersioningEnabled() && prefix != null && containers.size() > 0) {
                this.versioningService.createJNDIBindingMBeans((IDeployable)unpackedDeployable);
            }
        }
        this.deployWebServices(unpackedDeployable, unpackedURL, (ClassLoader)earClassLoader, ejbClassLoader, urlsEJB, urlsWAR);
        this.deployEJB21s(unpackedDeployable, unpackedURL, (URLClassLoader)earClassLoader, ejbClassLoader, roleNames);
        this.linkPolicyObjects(unpackedDeployable, earDD);
        this.commitEJBPolicyObjects(unpackedDeployable);
        this.deployWARs(unpackedDeployable, unpackedURL, (ClassLoader)earClassLoader, ejbClassLoader, ejbInjectionHolder, appContext);
        this.commitWebBPolicyObjects(unpackedDeployable);
        this.completeWebServicesDeployment(unpackedURL, unpackedDeployable, (ClassLoader)earClassLoader);
        String xmlDD = null;
        if (earDD != null) {
            xmlDD = earDD.getXmlContent();
        }
        EARModule earModule = new EARModule(unpackedDeployable, xmlDD);
        earModule.setClassLoader((ClassLoader)earClassLoader);
        earModule.setFilteringClassLoader(filteringClassLoader);
        Object oldTenantContext = null;
        if (this.isMultitenantEnabled()) {
            oldTenantContext = this.multitenantService.getTenantContext();
        }
        try {
            if (this.isMultitenantEnabled()) {
                this.multitenantService.setTenantIdInContext(tenantId);
            }
            this.jmxService.registerMBean((Object)earModule);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot register the MBean for the EAR Module of EARDeployable '" + deployable + "'.", (Throwable)e);
        }
        finally {
            if (this.isMultitenantEnabled()) {
                this.multitenantService.setTenantContext(oldTenantContext);
            }
        }
        if (this.ejb21Service != null) {
            this.ejb21Service.removeCache((ClassLoader)earClassLoader);
        }
        if (this.webContainerService != null) {
            this.webContainerService.removeCache((ClassLoader)earClassLoader);
        }
        if (this.jaxrpcService != null) {
            this.jaxrpcService.removeCache((ClassLoader)earClassLoader);
        }
        this.ears.put(originalURL, unpackedDeployable);
        this.logger.info((Object)"''{0}'' EAR Deployable has been deployed ({1} ms)", new Object[]{deployable.getShortName(), System.currentTimeMillis() - startTime});
    }

    private FilteringClassLoader createFilteringClassLoader(IArchive earArchive) {
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(this.appsClassLoader);
        try {
            String name = "META-INF/classloader-filtering.xml";
            URL filteringDefinitionUrl = earArchive.getResource(name);
            if (filteringDefinitionUrl != null) {
                filteringClassLoader.setDefinitionUrl(filteringDefinitionUrl);
            }
        }
        catch (ArchiveException ae) {
            this.logger.debug((Object)"Cannot get classloader-filtering.xml file from the EAR archive {0}.", new Object[]{earArchive, ae});
        }
        filteringClassLoader.start();
        return filteringClassLoader;
    }

    public void doUndeploy(IDeployable<EARDeployable> deployable) throws DeployerException {
        List ejb21Deployables;
        URL earURL;
        this.logger.info((Object)"Undeploying {0}", new Object[]{deployable.getShortName()});
        try {
            earURL = deployable.getArchive().getURL();
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get the URL on the EAR deployable '" + deployable + "'.", (Throwable)e);
        }
        EARDeployable unpackedDeployable = null;
        if (!this.ears.containsKey(earURL)) {
            throw new DeployerException("Cannot get the URL of the unpacked EAR deployable '" + deployable + "'.");
        }
        unpackedDeployable = this.ears.get(earURL);
        List warDeployables = unpackedDeployable.getWARDeployables();
        if (warDeployables != null && this.webContainerService != null) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (WARDeployable warDeployable : warDeployables) {
                try {
                    urls.add(warDeployable.getArchive().getURL());
                }
                catch (Exception e) {
                    this.logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{warDeployable, e});
                }
            }
            URL[] warURLs = urls.toArray(new URL[urls.size()]);
            this.webContainerService.unDeployWars(warURLs);
        }
        if ((ejb21Deployables = unpackedDeployable.getEJB21Deployables()) != null && this.ejb21Service != null) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (EJB21Deployable ejbDeployable : ejb21Deployables) {
                try {
                    urls.add(ejbDeployable.getArchive().getURL());
                }
                catch (Exception e) {
                    this.logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{ejbDeployable, e});
                }
            }
            URL[] ejbJarURLs = urls.toArray(new URL[urls.size()]);
            this.ejb21Service.unDeployJars(ejbJarURLs);
        }
        this.undeployEJB3FromEAR(unpackedDeployable);
        List rarDeployables = unpackedDeployable.getRARDeployables();
        if (rarDeployables != null && this.resourceService != null) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (RARDeployable rarDeployable : rarDeployables) {
                try {
                    urls.add(rarDeployable.getArchive().getURL());
                }
                catch (Exception e) {
                    this.logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{rarDeployable, e});
                }
            }
            URL[] rarURLs = urls.toArray(new URL[urls.size()]);
            this.resourceService.unDeployRars(rarURLs, earURL);
        }
        EARModule earModule = new EARModule(unpackedDeployable, "");
        try {
            this.jmxService.unregisterMBean((Object)earModule);
            if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
                this.versioningService.garbageCollectJNDIBindingMBeans();
            }
            if (this.isMultitenantEnabled() && this.multitenantService.isMultitenant((IDeployable)unpackedDeployable)) {
                this.multitenantService.garbageCollectJNDIBindingMBeans();
            }
        }
        catch (Exception e) {
            throw new DeployerException("Cannot unregister the MBean for the EAR Module of EARDeployable '" + deployable + "'.", (Throwable)e);
        }
        this.ears.remove(earURL);
        this.logger.info((Object)"''{0}'' EAR Deployable is now undeployed", new Object[]{deployable.getShortName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployEJB3FromEAR(EARDeployable earDeployable) throws DeployerException {
        EARDeployable workingDeployable = earDeployable;
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            workingDeployable = unpackedDeployable;
        }
        LinkedList<EZBContainer> containers = new LinkedList<EZBContainer>();
        for (EJB3Deployable ejb3 : workingDeployable.getEJB3Deployables()) {
            if (this.getEmbedded() == null) {
                this.logger.warn((Object)("No EJB3 service, but there are EJB3s in the given EAR archive '" + earDeployable.getOriginalDeployable() + "'."), new Object[0]);
                return;
            }
            EZBContainer container = this.getEmbedded().findContainer(ejb3.getArchive());
            if (container == null) {
                this.logger.warn((Object)"No container found for the archive ''{0}'', creation has maybe failed", new Object[]{ejb3.getArchive()});
                continue;
            }
            containers.add(container);
        }
        for (EZBContainer container : containers) {
            Object oldContext = null;
            if (this.isMultitenantEnabled()) {
                oldContext = this.multitenantService.getTenantContext();
            }
            try {
                if (this.isMultitenantEnabled()) {
                    this.multitenantService.setTenantIdInContext(this.multitenantService.getTenantIdDeployableInfo((IDeployable)workingDeployable));
                }
                container.stop();
            }
            finally {
                if (this.isMultitenantEnabled()) {
                    this.multitenantService.setTenantContext(oldContext);
                }
            }
            this.getEmbedded().removeContainer(container);
        }
    }

    public boolean supports(IDeployable<?> deployable) {
        return EARDeployable.class.isAssignableFrom(deployable.getClass());
    }

    protected void deployWARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader, ClassLoader parentClassLoader, EZBInjectionHolder ejbInjectionHolder, Context appContext) throws DeployerException {
        List wars = earDeployable.getWARDeployables();
        if (wars.size() > 0) {
            if (this.webContainerService == null) {
                this.logger.warn((Object)"There are WAR files in the EAR ''{0}'' but the 'web' service is not available", new Object[]{earDeployable});
                return;
            }
            ComponentContext ctx = new ComponentContext(earURL.toExternalForm());
            try {
                ctx.rebind("earDeployable", (Object)earDeployable);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR deployable parameter '" + earDeployable + "'", (Throwable)e);
            }
            try {
                ctx.rebind("earURL", (Object)earURL);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
            }
            try {
                ctx.rebind("earApplicationContext", (Object)appContext);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR Application Context parameter '" + earURL + "'", (Throwable)e);
            }
            LinkedList<URL> urls = new LinkedList<URL>();
            LinkedList<String> ctxRoots = new LinkedList<String>();
            for (WARDeployable warDeployable : wars) {
                try {
                    urls.add(warDeployable.getArchive().getURL());
                }
                catch (Exception e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + warDeployable.getArchive() + "'", (Throwable)e);
                }
                ctxRoots.add(warDeployable.getContextRoot());
                if (!this.isMultitenantEnabled()) continue;
                this.multitenantService.addTenantIdDeployableInfo((IDeployable)warDeployable, this.multitenantService.getTenantIdDeployableInfo((IDeployable)earDeployable));
            }
            try {
                ctx.rebind("warDeployables", (Object)wars);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the WAR deployables '" + wars + "'", (Throwable)e);
            }
            try {
                ctx.rebind("urls", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
            }
            try {
                ctx.rebind("parentClassLoader", (Object)parentClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the parentClassLoader parameter '" + parentClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("altDDs", (Object)new URL[urls.size()]);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the altDDs parameter.'", (Throwable)e);
            }
            try {
                ctx.rebind("contextRoots", (Object)ctxRoots.toArray(new String[ctxRoots.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the contextRoots parameter '" + urls + "'", (Throwable)e);
            }
            try {
                if (ejbInjectionHolder != null) {
                    ctx.rebind(EZBInjectionHolder.class.getName(), (Object)ejbInjectionHolder);
                }
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the ejb injection holder parameter '" + ejbInjectionHolder + "'", (Throwable)e);
            }
            try {
                this.webContainerService.deployWars((Context)ctx);
            }
            catch (JWebContainerServiceException e) {
                throw new DeployerException("Cannot deploy the WARs.'", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployEJB21s(EARDeployable earDeployable, URL earURL, URLClassLoader earClassLoader, ClassLoader ejbClassLoader, String[] roleNames) throws DeployerException {
        List ejbs = earDeployable.getEJB21Deployables();
        if (ejbs.size() > 0) {
            if (this.ejb21Service == null) {
                this.logger.warn((Object)"There are EJB 2.1 files in the EAR ''{0}'' but the EJB 2.1 service is not available", new Object[]{earDeployable});
                return;
            }
            LinkedList<URL> urls = new LinkedList<URL>();
            for (EJB21Deployable ejb21Deployable : ejbs) {
                try {
                    urls.add(ejb21Deployable.getArchive().getURL());
                    URL wsdlDirectory = ejb21Deployable.getArchive().getResource(WSDL_DIRECTORY);
                    if (wsdlDirectory == null) continue;
                    AccessibleObject addURLMethod = null;
                    for (Class<?> classToSearch = ejbClassLoader.getClass(); addURLMethod == null && classToSearch != null; classToSearch = classToSearch.getSuperclass()) {
                        try {
                            addURLMethod = classToSearch.getDeclaredMethod("addURL", URL.class);
                            continue;
                        }
                        catch (NoSuchMethodException e) {
                            this.logger.debug((Object)"Method addURL not found on class ''{0}''.", new Object[]{classToSearch.getName()});
                        }
                    }
                    if (addURLMethod == null) {
                        this.logger.warn((Object)"Unable to find addURL method on the classloaders", new Object[0]);
                        continue;
                    }
                    boolean accessible = addURLMethod.isAccessible();
                    try {
                        ((Method)addURLMethod).setAccessible(true);
                        ((Method)addURLMethod).invoke(ejbClassLoader, wsdlDirectory);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Cannot add URL for META-INF/wsdl directory to the Classloader", new Object[]{e});
                    }
                    finally {
                        ((Method)addURLMethod).setAccessible(accessible);
                    }
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + ejb21Deployable.getArchive() + "'", (Throwable)e);
                }
            }
            ComponentContext ctx = new ComponentContext(earURL.toExternalForm());
            try {
                URL earRootUrl = earURL;
                for (EARDeployable originalEarDeployable = earDeployable; originalEarDeployable != null; originalEarDeployable = (EARDeployable)originalEarDeployable.getOriginalDeployable()) {
                    earRootUrl = originalEarDeployable.getArchive().getURL();
                }
                ctx.rebind("earUrl", (Object)earURL);
                ctx.rebind("earRootUrl", (Object)earRootUrl);
                ctx.rebind("j2eeApplicationName", (Object)earDeployable.getModuleName());
            }
            catch (Exception e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
            }
            try {
                ctx.rebind("jarURLs", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the ejbClassLoader parameter '" + ejbClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("roleNames", (Object)roleNames);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the roleNames parameter.", (Throwable)e);
            }
            try {
                this.ejb21Service.deployJars((Context)ctx);
            }
            catch (ServiceException e) {
                throw new DeployerException("Cannot deploy the EJB 2.1.", (Throwable)e);
            }
        }
    }

    protected void deployRARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader) throws DeployerException {
        List rars = earDeployable.getRARDeployables();
        if (rars.size() > 0) {
            if (this.resourceService == null) {
                this.logger.warn((Object)"There are RAR files in the EAR ''{0}'' but the resource service is not available", new Object[]{earDeployable});
                return;
            }
            ComponentContext ctx = new ComponentContext(earURL.toExternalForm());
            try {
                ctx.rebind("earUrl", (Object)earURL);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
            }
            LinkedList<URL> urls = new LinkedList<URL>();
            for (RARDeployable rarDeployable : rars) {
                try {
                    urls.add(rarDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + rarDeployable.getArchive() + "'", (Throwable)e);
                }
            }
            try {
                ctx.rebind("urls", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("altDDs", (Object)new URL[urls.size()]);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the altDDs parameter.'", (Throwable)e);
            }
            try {
                this.resourceService.deployRars((Context)ctx);
            }
            catch (ResourceServiceException e) {
                throw new DeployerException("Cannot deploy the RARs.'", (Throwable)e);
            }
        }
    }

    protected void deployWebServices(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader, ClassLoader ejbClassLoader, List<URL> urlsEJB, List<URL> urlsWAR) throws DeployerException {
        if (this.jaxrpcService == null) {
            return;
        }
        ComponentContext ctx = new ComponentContext(earURL.toExternalForm());
        try {
            File earFile = URLUtils.urlToFile((URL)earURL);
            ctx.rebind("unpackDir", (Object)earFile);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'unpackDir' parameter '", (Throwable)e);
        }
        try {
            ctx.rebind("jarUrls", (Object)urlsEJB.toArray(new URL[urlsEJB.size()]));
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'jarUrls' parameter '", (Throwable)e);
        }
        URL[] warURLs = urlsWAR.toArray(new URL[urlsWAR.size()]);
        try {
            ctx.rebind("warUrls", (Object)warURLs);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'warUrls' parameter '", (Throwable)e);
        }
        try {
            Hashtable<URL, String> ctxRoots = new Hashtable<URL, String>();
            List wars = earDeployable.getWARDeployables();
            for (WARDeployable deployable : wars) {
                ctxRoots.put(deployable.getArchive().getURL(), deployable.getContextRoot());
            }
            ctx.rebind("warCtxRootMapping", ctxRoots);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot add the 'warCtxRootMapping' parameter '", (Throwable)e);
        }
        try {
            ctx.rebind("earURL", (Object)earURL);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'earURL' parameter '" + earURL + "'", (Throwable)e);
        }
        try {
            ctx.rebind("earDeployable", (Object)earDeployable);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'earDeployable' parameter '" + earDeployable + "'", (Throwable)e);
        }
        try {
            ctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the ejbClassLoader parameter '" + ejbClassLoader + "'", (Throwable)e);
        }
        try {
            ctx.rebind("earClassLoader", (Object)earClassLoader);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
        }
        try {
            this.jaxrpcService.deployWebServices((Context)ctx);
        }
        catch (JWebContainerServiceException e) {
            throw new DeployerException("Cannot deploy the Web Services.", (Throwable)e);
        }
    }

    protected void completeWebServicesDeployment(URL earURL, EARDeployable earDeployable, ClassLoader earClassLoader) throws DeployerException {
        if (this.jaxrpcService != null) {
            try {
                ComponentContext contctx = null;
                try {
                    contctx = new ComponentContext(earURL.toExternalForm());
                    contctx.rebind("classloader", (Object)earClassLoader);
                    String javaEEApplicationName = earDeployable.getModuleName();
                    ObjectName name = J2eeObjectName.J2EEApplication((String)this.getServerProperties().getDomainName(), (String)this.getServerProperties().getServerName(), (String)javaEEApplicationName);
                    contctx.rebind("parentObjectName", (Object)name);
                    contctx.rebind("isInEar", (Object)Boolean.TRUE);
                }
                catch (NamingException e) {
                    String err = "Can not bind params for the WebServices service, can't complete deployment of Web Services Endpoints";
                    throw new JWebContainerServiceException(err, (Throwable)e);
                }
                this.jaxrpcService.completeWSDeployment((Context)contctx);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot complete Web Services deployment.", (Throwable)e);
            }
        }
    }

    private void linkPolicyObjects(EARDeployable earDeployable, EarDeploymentDesc earDD) throws DeployerException {
        Map userToRoleMapping;
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addEjbContextIdToList(earDeployable, ctxIDs, false);
        this.addWebBContextIdToList(earDeployable, ctxIDs, true);
        try {
            for (String toBeLinkedCtxId : ctxIDs) {
                PolicyConfiguration toBeLinkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(toBeLinkedCtxId, false);
                for (String linkedCtxId : ctxIDs) {
                    if (toBeLinkedCtxId.equals(linkedCtxId)) continue;
                    PolicyConfiguration linkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(linkedCtxId, false);
                    toBeLinkedPC.linkConfiguration(linkedPC);
                }
            }
        }
        catch (PolicyContextException pce) {
            throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
        }
        if (earDD != null && (userToRoleMapping = earDD.getUserToRoleMapping()) != null) {
            for (String contextId : ctxIDs) {
                for (String principalName : userToRoleMapping.keySet()) {
                    List roles = (List)userToRoleMapping.get(principalName);
                    String[] roleNames = roles.toArray(new String[roles.size()]);
                    JPolicyUserRoleMapping.addUserToRoleMapping((String)contextId, (String)principalName, (String[])roleNames);
                }
            }
        }
    }

    private void addEjbContextIdToList(EARDeployable earDeployable, List<String> contextIDs, boolean resetPolicyConfiguration) throws DeployerException {
        List ejbDeployables = earDeployable.getEJBDeployables();
        LinkedList<URL> urls = new LinkedList<URL>();
        if (ejbDeployables != null) {
            for (EJBDeployable ejbDeployable : ejbDeployables) {
                try {
                    urls.add(ejbDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get URL on the deployable '" + ejbDeployable + "'.", (Throwable)e);
                }
            }
        }
        URL[] jarUrls = urls.toArray(new URL[urls.size()]);
        for (int u = 0; u < jarUrls.length; ++u) {
            String ctxId = jarUrls[u].getPath();
            if (resetPolicyConfiguration) {
                try {
                    this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                }
                catch (PolicyContextException pce) {
                    throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
                }
            }
            contextIDs.add(ctxId);
        }
    }

    private void addWebBContextIdToList(EARDeployable earDeployable, List<String> contextIDs, boolean resetPolicyConfiguration) throws DeployerException {
        List warDeployables = earDeployable.getWARDeployables();
        if (warDeployables != null) {
            for (WARDeployable warDeployable : warDeployables) {
                String tenantId;
                String versionID;
                URL warURL = null;
                try {
                    warURL = warDeployable.getArchive().getURL();
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get URL on the deployable '" + warDeployable + "'.", (Throwable)e);
                }
                String contextRoot = warDeployable.getContextRoot();
                if (this.versioningService != null && this.versioningService.isVersioningEnabled() && (versionID = this.versioningService.getVersionID((IDeployable)earDeployable)) != null && !contextRoot.contains(versionID)) {
                    contextRoot = contextRoot + versionID;
                }
                if (this.isMultitenantEnabled() && this.multitenantService.isMultitenant((IDeployable)earDeployable) && (tenantId = this.multitenantService.getTenantIdDeployableInfo((IDeployable)earDeployable)) != null && !contextRoot.contains(tenantId)) {
                    contextRoot = tenantId + '/' + contextRoot;
                }
                String ctxId = warURL.getFile() + contextRoot;
                if (resetPolicyConfiguration) {
                    try {
                        this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                    }
                    catch (PolicyContextException pce) {
                        throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
                    }
                }
                contextIDs.add(ctxId);
            }
        }
    }

    private void commitEJBPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addEjbContextIdToList(earDeployable, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private void commitWebBPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addWebBContextIdToList(earDeployable, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private PolicyConfigurationFactory getPolicyConfigurationFactory() throws DeployerException {
        PolicyConfigurationFactory pcFactory = null;
        try {
            pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (Exception cnfe) {
            throw new DeployerException("Cannot retrieve current policy configuration factory", (Throwable)cnfe);
        }
        return pcFactory;
    }

    private void commitPolicyObjects(List<String> ctxIDs) throws DeployerException {
        String ctxId2 = null;
        try {
            for (String ctxId2 : ctxIDs) {
                PolicyConfiguration pc = this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId2, false);
                pc.commit();
            }
        }
        catch (PolicyContextException pce) {
            throw new DeployerException("Cannot commit policy configuration with Id '" + ctxId2 + "'", (Throwable)pce);
        }
        Policy.getPolicy().refresh();
    }

    public void setJAXRPCService(IJAXRPCService jaxrpcService) {
        this.jaxrpcService = jaxrpcService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setEjb21Service(EJBService ejb21Service) {
        this.ejb21Service = ejb21Service;
    }

    public void setJMXService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setWebContainerService(JWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    public void setAppsClassLoader(ClassLoader appsClassLoader) {
        this.appsClassLoader = appsClassLoader;
    }

    protected List<IArchive> getLibArchives(EARDeployable earDeployable) {
        LinkedList<IArchive> libArchives = new LinkedList<IArchive>();
        for (LibDeployable lib : earDeployable.getLibDeployables()) {
            libArchives.add(lib.getArchive());
        }
        return libArchives;
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void setEasyBeansService(IEasyBeansService service) {
        this.ejb3Service = service;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setMultitenantService(MultitenantService multitenantService) {
        this.multitenantService = multitenantService;
    }

    public void unsetMultitenantService() {
        this.multitenantService = null;
    }

    public MultitenantService getMultitenantService() {
        return this.multitenantService;
    }

    public boolean isMultitenantEnabled() {
        return this.multitenantService != null;
    }

    public void unsetServiceManager() {
        this.serviceManager = null;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void setDeployerLog(DeployerLog deployerLog) {
        this.deployerLog = deployerLog;
    }

    public Map<URL, EARDeployable> getEars() {
        return this.ears;
    }

    public void setAppsWorkDirectory(String appsWorkDirectory) {
        this.appsWorkDirectory = appsWorkDirectory;
    }

    public void setWebappsWorkDirectory(String webappsWorkDirectory) {
        this.webappsWorkDirectory = webappsWorkDirectory;
    }

    public void setContextFactory(JComponentContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }
}

