/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.lib.BasicClass;
import org.objectweb.jorm.metainfo.lib.BasicCompositeName;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicPackage
extends BasicMetaObject
implements Package {
    protected Map classes;
    protected Map compositeNames;
    protected String name;

    public BasicPackage(String name, Manager parent) {
        super(parent);
        this.name = name;
        this.classes = new HashMap();
        this.compositeNames = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public Class getClass(String className) {
        if (this.debug && this.classes.get(className) == null) {
            this.logger.log(BasicLevel.DEBUG, (Object)("There is no class with this name (" + className + ") for the current Package (" + this.name + ")"));
        }
        return (Class)this.classes.get(className);
    }

    public CompositeName getCompositeName(String cn_Name) {
        if (this.debug && this.compositeNames.get(cn_Name) == null) {
            this.logger.log(BasicLevel.DEBUG, (Object)("There is no composite name with this name (" + cn_Name + ") for the current Package (" + this.name + ")"));
        }
        return (CompositeName)this.compositeNames.get(cn_Name);
    }

    public CompositeName createCompositeName(String CN_Name) {
        CompositeName result;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new CompositeName (" + CN_Name + ") for the current Package (" + this.name + ")"));
        }
        if ((result = (CompositeName)this.compositeNames.get(CN_Name)) != null) {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("return the existing CompositeName" + CN_Name));
            }
        } else {
            result = new BasicCompositeName(CN_Name, this);
            this.setLoggingOnChild(result);
            this.compositeNames.put(CN_Name, result);
        }
        return result;
    }

    public Iterator iterateCompositeName() {
        return this.compositeNames.values().iterator();
    }

    public Class createClass(String className) {
        Class result;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new Class (" + className + ") for the current Package (" + this.name + ")"));
        }
        if ((result = (Class)this.classes.get(className)) != null) {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("return the existing Class " + className));
            }
        } else {
            result = new BasicClass(className, this);
            this.setLoggingOnChild(result);
            this.classes.put(className, result);
        }
        return result;
    }

    public void addClass(Class aClass) {
        String aClassName = aClass.getName();
        if (this.classes.get(aClassName) != null) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.INFO, (Object)("try to add an existing Class (" + aClassName + ")"));
            }
        } else {
            this.classes.put(aClassName, aClass);
        }
    }

    public void addCompositeName(CompositeName composite) {
        String compositeName = composite.getName();
        if (this.compositeNames.get(compositeName) != null) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.INFO, (Object)("try to add an existing CompositeName (" + compositeName + ")"));
            }
        } else {
            this.compositeNames.put(compositeName, composite);
        }
    }

    public Collection getClasses() {
        return this.classes.values();
    }

    public Collection getCompositeNames() {
        return this.compositeNames.values();
    }

    protected Collection getChildren() {
        ArrayList res = new ArrayList();
        res.addAll(this.classes.values());
        res.addAll(this.compositeNames.values());
        return res;
    }
}

