/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.lib;

import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.BasicQueryNode;

public class Intersection
extends BasicQueryNode {
    public Intersection() {
    }

    public Intersection(QueryTree leftQT, QueryTree rightQT, String name) throws MedorException {
        super(name);
        Field[] lfs = leftQT.getTupleStructure().getFields();
        Field[] rfs = rightQT.getTupleStructure().getFields();
        if (lfs.length != rfs.length) {
            throw new MedorException("The intersection must be with the same Tuple Collection");
        }
        this.indexes = new int[lfs.length];
        for (int i = 0; i < lfs.length; ++i) {
            if (!lfs[i].getName().equalsIgnoreCase(rfs[i].getName()) || !lfs[i].getType().isa(rfs[i].getType()) && !rfs[i].getType().isa(lfs[i].getType())) {
                throw new MedorException("The intersection must be with the same Tuple Collection");
            }
            this.addPropagatedField(lfs[i].getName(), lfs[i].getType(), new QueryTreeField[]{(QueryTreeField)lfs[i], (QueryTreeField)rfs[i]});
            this.indexes[i] = i + 1;
            Equal subFilter = new Equal(new BasicFieldOperand(lfs[i]), new BasicFieldOperand(rfs[i]));
            this.filter = this.filter == null ? subFilter : new And(this.filter, subFilter);
        }
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        return clone;
    }

    public void setQueryFilter(Expression f) {
        throw new UnsupportedOperationException("Intersections cannot be assigned a filter.");
    }

    public short getType() {
        return 2;
    }
}

