/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import java.io.Serializable;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import org.objectweb.joram.client.connector.JoramAdapter;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ActivationSpecImpl
implements ActivationSpec,
ResourceAdapterAssociation,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)ActivationSpecImpl.class.getName());
    public static final String AUTO_ACKNOWLEDGE = "Auto-acknowledge";
    public static final String DUPS_OK_ACKNOWLEDGE = "Dups-ok-acknowledge";
    private String destinationType;
    private String destination;
    private String userName = "anonymous";
    private String password = "anonymous";
    private String identityClass = SimpleIdentity.class.getName();
    private String messageSelector = null;
    private String subscriptionDurability = null;
    private String subscriptionName;
    private String acknowledgeMode = "Auto-acknowledge";
    private String maxNumberOfWorks = "10";
    private String maxMessages = "10";
    private Boolean deleteDurableSubscription = false;
    private transient JoramAdapter ra = null;
    private Boolean collocated = false;
    private String hostName = null;
    private int serverPort = -2;
    private int connectingTimer = 0;
    private int txPendingTimer = 0;
    private int cnxPendingTimer = 0;
    private int queueMessageReadMax = 2;
    private int topicAckBufferMax = 0;
    private int topicPassivationThreshold = Integer.MAX_VALUE;
    private int topicActivationThreshold = 0;
    private String name;

    public void setCollocated(String collocatedServer) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ActivationSpecImpl.setCollocated(" + collocatedServer + ')'));
        }
        this.collocated = new Boolean(collocatedServer);
    }

    public Boolean getCollocated() {
        return new Boolean(this.collocated);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ActivationSpecImpl.setHostName(" + hostName + ')'));
        }
        this.hostName = hostName;
    }

    public Integer getServerPort() {
        return new Integer(this.serverPort);
    }

    public void setServerPort(String serverPort) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ActivationSpecImpl.setServerPort(" + serverPort + ')'));
        }
        this.serverPort = new Integer(serverPort);
    }

    public Integer getConnectingTimer() {
        return new Integer(this.connectingTimer);
    }

    public void setConnectingTimer(String connectingTimer) {
        this.connectingTimer = new Integer(connectingTimer);
    }

    public Integer getTxPendingTimer() {
        return new Integer(this.txPendingTimer);
    }

    public void setTxPendingTimer(String txPendingTimer) {
        this.txPendingTimer = new Integer(txPendingTimer);
    }

    public Integer getCnxPendingTimer() {
        return new Integer(this.cnxPendingTimer);
    }

    public void setCnxPendingTimer(String cnxPendingTimer) {
        this.cnxPendingTimer = new Integer(cnxPendingTimer);
    }

    public Integer getQueueMessageReadMax() {
        return new Integer(this.queueMessageReadMax);
    }

    public void setQueueMessageReadMax(String queueMessageReadMax) {
        this.queueMessageReadMax = new Integer(queueMessageReadMax);
    }

    public Integer getTopicAckBufferMax() {
        return new Integer(this.topicAckBufferMax);
    }

    public void setTopicAckBufferMax(String topicAckBufferMax) {
        this.topicAckBufferMax = new Integer(topicAckBufferMax);
    }

    public Integer getTopicPassivationThreshold() {
        return new Integer(this.topicPassivationThreshold);
    }

    public void setTopicPassivationThreshold(String topicPassivationThreshold) {
        this.topicPassivationThreshold = new Integer(topicPassivationThreshold);
    }

    public Integer getTopicActivationThreshold() {
        return new Integer(this.topicActivationThreshold);
    }

    public void setTopicActivationThreshold(String topicActivationThreshold) {
        this.topicActivationThreshold = new Integer(topicActivationThreshold);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActivationSpecImpl() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ActivationSpecImpl<>");
        }
    }

    public void validate() throws InvalidPropertyException {
        if (this.destinationType != null && !this.destinationType.equals("javax.jms.Queue") && !this.destinationType.equals("javax.jms.Topic")) {
            throw new InvalidPropertyException("Invalid destination type: " + this.destinationType);
        }
        if (this.destination == null) {
            throw new InvalidPropertyException("Missing destination property.");
        }
        if (this.acknowledgeMode != null && !this.acknowledgeMode.equals(AUTO_ACKNOWLEDGE) && !this.acknowledgeMode.equals(DUPS_OK_ACKNOWLEDGE)) {
            throw new InvalidPropertyException("Invalid acknowledge mode: " + this.acknowledgeMode);
        }
        if (this.subscriptionDurability != null) {
            if (this.subscriptionDurability.equals("Durable") && this.destinationType.equals("javax.jms.Queue")) {
                throw new InvalidPropertyException("Can't set a durable subscription on a JMS queue.");
            }
            if (this.subscriptionDurability.equals("Durable") && this.subscriptionName == null) {
                throw new InvalidPropertyException("Missing durable subscription name.");
            }
        }
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " setResourceAdapter(" + ra + ")"));
        }
        if (this.ra != null) {
            throw new IllegalStateException("Can not change resource adapter association.");
        }
        if (!(ra instanceof JoramAdapter)) {
            throw new ResourceException("Provided resource adapter is not a JORAM resource adapter: " + ra.getClass().getName());
        }
        this.ra = (JoramAdapter)ra;
        if (this.hostName == null && this.serverPort == -2) {
            this.hostName = this.ra.getHostName();
            this.serverPort = this.ra.getServerPort();
            this.identityClass = this.ra.getIdentityClass();
            this.collocated = this.ra.getCollocated();
        }
    }

    public ResourceAdapter getResourceAdapter() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getResourceAdapter = " + this.ra));
        }
        return this.ra;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIdentityClass(String identityClass) {
        this.identityClass = identityClass;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = subscriptionDurability;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setMaxNumberOfWorks(String maxNumberOfWorks) {
        this.maxNumberOfWorks = maxNumberOfWorks;
    }

    public void setMaxMessages(String maxMessages) {
        this.maxMessages = maxMessages;
    }

    public void setDeleteDurableSubscription(String deleteDurableSubscription) {
        this.deleteDurableSubscription = new Boolean(deleteDurableSubscription);
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIdentityClass() {
        return this.identityClass;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public String getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public String getMaxNumberOfWorks() {
        return this.maxNumberOfWorks;
    }

    public String getMaxMessages() {
        return this.maxMessages;
    }

    public Boolean getDeleteDurableSubscription() {
        return new Boolean(this.deleteDurableSubscription);
    }

    public void setActivationSpecConfig(Properties props) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ActivationSpecImpl.setActivationSpecConfig(" + props + ')'));
        }
        if (props == null) {
            return;
        }
        this.name = props.getProperty("name");
        this.hostName = props.getProperty("HostName", "localhost");
        this.serverPort = new Integer(props.getProperty("ServerPort", "16010"));
        this.userName = props.getProperty("UserName", "anonymous");
        this.password = props.getProperty("Password", "anonymous");
        this.identityClass = props.getProperty("IdentityClass", "org.objectweb.joram.shared.security.SimpleIdentity");
        this.collocated = (boolean)new Boolean(props.getProperty("Collocated", "false"));
        this.connectingTimer = new Integer(props.getProperty("ConnectingTimer", "0"));
        this.cnxPendingTimer = new Integer(props.getProperty("CnxPendingTimer", "0"));
        this.txPendingTimer = new Integer(props.getProperty("TxPendingTimer", "0"));
        this.topicPassivationThreshold = new Integer(props.getProperty("TopicPassivationThreshold", "2147483647"));
        this.topicActivationThreshold = new Integer(props.getProperty("TopicActivationThreshold", "0"));
        this.topicAckBufferMax = new Integer(props.getProperty("TopicAckBufferMax", "0"));
        this.subscriptionName = props.getProperty("SubscriptionName");
        this.subscriptionDurability = props.getProperty("SubscriptionDurability");
        this.queueMessageReadMax = new Integer(props.getProperty("QueueMessageReadMax", "2"));
        this.messageSelector = props.getProperty("MessageSelector");
        this.maxNumberOfWorks = props.getProperty("MaxNumberOfWorks", "0");
        this.maxMessages = props.getProperty("MaxMessages", "10");
        this.destinationType = props.getProperty("DestinationType");
        this.destination = props.getProperty("Destination");
        this.deleteDurableSubscription = (boolean)new Boolean(props.getProperty("DeleteDurableSubscription", "false"));
        this.acknowledgeMode = props.getProperty("AcknowledgeMode", AUTO_ACKNOWLEDGE);
    }

    public String toString() {
        return "ActivationSpecImpl@" + this.hashCode() + " [destinationType=" + this.destinationType + ", destination=" + this.destination + ", userName=" + this.userName + ", password=" + this.password + ", identityClass=" + this.identityClass + ", messageSelector=" + this.messageSelector + ", subscriptionDurability=" + this.subscriptionDurability + ", subscriptionName=" + this.subscriptionName + ", acknowledgeMode=" + this.acknowledgeMode + ", maxNumberOfWorks=" + this.maxNumberOfWorks + ", maxMessages=" + this.maxMessages + ", deleteDurableSubscription=" + this.deleteDurableSubscription + ", ra=" + this.ra + ", collocated=" + this.collocated + ", hostName=" + this.hostName + ", serverPort=" + this.serverPort + ", connectingTimer=" + this.connectingTimer + ", txPendingTimer=" + this.txPendingTimer + ", cnxPendingTimer=" + this.cnxPendingTimer + ", queueMessageReadMax=" + this.queueMessageReadMax + ", topicAckBufferMax=" + this.topicAckBufferMax + ", topicPassivationThreshold=" + this.topicPassivationThreshold + ", topicActivationThreshold=" + this.topicActivationThreshold + ", name=" + this.name + "]";
    }
}

