/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.objectweb.joram.client.connector.JoramAdapter;
import org.objectweb.joram.client.connector.JoramResourceAdapter;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedConnectionMetaDataImpl;
import org.objectweb.joram.client.connector.OutboundConnection;
import org.objectweb.joram.client.connector.OutboundQueueConnection;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.joram.client.connector.OutboundTopicConnection;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.XAConnection;
import org.objectweb.joram.client.jms.XAQueueConnection;
import org.objectweb.joram.client.jms.XAResourceMngr;
import org.objectweb.joram.client.jms.XASession;
import org.objectweb.joram.client.jms.XATopicConnection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ManagedConnectionImpl
implements ManagedConnection,
LocalTransaction,
ExceptionListener {
    public static Logger logger = Debug.getLogger((String)ManagedConnectionImpl.class.getName());
    private JoramResourceAdapter ra;
    ManagedConnectionFactoryImpl mcf;
    private javax.jms.XAConnection cnx = null;
    private Vector handles;
    private Vector listeners;
    private boolean startedLocalTx = false;
    private ManagedConnectionMetaDataImpl metaData = null;
    private PrintWriter out = null;
    private boolean valid = false;
    private int hashCode = -1;
    String hostName;
    int serverPort;
    String mode;
    String userName;
    Session session = null;
    Subject subject;
    ConnectionRequestInfo cxRequest;
    private Object lock = new Object();
    private long timeWaitReconnect = 240000L;

    ManagedConnectionImpl(JoramResourceAdapter ra, ManagedConnectionFactoryImpl mcf, javax.jms.XAConnection cnx, String hostName, int serverPort, String userName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ManagedConnectionImpl(" + ra + ", " + mcf + ", " + cnx + ", " + hostName + ", " + serverPort + ", " + userName + ")"));
        }
        this.ra = ra;
        this.mcf = mcf;
        this.cnx = cnx;
        this.hostName = hostName;
        this.serverPort = serverPort;
        this.userName = userName;
        this.mode = cnx instanceof javax.jms.XAQueueConnection ? "PTP" : (cnx instanceof javax.jms.XATopicConnection ? "PubSub" : "Unified");
        try {
            cnx.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException exc) {
            // empty catch block
        }
        this.handles = new Vector();
        this.listeners = new Vector();
        this.valid = true;
        this.hashCode = -1;
        ra.addProducer(this);
        if (ra instanceof JoramAdapter && ((JoramAdapter)ra).getConnectingTimer() > 0) {
            this.timeWaitReconnect = ((JoramAdapter)ra).getConnectingTimer() * 1000;
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getConnection(" + subject + ", " + cxRequestInfo + ")"));
        }
        if (!this.isValid()) {
            if (this.out != null) {
                this.out.print("Physical connection to the underlying JORAM server has been lost.");
            }
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        OutboundConnection handle = this.cnx instanceof javax.jms.XAQueueConnection ? new OutboundQueueConnection(this, (javax.jms.XAQueueConnection)this.cnx) : (this.cnx instanceof javax.jms.XATopicConnection ? new OutboundTopicConnection(this, (javax.jms.XATopicConnection)this.cnx) : new OutboundConnection(this, this.cnx));
        this.handles.add(handle);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getConnection handles = " + this.handles));
        }
        return handle;
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " associateConnection(" + connection + ")"));
        }
        if (!this.isValid()) {
            if (this.out != null) {
                this.out.print("Physical connection to the underlying JORAM server has been lost.");
            }
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        if (!(connection instanceof OutboundConnection)) {
            if (this.out != null) {
                this.out.print("The provided connection handle is not a JORAM handle.");
            }
            throw new ResourceException("The provided connection handle is not a JORAM handle.");
        }
        OutboundConnection newConn = (OutboundConnection)connection;
        newConn.managedCx = this;
        newConn.xac = this.cnx;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource()"));
        }
        if (!this.isValid()) {
            if (this.out != null) {
                this.out.print("Physical connection to the underlying JORAM server has been lost.");
            }
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource session = " + this.session));
            }
            if (this.session == null) {
                OutboundConnection outboundCnx = null;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource handles = " + this.handles));
                }
                Enumeration e = this.handles.elements();
                while (e.hasMoreElements()) {
                    outboundCnx = (OutboundConnection)e.nextElement();
                    if (!outboundCnx.cnxEquals(this.cnx)) continue;
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break;
                    logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource : outboundCnx found in handles table."));
                    break;
                }
                if (outboundCnx == null) {
                    outboundCnx = (OutboundConnection)this.getConnection(null, null);
                }
                if (outboundCnx != null) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  outboundCnx = " + outboundCnx + "\n  outboundCnx.sess = " + outboundCnx.sessions));
                    }
                    OutboundSession outboundSession = null;
                    if (outboundCnx.sessions.size() > 0) {
                        outboundSession = (OutboundSession)outboundCnx.sessions.get(0);
                        if (!(outboundSession.sess instanceof javax.jms.XASession)) {
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  outboundSession.sess = " + outboundSession.sess));
                            }
                            XAResourceMngr xaResourceMngr = null;
                            if (this.cnx instanceof XAConnection) {
                                xaResourceMngr = ((XAConnection)this.cnx).getXAResourceMngr();
                            } else if (this.cnx instanceof XAQueueConnection) {
                                xaResourceMngr = ((XAQueueConnection)this.cnx).getXAResourceMngr();
                            } else if (this.cnx instanceof XATopicConnection) {
                                xaResourceMngr = ((XATopicConnection)this.cnx).getXAResourceMngr();
                            }
                            if (xaResourceMngr == null) {
                                xaResourceMngr = new XAResourceMngr((Connection)outboundCnx.xac);
                            }
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  xaResourceMngr = " + xaResourceMngr));
                            }
                            org.objectweb.joram.client.jms.Session sess = (org.objectweb.joram.client.jms.Session)outboundSession.sess;
                            sess.setTransacted(true);
                            this.session = new XASession((Connection)outboundCnx.xac, sess, xaResourceMngr);
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  session = " + this.session + "\noutboundSession.sess = " + outboundSession.sess + ", sess.class = " + outboundSession.sess.getClass().getName() + ", getAcknowledgeMode = " + outboundSession.getAcknowledgeMode() + ", getTransacted = " + outboundSession.getTransacted() + ", isStarted = " + outboundSession.isStarted()));
                            }
                        } else if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource outboundSession.sess = " + outboundSession.sess + ", sess.class = " + outboundSession.sess.getClass().getName() + ", getAcknowledgeMode = " + outboundSession.getAcknowledgeMode() + ", getTransacted = " + outboundSession.getTransacted() + ", isStarted = " + outboundSession.isStarted()));
                        }
                    } else {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource createXASession"));
                        }
                        this.session = this.cnx.createXASession();
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource session = " + this.session + ", session.class = " + this.session.getClass().getName() + ", getAcknowledgeMode = " + this.session.getAcknowledgeMode() + ", getTransacted = " + this.session.getTransacted()));
                        }
                    }
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource xaresource = " + ((XASession)this.session).getXAResource() + ", transacted = " + ((XASession)this.session).getTransacted()));
                    }
                } else if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)(this + " getXAResource  outboundCnx = null."));
                }
            } else if (this.session instanceof XASession) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource session is XASession and not null"));
                }
                ((XASession)this.session).getDelegateSession().setTransacted(true);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource session = " + this.session + ", session.class = " + this.session.getClass().getName() + ", getAcknowledgeMode = " + this.session.getAcknowledgeMode() + ", getTransacted = " + this.session.getTransacted()));
                }
            } else if (!(this.session instanceof javax.jms.XASession)) {
                if (this.out != null) {
                    this.out.print("Managed connection not involved in a local transaction.");
                }
                throw new javax.resource.spi.IllegalStateException("Managed connection not involved in a local transaction.");
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  return = " + ((javax.jms.XASession)this.session).getXAResource()));
            }
            return ((javax.jms.XASession)this.session).getXAResource();
        }
        catch (JMSException exc) {
            if (this.out != null) {
                this.out.print("Could not get XA resource: " + (Object)((Object)exc));
            }
            throw new ResourceAdapterInternalException("Could not get XA resource: " + (Object)((Object)exc));
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getLocalTransaction()"));
        }
        if (!this.isValid()) {
            if (this.out != null) {
                this.out.print("Physical connection to the underlying JORAM server has been lost.");
            }
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " getLocalTransaction session = " + this.session));
            }
            if (this.session == null) {
                this.session = this.cnx.createSession(true, 0);
            } else if (this.session instanceof javax.jms.XASession) {
                if (this.out != null) {
                    this.out.print("Managed connection already involved in a distributed transaction.");
                }
                throw new javax.resource.spi.IllegalStateException("Managed connection already involved in a distributed transaction.");
            }
            return this;
        }
        catch (JMSException exc) {
            if (this.out != null) {
                this.out.print("Could not build underlying transacted JMS session: " + (Object)((Object)exc));
            }
            throw new LocalTransactionException("Could not build underlying transacted JMS session: " + (Object)((Object)exc));
        }
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.metaData == null) {
            this.metaData = new ManagedConnectionMetaDataImpl(this.userName);
        }
        return this.metaData;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public synchronized void cleanup() throws ResourceException {
        block4: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " cleanup()"));
            }
            for (OutboundConnection handle : this.handles) {
                handle.cleanup();
            }
            this.session = null;
            try {
                this.handles.clear();
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block4;
                logger.log(BasicLevel.WARN, (Object)e);
            }
        }
    }

    public synchronized void destroy() throws ResourceException {
        block3: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " destroy()"));
            }
            this.cleanup();
            try {
                this.cnx.close();
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)(this + " destroy()"), (Throwable)exc);
            }
        }
        this.ra.removeProducer(this);
        this.valid = false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = (this.mode + ":" + this.hostName + ":" + ":" + this.serverPort + "-" + this.userName).hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManagedConnectionImpl)) {
            return false;
        }
        ManagedConnectionImpl other = (ManagedConnectionImpl)o;
        boolean res = this.mode.equals(other.mode) && (this.hostName.equals(other.hostName) && this.serverPort == other.serverPort || this.mcf.isCollocated() != false && other.serverPort == -1) && this.userName.equals(other.userName) && this.cnx.equals(other.cnx);
        return res;
    }

    public synchronized void onException(JMSException exc) {
        block9: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " onException(" + (Object)((Object)exc) + ')'));
            }
            if (!this.isValid()) {
                return;
            }
            if (!(exc instanceof IllegalStateException)) {
                return;
            }
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
                listener.connectionErrorOccurred(event);
            }
            try {
                this.cleanup();
            }
            catch (ResourceException e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block9;
                logger.log(BasicLevel.DEBUG, (Object)(this + " onException.cleanup exception " + (Object)((Object)e)));
            }
        }
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " onException: call ra.reconnect()"));
            }
            this.ra.reconnect();
            this.reconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect() {
        block6: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " reconnect(), ra.isActive() = " + ((JoramAdapter)this.ra).isActive()));
            }
            try {
                this.valid = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block6;
                logger.log(BasicLevel.DEBUG, (Object)(this + " reconnect exception "), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReconnected() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(this.timeWaitReconnect);
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return false;
    }

    public synchronized void begin() throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " begin()"));
        }
        if (!this.isValid()) {
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        if (this.startedLocalTx) {
            throw new LocalTransactionException("Local transaction has already begun.");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.localTransactionStarted(event);
        }
        this.startedLocalTx = true;
    }

    public synchronized void commit() throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " commit()"));
        }
        if (!this.isValid()) {
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        if (!this.startedLocalTx) {
            throw new LocalTransactionException("Local transaction has not begun.");
        }
        try {
            this.session.commit();
        }
        catch (JMSException exc) {
            throw new LocalTransactionException("Commit of the transacted JMS session failed: " + (Object)((Object)exc));
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.localTransactionCommitted(event);
        }
        this.startedLocalTx = false;
    }

    public synchronized void rollback() throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " rollback()"));
        }
        if (!this.isValid()) {
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        if (!this.startedLocalTx) {
            throw new LocalTransactionException("Local transaction has not begun.");
        }
        try {
            this.session.rollback();
        }
        catch (JMSException exc) {
            throw new LocalTransactionException("Rollback of the transacted JMS session failed: " + (Object)((Object)exc));
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.localTransactionRolledback(event);
        }
        this.startedLocalTx = false;
    }

    boolean matches(String hostName, int serverPort, String userName, String mode) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("matches: " + hostName + " = " + this.hostName + ", " + serverPort + " = " + this.serverPort + ", " + userName + " = " + this.userName + ", " + mode + " = " + this.mode + ", isColocated = " + this.mcf.isCollocated()));
        }
        return (this.hostName.equals(hostName) && this.serverPort == serverPort || this.mcf.isCollocated() != false && serverPort == -1) && this.userName.equals(userName) && this.mode.equals(mode);
    }

    boolean isValid() {
        return this.valid;
    }

    void closeHandle(OutboundConnection handle) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " closeHandle(" + handle + ")"));
        }
        this.handles.remove(handle);
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)handle);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.connectionClosed(event);
        }
    }
}

