/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.OutboundConnectionFactory;
import org.objectweb.joram.client.connector.TopicConnectionRequest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class OutboundTopicConnectionFactory
extends OutboundConnectionFactory
implements TopicConnectionFactory {
    public static Logger logger = Debug.getLogger((String)OutboundTopicConnectionFactory.class.getName());
    private static final long serialVersionUID = 1L;

    OutboundTopicConnectionFactory(ManagedConnectionFactoryImpl mcf, ConnectionManager cxManager) {
        super(mcf, cxManager);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("OutboundTopicConnectionFactory(" + mcf + ", " + cxManager + ")"));
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createTopicConnection()"));
        }
        return this.createTopicConnection(this.mcf.getUserName(), this.mcf.getPassword());
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createTopicConnection(" + userName + ", " + password + ")"));
        }
        try {
            TopicConnectionRequest cxRequest = new TopicConnectionRequest(userName, password, this.mcf.getIdentityClass());
            Object o = this.cxManager.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cxRequest);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " createTopicConnection TopicConnection = " + o));
            }
            return (TopicConnection)o;
        }
        catch (SecurityException exc) {
            throw new JMSSecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (CommException exc) {
            throw new IllegalStateException("Could not connect to the JORAM server: " + (Object)((Object)exc));
        }
        catch (ResourceException exc) {
            throw new JMSException("Could not create connection: " + (Object)((Object)exc));
        }
    }
}

