/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ssh.server.internal;

import java.io.File;

public class HostKey {
    private final String user;
    private final File objKey;
    private final File rsaKey;
    private final File dsaKey;
    private final File peerKeys;

    public HostKey(String user, File objKey, File rsaKey, File dsaKey, File peerKeys) {
        this.user = user;
        this.objKey = objKey;
        this.rsaKey = rsaKey;
        this.dsaKey = dsaKey;
        this.peerKeys = peerKeys;
    }

    public String getUser() {
        return this.user;
    }

    public File getObjKey() {
        return this.objKey;
    }

    public File getRsaKey() {
        return this.rsaKey;
    }

    public File getDsaKey() {
        return this.dsaKey;
    }

    public File getPeerKeys() {
        return this.peerKeys;
    }

    public static HostKey findHostKey() {
        File rsaKey = null;
        File dsaKey = null;
        File peerKeys = null;
        String user = System.getProperty("user.name");
        String userHome = System.getProperty("user.home");
        File fUserHome = new File(userHome);
        File sshHome = new File(fUserHome, ".ssh");
        if (sshHome.exists()) {
            rsaKey = new File(sshHome, "id_rsa");
            dsaKey = new File(sshHome, "id_dsa");
            peerKeys = new File(sshHome, "authorized_keys");
        }
        return new HostKey(user, null, rsaKey, dsaKey, peerKeys);
    }
}

