/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.AnnotationProcessor;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JspServletWrapper {
    private Log log = LogFactory.getLog(JspServletWrapper.class);
    private Servlet theServlet;
    private String jspUri;
    private Class servletClass;
    private Class tagHandlerClass;
    private JspCompilationContext ctxt;
    private long available = 0L;
    private ServletConfig config;
    private Options options;
    private boolean firstTime = true;
    private volatile boolean reload = true;
    private boolean isTagFile;
    private int tripCount;
    private JasperException compileException;
    private volatile long servletClassLastModifiedTime;
    private long lastModificationTest = 0L;

    public JspServletWrapper(ServletConfig config, Options options, String jspUri, boolean isErrorPage, JspRuntimeContext rctxt) throws JasperException {
        this.isTagFile = false;
        this.config = config;
        this.options = options;
        this.jspUri = jspUri;
        this.ctxt = new JspCompilationContext(jspUri, isErrorPage, options, config.getServletContext(), this, rctxt);
    }

    public JspServletWrapper(ServletContext servletContext, Options options, String tagFilePath, TagInfo tagInfo, JspRuntimeContext rctxt, URL tagFileJarUrl) throws JasperException {
        this.isTagFile = true;
        this.config = null;
        this.options = options;
        this.jspUri = tagFilePath;
        this.tripCount = 0;
        this.ctxt = new JspCompilationContext(this.jspUri, tagInfo, options, servletContext, this, rctxt, tagFileJarUrl);
    }

    public JspCompilationContext getJspEngineContext() {
        return this.ctxt;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServlet() throws ServletException, IOException, FileNotFoundException {
        if (this.reload) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.reload) {
                    Servlet servlet;
                    this.destroy();
                    try {
                        this.servletClass = this.ctxt.load();
                        servlet = (Servlet)this.servletClass.newInstance();
                        AnnotationProcessor annotationProcessor = (AnnotationProcessor)this.config.getServletContext().getAttribute(AnnotationProcessor.class.getName());
                        if (annotationProcessor != null) {
                            annotationProcessor.processAnnotations(servlet);
                            annotationProcessor.postConstruct(servlet);
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new JasperException(e);
                    }
                    catch (InstantiationException e) {
                        throw new JasperException(e);
                    }
                    catch (Exception e) {
                        throw new JasperException(e);
                    }
                    servlet.init(this.config);
                    if (!this.firstTime) {
                        this.ctxt.getRuntimeContext().incrementJspReloadCount();
                    }
                    this.theServlet = servlet;
                    this.reload = false;
                }
            }
        }
        return this.theServlet;
    }

    public ServletContext getServletContext() {
        return this.ctxt.getServletContext();
    }

    public void setCompilationException(JasperException je) {
        this.compileException = je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletClassLastModifiedTime(long lastModified) {
        if (this.servletClassLastModifiedTime < lastModified) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.servletClassLastModifiedTime < lastModified) {
                    this.servletClassLastModifiedTime = lastModified;
                    this.reload = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadTagFile() throws JasperException {
        try {
            if (this.ctxt.isRemoved()) {
                throw new FileNotFoundException(this.jspUri);
            }
            if (this.options.getDevelopment() || this.firstTime) {
                JspServletWrapper jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    this.firstTime = false;
                    this.ctxt.compile();
                }
            } else if (this.compileException != null) {
                throw this.compileException;
            }
            if (this.reload) {
                this.tagHandlerClass = this.ctxt.load();
                this.reload = false;
            }
        }
        catch (FileNotFoundException ex) {
            throw new JasperException(ex);
        }
        return this.tagHandlerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadTagFilePrototype() throws JasperException {
        this.ctxt.setPrototypeMode(true);
        try {
            Class clazz = this.loadTagFile();
            Object var3_2 = null;
            this.ctxt.setPrototypeMode(false);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.ctxt.setPrototypeMode(false);
            throw throwable;
        }
    }

    public List getDependants() {
        try {
            Object target;
            if (this.isTagFile) {
                if (this.reload) {
                    this.tagHandlerClass = this.ctxt.load();
                    this.reload = false;
                }
                target = this.tagHandlerClass.newInstance();
            } else {
                target = this.getServlet();
            }
            if (target != null && target instanceof JspSourceDependent) {
                return (List)((JspSourceDependent)target).getDependants();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public int incTripCount() {
        return this.tripCount++;
    }

    public int decTripCount() {
        return this.tripCount--;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
        block36: {
            Servlet servlet;
            try {
                if (this.ctxt.isRemoved()) {
                    throw new FileNotFoundException(this.jspUri);
                }
                if (this.available > 0L && this.available < Long.MAX_VALUE) {
                    if (this.available > System.currentTimeMillis()) {
                        response.setDateHeader("Retry-After", this.available);
                        response.sendError(503, Localizer.getMessage("jsp.error.unavailable"));
                        return;
                    }
                    this.available = 0L;
                }
                if (this.options.getDevelopment() || this.firstTime) {
                    JspServletWrapper jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        this.firstTime = false;
                        this.ctxt.compile();
                    }
                } else if (this.compileException != null) {
                    throw this.compileException;
                }
                servlet = this.getServlet();
                if (precompile) {
                    return;
                }
            }
            catch (ServletException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException((Exception)((Object)ex));
                }
                throw ex;
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (IOException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw ex;
            }
            catch (IllegalStateException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw ex;
            }
            catch (Exception ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw new JasperException(ex);
            }
            try {
                if (servlet instanceof SingleThreadModel) {
                    JspServletWrapper ex = this;
                    synchronized (ex) {
                        servlet.service((ServletRequest)request, (ServletResponse)response);
                        break block36;
                    }
                }
                servlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (UnavailableException ex) {
                String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                if (includeRequestUri != null) {
                    throw ex;
                }
                int unavailableSeconds = ex.getUnavailableSeconds();
                if (unavailableSeconds <= 0) {
                    unavailableSeconds = 60;
                }
                this.available = System.currentTimeMillis() + (long)unavailableSeconds * 1000L;
                response.sendError(503, ex.getMessage());
            }
            catch (ServletException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException((Exception)((Object)ex));
                }
                throw ex;
            }
            catch (IOException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw ex;
            }
            catch (IllegalStateException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw ex;
            }
            catch (Exception ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw new JasperException(ex);
            }
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
            AnnotationProcessor annotationProcessor = (AnnotationProcessor)this.config.getServletContext().getAttribute(AnnotationProcessor.class.getName());
            if (annotationProcessor != null) {
                try {
                    annotationProcessor.preDestroy(this.theServlet);
                }
                catch (Exception e) {
                    this.log.error(Localizer.getMessage("jsp.error.file.not.found", e.getMessage()), e);
                }
            }
        }
    }

    public long getLastModificationTest() {
        return this.lastModificationTest;
    }

    public void setLastModificationTest(long lastModificationTest) {
        this.lastModificationTest = lastModificationTest;
    }

    protected JasperException handleJspException(Exception ex) {
        try {
            Throwable realException = ex;
            if (ex instanceof ServletException) {
                realException = ((ServletException)((Object)ex)).getRootCause();
            }
            StackTraceElement[] frames = realException.getStackTrace();
            StackTraceElement jspFrame = null;
            for (int i = 0; i < frames.length; ++i) {
                if (!frames[i].getClassName().equals(this.getServlet().getClass().getName())) continue;
                jspFrame = frames[i];
                break;
            }
            if (jspFrame == null || this.ctxt.getCompiler().getPageNodes() == null) {
                return new JasperException(ex);
            }
            int javaLineNumber = jspFrame.getLineNumber();
            JavacErrorDetail detail = ErrorDispatcher.createJavacError(jspFrame.getMethodName(), this.ctxt.getCompiler().getPageNodes(), null, javaLineNumber, this.ctxt);
            int jspLineNumber = detail.getJspBeginLineNumber();
            if (jspLineNumber < 1) {
                throw new JasperException(ex);
            }
            if (this.options.getDisplaySourceFragment()) {
                return new JasperException(Localizer.getMessage("jsp.exception", detail.getJspFileName(), "" + jspLineNumber) + "\n\n" + detail.getJspExtract() + "\n\nStacktrace:", ex);
            }
            return new JasperException(Localizer.getMessage("jsp.exception", detail.getJspFileName(), "" + jspLineNumber), ex);
        }
        catch (Exception je) {
            if (ex instanceof JasperException) {
                return (JasperException)((Object)ex);
            }
            return new JasperException(ex);
        }
    }
}

