/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6;

import java.lang.reflect.Field;
import org.apache.AnnotationProcessor;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.util.digester.Digester;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.web.tomcat6.SetSecurityServiceRule;

public class JOnASContextConfig
extends ContextConfig {
    private SecurityService service = null;
    public static final String DEFAULT_CONTEXT_XML = "conf/tomcat6-context.xml";
    public static final String DEFAULT_WEB_XML = "conf/tomcat6-web.xml";

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = DEFAULT_WEB_XML;
        }
        return this.defaultWebXml;
    }

    public String getDefaultContextXml() {
        if (this.defaultContextXml == null) {
            this.defaultContextXml = DEFAULT_CONTEXT_XML;
        }
        return this.defaultContextXml;
    }

    protected Digester createContextDigester() {
        Digester digester = super.createContextDigester();
        digester.addRule("Context/Realm", new SetSecurityServiceRule(this.service));
        return digester;
    }

    public void setSecurityService(SecurityService service) {
        this.service = service;
    }

    protected synchronized void init() {
        contextDigester = null;
        super.init();
    }

    protected void applicationWebConfig() {
        super.applicationWebConfig();
        boolean ignore = this.context.getIgnoreAnnotations();
        if (ignore) {
            AnnotationProcessor annotationProcessor = ((StandardContext)this.context).getAnnotationProcessor();
            Class<?> clazz = annotationProcessor.getClass();
            Field f = null;
            try {
                f = clazz.getDeclaredField("disabledAnnotation");
                f.setAccessible(true);
                f.set(annotationProcessor, Boolean.TRUE);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to find the field", e);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Unable to find the field", e);
            }
            this.context.setIgnoreAnnotations(false);
        }
    }

    public void setDefaultContextXml(String tomcat6ContextConfPath) {
        this.defaultContextXml = tomcat6ContextConfPath;
    }

    public void setDefaultWebXml(String tomcat6WebConfPath) {
        this.defaultWebXml = tomcat6WebConfPath;
    }
}

