/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProvider;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProviderImpl;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SamlAssertionValidator;
import org.apache.ws.security.validate.Validator;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractSamlInHandler
implements RequestHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSamlInHandler.class);
    private Validator samlValidator = new SamlAssertionValidator();
    private SecurityContextProvider scProvider = new SecurityContextProviderImpl();

    public void setValidator(Validator validator) {
        this.samlValidator = validator;
    }

    public void setSecurityContextProvider(SecurityContextProvider p) {
        this.scProvider = p;
    }

    protected void validateToken(Message message, InputStream tokenStream) {
        Document doc = null;
        try {
            doc = DOMUtils.readXml(new InputStreamReader(tokenStream, "UTF-8"));
        }
        catch (Exception ex) {
            this.throwFault("Assertion can not be read as XML document", ex);
        }
        this.validateToken(message, doc.getDocumentElement());
    }

    protected void validateToken(Message message, Element tokenElement) {
        try {
            AssertionWrapper assertion = new AssertionWrapper(tokenElement);
            RequestData data = new RequestData();
            if (assertion.isSigned()) {
                WSSConfig cfg = WSSConfig.getNewInstance();
                data.setWssConfig(cfg);
                data.setCallbackHandler(SecurityUtils.getCallbackHandler(message, this.getClass()));
                try {
                    data.setSigCrypto(new CryptoLoader().getCrypto(message, "ws-security.signature.crypto", "ws-security.signature.properties"));
                }
                catch (IOException ex) {
                    this.throwFault("Crypto can not be loaded", ex);
                }
                data.setEnableRevocation(MessageUtils.isTrue(message.getContextualProperty("enableRevocation")));
                assertion.verifySignature(data, null);
                assertion.parseHOKSubject(data, null);
            }
            if (this.samlValidator != null) {
                Credential credential = new Credential();
                credential.setAssertion(assertion);
                this.samlValidator.validate(credential, data);
            }
            this.checkSubjectConfirmationData(message, assertion);
            this.setSecurityContext(message, assertion);
        }
        catch (Exception ex) {
            this.throwFault("Assertion can not be validated", ex);
        }
    }

    protected void checkSubjectConfirmationData(Message message, AssertionWrapper assertion) {
        Certificate[] tlsCerts = this.getTLSCertificates(message);
        if (!this.checkHolderOfKey(message, assertion, tlsCerts)) {
            this.throwFault("Holder Of Key claim fails", null);
        }
        if (!this.checkSenderVouches(message, assertion, tlsCerts)) {
            this.throwFault("Sender vouchers claim fails", null);
        }
        if (!this.checkBearer(assertion, tlsCerts)) {
            this.throwFault("Bearer claim fails", null);
        }
    }

    protected void setSecurityContext(Message message, AssertionWrapper wrapper) {
        if (this.scProvider != null) {
            SecurityContext sc = this.scProvider.getSecurityContext(message, wrapper);
            message.put(SecurityContext.class, sc);
        }
    }

    private Certificate[] getTLSCertificates(Message message) {
        TLSSessionInfo tlsInfo = message.get(TLSSessionInfo.class);
        return tlsInfo != null ? tlsInfo.getPeerCertificates() : null;
    }

    protected void throwFault(String error, Exception ex) {
        LOG.warning(error);
        Response response = Response.status((int)401).entity((Object)error).build();
        throw ex != null ? new NotAuthorizedException((Throwable)ex, (Object)response, new Object[0]) : new NotAuthorizedException(response);
    }

    protected boolean checkSenderVouches(Message message, AssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        if (tlsCerts != null && tlsCerts.length > 0) {
            return true;
        }
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) continue;
            Element signedElement = message.getContent(Element.class);
            Node assertionParent = assertionWrapper.getElement().getParentNode();
            if (assertionParent == signedElement) continue;
            XMLSignature signature = message.getContent(XMLSignature.class);
            if (signature == null) {
                return false;
            }
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSignatureKeyInfo();
            if (this.compareCredentials(subjectKeyInfo, signature, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkHolderOfKey(Message message, AssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) continue;
            XMLSignature sig = message.getContent(XMLSignature.class);
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (this.compareCredentials(subjectKeyInfo, sig, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    private boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, XMLSignature sig, Certificate[] tlsCerts) {
        X509Certificate[] subjectCerts = subjectKeyInfo.getCerts();
        PublicKey subjectPublicKey = subjectKeyInfo.getPublicKey();
        if (tlsCerts != null && tlsCerts.length > 0 && subjectCerts != null && subjectCerts.length > 0 && tlsCerts[0].equals(subjectCerts[0])) {
            return true;
        }
        if (tlsCerts != null && tlsCerts.length > 0 && subjectPublicKey != null && tlsCerts[0].getPublicKey().equals(subjectPublicKey)) {
            return true;
        }
        if (sig == null) {
            return false;
        }
        try {
            X509Certificate[] certs = new X509Certificate[]{sig.getKeyInfo().getX509Certificate()};
            PublicKey publicKey = sig.getKeyInfo().getPublicKey();
            if (certs != null && certs.length > 0 && subjectCerts != null && subjectCerts.length > 0 && certs[0].equals(subjectCerts[0])) {
                return true;
            }
            if (publicKey != null && publicKey.equals(subjectPublicKey)) {
                return true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }

    protected boolean checkBearer(AssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            boolean isBearer = this.isMethodBearer(confirmationMethod);
            if (!isBearer || assertionWrapper.isSigned() || tlsCerts != null && tlsCerts.length != 0) continue;
            return false;
        }
        return true;
    }

    private boolean isMethodBearer(String confirmMethod) {
        return confirmMethod != null && confirmMethod.startsWith("urn:oasis:names:tc:SAML:") && confirmMethod.endsWith(":cm:bearer");
    }

    static {
        WSSConfig.init();
    }
}

