/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.SequenceFault;

public class RMDeliveryInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMDeliveryInterceptor.class);

    public RMDeliveryInterceptor() {
        super("post-invoke");
    }

    @Override
    public void handle(Message message) throws SequenceFault, RMException {
        LOG.entering(this.getClass().getName(), "handleMessage");
        Destination dest = this.getManager().getDestination(message);
        boolean robust = MessageUtils.isTrue(message.getContextualProperty("org.apache.cxf.oneway.robust"));
        if (robust) {
            message.remove("org.apache.cxf.oneway.robust.delivering");
            dest.acknowledge(message);
        }
        dest.processingComplete(message);
    }
}

