/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.ContentEncryptedElements;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.KerberosToken;
import org.apache.cxf.ws.security.policy.model.KeyValueToken;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SecurityContextToken;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedElements;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.policy.model.Wss10;
import org.apache.cxf.ws.security.policy.model.Wss11;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.cxf.ws.security.wss4j.policyhandlers.WSSecurityTokenHolder;
import org.apache.neethi.Assertion;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecSignatureConfirmation;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractBindingBuilder {
    public static final String CRYPTO_CACHE = "ws-security.crypto.cache";
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractBindingBuilder.class);
    protected SPConstants.ProtectionOrder protectionOrder = SPConstants.ProtectionOrder.SignBeforeEncrypting;
    protected final WSSConfig wssConfig;
    protected SOAPMessage saaj;
    protected WSSecHeader secHeader;
    protected AssertionInfoMap aim;
    protected Binding binding;
    protected SoapMessage message;
    protected WSSecTimestamp timestampEl;
    protected String mainSigId;
    protected List<WSEncryptionPart> sigConfList;
    protected Set<WSEncryptionPart> encryptedTokensList = new HashSet<WSEncryptionPart>();
    protected Map<Token, Object> endEncSuppTokMap;
    protected Map<Token, Object> endSuppTokMap;
    protected Map<Token, Object> sgndEndEncSuppTokMap;
    protected Map<Token, Object> sgndEndSuppTokMap;
    protected List<byte[]> signatures = new ArrayList<byte[]>();
    Element lastSupportingTokenElement;
    Element lastEncryptedKeyElement;
    Element lastDerivedKeyElement;
    Element bottomUpElement;
    Element topDownElement;
    Element bstElement;

    public AbstractBindingBuilder(WSSConfig config, Binding binding, SOAPMessage saaj, WSSecHeader secHeader, AssertionInfoMap aim, SoapMessage message) {
        this.wssConfig = config;
        this.binding = binding;
        this.aim = aim;
        this.secHeader = secHeader;
        this.saaj = saaj;
        this.message = message;
        message.getExchange().put("_sendSignatureValues_", this.signatures);
    }

    private void insertAfter(Element child, Element sib) {
        if (sib.getNextSibling() == null) {
            this.secHeader.getSecurityHeader().appendChild(child);
        } else {
            this.secHeader.getSecurityHeader().insertBefore(child, sib.getNextSibling());
        }
    }

    protected void addDerivedKeyElement(Element el) {
        if (this.lastDerivedKeyElement != null) {
            this.insertAfter(el, this.lastDerivedKeyElement);
        } else if (this.lastEncryptedKeyElement != null) {
            this.insertAfter(el, this.lastEncryptedKeyElement);
        } else if (this.topDownElement != null) {
            this.insertAfter(el, this.topDownElement);
        } else if (this.secHeader.getSecurityHeader().getFirstChild() != null) {
            this.secHeader.getSecurityHeader().insertBefore(el, this.secHeader.getSecurityHeader().getFirstChild());
        } else {
            this.secHeader.getSecurityHeader().appendChild(el);
        }
        this.lastEncryptedKeyElement = el;
    }

    protected void addEncryptedKeyElement(Element el) {
        if (this.lastEncryptedKeyElement != null) {
            this.insertAfter(el, this.lastEncryptedKeyElement);
        } else if (this.lastDerivedKeyElement != null) {
            this.secHeader.getSecurityHeader().insertBefore(el, this.lastDerivedKeyElement);
        } else if (this.topDownElement != null) {
            this.insertAfter(el, this.topDownElement);
        } else if (this.secHeader.getSecurityHeader().getFirstChild() != null) {
            this.secHeader.getSecurityHeader().insertBefore(el, this.secHeader.getSecurityHeader().getFirstChild());
        } else {
            this.secHeader.getSecurityHeader().appendChild(el);
        }
        this.lastEncryptedKeyElement = el;
    }

    protected void addSupportingElement(Element el) {
        if (this.lastSupportingTokenElement != null) {
            this.insertAfter(el, this.lastSupportingTokenElement);
        } else if (this.lastDerivedKeyElement != null) {
            this.insertAfter(el, this.lastDerivedKeyElement);
        } else if (this.lastEncryptedKeyElement != null) {
            this.insertAfter(el, this.lastEncryptedKeyElement);
        } else if (this.topDownElement != null) {
            this.insertAfter(el, this.topDownElement);
        } else if (this.bottomUpElement != null) {
            this.secHeader.getSecurityHeader().insertBefore(el, this.bottomUpElement);
        } else {
            this.secHeader.getSecurityHeader().appendChild(el);
        }
        this.lastSupportingTokenElement = el;
    }

    protected void insertBeforeBottomUp(Element el) {
        if (this.bottomUpElement == null) {
            this.secHeader.getSecurityHeader().appendChild(el);
        } else {
            this.secHeader.getSecurityHeader().insertBefore(el, this.bottomUpElement);
        }
        this.bottomUpElement = el;
    }

    protected void addTopDownElement(Element el) {
        if (this.topDownElement == null) {
            if (this.secHeader.getSecurityHeader().getFirstChild() == null) {
                this.secHeader.getSecurityHeader().appendChild(el);
            } else {
                this.secHeader.getSecurityHeader().insertBefore(el, this.secHeader.getSecurityHeader().getFirstChild());
            }
        } else {
            this.insertAfter(el, this.topDownElement);
        }
        this.topDownElement = el;
    }

    protected boolean isRequestor() {
        return MessageUtils.isRequestor(this.message);
    }

    protected void policyNotAsserted(Assertion assertion, Exception reason) {
        if (assertion == null) {
            return;
        }
        LOG.log(Level.FINE, "Not asserting " + assertion.getName() + ": " + reason);
        Collection ais = (Collection)this.aim.get(assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason.getMessage());
            }
        }
        if (!assertion.isOptional()) {
            throw new PolicyException(new Message(reason.getMessage(), LOG, new Object[0]));
        }
    }

    protected void policyNotAsserted(Assertion assertion, String reason) {
        if (assertion == null) {
            return;
        }
        LOG.log(Level.FINE, "Not asserting " + assertion.getName() + ": " + reason);
        Collection ais = (Collection)this.aim.get(assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setNotAsserted(reason);
            }
        }
        if (!assertion.isOptional()) {
            throw new PolicyException(new Message(reason, LOG, new Object[0]));
        }
    }

    protected void policyAsserted(Assertion assertion) {
        if (assertion == null) {
            return;
        }
        LOG.log(Level.FINE, "Asserting " + assertion.getName());
        Collection ais = (Collection)this.aim.get(assertion.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != assertion) continue;
                ai.setAsserted(true);
            }
        }
    }

    protected void policyAsserted(QName n) {
        Collection<AssertionInfo> ais = this.aim.getAssertionInfo(n);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    protected Collection<Assertion> findAndAssertPolicy(QName n) {
        Collection<AssertionInfo> ais = this.aim.getAssertionInfo(n);
        if (ais != null && !ais.isEmpty()) {
            ArrayList<Assertion> p = new ArrayList<Assertion>(ais.size());
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
                p.add(ai.getAssertion());
            }
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<Object, Crypto> getCryptoCache() {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = this.message.getExchange().get(Endpoint.class).getEndpointInfo();
        synchronized (endpointInfo) {
            Map<Object, Crypto> o = CastUtils.cast((Map)this.message.getContextualProperty(CRYPTO_CACHE));
            if (o == null) {
                o = new ConcurrentHashMap();
                info.setProperty(CRYPTO_CACHE, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TokenStore getTokenStore() {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = this.message.getExchange().get(Endpoint.class).getEndpointInfo();
        synchronized (endpointInfo) {
            TokenStore tokenStore = (TokenStore)this.message.getContextualProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
            if (tokenStore == null) {
                tokenStore = (TokenStore)info.getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
            }
            if (tokenStore == null) {
                TokenStoreFactory tokenStoreFactory = TokenStoreFactory.newInstance();
                String cacheKey = "org.apache.cxf.ws.security.tokenstore.TokenStore";
                if (info.getName() != null) {
                    cacheKey = cacheKey + "-" + info.getName().toString().hashCode();
                }
                tokenStore = tokenStoreFactory.newTokenStore(cacheKey, this.message);
                info.setProperty("org.apache.cxf.ws.security.tokenstore.TokenStore", tokenStore);
            }
            return tokenStore;
        }
    }

    protected WSSecTimestamp createTimestamp() {
        Collection ais = (Collection)this.aim.get(SP12Constants.INCLUDE_TIMESTAMP);
        if (ais != null) {
            Object o = this.message.getContextualProperty("ws-security.timestamp.timeToLive");
            int ttl = 300;
            if (o instanceof Number) {
                ttl = ((Number)o).intValue();
            } else if (o instanceof String) {
                ttl = Integer.parseInt((String)o);
            }
            if (ttl <= 0) {
                ttl = 300;
            }
            this.timestampEl = new WSSecTimestamp(this.wssConfig);
            this.timestampEl.setWsConfig(this.wssConfig);
            this.timestampEl.setTimeToLive(ttl);
            this.timestampEl.prepare((Document)this.saaj.getSOAPPart());
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
        return this.timestampEl;
    }

    protected WSSecTimestamp handleLayout(WSSecTimestamp timestamp) {
        Collection ais = (Collection)this.aim.get(SP12Constants.LAYOUT);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                Layout layout = (Layout)ai.getAssertion();
                ai.setAsserted(true);
                if (SPConstants.Layout.LaxTimestampLast == layout.getValue()) {
                    if (timestamp == null) {
                        ai.setNotAsserted((Object)((Object)SPConstants.Layout.LaxTimestampLast) + " requires a timestamp");
                        continue;
                    }
                    ai.setAsserted(true);
                    Element el = timestamp.getElement();
                    this.secHeader.getSecurityHeader().appendChild(el);
                    if (this.bottomUpElement != null) continue;
                    this.bottomUpElement = el;
                    continue;
                }
                if (SPConstants.Layout.LaxTimestampFirst == layout.getValue()) {
                    if (timestamp == null) {
                        ai.setNotAsserted((Object)((Object)SPConstants.Layout.LaxTimestampLast) + " requires a timestamp");
                        continue;
                    }
                    this.addTopDownElement(this.timestampEl.getElement());
                    continue;
                }
                if (this.timestampEl == null) continue;
                this.addTopDownElement(this.timestampEl.getElement());
            }
        } else if (this.timestampEl != null) {
            this.addTopDownElement(this.timestampEl.getElement());
        }
        return timestamp;
    }

    protected void assertSupportingTokens(Collection<Assertion> suppTokens) {
        if (suppTokens == null) {
            return;
        }
        for (Assertion pa : suppTokens) {
            if (!(pa instanceof SupportingToken)) continue;
            for (Token token : ((SupportingToken)pa).getTokens()) {
                this.policyAsserted(token);
            }
        }
    }

    protected Map<Token, Object> handleSupportingTokens(Collection<Assertion> tokens, boolean endorse) throws WSSecurityException {
        HashMap<Token, Object> ret = new HashMap<Token, Object>();
        if (tokens != null) {
            for (Assertion pa : tokens) {
                if (!(pa instanceof SupportingToken)) continue;
                this.handleSupportingTokens((SupportingToken)pa, endorse, ret);
            }
        }
        return ret;
    }

    protected Map<Token, Object> handleSupportingTokens(SupportingToken suppTokens, boolean endorse) throws WSSecurityException {
        return this.handleSupportingTokens(suppTokens, endorse, new HashMap<Token, Object>());
    }

    protected Map<Token, Object> handleSupportingTokens(SupportingToken suppTokens, boolean endorse, Map<Token, Object> ret) throws WSSecurityException {
        if (suppTokens == null) {
            return ret;
        }
        for (Token token : suppTokens.getTokens()) {
            AssertionWrapper assertionWrapper;
            WSEncryptionPart part;
            WSSecSignature sig;
            if (token instanceof UsernameToken) {
                this.handleUsernameTokenSupportingToken((UsernameToken)token, endorse, suppTokens.isEncryptedToken(), ret);
                continue;
            }
            if (this.isRequestor() && (token instanceof IssuedToken || token instanceof SecureConversationToken || token instanceof SecurityContextToken || token instanceof KerberosToken)) {
                SecurityToken secToken = this.getSecurityToken();
                if (secToken == null) {
                    this.policyNotAsserted((Assertion)token, "Could not find IssuedToken");
                }
                Element clone = this.cloneElement(secToken.getToken());
                secToken.setToken(clone);
                this.addSupportingElement(clone);
                String id = secToken.getId();
                if (id != null && id.charAt(0) == '#') {
                    id = id.substring(1);
                }
                if (suppTokens.isEncryptedToken()) {
                    WSEncryptionPart part2 = new WSEncryptionPart(id, "Element");
                    part2.setElement(clone);
                    this.encryptedTokensList.add(part2);
                }
                if (secToken.getX509Certificate() == null) {
                    ret.put(token, (Object)new WSSecurityTokenHolder(this.wssConfig, secToken));
                    continue;
                }
                WSSecSignature sig2 = new WSSecSignature(this.wssConfig);
                sig2.setX509Certificate(secToken.getX509Certificate());
                sig2.setCustomTokenId(id);
                sig2.setKeyIdentifierType(12);
                String tokenType = secToken.getTokenType();
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
                    sig2.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                    sig2.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
                } else if (tokenType != null) {
                    sig2.setCustomTokenValueType(tokenType);
                } else {
                    sig2.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                }
                sig2.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getAsymmetricSignature());
                sig2.setSigCanonicalization(this.binding.getAlgorithmSuite().getInclusiveC14n());
                Crypto crypto = secToken.getCrypto();
                String uname = null;
                try {
                    uname = crypto.getX509Identifier(secToken.getX509Certificate());
                }
                catch (WSSecurityException e1) {
                    LOG.log(Level.FINE, e1.getMessage(), e1);
                    throw new Fault(e1);
                }
                String password = this.getPassword(uname, token, 3);
                sig2.setUserInfo(uname, password);
                try {
                    sig2.prepare((Document)this.saaj.getSOAPPart(), secToken.getCrypto(), this.secHeader);
                }
                catch (WSSecurityException e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                    throw new Fault(e);
                }
                ret.put(token, sig2);
                continue;
            }
            if (token instanceof X509Token) {
                sig = this.getSignatureBuilder(suppTokens, token, endorse);
                Element bstElem = sig.getBinarySecurityTokenElement();
                if (bstElem != null) {
                    sig.prependBSTElementToHeader(this.secHeader);
                }
                if (suppTokens.isEncryptedToken()) {
                    part = new WSEncryptionPart(sig.getBSTTokenId(), "Element");
                    this.encryptedTokensList.add(part);
                }
                ret.put(token, sig);
                continue;
            }
            if (token instanceof KeyValueToken) {
                sig = this.getSignatureBuilder(suppTokens, token, endorse);
                if (suppTokens.isEncryptedToken()) {
                    WSEncryptionPart part3 = new WSEncryptionPart(sig.getBSTTokenId(), "Element");
                    this.encryptedTokensList.add(part3);
                }
                ret.put(token, sig);
                continue;
            }
            if (!(token instanceof SamlToken) || (assertionWrapper = this.addSamlToken((SamlToken)token)) == null) continue;
            Element assertionElement = assertionWrapper.toDOM((Document)this.saaj.getSOAPPart());
            this.addSupportingElement(assertionElement);
            ret.put(token, assertionWrapper);
            if (!suppTokens.isEncryptedToken()) continue;
            part = new WSEncryptionPart(assertionWrapper.getId(), "Element");
            part.setElement(assertionElement);
            this.encryptedTokensList.add(part);
        }
        return ret;
    }

    protected void handleUsernameTokenSupportingToken(UsernameToken token, boolean endorse, boolean encryptedToken, Map<Token, Object> ret) throws WSSecurityException {
        if (endorse) {
            WSSecUsernameToken utBuilder = this.addDKUsernameToken(token, true);
            if (utBuilder != null) {
                utBuilder.prepare((Document)this.saaj.getSOAPPart());
                this.addSupportingElement(utBuilder.getUsernameTokenElement());
                ret.put(token, utBuilder);
                if (encryptedToken) {
                    WSEncryptionPart part = new WSEncryptionPart(utBuilder.getId(), "Element");
                    part.setElement(utBuilder.getUsernameTokenElement());
                    this.encryptedTokensList.add(part);
                }
            }
        } else {
            WSSecUsernameToken utBuilder = this.addUsernameToken(token);
            if (utBuilder != null) {
                utBuilder.prepare((Document)this.saaj.getSOAPPart());
                this.addSupportingElement(utBuilder.getUsernameTokenElement());
                ret.put(token, utBuilder);
                if (encryptedToken || MessageUtils.getContextualBoolean(this.message, "ws-security.username-token.always.encrypted", true)) {
                    WSEncryptionPart part = new WSEncryptionPart(utBuilder.getId(), "Element");
                    part.setElement(utBuilder.getUsernameTokenElement());
                    this.encryptedTokensList.add(part);
                }
            }
        }
    }

    protected Element cloneElement(Element el) {
        return (Element)this.secHeader.getSecurityHeader().getOwnerDocument().importNode(el, true);
    }

    protected SecurityToken getSecurityToken() {
        String id;
        SecurityToken st = (SecurityToken)this.message.getContextualProperty("ws-security.token");
        if (st == null && (id = (String)this.message.getContextualProperty("ws-security.token.id")) != null) {
            st = this.getTokenStore().getToken(id);
        }
        if (st != null) {
            this.getTokenStore().add(st);
            return st;
        }
        return null;
    }

    protected void addSignatureParts(Map<Token, Object> tokenMap, List<WSEncryptionPart> sigParts) {
        for (Map.Entry<Token, Object> entry : tokenMap.entrySet()) {
            boolean saml1;
            Document doc;
            Object tempTok = entry.getValue();
            WSEncryptionPart part = null;
            if (tempTok instanceof WSSecSignature) {
                WSSecSignature tempSig = (WSSecSignature)tempTok;
                SecurityTokenReference secRef = tempSig.getSecurityTokenReference();
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType())) {
                    Element secRefElement = this.cloneElement(secRef.getElement());
                    this.addSupportingElement(secRefElement);
                    part = new WSEncryptionPart("STRTransform", null, "Element");
                    part.setId(tempSig.getSecurityTokenReferenceURI());
                    part.setElement(secRefElement);
                } else if (tempSig.getBSTTokenId() != null) {
                    part = new WSEncryptionPart(tempSig.getBSTTokenId());
                    part.setElement(tempSig.getBinarySecurityTokenElement());
                }
            } else if (tempTok instanceof WSSecUsernameToken) {
                WSSecUsernameToken unt = (WSSecUsernameToken)tempTok;
                part = new WSEncryptionPart(unt.getId());
                part.setElement(unt.getUsernameTokenElement());
            } else if (tempTok instanceof BinarySecurity) {
                BinarySecurity bst = (BinarySecurity)tempTok;
                part = new WSEncryptionPart(bst.getID());
                part.setElement(bst.getElement());
            } else if (tempTok instanceof AssertionWrapper) {
                boolean selfSignAssertion = MessageUtils.getContextualBoolean(this.message, "ws-security.self-sign-saml-assertion", false);
                if (!selfSignAssertion) {
                    AssertionWrapper assertionWrapper = (AssertionWrapper)tempTok;
                    doc = assertionWrapper.getElement().getOwnerDocument();
                    saml1 = assertionWrapper.getSaml1() != null;
                    SecurityTokenReference secRef = this.createSTRForSamlAssertion(doc, assertionWrapper.getId(), saml1, false);
                    Element clone = this.cloneElement(secRef.getElement());
                    this.addSupportingElement(clone);
                    part = new WSEncryptionPart("STRTransform", null, "Element");
                    part.setId(secRef.getID());
                    part.setElement(clone);
                }
            } else if (tempTok instanceof WSSecurityTokenHolder) {
                SecurityToken token = ((WSSecurityTokenHolder)((Object)tempTok)).getToken();
                String tokenType = token.getTokenType();
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                    doc = token.getToken().getOwnerDocument();
                    saml1 = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType);
                    String id = null;
                    id = saml1 ? token.getToken().getAttributeNS(null, "AssertionID") : token.getToken().getAttributeNS(null, "ID");
                    SecurityTokenReference secRef = this.createSTRForSamlAssertion(doc, id, saml1, false);
                    Element clone = this.cloneElement(secRef.getElement());
                    this.addSupportingElement(clone);
                    part = new WSEncryptionPart("STRTransform", null, "Element");
                    part.setId(secRef.getID());
                    part.setElement(clone);
                } else {
                    String id = token.getId();
                    if (id != null && id.charAt(0) == '#') {
                        id = id.substring(1);
                    }
                    part = new WSEncryptionPart(id);
                    part.setElement(token.getToken());
                }
            } else {
                this.policyNotAsserted((Assertion)entry.getKey(), "UnsupportedTokenInSupportingToken: " + tempTok);
            }
            if (part == null) continue;
            sigParts.add(part);
        }
    }

    private SecurityTokenReference createSTRForSamlAssertion(Document doc, String id, boolean saml1, boolean useDirectReferenceToAssertion) {
        SecurityTokenReference secRefSaml = new SecurityTokenReference(doc);
        String secRefID = this.wssConfig.getIdAllocator().createSecureId("STR-", (Object)secRefSaml);
        secRefSaml.setID(secRefID);
        if (useDirectReferenceToAssertion) {
            Reference ref = new Reference(doc);
            ref.setURI("#" + id);
            if (saml1) {
                ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            } else {
                secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            secRefSaml.setReference(ref);
        } else {
            Element keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
            String valueType = null;
            if (saml1) {
                valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
                secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            } else {
                valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
                secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            keyId.setAttributeNS(null, "ValueType", valueType);
            keyId.appendChild(doc.createTextNode(id));
            Element elem = secRefSaml.getElement();
            elem.appendChild(keyId);
        }
        return secRefSaml;
    }

    protected WSSecUsernameToken addUsernameToken(UsernameToken token) {
        AssertionInfo info = null;
        Collection<AssertionInfo> ais = this.aim.getAssertionInfo(token.getName());
        for (AssertionInfo ai : ais) {
            if (ai.getAssertion() != token) continue;
            info = ai;
            if (this.isRequestor()) continue;
            info.setAsserted(true);
            return null;
        }
        String userName = (String)this.message.getContextualProperty("ws-security.username");
        if (!StringUtils.isEmpty(userName)) {
            WSSecUsernameToken utBuilder = new WSSecUsernameToken(this.wssConfig);
            if (token.isNoPassword()) {
                utBuilder.setUserInfo(userName, null);
                utBuilder.setPasswordType(null);
            } else {
                String password = (String)this.message.getContextualProperty("ws-security.password");
                if (StringUtils.isEmpty(password)) {
                    password = this.getPassword(userName, token, 2);
                }
                if (!StringUtils.isEmpty(password)) {
                    if (token.isHashPassword()) {
                        utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                    } else {
                        utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                    }
                    utBuilder.setUserInfo(userName, password);
                } else {
                    this.policyNotAsserted((Assertion)token, "No password available");
                    return null;
                }
            }
            if (token.isRequireCreated() && !token.isHashPassword()) {
                utBuilder.addCreated();
            }
            if (token.isRequireNonce() && !token.isHashPassword()) {
                utBuilder.addNonce();
            }
            info.setAsserted(true);
            return utBuilder;
        }
        this.policyNotAsserted((Assertion)token, "No username available");
        return null;
    }

    protected WSSecUsernameToken addDKUsernameToken(UsernameToken token, boolean useMac) {
        AssertionInfo info = null;
        Collection<AssertionInfo> ais = this.aim.getAssertionInfo(token.getName());
        for (AssertionInfo ai : ais) {
            if (ai.getAssertion() != token) continue;
            info = ai;
            if (this.isRequestor()) continue;
            info.setAsserted(true);
            return null;
        }
        String userName = (String)this.message.getContextualProperty("ws-security.username");
        if (!StringUtils.isEmpty(userName)) {
            WSSecUsernameToken utBuilder = new WSSecUsernameToken(this.wssConfig);
            String password = (String)this.message.getContextualProperty("ws-security.password");
            if (StringUtils.isEmpty(password)) {
                password = this.getPassword(userName, token, 2);
            }
            if (StringUtils.isEmpty(password)) {
                this.policyNotAsserted((Assertion)token, "No password available");
                return null;
            }
            utBuilder.setUserInfo(userName, password);
            utBuilder.addDerivedKey(useMac, null, 1000);
            utBuilder.prepare((Document)this.saaj.getSOAPPart());
            info.setAsserted(true);
            return utBuilder;
        }
        this.policyNotAsserted((Assertion)token, "No username available");
        return null;
    }

    protected AssertionWrapper addSamlToken(SamlToken token) throws WSSecurityException {
        AssertionInfo info = null;
        Collection<AssertionInfo> ais = this.aim.getAssertionInfo(token.getName());
        for (AssertionInfo ai : ais) {
            if (ai.getAssertion() != token) continue;
            info = ai;
            if (this.isRequestor()) continue;
            info.setAsserted(true);
            return null;
        }
        Object o = this.message.getContextualProperty("ws-security.saml-callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        if (handler == null) {
            this.policyNotAsserted((Assertion)token, "No SAML CallbackHandler available");
            return null;
        }
        SAMLParms samlParms = new SAMLParms();
        samlParms.setCallbackHandler(handler);
        if (token.isUseSamlVersion11Profile10() || token.isUseSamlVersion11Profile11()) {
            samlParms.setSAMLVersion(SAMLVersion.VERSION_11);
        } else if (token.isUseSamlVersion20Profile11()) {
            samlParms.setSAMLVersion(SAMLVersion.VERSION_20);
        }
        info.setAsserted(true);
        AssertionWrapper assertion = new AssertionWrapper(samlParms);
        boolean selfSignAssertion = MessageUtils.getContextualBoolean(this.message, "ws-security.self-sign-saml-assertion", false);
        if (selfSignAssertion) {
            Crypto crypto = this.getSignatureCrypto(null);
            String userNameKey = "ws-security.signature.username";
            String user = (String)this.message.getContextualProperty(userNameKey);
            if (crypto != null && StringUtils.isEmpty(user)) {
                try {
                    user = crypto.getDefaultX509Identifier();
                }
                catch (WSSecurityException e1) {
                    throw new Fault(e1);
                }
            }
            if (StringUtils.isEmpty(user)) {
                this.policyNotAsserted((Assertion)token, "No username found.");
                return null;
            }
            String password = this.getPassword(user, token, 3);
            assertion.signAssertion(user, password, crypto, false);
        }
        return assertion;
    }

    protected void storeAssertionAsSecurityToken(AssertionWrapper assertion) {
        String id = this.findIDFromSamlToken(assertion.getElement());
        if (id == null) {
            return;
        }
        SecurityToken secToken = new SecurityToken(id);
        if (assertion.getSaml2() != null) {
            secToken.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        } else {
            secToken.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        }
        secToken.setToken(assertion.getElement());
        this.getTokenStore().add(secToken);
        this.message.setContextualProperty("ws-security.token.id", secToken.getId());
    }

    protected String findIDFromSamlToken(Element samlToken) {
        String id = null;
        if (samlToken != null) {
            QName elName = DOMUtils.getElementQName(samlToken);
            if (elName.equals(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) && samlToken.hasAttributeNS(null, "AssertionID")) {
                id = samlToken.getAttributeNS(null, "AssertionID");
            } else if (elName.equals(new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion")) && samlToken.hasAttributeNS(null, "ID")) {
                id = samlToken.getAttributeNS(null, "ID");
            }
            if (id == null) {
                id = samlToken.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            }
        }
        return id;
    }

    public String getPassword(String userName, Assertion info, int type) {
        CallbackHandler handler = this.getCallbackHandler();
        if (handler == null) {
            this.policyNotAsserted(info, "No callback handler and no password available");
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, type)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            this.policyNotAsserted(info, e);
        }
        return cb[0].getPassword();
    }

    protected CallbackHandler getCallbackHandler() {
        Object o = this.message.getContextualProperty("ws-security.callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }

    public String addWsuIdToElement(Element elem) {
        String id;
        Attr idAttr = elem.getAttributeNode("Id");
        if (idAttr == null) {
            idAttr = elem.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        if (idAttr != null) {
            id = idAttr.getValue();
        } else {
            id = "Id-" + elem.hashCode();
            String pfx = null;
            try {
                pfx = elem.lookupPrefix("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            }
            catch (Throwable t) {
                pfx = DOMUtils.getPrefixRecursive(elem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            }
            boolean found = !StringUtils.isEmpty(pfx);
            int cnt = 0;
            while (StringUtils.isEmpty(pfx)) {
                String ns;
                pfx = "wsu" + (cnt == 0 ? "" : Integer.valueOf(cnt));
                try {
                    ns = elem.lookupNamespaceURI(pfx);
                }
                catch (Throwable t) {
                    ns = DOMUtils.getNamespace(elem, pfx);
                }
                if (StringUtils.isEmpty(ns)) continue;
                pfx = null;
                ++cnt;
            }
            if (!found) {
                idAttr = elem.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + pfx);
                idAttr.setValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                elem.setAttributeNodeNS(idAttr);
            }
            idAttr = elem.getOwnerDocument().createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", pfx + ":Id");
            idAttr.setValue(id);
            elem.setAttributeNodeNS(idAttr);
        }
        return id;
    }

    public List<WSEncryptionPart> getEncryptedParts() throws SOAPException {
        boolean isBody = false;
        SignedEncryptedParts parts = null;
        SignedEncryptedElements elements = null;
        ContentEncryptedElements celements = null;
        Collection<AssertionInfo> ais = this.aim.getAssertionInfo(SP12Constants.ENCRYPTED_PARTS);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                parts = (SignedEncryptedParts)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if ((ais = this.aim.getAssertionInfo(SP12Constants.ENCRYPTED_ELEMENTS)) != null) {
            for (AssertionInfo ai : ais) {
                elements = (SignedEncryptedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if ((ais = this.aim.getAssertionInfo(SP12Constants.CONTENT_ENCRYPTED_ELEMENTS)) != null) {
            for (AssertionInfo ai : ais) {
                celements = (ContentEncryptedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        ArrayList<WSEncryptionPart> signedParts = new ArrayList<WSEncryptionPart>();
        if (parts != null) {
            isBody = parts.isBody();
            for (Header head : parts.getHeaders()) {
                WSEncryptionPart wep = new WSEncryptionPart(head.getName(), head.getNamespace(), "Element");
                signedParts.add(wep);
            }
        }
        return this.getPartsAndElements(false, isBody, signedParts, elements == null ? null : elements.getXPathExpressions(), elements == null ? null : elements.getDeclaredNamespaces(), celements == null ? null : celements.getXPathExpressions(), celements == null ? null : celements.getDeclaredNamespaces());
    }

    public List<WSEncryptionPart> getSignedParts() throws SOAPException {
        boolean isSignBody = false;
        SignedEncryptedParts parts = null;
        SignedEncryptedElements elements = null;
        Collection<AssertionInfo> ais = this.aim.getAssertionInfo(SP12Constants.SIGNED_PARTS);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                parts = (SignedEncryptedParts)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        if ((ais = this.aim.getAssertionInfo(SP12Constants.SIGNED_ELEMENTS)) != null) {
            for (AssertionInfo ai : ais) {
                elements = (SignedEncryptedElements)ai.getAssertion();
                ai.setAsserted(true);
            }
        }
        ArrayList<WSEncryptionPart> signedParts = new ArrayList<WSEncryptionPart>();
        if (parts != null) {
            isSignBody = parts.isBody();
            for (Header head : parts.getHeaders()) {
                WSEncryptionPart wep = new WSEncryptionPart(head.getName(), head.getNamespace(), "Element");
                signedParts.add(wep);
            }
        }
        return this.getPartsAndElements(true, isSignBody, signedParts, elements == null ? null : elements.getXPathExpressions(), elements == null ? null : elements.getDeclaredNamespaces(), null, null);
    }

    public List<WSEncryptionPart> getPartsAndElements(boolean sign, boolean includeBody, List<WSEncryptionPart> parts, List<String> xpaths, Map<String, String> namespaces, List<String> contentXpaths, Map<String, String> cnamespaces) throws SOAPException {
        ArrayList<WSEncryptionPart> result = new ArrayList<WSEncryptionPart>();
        ArrayList<Element> found = new ArrayList<Element>();
        result.addAll(this.getParts(sign, includeBody, parts, found));
        try {
            result.addAll(this.getElements("Element", xpaths, namespaces, found));
        }
        catch (XPathExpressionException e) {
            LOG.log(Level.FINE, e.getMessage(), e);
        }
        try {
            result.addAll(this.getElements("Content", contentXpaths, cnamespaces, found));
        }
        catch (XPathExpressionException e) {
            LOG.log(Level.FINE, e.getMessage(), e);
        }
        return result;
    }

    protected List<WSEncryptionPart> getParts(boolean sign, boolean includeBody, List<WSEncryptionPart> parts, List<Element> found) throws SOAPException {
        ArrayList<WSEncryptionPart> result = new ArrayList<WSEncryptionPart>();
        if (includeBody && !found.contains(SAAJUtils.getBody(this.saaj))) {
            WSEncryptionPart bodyPart;
            found.add((Element)SAAJUtils.getBody(this.saaj));
            String id = this.addWsuIdToElement((Element)SAAJUtils.getBody(this.saaj));
            if (sign) {
                bodyPart = new WSEncryptionPart(id, "Element");
                bodyPart.setElement((Element)SAAJUtils.getBody(this.saaj));
                result.add(bodyPart);
            } else {
                bodyPart = new WSEncryptionPart(id, "Content");
                bodyPart.setElement((Element)SAAJUtils.getBody(this.saaj));
                result.add(bodyPart);
            }
        }
        SOAPHeader header = SAAJUtils.getHeader(this.saaj);
        for (WSEncryptionPart part : parts) {
            List<Element> elements = StringUtils.isEmpty(part.getName()) ? DOMUtils.getChildrenWithNamespace((Element)header, part.getNamespace()) : DOMUtils.getChildrenWithName((Element)header, part.getNamespace(), part.getName());
            for (Element el : elements) {
                if (found.contains(el)) continue;
                found.add(el);
                String id = this.addWsuIdToElement(el);
                WSEncryptionPart elPart = new WSEncryptionPart(id, part.getEncModifier());
                elPart.setElement(el);
                result.add(elPart);
            }
        }
        return result;
    }

    protected List<WSEncryptionPart> getElements(String encryptionModifier, List<String> xpaths, Map<String, String> namespaces, List<Element> found) throws XPathExpressionException, SOAPException {
        ArrayList<WSEncryptionPart> result = new ArrayList<WSEncryptionPart>();
        if (xpaths != null && !xpaths.isEmpty()) {
            XPathFactory factory = XPathFactory.newInstance();
            for (String expression : xpaths) {
                XPath xpath = factory.newXPath();
                if (namespaces != null) {
                    xpath.setNamespaceContext(new MapNamespaceContext(namespaces));
                }
                NodeList list = (NodeList)xpath.evaluate(expression, this.saaj.getSOAPPart().getEnvelope(), XPathConstants.NODESET);
                for (int x = 0; x < list.getLength(); ++x) {
                    Element el = (Element)list.item(x);
                    if (found.contains(el)) continue;
                    String id = this.addWsuIdToElement(el);
                    WSEncryptionPart part = new WSEncryptionPart(id, encryptionModifier);
                    part.setElement(el);
                    part.setXpath(expression);
                    result.add(part);
                }
            }
        }
        return result;
    }

    protected WSSecEncryptedKey getEncryptedKeyBuilder(TokenWrapper wrapper, Token token) throws WSSecurityException {
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey(this.wssConfig);
        Crypto crypto = this.getEncryptionCrypto(wrapper);
        this.message.getExchange().put("ws-security.encryption.crypto", crypto);
        this.setKeyIdentifierType((WSSecBase)encrKey, wrapper, token);
        boolean alsoIncludeToken = false;
        if (token instanceof X509Token && token.getInclusion() != SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER && encrKey.getKeyIdentifierType() != 1) {
            alsoIncludeToken = true;
        }
        String encrUser = this.setEncryptionUser(encrKey, wrapper, false, crypto);
        encrKey.setSymmetricEncAlgorithm(this.binding.getAlgorithmSuite().getEncryption());
        encrKey.setKeyEncAlgo(this.binding.getAlgorithmSuite().getAsymmetricKeyWrap());
        encrKey.prepare((Document)this.saaj.getSOAPPart(), crypto);
        if (alsoIncludeToken) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(encrUser);
            X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
            X509Security bstToken = new X509Security((Document)this.saaj.getSOAPPart());
            bstToken.setX509Certificate(certs[0]);
            bstToken.addWSUNamespace();
            bstToken.setID(this.wssConfig.getIdAllocator().createSecureId("X509-", (Object)certs[0]));
            WSSecurityUtil.prependChildElement((Element)this.secHeader.getSecurityHeader(), (Element)bstToken.getElement());
            this.bstElement = bstToken.getElement();
        }
        return encrKey;
    }

    public Crypto getSignatureCrypto(TokenWrapper wrapper) throws WSSecurityException {
        return this.getCrypto(wrapper, "ws-security.signature.crypto", "ws-security.signature.properties");
    }

    public Crypto getEncryptionCrypto(TokenWrapper wrapper) throws WSSecurityException {
        Crypto crypto = this.getCrypto(wrapper, "ws-security.encryption.crypto", "ws-security.encryption.properties");
        boolean enableRevocation = MessageUtils.isTrue(this.message.getContextualProperty("ws-security.enableRevocation"));
        if (enableRevocation && crypto != null) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            String encrUser = (String)this.message.getContextualProperty("ws-security.encryption.username");
            if (encrUser == null) {
                try {
                    encrUser = crypto.getDefaultX509Identifier();
                }
                catch (WSSecurityException e1) {
                    throw new Fault(e1);
                }
            }
            cryptoType.setAlias(encrUser);
            X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
            if (certs != null && certs.length > 0) {
                crypto.verifyTrust(certs, enableRevocation);
            }
        }
        return crypto;
    }

    public Crypto getCrypto(TokenWrapper wrapper, String cryptoKey, String propKey) throws WSSecurityException {
        Properties properties;
        Object o;
        Crypto crypto;
        block20: {
            crypto = (Crypto)this.message.getContextualProperty(cryptoKey);
            if (crypto != null) {
                return crypto;
            }
            o = this.message.getContextualProperty(propKey);
            if (o == null) {
                return null;
            }
            crypto = this.getCryptoCache().get(o);
            if (crypto != null) {
                return crypto;
            }
            properties = null;
            if (o instanceof Properties) {
                properties = (Properties)o;
            } else {
                if (o instanceof String) {
                    ResourceManager rm = this.message.getExchange().get(Bus.class).getExtension(ResourceManager.class);
                    URL url = rm.resolveResource((String)o, URL.class);
                    try {
                        if (url == null) {
                            url = ClassLoaderUtils.getResource((String)o, this.getClass());
                        }
                        if (url == null) {
                            try {
                                url = new URL((String)o);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (url != null) {
                            InputStream ins = url.openStream();
                            properties = new Properties();
                            properties.load(ins);
                            ins.close();
                        } else if (wrapper != null) {
                            this.policyNotAsserted((Assertion)wrapper, "Could not find properties file " + o);
                        }
                        break block20;
                    }
                    catch (IOException e) {
                        if (wrapper != null) {
                            this.policyNotAsserted((Assertion)wrapper, e);
                        }
                        break block20;
                    }
                }
                if (o instanceof URL) {
                    properties = new Properties();
                    try {
                        InputStream ins = ((URL)o).openStream();
                        properties.load(ins);
                        ins.close();
                    }
                    catch (IOException e) {
                        if (wrapper == null) break block20;
                        this.policyNotAsserted((Assertion)wrapper, e);
                    }
                }
            }
        }
        if (properties != null) {
            crypto = CryptoFactory.getInstance((Properties)properties);
            this.getCryptoCache().put(o, crypto);
        }
        return crypto;
    }

    public void setKeyIdentifierType(WSSecBase secBase, TokenWrapper wrapper, Token token) {
        boolean tokenTypeSet = false;
        if (token instanceof X509Token) {
            X509Token x509Token = (X509Token)token;
            if (x509Token.isRequireIssuerSerialReference()) {
                secBase.setKeyIdentifierType(2);
                tokenTypeSet = true;
            } else if (x509Token.isRequireKeyIdentifierReference()) {
                secBase.setKeyIdentifierType(4);
                tokenTypeSet = true;
            } else if (x509Token.isRequireThumbprintReference()) {
                secBase.setKeyIdentifierType(8);
                tokenTypeSet = true;
            }
        } else if (token instanceof KeyValueToken) {
            secBase.setKeyIdentifierType(13);
            tokenTypeSet = true;
        }
        this.policyAsserted(token);
        this.policyAsserted(wrapper);
        if (!tokenTypeSet) {
            if (token.getInclusion() == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
                Wss10 wss = this.getWss10();
                this.policyAsserted(wss);
                if (wss == null || wss.isMustSupportRefKeyIdentifier()) {
                    secBase.setKeyIdentifierType(4);
                } else if (wss.isMustSupportRefIssuerSerial()) {
                    secBase.setKeyIdentifierType(2);
                } else if (wss instanceof Wss11 && ((Wss11)wss).isMustSupportRefThumbprint()) {
                    secBase.setKeyIdentifierType(8);
                }
            } else {
                secBase.setKeyIdentifierType(1);
            }
        }
    }

    public String setEncryptionUser(WSSecEncryptedKey encrKeyBuilder, TokenWrapper token, boolean sign, Crypto crypto) {
        String encrUser = (String)this.message.getContextualProperty(sign ? "ws-security.signature.username" : "ws-security.encryption.username");
        if (crypto != null && encrUser == null) {
            try {
                encrUser = crypto.getDefaultX509Identifier();
            }
            catch (WSSecurityException e1) {
                throw new Fault(e1);
            }
        } else if (encrUser == null || "".equals(encrUser)) {
            this.policyNotAsserted((Assertion)token, "No " + (sign ? "signature" : "encryption") + " crypto object found.");
        }
        if (encrUser == null || "".equals(encrUser)) {
            this.policyNotAsserted((Assertion)token, "A " + (sign ? "signature" : "encryption") + " username needs to be declared.");
        }
        if ("useReqSigCert".equals(encrUser)) {
            List<WSHandlerResult> results = CastUtils.cast((List)this.message.getExchange().getInMessage().get("RECV_RESULTS"));
            if (results != null) {
                encrKeyBuilder.setUseThisCert(AbstractBindingBuilder.getReqSigCert(results));
                if (encrKeyBuilder.isCertSet()) {
                    encrKeyBuilder.setUserInfo(AbstractBindingBuilder.getUsername(results));
                }
            } else {
                this.policyNotAsserted((Assertion)token, "No security results in incoming message");
            }
        } else {
            encrKeyBuilder.setUserInfo(encrUser);
        }
        return encrUser;
    }

    private static X509Certificate getReqSigCert(List<WSHandlerResult> results) {
        for (WSHandlerResult rResult : results) {
            List wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 2) continue;
                return (X509Certificate)wser.get((Object)"x509-certificate");
            }
        }
        return null;
    }

    public static String getUsername(List<WSHandlerResult> results) {
        for (WSHandlerResult rResult : results) {
            List wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 1) continue;
                WSUsernameTokenPrincipal principal = (WSUsernameTokenPrincipal)wser.get((Object)"principal");
                return principal.getName();
            }
        }
        return null;
    }

    protected Wss10 getWss10() {
        Iterator<AssertionInfo> i$;
        Collection<AssertionInfo> ais = this.aim.getAssertionInfo(SP12Constants.WSS10);
        if (ais != null && (i$ = ais.iterator()).hasNext()) {
            AssertionInfo ai = i$.next();
            return (Wss10)ai.getAssertion();
        }
        ais = this.aim.getAssertionInfo(SP12Constants.WSS11);
        if (ais != null && (i$ = ais.iterator()).hasNext()) {
            AssertionInfo ai = i$.next();
            return (Wss10)ai.getAssertion();
        }
        return null;
    }

    private void checkForX509PkiPath(WSSecSignature sig, Token token) {
        X509Token x509Token;
        if (token instanceof X509Token && ((x509Token = (X509Token)token).getTokenVersionAndType().equals("WssX509PkiPathV1Token10") || x509Token.getTokenVersionAndType().equals("WssX509PkiPathV1Token11"))) {
            sig.setUseSingleCertificate(false);
        }
    }

    protected WSSecSignature getSignatureBuilder(TokenWrapper wrapper, Token token, boolean endorse) throws WSSecurityException {
        return this.getSignatureBuilder(wrapper, token, false, endorse);
    }

    protected WSSecSignature getSignatureBuilder(TokenWrapper wrapper, Token token, boolean attached, boolean endorse) throws WSSecurityException {
        String user;
        Crypto crypto;
        boolean alsoIncludeToken;
        WSSecSignature sig;
        block24: {
            sig = new WSSecSignature(this.wssConfig);
            this.checkForX509PkiPath(sig, token);
            alsoIncludeToken = false;
            if (token instanceof IssuedToken || token instanceof SamlToken) {
                String sigTokId;
                this.policyAsserted(token);
                this.policyAsserted(wrapper);
                SecurityToken securityToken = this.getSecurityToken();
                String tokenType = securityToken.getTokenType();
                Element ref = attached ? securityToken.getAttachedReference() : securityToken.getUnattachedReference();
                if (ref != null) {
                    SecurityTokenReference secRef = new SecurityTokenReference(this.cloneElement(ref), false);
                    sig.setSecurityTokenReference(secRef);
                    sig.setKeyIdentifierType(12);
                } else {
                    int type;
                    int n = type = attached ? 9 : 11;
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
                        sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                        sig.setKeyIdentifierType(12);
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                        sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
                        sig.setKeyIdentifierType(12);
                    } else {
                        sig.setCustomTokenValueType(tokenType);
                        sig.setKeyIdentifierType(type);
                    }
                }
                if (attached) {
                    sigTokId = securityToken.getWsuId();
                    if (sigTokId == null) {
                        sigTokId = securityToken.getId();
                    }
                    if (sigTokId.startsWith("#")) {
                        sigTokId = sigTokId.substring(1);
                    }
                } else {
                    sigTokId = securityToken.getId();
                }
                sig.setCustomTokenId(sigTokId);
            } else {
                this.setKeyIdentifierType((WSSecBase)sig, wrapper, token);
                if (token instanceof X509Token && token.getInclusion() != SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER && sig.getKeyIdentifierType() != 1 && sig.getKeyIdentifierType() != 13) {
                    alsoIncludeToken = true;
                }
            }
            boolean encryptCrypto = false;
            String userNameKey = "ws-security.signature.username";
            String type = "signature";
            if (this.binding instanceof SymmetricBinding && !endorse) {
                encryptCrypto = ((SymmetricBinding)this.binding).getProtectionToken() != null;
                userNameKey = "ws-security.encryption.username";
            }
            Crypto crypto2 = crypto = encryptCrypto ? this.getEncryptionCrypto(wrapper) : this.getSignatureCrypto(wrapper);
            if (endorse && crypto == null && this.binding instanceof SymmetricBinding) {
                type = "encryption";
                userNameKey = "ws-security.encryption.username";
                crypto = this.getEncryptionCrypto(wrapper);
            }
            if (!endorse) {
                this.message.getExchange().put("ws-security.signature.crypto", crypto);
            }
            if (StringUtils.isEmpty(user = (String)this.message.getContextualProperty(userNameKey))) {
                if (crypto != null) {
                    try {
                        user = crypto.getDefaultX509Identifier();
                        if (StringUtils.isEmpty(user)) {
                            this.policyNotAsserted((Assertion)token, "No configured " + type + " username detected");
                            return null;
                        }
                        break block24;
                    }
                    catch (WSSecurityException e1) {
                        LOG.log(Level.FINE, e1.getMessage(), e1);
                        throw new Fault(e1);
                    }
                }
                this.policyNotAsserted((Assertion)token, "Security configuration could not be detected. Potential cause: Make sure jaxws:client element with name attribute value matching endpoint port is defined as well as a ws-security.signature.properties element within it.");
                return null;
            }
        }
        String password = this.getPassword(user, token, 3);
        sig.setUserInfo(user, password);
        sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getAsymmetricSignature());
        sig.setDigestAlgo(this.binding.getAlgorithmSuite().getDigest());
        sig.setSigCanonicalization(this.binding.getAlgorithmSuite().getInclusiveC14n());
        sig.setWsConfig(this.wssConfig);
        try {
            sig.prepare((Document)this.saaj.getSOAPPart(), crypto, this.secHeader);
        }
        catch (WSSecurityException e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.policyNotAsserted((Assertion)token, (Exception)((Object)e));
        }
        if (alsoIncludeToken) {
            this.includeToken(user, crypto, sig);
        }
        return sig;
    }

    private void includeToken(String user, Crypto crypto, WSSecSignature sig) throws WSSecurityException {
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(user);
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        PKIPathSecurity bstToken = null;
        if (!sig.isUseSingleCertificate()) {
            bstToken = new PKIPathSecurity((Document)this.saaj.getSOAPPart());
            bstToken.setX509Certificates(certs, crypto);
        } else {
            bstToken = new X509Security((Document)this.saaj.getSOAPPart());
            ((X509Security)bstToken).setX509Certificate(certs[0]);
        }
        bstToken.setID(this.wssConfig.getIdAllocator().createSecureId("X509-", (Object)certs[0]));
        WSSecurityUtil.prependChildElement((Element)this.secHeader.getSecurityHeader(), (Element)bstToken.getElement());
        this.bstElement = bstToken.getElement();
    }

    protected void doEndorsedSignatures(Map<Token, Object> tokenMap, boolean isTokenProtection, boolean isSigProtect) {
        for (Map.Entry<Token, Object> ent : tokenMap.entrySet()) {
            Object tempTok = ent.getValue();
            ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
            WSEncryptionPart sigPart = new WSEncryptionPart(this.mainSigId);
            sigPart.setElement(this.bottomUpElement);
            sigParts.add(sigPart);
            if (tempTok instanceof WSSecSignature) {
                WSSecSignature sig = (WSSecSignature)tempTok;
                if (isTokenProtection && sig.getBSTTokenId() != null) {
                    WSEncryptionPart bstPart = new WSEncryptionPart(sig.getBSTTokenId());
                    bstPart.setElement(sig.getBinarySecurityTokenElement());
                    sigParts.add(bstPart);
                }
                try {
                    List referenceList = sig.addReferencesToSign(sigParts, this.secHeader);
                    sig.computeSignature(referenceList, false, null);
                    this.signatures.add(sig.getSignatureValue());
                    if (!isSigProtect) continue;
                    WSEncryptionPart part = new WSEncryptionPart(sig.getId(), "Element");
                    this.encryptedTokensList.add(part);
                }
                catch (WSSecurityException e) {
                    this.policyNotAsserted((Assertion)ent.getKey(), (Exception)((Object)e));
                }
                continue;
            }
            if (tempTok instanceof WSSecurityTokenHolder) {
                SecurityToken token = ((WSSecurityTokenHolder)((Object)tempTok)).getToken();
                if (isTokenProtection) {
                    sigParts.add(new WSEncryptionPart(token.getId()));
                }
                try {
                    if (ent.getKey().isDerivedKeys()) {
                        this.doSymmSignatureDerived(ent.getKey(), token, sigParts, isTokenProtection);
                        continue;
                    }
                    this.doSymmSignature(ent.getKey(), token, sigParts, isTokenProtection);
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                }
                continue;
            }
            if (!(tempTok instanceof WSSecUsernameToken)) continue;
            WSSecUsernameToken utBuilder = (WSSecUsernameToken)tempTok;
            String id = utBuilder.getId();
            Date created = new Date();
            Date expires = new Date();
            expires.setTime(created.getTime() + 300000L);
            SecurityToken secToken = new SecurityToken(id, utBuilder.getUsernameTokenElement(), created, expires);
            if (isTokenProtection) {
                sigParts.add(new WSEncryptionPart(secToken.getId()));
            }
            try {
                byte[] secret = utBuilder.getDerivedKey();
                secToken.setSecret(secret);
                if (ent.getKey().isDerivedKeys()) {
                    this.doSymmSignatureDerived(ent.getKey(), secToken, sigParts, isTokenProtection);
                    continue;
                }
                this.doSymmSignature(ent.getKey(), secToken, sigParts, isTokenProtection);
            }
            catch (Exception e) {
                LOG.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    private void doSymmSignatureDerived(Token policyToken, SecurityToken tok, List<WSEncryptionPart> sigParts, boolean isTokenProtection) throws WSSecurityException, ConversationException {
        Element ref;
        SOAPPart doc = this.saaj.getSOAPPart();
        WSSecDKSign dkSign = new WSSecDKSign(this.wssConfig);
        if (SP12Constants.INSTANCE == policyToken.getSPConstants()) {
            dkSign.setWscVersion(2);
        }
        boolean attached = false;
        if (this.includeToken(policyToken.getInclusion())) {
            attached = true;
        }
        if ((ref = attached ? tok.getAttachedReference() : tok.getUnattachedReference()) != null) {
            ref = this.cloneElement(ref);
            dkSign.setExternalKey(tok.getSecret(), ref);
        } else if (!this.isRequestor() && policyToken.isDerivedKeys()) {
            SecurityTokenReference tokenRef = new SecurityTokenReference((Document)doc);
            if (tok.getSHA1() != null) {
                tokenRef.setKeyIdentifierEncKeySHA1(tok.getSHA1());
                tokenRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            }
            dkSign.setExternalKey(tok.getSecret(), tokenRef.getElement());
        } else {
            dkSign.setExternalKey(tok.getSecret(), tok.getId());
        }
        dkSign.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getSymmetricSignature());
        dkSign.setDerivedKeyLength(this.binding.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
        if (tok.getSHA1() != null) {
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        } else if (policyToken instanceof UsernameToken) {
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        }
        dkSign.prepare((Document)doc, this.secHeader);
        if (isTokenProtection) {
            String sigTokId = tok.getId();
            if (sigTokId.startsWith("#")) {
                sigTokId = sigTokId.substring(1);
            }
            sigParts.add(new WSEncryptionPart(sigTokId));
        }
        dkSign.setParts(sigParts);
        List referenceList = dkSign.addReferencesToSign(sigParts, this.secHeader);
        this.addSupportingElement(dkSign.getdktElement());
        dkSign.computeSignature(referenceList, false, null);
        this.signatures.add(dkSign.getSignatureValue());
    }

    private void doSymmSignature(Token policyToken, SecurityToken tok, List<WSEncryptionPart> sigParts, boolean isTokenProtection) throws WSSecurityException, ConversationException {
        SOAPPart doc = this.saaj.getSOAPPart();
        WSSecSignature sig = new WSSecSignature(this.wssConfig);
        if (policyToken instanceof X509Token) {
            if (this.isRequestor()) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                sig.setKeyIdentifierType(9);
            } else {
                sig.setEncrKeySha1value(tok.getSHA1());
                sig.setKeyIdentifierType(10);
            }
        } else {
            String tokenType = tok.getTokenType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
            } else if (tokenType != null) {
                sig.setCustomTokenValueType(tokenType);
            } else if (policyToken instanceof UsernameToken) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
            } else {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            }
            sig.setKeyIdentifierType(9);
        }
        String sigTokId = tok.getWsuId();
        if (sigTokId == null) {
            sigTokId = tok.getId();
        }
        if (sigTokId.startsWith("#")) {
            sigTokId = sigTokId.substring(1);
        }
        sig.setCustomTokenId(sigTokId);
        sig.setSecretKey(tok.getSecret());
        sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getAsymmetricSignature());
        sig.setSignatureAlgorithm(this.binding.getAlgorithmSuite().getSymmetricSignature());
        sig.prepare((Document)doc, this.getSignatureCrypto(null), this.secHeader);
        sig.setParts(sigParts);
        List referenceList = sig.addReferencesToSign(sigParts, this.secHeader);
        sig.computeSignature(referenceList, false, null);
        this.signatures.add(sig.getSignatureValue());
    }

    protected void assertSupportingTokens(List<WSEncryptionPart> sigs) {
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SIGNED_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.ENDORSING_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.SUPPORTING_TOKENS));
        this.assertSupportingTokens(this.findAndAssertPolicy(SP12Constants.ENCRYPTED_SUPPORTING_TOKENS));
    }

    protected void addSupportingTokens(List<WSEncryptionPart> sigs) throws WSSecurityException {
        Collection<Assertion> sgndSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_SUPPORTING_TOKENS);
        Map<Token, Object> sigSuppTokMap = this.handleSupportingTokens(sgndSuppTokens, false);
        Collection<Assertion> endSuppTokens = this.findAndAssertPolicy(SP12Constants.ENDORSING_SUPPORTING_TOKENS);
        this.endSuppTokMap = this.handleSupportingTokens(endSuppTokens, true);
        Collection<Assertion> sgndEndSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS);
        this.sgndEndSuppTokMap = this.handleSupportingTokens(sgndEndSuppTokens, true);
        Collection<Assertion> sgndEncryptedSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS);
        Map<Token, Object> sgndEncSuppTokMap = this.handleSupportingTokens(sgndEncryptedSuppTokens, false);
        Collection<Assertion> endorsingEncryptedSuppTokens = this.findAndAssertPolicy(SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
        this.endEncSuppTokMap = this.handleSupportingTokens(endorsingEncryptedSuppTokens, true);
        Collection<Assertion> sgndEndEncSuppTokens = this.findAndAssertPolicy(SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
        this.sgndEndEncSuppTokMap = this.handleSupportingTokens(sgndEndEncSuppTokens, true);
        Collection<Assertion> supportingToks = this.findAndAssertPolicy(SP12Constants.SUPPORTING_TOKENS);
        this.handleSupportingTokens(supportingToks, false);
        Collection<Assertion> encryptedSupportingToks = this.findAndAssertPolicy(SP12Constants.ENCRYPTED_SUPPORTING_TOKENS);
        this.handleSupportingTokens(encryptedSupportingToks, false);
        this.addSignatureParts(sigSuppTokMap, sigs);
        this.addSignatureParts(sgndEncSuppTokMap, sigs);
        this.addSignatureParts(this.sgndEndSuppTokMap, sigs);
        this.addSignatureParts(this.sgndEndEncSuppTokMap, sigs);
    }

    protected void doEndorse() {
        boolean tokenProtect = false;
        boolean sigProtect = false;
        if (this.binding instanceof AsymmetricBinding) {
            tokenProtect = ((AsymmetricBinding)this.binding).isTokenProtection();
            sigProtect = ((AsymmetricBinding)this.binding).isSignatureProtection();
        } else if (this.binding instanceof SymmetricBinding) {
            tokenProtect = ((SymmetricBinding)this.binding).isTokenProtection();
            sigProtect = ((SymmetricBinding)this.binding).isSignatureProtection();
        }
        this.endSuppTokMap.putAll(this.endEncSuppTokMap);
        this.doEndorsedSignatures(this.endSuppTokMap, tokenProtect, sigProtect);
        this.sgndEndSuppTokMap.putAll(this.sgndEndEncSuppTokMap);
        this.doEndorsedSignatures(this.sgndEndSuppTokMap, tokenProtect, sigProtect);
    }

    protected void addSignatureConfirmation(List<WSEncryptionPart> sigParts) {
        Wss10 wss10 = this.getWss10();
        if (!(wss10 instanceof Wss11) || !((Wss11)wss10).isRequireSignatureConfirmation()) {
            return;
        }
        List<WSHandlerResult> results = CastUtils.cast((List)this.message.getExchange().getInMessage().get("RECV_RESULTS"));
        ArrayList signatureActions = new ArrayList();
        for (WSHandlerResult wshResult : results) {
            WSSecurityUtil.fetchAllActionResults((List)wshResult.getResults(), (int)2, signatureActions);
            WSSecurityUtil.fetchAllActionResults((List)wshResult.getResults(), (int)64, signatureActions);
        }
        this.sigConfList = new ArrayList<WSEncryptionPart>();
        WSSecSignatureConfirmation wsc = new WSSecSignatureConfirmation(this.wssConfig);
        if (signatureActions.size() > 0) {
            for (WSSecurityEngineResult wsr : signatureActions) {
                byte[] sigVal = (byte[])wsr.get((Object)"signature-value");
                wsc.setSignatureValue(sigVal);
                wsc.prepare((Document)this.saaj.getSOAPPart());
                this.addSupportingElement(wsc.getSignatureConfirmationElement());
                if (sigParts == null) continue;
                WSEncryptionPart part = new WSEncryptionPart(wsc.getId(), "Element");
                part.setElement(wsc.getSignatureConfirmationElement());
                sigParts.add(part);
                this.sigConfList.add(part);
            }
        } else {
            wsc.prepare((Document)this.saaj.getSOAPPart());
            this.addSupportingElement(wsc.getSignatureConfirmationElement());
            if (sigParts != null) {
                WSEncryptionPart part = new WSEncryptionPart(wsc.getId(), "Element");
                part.setElement(wsc.getSignatureConfirmationElement());
                sigParts.add(part);
                this.sigConfList.add(part);
            }
        }
    }

    public void handleEncryptedSignedHeaders(List<WSEncryptionPart> encryptedParts, List<WSEncryptionPart> signedParts) {
        ArrayList<WSEncryptionPart> signedEncryptedParts = new ArrayList<WSEncryptionPart>();
        for (WSEncryptionPart encryptedPart : encryptedParts) {
            Iterator<WSEncryptionPart> signedPartsIt = signedParts.iterator();
            while (signedPartsIt.hasNext()) {
                WSEncryptionPart signedPart = signedPartsIt.next();
                if (signedPart.getId() == null && !"Token".equals(signedPart.getName())) {
                    throw new IllegalArgumentException("WSEncryptionPart must be ID based but no id was found.");
                }
                if (!encryptedPart.getEncModifier().equals("Element") || !signedPart.getId().equals(encryptedPart.getId())) continue;
                signedPartsIt.remove();
                WSEncryptionPart part = new WSEncryptionPart(encryptedPart.getEncId(), encryptedPart.getEncModifier());
                part.setElement(encryptedPart.getElement());
                signedEncryptedParts.add(part);
            }
        }
        signedParts.addAll(signedEncryptedParts);
    }

    public WSEncryptionPart convertToEncryptionPart(Element element) {
        String id = this.addWsuIdToElement(element);
        WSEncryptionPart part = new WSEncryptionPart(id);
        part.setElement(element);
        return part;
    }

    protected boolean includeToken(SPConstants.IncludeTokenType inclusion) {
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS) {
            return true;
        }
        return this.isRequestor() ? inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT || inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE : inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_INITIATOR;
    }
}

