/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class StressTester
implements Runnable {
    private URL url;
    private String name;

    StressTester(URL url, String name) {
        this.url = url;
        this.name = name;
    }

    @Override
    public void run() {
        System.out.println(this.name + " starting");
        String cookie = null;
        int count = 0;
        while (true) {
            ++count;
            try {
                String header;
                HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
                if (cookie != null) {
                    conn.addRequestProperty("Cookie", cookie);
                }
                conn.connect();
                int rc = conn.getResponseCode();
                if (cookie == null && (header = conn.getHeaderField("Set-Cookie")) != null) {
                    int semi = header.indexOf(59);
                    cookie = semi > 0 ? header.substring(0, semi) : header;
                }
                InputStream is = conn.getInputStream();
                while (is.read() != -1) {
                }
                is.close();
                if (rc == 200 && count % 1000 != 0) continue;
                StringBuilder sb = new StringBuilder(this.name);
                sb.append('-');
                sb.append(count);
                sb.append('-');
                sb.append(rc);
                sb.append('-');
                sb.append(cookie);
                System.out.println(sb.toString());
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        try {
            int i;
            int threadCount = Integer.parseInt(args[0]);
            int serverCount = args.length - 1;
            URL[] urls = new URL[serverCount];
            for (i = 1; i < args.length; ++i) {
                urls[i - 1] = new URL("http://" + args[i] + "/jbento-httpsession/SetListOfString16");
            }
            for (i = 0; i < threadCount; ++i) {
                StressTester tester = new StressTester(urls[i % serverCount], "Thread" + i);
                Thread t = new Thread(tester);
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

