/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean.session.checks;

import java.util.List;
import org.ow2.easybeans.deployment.annotations.exceptions.InterceptorsValidationException;
import org.ow2.easybeans.deployment.annotations.helper.bean.checks.AccessChecker;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJInterceptors;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class InterceptorsValidator {
    private static final String AROUND_INVOKE_DESCRIPTOR_EJB = "(Ljavax/interceptor/InvocationContext;)Ljava/lang/Object;";
    private static final String LIFECYCLE_DESCRIPTOR_OUTSIDEBEAN = "(Ljavax/interceptor/InvocationContext;)V";
    private static final String LIFECYCLE_DESCRIPTOR_BEAN = "()V";
    private static final String AROUND_INVOKE_EXCEPTION = "java/lang/Exception";
    private static final String DEFAULT_CONSTRUCTOR_DESCRIPTOR = "()V";
    private static final String CONSTRUCTOR_METHOD = "<init>";

    private InterceptorsValidator() {
    }

    public static void validate(EasyBeansEjbJarClassMetadata bean) {
        EjbJarArchiveMetadata ejbMetaData = (EjbJarArchiveMetadata)bean.getEjbJarDeployableMetadata();
        if (bean.isBean()) {
            String[] interfaces;
            for (EasyBeansEjbJarMethodMetadata method : bean.getMethodMetadataCollection()) {
                IJInterceptors methodInterceptors;
                if (method.isLifeCycleMethod()) {
                    InterceptorsValidator.validateJMethod(method.getJMethod(), "()V", null, bean.getClassName());
                } else if (method.isAroundInvoke()) {
                    InterceptorsValidator.validateJMethod(method.getJMethod(), AROUND_INVOKE_DESCRIPTOR_EJB, AROUND_INVOKE_EXCEPTION, bean.getClassName());
                }
                if ((methodInterceptors = method.getAnnotationInterceptors()) == null) continue;
                for (String className : methodInterceptors.getClasses()) {
                    InterceptorsValidator.analyzeInterceptorClass(ejbMetaData, (EasyBeansEjbJarClassMetadata)bean.getLinkedClassMetadata(className));
                }
            }
            IJInterceptors methodInterceptors = bean.getAnnotationInterceptors();
            if (methodInterceptors != null) {
                for (String className : methodInterceptors.getClasses()) {
                    InterceptorsValidator.analyzeInterceptorClass(ejbMetaData, (EasyBeansEjbJarClassMetadata)bean.getLinkedClassMetadata(className));
                }
            }
            if ((interfaces = bean.getInterfaces()) != null) {
                for (String itf : interfaces) {
                    EasyBeansEjbJarClassMetadata interfaceMetaData = (EasyBeansEjbJarClassMetadata)bean.getLinkedClassMetadata(itf);
                    if (interfaceMetaData == null) continue;
                    for (EasyBeansEjbJarMethodMetadata method : interfaceMetaData.getMethodMetadataCollection()) {
                        if (method.isAroundInvoke()) {
                            throw new InterceptorsValidationException("The method '" + method + "' in the bean class '" + bean.getClassName() + "' cannot be an AroundInvoke as it is an interface");
                        }
                        if (!method.isLifeCycleMethod()) continue;
                        throw new InterceptorsValidationException("The method '" + method + "' in the bean class '" + bean.getClassName() + "' cannot be a lifecycle as it is an interface");
                    }
                }
            }
        }
        if (bean.isInterceptor()) {
            InterceptorsValidator.analyzeInterceptorClass(ejbMetaData, bean);
        }
    }

    private static void analyzeInterceptorClass(EjbJarArchiveMetadata ejbMetaData, EasyBeansEjbJarClassMetadata interceptorMetaData) {
        JMethod defaultConstructor;
        List<EasyBeansEjbJarMethodMetadata> aroundInvokeList = interceptorMetaData.getAroundInvokeMethodMetadatas();
        if (aroundInvokeList != null && aroundInvokeList.size() > 1) {
            String errMsg = "There are severals @AroundInvoke in the class '" + interceptorMetaData.getClassName() + "', while only one is allowed. List of Methods : '" + aroundInvokeList + "'.";
            int forCurrentClass = 0;
            for (EasyBeansEjbJarMethodMetadata method : aroundInvokeList) {
                if (method.getOriginalClassMetadata() != null) {
                    if (!((Object)((Object)method.getOriginalClassMetadata())).equals((Object)interceptorMetaData)) continue;
                    throw new InterceptorsValidationException(errMsg);
                }
                ++forCurrentClass;
            }
            if (forCurrentClass > 1) {
                throw new InterceptorsValidationException(errMsg);
            }
        }
        if (interceptorMetaData.getMethodMetadata(defaultConstructor = new JMethod(0, CONSTRUCTOR_METHOD, "()V", null, null)) == null) {
            throw new InterceptorsValidationException("No default constructor in the interceptor class '" + interceptorMetaData.getClassName() + "'.");
        }
        for (EasyBeansEjbJarMethodMetadata method : interceptorMetaData.getMethodMetadataCollection()) {
            if (method.isLifeCycleMethod() && !((EasyBeansEjbJarClassMetadata)method.getClassMetadata()).isBean()) {
                InterceptorsValidator.validateJMethod(method.getJMethod(), LIFECYCLE_DESCRIPTOR_OUTSIDEBEAN, null, interceptorMetaData.getClassName());
                continue;
            }
            if (!method.isAroundInvoke()) continue;
            InterceptorsValidator.validateJMethod(method.getJMethod(), AROUND_INVOKE_DESCRIPTOR_EJB, AROUND_INVOKE_EXCEPTION, interceptorMetaData.getClassName());
            AccessChecker.ensureNoAccess(16, method.getJMethod(), "Final", interceptorMetaData.getClassName());
            AccessChecker.ensureNoAccess(8, method.getJMethod(), "Static", interceptorMetaData.getClassName());
        }
    }

    private static void validateJMethod(JMethod jMethod, String desc, String awaitedException, String className) {
        if (!jMethod.getDescriptor().equals(desc)) {
            throw new InterceptorsValidationException("Method '" + jMethod + "' of the class '" + className + "' is not compliant with the signature '" + desc + "'. Signature found = '" + jMethod.getDescriptor() + "'.");
        }
        String[] exceptions = jMethod.getExceptions();
        if (awaitedException == null) {
            return;
        }
        boolean found = false;
        if (exceptions != null) {
            for (String exception : exceptions) {
                if (!exception.equals(awaitedException)) continue;
                found = true;
            }
        }
        if (!found) {
            throw new InterceptorsValidationException("Method '" + jMethod + "' of the class '" + className + "' is not compliant with the signature '" + desc + "' as the required exception '" + awaitedException + "' is missing.");
        }
    }
}

