/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Properties;
import org.objectweb.joram.mom.dest.AcquisitionNot;
import org.objectweb.joram.mom.dest.DistributionHandler;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class NotificationDistributionHandler
implements DistributionHandler {
    public static Logger logger = Debug.getLogger((String)NotificationDistributionHandler.class.getName());
    private AgentId remoteDestinationID = null;

    public void init(Properties properties, boolean firstTime) {
        this.remoteDestinationID = AgentId.fromString((String)properties.getProperty("remoteAgentID"));
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("--- " + this + " notification distribution handler bind to destination (" + this.remoteDestinationID + ")"));
        }
    }

    public void distribute(Message message) throws Exception {
        ClientMessages cm = new ClientMessages();
        cm.addMessage(message);
        AcquisitionNot an = new AcquisitionNot(cm, message.persistent, message.id);
        if (this.remoteDestinationID == null) {
            throw new Exception("Remote \"alias destination\" A3 agent identifier is null. Did you set the property \"remoteAgentID\" of the distribution destination?");
        }
        Channel.sendTo((AgentId)this.remoteDestinationID, (Notification)an);
    }

    public void close() {
    }
}

