/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.stream.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.proxies.GetConnectionNot;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.ReliableConnectionContext;
import org.objectweb.joram.mom.proxies.tcp.IOControl;
import org.objectweb.joram.mom.proxies.tcp.TcpConnection;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyService;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.stream.MetaData;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class TcpConnectionListener
extends Daemon {
    public static Logger logger = Debug.getLogger((String)TcpConnectionListener.class.getName());
    private TcpProxyService proxyService;
    private int timeout;
    public static final String CLOCK_SYNCHRO_THRESHOLD = "org.objectweb.joram.TcpConnection.ClockSynchro.Threshold";
    private long clockSynchroThreshold = 1000L;
    private int failedLoginCount;
    private int connectionCount;
    private int protocolErrorCount;

    public TcpConnectionListener(TcpProxyService proxyService, int timeout) {
        super("TcpConnectionListener", logger);
        this.proxyService = proxyService;
        this.timeout = timeout;
        this.clockSynchroThreshold = Configuration.getLong((String)CLOCK_SYNCHRO_THRESHOLD, (long)this.clockSynchroThreshold);
    }

    public void run() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpConnectionListener.run()");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        while (this.running) {
            this.canStop = true;
            try {
                this.acceptConnection();
            }
            catch (Exception exception) {}
        }
    }

    private void acceptConnection() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpConnectionListener.acceptConnection()");
        }
        Socket sock = this.proxyService.getServerSocket().accept();
        String inaddr = sock.getInetAddress().getHostAddress();
        ++this.connectionCount;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> accept connection from " + inaddr));
        }
        try {
            IOControl ioctrl;
            ReliableConnectionContext ctx;
            AgentId proxyId;
            long dt;
            sock.setTcpNoDelay(true);
            sock.setSoTimeout(this.timeout);
            InputStream is = sock.getInputStream();
            NetOutputStream nos = new NetOutputStream(sock);
            byte[] magic = StreamUtil.readByteArrayFrom((InputStream)is, (int)8);
            for (int i = 0; i < 5; ++i) {
                if (magic.length != i && (magic[i] == MetaData.joramMagic[i] || magic[i] <= 0)) continue;
                String errorMsg = "Bad magic number. Client is not compatible with JORAM.";
                logger.log(BasicLevel.ERROR, (Object)errorMsg);
                ++this.protocolErrorCount;
                throw new IllegalAccessException(errorMsg);
            }
            if (magic[7] != MetaData.joramMagic[7]) {
                if (magic[7] > 0 && MetaData.joramMagic[7] > 0) {
                    String errorMsg = "Bad protocol version number " + magic[7] + " != " + MetaData.joramMagic[7];
                    logger.log(BasicLevel.ERROR, (Object)errorMsg);
                    ++this.protocolErrorCount;
                    throw new IllegalAccessException(errorMsg);
                }
                logger.log(BasicLevel.WARN, (Object)("Wildcard protocol version number: from stream = " + magic[7] + ", from MetaData = " + MetaData.joramMagic[7]));
            }
            if ((dt = Math.abs(StreamUtil.readLongFrom((InputStream)is) - System.currentTimeMillis())) > this.clockSynchroThreshold) {
                logger.log(BasicLevel.WARN, (Object)(" -> bad clock synchronization between client and server: " + dt));
            }
            StreamUtil.writeTo((long)dt, (OutputStream)nos);
            Identity identity = Identity.read((InputStream)is);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> read identity = " + identity));
            }
            int key = StreamUtil.readIntFrom((InputStream)is);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> read key = " + key));
            }
            int heartBeat = 0;
            if (key == -1) {
                heartBeat = StreamUtil.readIntFrom((InputStream)is);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> read heartBeat = " + heartBeat));
                }
            }
            GetProxyIdNot gpin = new GetProxyIdNot(identity, inaddr);
            try {
                gpin.invoke(AdminTopic.getDefault());
                proxyId = gpin.getProxyId();
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
                ++this.failedLoginCount;
                StreamUtil.writeTo((int)1, (OutputStream)nos);
                StreamUtil.writeTo((String)exc.getMessage(), (OutputStream)nos);
                nos.send();
                return;
            }
            if (key == -1) {
                OpenConnectionNot ocn = new OpenConnectionNot(true, heartBeat);
                ocn.invoke(proxyId);
                StreamUtil.writeTo((int)0, (OutputStream)nos);
                ctx = (ReliableConnectionContext)ocn.getConnectionContext();
                key = ctx.getKey();
                StreamUtil.writeTo((int)key, (OutputStream)nos);
                nos.send();
                ioctrl = new IOControl(sock);
            } else {
                GetConnectionNot gcn = new GetConnectionNot(key);
                try {
                    gcn.invoke(proxyId);
                }
                catch (Exception exc) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                    }
                    StreamUtil.writeTo((int)1, (OutputStream)nos);
                    StreamUtil.writeTo((String)exc.getMessage(), (OutputStream)nos);
                    nos.send();
                    return;
                }
                ctx = (ReliableConnectionContext)gcn.getConnectionContext();
                StreamUtil.writeTo((int)0, (OutputStream)nos);
                nos.send();
                ioctrl = new IOControl(sock, ctx.getInputCounter());
                TcpConnection tcpConnection = this.proxyService.getConnection(proxyId, key);
                if (tcpConnection != null) {
                    tcpConnection.close();
                }
            }
            sock.setSoTimeout(0);
            TcpConnection tcpConnection = new TcpConnection(ioctrl, ctx, proxyId, this.proxyService, identity);
            tcpConnection.start();
        }
        catch (IllegalAccessException exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            sock.close();
            throw exc;
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            sock.close();
            throw exc;
        }
    }

    protected void shutdown() {
        this.close();
    }

    protected void close() {
        this.proxyService.resetServerSocket();
    }

    public int getFailedLoginCount() {
        return this.failedLoginCount;
    }

    public int getInitiatedConnectionCount() {
        return this.connectionCount;
    }

    public int getProtocolErrorCount() {
        return this.protocolErrorCount;
    }

    static class NetOutputStream
    extends ByteArrayOutputStream {
        private OutputStream os = null;

        NetOutputStream(Socket sock) throws IOException {
            super(1024);
            this.reset();
            this.os = sock.getOutputStream();
        }

        public void reset() {
            this.count = 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send() throws IOException {
            try {
                this.buf[0] = (byte)(this.count - 4 >>> 24);
                this.buf[1] = (byte)(this.count - 4 >>> 16);
                this.buf[2] = (byte)(this.count - 4 >>> 8);
                this.buf[3] = (byte)(this.count - 4 >>> 0);
                this.writeTo(this.os);
                this.os.flush();
            }
            finally {
                this.reset();
            }
        }
    }
}

