/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.tenant.listener;

import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.easybeans.api.event.bean.EZBMessageDrivenInfo;
import org.ow2.easybeans.api.event.naming.EZBJavaContextNamingEvent;
import org.ow2.jonas.lib.tenant.context.TenantCurrent;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IActivationConfigProperty;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventListener;

public class TenantEventListener
implements IEventListener {
    private String separator;
    private final String DESTINATION_PROPERTY_NAME = "destination";

    public TenantEventListener(String separator) {
        this.separator = separator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(IEvent event) {
        if (event instanceof EZBMessageDrivenInfo) {
            EZBMessageDrivenInfo mEvent = (EZBMessageDrivenInfo)event;
            List properties = mEvent.getActivationConfigProperties();
            for (IActivationConfigProperty property : properties) {
                if (!"destination".equals(property.propertyName())) continue;
                String oldValue = property.propertyValue();
                String tenanId = this.getTenantId();
                if (tenanId == null || "T0".equals(tenanId)) continue;
                property.setPropertyValue(tenanId + this.separator + oldValue);
            }
            return;
        } else {
            if (!(event instanceof EZBJavaContextNamingEvent)) return;
            EZBJavaContextNamingEvent ene = (EZBJavaContextNamingEvent)event;
            Context javaContext = ene.getJavaContext();
            String tenantId = this.getTenantId();
            try {
                if (tenantId == null) return;
                javaContext.rebind("comp/tenantId", (Object)this.getTenantId());
                return;
            }
            catch (NamingException e) {
                TenantEventListener.throwException(ene, new IllegalStateException("Cannot lookup java:comp element.", e));
            }
        }
    }

    public boolean accept(IEvent event) {
        EZBJavaContextNamingEvent javaContextNamingEvent;
        if (event instanceof EZBMessageDrivenInfo) {
            EZBMessageDrivenInfo mEvent = (EZBMessageDrivenInfo)event;
            return !mEvent.getActivationConfigProperties().isEmpty();
        }
        return event instanceof EZBJavaContextNamingEvent && "java:".equals((javaContextNamingEvent = (EZBJavaContextNamingEvent)event).getEventProviderId());
    }

    public EventPriority getPriority() {
        return EventPriority.SYNC_NORM;
    }

    private String getTenantId() {
        String tenantId = null;
        if (TenantCurrent.getCurrent().getTenantContext() != null) {
            tenantId = TenantCurrent.getCurrent().getTenantContext().getTenantId();
        }
        return tenantId;
    }

    private static void throwException(EZBJavaContextNamingEvent event, Throwable throwable) {
        event.addThrowable(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException("Wrapping cause", throwable);
    }
}

