/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.db.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.hsqldb.Server;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.db.DBService;
import org.ow2.jonas.db.base.AbsDBServiceImpl;
import org.ow2.jonas.db.base.User;
import org.ow2.jonas.db.hsqldb.HsqlDBServiceImplMBean;
import org.ow2.jonas.service.ServiceException;

public class HsqlDBServiceImpl
extends AbsDBServiceImpl
implements DBService,
HsqlDBServiceImplMBean,
Pojo {
    private InstanceManager __IM;
    private boolean __Fusers;
    private List<User> users;
    private boolean __FdatabaseName;
    private String databaseName;
    private static final String DEFAULT_PORT = "9001";
    private static final int SLEEP_VALUE = 100;
    private static final int MAX_RETRY_NB = 20;
    private boolean __Fserver;
    private Server server;
    private boolean __MinitServer$java_util_List$java_lang_String$java_lang_String;
    private boolean __MdoStart;
    private boolean __MdoStop;

    List __getusers() {
        if (!this.__Fusers) {
            return this.users;
        }
        return (List)this.__IM.onGet((Object)this, "users");
    }

    void __setusers(List list) {
        if (!this.__Fusers) {
            this.users = list;
            return;
        }
        this.__IM.onSet((Object)this, "users", (Object)list);
    }

    String __getdatabaseName() {
        if (!this.__FdatabaseName) {
            return this.databaseName;
        }
        return (String)this.__IM.onGet((Object)this, "databaseName");
    }

    void __setdatabaseName(String string) {
        if (!this.__FdatabaseName) {
            this.databaseName = string;
            return;
        }
        this.__IM.onSet((Object)this, "databaseName", (Object)string);
    }

    Server __getserver() {
        if (!this.__Fserver) {
            return this.server;
        }
        return (Server)this.__IM.onGet((Object)this, "server");
    }

    void __setserver(Server server) {
        if (!this.__Fserver) {
            this.server = server;
            return;
        }
        this.__IM.onSet((Object)this, "server", (Object)server);
    }

    public HsqlDBServiceImpl() {
        this(null);
    }

    private HsqlDBServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setusers(null);
        this.__setdatabaseName(null);
        this.__setserver(null);
    }

    protected void initServer(List<User> users, String databaseName, String portNumber) throws ServiceException {
        if (!this.__MinitServer$java_util_List$java_lang_String$java_lang_String) {
            this.__M_initServer(users, databaseName, portNumber);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initServer$java_util_List$java_lang_String$java_lang_String", new Object[]{users, databaseName, portNumber});
            this.__M_initServer(users, databaseName, portNumber);
            this.__IM.onExit((Object)this, "initServer$java_util_List$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initServer$java_util_List$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_initServer(List<User> users, String databaseName, String portNumber) throws ServiceException {
        this.__setusers(users);
        this.portNumber = portNumber != null ? portNumber : DEFAULT_PORT;
        this.__setdatabaseName(databaseName);
        this.__setserver(new Server());
        if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.__getserver().setLogWriter(null);
            this.__getserver().setErrWriter(null);
            this.__getserver().setSilent(true);
            this.__getserver().setTrace(false);
            this.__getserver().setLogWriter(null);
        } else {
            this.__getserver().setSilent(false);
            this.__getserver().setTrace(true);
        }
        String baseDir = this.getServerProperties().getWorkDirectory() + File.separator + "hsqldb" + File.separator + databaseName;
        String pString = "";
        if (portNumber != null) {
            pString = ";port=" + portNumber;
        }
        String serverProps = "database.0=" + baseDir + ";dbname.0=" + databaseName + pString;
        this.__getserver().putPropertiesFromString(serverProps);
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        block16: {
            super.doStart();
            if (HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.INFO)) {
                HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)("Starting " + this.__getserver().getProductName() + " " + this.__getserver().getProductVersion() + " on port " + this.portNumber));
            }
            if (HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) {
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("serverState=" + this.__getserver().getState()));
            }
            this.__getserver().start();
            int retryNb = 0;
            while (this.__getserver().getState() != 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    HsqlDBServiceImpl.getLogger().log(BasicLevel.ERROR, (Object)"Can't wait that the service is online", (Throwable)ie);
                }
                if (this.__getserver().getState() == 16 && ++retryNb >= 20) {
                    Throwable t = this.__getserver().getServerError();
                    throw new ServiceException("The server was shutdown :", t);
                }
                if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) continue;
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("retry=" + retryNb + ", serverState=" + this.__getserver().getState()));
            }
            HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)(this.__getserver().getProductName() + " started."));
            Connection conn = null;
            Statement st = null;
            try {
                Class.forName("org.hsqldb.jdbcDriver");
                conn = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost:" + this.portNumber + "/" + this.__getdatabaseName(), "sa", "");
                st = conn.createStatement();
            }
            catch (Exception e) {
                throw new ServiceException("Cannot access to HSQL", (Throwable)e);
            }
            User user2 = null;
            String userName = null;
            String password = null;
            ResultSet rs = null;
            for (User user2 : this.__getusers()) {
                try {
                    block15: {
                        password = user2.getPassword();
                        userName = user2.getUserName();
                        HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)("Dropping and adding user '" + userName + "' with password '" + password + "'."));
                        try {
                            rs = st.executeQuery("DROP USER " + userName);
                        }
                        catch (Exception ee) {
                            if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) break block15;
                            HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("User '" + userName + "' doesn't exists"), (Throwable)ee);
                        }
                    }
                    rs = st.executeQuery("Create USER " + userName + " PASSWORD " + password + " ADMIN");
                    rs.close();
                }
                catch (Exception e) {
                    HsqlDBServiceImpl.getLogger().log(BasicLevel.ERROR, (Object)"Error while creating/adding user", (Throwable)e);
                }
            }
            try {
                st.close();
            }
            catch (Exception e) {
                if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) break block16;
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)"Error while closing statement object", (Throwable)e);
            }
        }
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        super.doStop();
        this.__getserver().shutdown();
        HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)(this.__getserver().getProductName() + " stopped."));
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("databaseName")) {
                this.__FdatabaseName = true;
            }
            if (set.contains("server")) {
                this.__Fserver = true;
            }
            if (set.contains("users")) {
                this.__Fusers = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initServer$java_util_List$java_lang_String$java_lang_String")) {
                this.__MinitServer$java_util_List$java_lang_String$java_lang_String = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

