/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLAnyAttributeMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeObjectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public class XPathNode {
    private NodeValue unmarshalNodeValue;
    private NodeValue marshalNodeValue;
    private boolean isMarshalOnlyNodeValue;
    private XPathFragment xPathFragment;
    private XPathNode parent;
    private List<XPathNode> attributeChildren;
    private List<XPathNode> nonAttributeChildren;
    private List<XPathNode> selfChildren;
    private Map<XPathFragment, XPathNode> attributeChildrenMap;
    private Map<XPathFragment, XPathNode> nonAttributeChildrenMap;
    private XMLAnyAttributeMappingNodeValue anyAttributeNodeValue;
    private XPathNode anyAttributeNode;
    private XPathNode textNode;
    private XPathNode anyNode;
    private boolean hasTypeChild;
    private boolean hasPredicateSiblings;
    private boolean hasPredicateChildren;

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public NodeValue getNodeValue() {
        return this.unmarshalNodeValue;
    }

    public void setNodeValue(NodeValue nodeValue) {
        this.marshalNodeValue = nodeValue;
        this.unmarshalNodeValue = nodeValue;
        if (nodeValue != null) {
            nodeValue.setXPathNode(this);
            this.isMarshalOnlyNodeValue = nodeValue.isMarshalOnlyNodeValue();
        }
    }

    public NodeValue getUnmarshalNodeValue() {
        return this.unmarshalNodeValue;
    }

    public void setUnmarshalNodeValue(NodeValue nodeValue) {
        if (nodeValue != null) {
            nodeValue.setXPathNode(this);
        }
        this.unmarshalNodeValue = nodeValue;
    }

    public NodeValue getMarshalNodeValue() {
        return this.marshalNodeValue;
    }

    public void setMarshalNodeValue(NodeValue nodeValue) {
        if (nodeValue != null) {
            nodeValue.setXPathNode(this);
        }
        this.marshalNodeValue = nodeValue;
        this.isMarshalOnlyNodeValue = this.marshalNodeValue.isMarshalOnlyNodeValue();
    }

    public XPathNode getParent() {
        return this.parent;
    }

    public void setParent(XPathNode parent) {
        this.parent = parent;
    }

    public List<XPathNode> getAttributeChildren() {
        return this.attributeChildren;
    }

    public List<XPathNode> getNonAttributeChildren() {
        return this.nonAttributeChildren;
    }

    public List<XPathNode> getSelfChildren() {
        return this.selfChildren;
    }

    public Map<XPathFragment, XPathNode> getNonAttributeChildrenMap() {
        return this.nonAttributeChildrenMap;
    }

    public Map<XPathFragment, XPathNode> getAttributeChildrenMap() {
        return this.attributeChildrenMap;
    }

    public void setAnyAttributeNodeValue(XMLAnyAttributeMappingNodeValue nodeValue) {
        this.anyAttributeNodeValue = nodeValue;
    }

    public XMLAnyAttributeMappingNodeValue getAnyAttributeNodeValue() {
        return this.anyAttributeNodeValue;
    }

    public XPathNode getAnyAttributeNode() {
        return this.anyAttributeNode;
    }

    public XPathNode getAnyNode() {
        return this.anyNode;
    }

    public void setAnyNode(XPathNode xPathNode) {
        this.anyNode = xPathNode;
    }

    public XPathNode getTextNode() {
        return this.textNode;
    }

    public void setTextNode(XPathNode xPathNode) {
        this.textNode = xPathNode;
    }

    public boolean hasTypeChild() {
        return this.hasTypeChild;
    }

    public boolean equals(Object object) {
        XPathFragment perfNodeXPathFragment;
        block7: {
            block6: {
                block5: {
                    try {
                        perfNodeXPathFragment = ((XPathNode)object).getXPathFragment();
                        if (this.xPathFragment != perfNodeXPathFragment) break block5;
                        return true;
                    }
                    catch (ClassCastException classCastException) {
                        return false;
                    }
                }
                if (this.xPathFragment != null) break block6;
                return false;
            }
            if (perfNodeXPathFragment != null) break block7;
            return false;
        }
        return this.xPathFragment.equals(perfNodeXPathFragment);
    }

    public XPathNode addChild(XPathFragment anXPathFragment, NodeValue aNodeValue, NamespaceResolver namespaceResolver) {
        boolean isSelfFragment;
        Map<XPathFragment, XPathNode> childrenMap;
        List<XPathNode> children;
        if (anXPathFragment != null && anXPathFragment.nameIsText() && aNodeValue.isOwningNode(anXPathFragment)) {
            XPathNode textXPathNode = this.getTextNode();
            if (textXPathNode == null) {
                textXPathNode = new XPathNode();
            }
            textXPathNode.setParent(this);
            textXPathNode.setXPathFragment(anXPathFragment);
            if (aNodeValue.isMarshalNodeValue()) {
                textXPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue()) {
                textXPathNode.setUnmarshalNodeValue(aNodeValue);
            }
            this.setTextNode(textXPathNode);
            if (this.nonAttributeChildren != null && !this.nonAttributeChildren.contains(textXPathNode)) {
                this.nonAttributeChildren.add(textXPathNode);
            }
            if (aNodeValue instanceof XMLCompositeObjectMappingNodeValue) {
                if (this.selfChildren == null) {
                    this.selfChildren = new ArrayList<XPathNode>();
                }
                this.selfChildren.add(textXPathNode);
            }
            return textXPathNode;
        }
        if (anXPathFragment != null && namespaceResolver != null && anXPathFragment.getNamespaceURI() == null && !anXPathFragment.nameIsText()) {
            if (!anXPathFragment.isAttribute()) {
                anXPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(anXPathFragment.getPrefix()));
            } else if (anXPathFragment.hasNamespace()) {
                anXPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(anXPathFragment.getPrefix()));
            }
        }
        XPathNode xPathNode = new XPathNode();
        xPathNode.setXPathFragment(anXPathFragment);
        if (anXPathFragment != null && anXPathFragment.isAttribute()) {
            if (this.attributeChildren == null) {
                this.attributeChildren = new ArrayList<XPathNode>();
            }
            if (this.attributeChildrenMap == null) {
                this.attributeChildrenMap = new HashMap<XPathFragment, XPathNode>();
            }
            children = this.attributeChildren;
            childrenMap = this.attributeChildrenMap;
        } else {
            if (this.nonAttributeChildren == null) {
                this.nonAttributeChildren = new ArrayList<XPathNode>();
                if (this.textNode != null) {
                    this.nonAttributeChildren.add(this.textNode);
                }
            }
            if (this.nonAttributeChildrenMap == null) {
                this.nonAttributeChildrenMap = new HashMap<XPathFragment, XPathNode>();
            }
            if (anXPathFragment != null && "type".equals(anXPathFragment.getLocalName())) {
                this.hasTypeChild = true;
            }
            children = this.nonAttributeChildren;
            childrenMap = this.nonAttributeChildrenMap;
        }
        if (anXPathFragment == null) {
            if (aNodeValue.isMarshalNodeValue()) {
                xPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue() && xPathNode.getUnmarshalNodeValue() == null) {
                xPathNode.setUnmarshalNodeValue(aNodeValue);
            }
            xPathNode.setParent(this);
            if (aNodeValue instanceof XMLAnyAttributeMappingNodeValue) {
                this.setAnyAttributeNodeValue((XMLAnyAttributeMappingNodeValue)aNodeValue);
                this.anyAttributeNode = xPathNode;
            } else {
                if (!children.contains(xPathNode)) {
                    children.add(xPathNode);
                }
                this.setAnyNode(xPathNode);
            }
            return xPathNode;
        }
        boolean bl = this.hasPredicateChildren = this.hasPredicateChildren || anXPathFragment.getPredicate() != null;
        if (this.getNonAttributeChildren() != null && this.hasPredicateChildren) {
            for (XPathNode nextChild : this.getNonAttributeChildren()) {
                XPathFragment nextFrag = nextChild.getXPathFragment();
                if (nextFrag == null || !nextFrag.equals(anXPathFragment, true)) continue;
                if (nextFrag.getPredicate() == null && anXPathFragment.getPredicate() != null) {
                    nextChild.setHasPredicateSiblings(true);
                    continue;
                }
                if (anXPathFragment.getPredicate() != null || nextFrag.getPredicate() == null) continue;
                xPathNode.setHasPredicateSiblings(true);
            }
        }
        if (isSelfFragment = XPathFragment.SELF_FRAGMENT.equals(anXPathFragment)) {
            children.add(xPathNode);
            if (this.selfChildren == null) {
                this.selfChildren = new ArrayList<XPathNode>();
            }
            this.selfChildren.add(xPathNode);
        } else {
            int index = children.indexOf(xPathNode);
            if (index >= 0) {
                xPathNode = children.get(index);
            } else {
                xPathNode.setParent(this);
                if (!children.contains(xPathNode)) {
                    children.add(xPathNode);
                }
                childrenMap.put(anXPathFragment, xPathNode);
            }
        }
        if (aNodeValue.isOwningNode(anXPathFragment)) {
            if (aNodeValue.isMarshalNodeValue()) {
                xPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue() && xPathNode.getUnmarshalNodeValue() == null) {
                xPathNode.setUnmarshalNodeValue(aNodeValue);
            }
        } else {
            XPathFragment nextFragment = anXPathFragment.getNextFragment();
            xPathNode.addChild(nextFragment, aNodeValue, namespaceResolver);
        }
        return xPathNode;
    }

    private void setHasPredicateSiblings(boolean b) {
        this.hasPredicateSiblings = b;
    }

    public boolean hasPredicateSiblings() {
        return this.hasPredicateSiblings;
    }

    public boolean marshal(MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, XMLMarshaller marshaller, MarshalContext marshalContext, XPathFragment rootFragment) {
        if (this.marshalNodeValue == null || this.isMarshalOnlyNodeValue) {
            XPathNode xPathNode;
            if (marshalRecord.isWrapperAsCollectionName() && this.nonAttributeChildren != null && this.nonAttributeChildren.size() == 1) {
                ContainerValue containerValue;
                XPathNode childXPathNode = this.nonAttributeChildren.get(0);
                NodeValue childXPathNodeUnmarshalNodeValue = childXPathNode.getUnmarshalNodeValue();
                if (childXPathNode != null && childXPathNodeUnmarshalNodeValue.isContainerValue() && (containerValue = (ContainerValue)((Object)childXPathNodeUnmarshalNodeValue)).isWrapperAllowedAsCollectionName()) {
                    XPathNode wrapperXPathNode = new XPathNode();
                    wrapperXPathNode.setXPathFragment(this.getXPathFragment());
                    wrapperXPathNode.setMarshalNodeValue(childXPathNode.getMarshalNodeValue());
                    return wrapperXPathNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, marshalContext, rootFragment);
                }
            }
            marshalRecord.addGroupingElement(this);
            boolean hasValue = false;
            if (this.attributeChildren != null) {
                int x = 0;
                int size = this.attributeChildren.size();
                while (x < size) {
                    xPathNode = this.attributeChildren.get(x);
                    hasValue = xPathNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, ObjectMarshalContext.getInstance(), this.xPathFragment) || hasValue;
                    ++x;
                }
            }
            if (this.anyAttributeNode != null) {
                boolean bl = hasValue = this.anyAttributeNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, ObjectMarshalContext.getInstance(), null) || hasValue;
            }
            if (this.nonAttributeChildren == null) {
                if (this.textNode != null) {
                    hasValue = this.textNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, ObjectMarshalContext.getInstance(), null) || hasValue;
                }
            } else {
                int x = 0;
                int size = marshalContext.getNonAttributeChildrenSize(this);
                while (x < size) {
                    MarshalContext childMarshalContext;
                    xPathNode = (XPathNode)marshalContext.getNonAttributeChild(x, this);
                    hasValue = xPathNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, childMarshalContext = marshalContext.getMarshalContext(x), this.xPathFragment) || hasValue;
                    ++x;
                }
            }
            if (hasValue) {
                marshalRecord.endElement(this.xPathFragment, namespaceResolver);
            } else {
                marshalRecord.removeGroupingElement(this);
            }
            return hasValue;
        }
        return marshalContext.marshal(this.marshalNodeValue, this.xPathFragment, marshalRecord, object, session, namespaceResolver, rootFragment);
    }

    public boolean startElement(MarshalRecord marshalRecord, XPathFragment anXPathFragment, Object object, AbstractSession session, NamespaceResolver namespaceResolver, TreeObjectBuilder compositeObjectBuilder, Object compositeObject) {
        if (anXPathFragment == null) {
            return false;
        }
        marshalRecord.openStartElement(anXPathFragment, namespaceResolver);
        boolean hasValue = false;
        marshalRecord.predicateAttribute(anXPathFragment, namespaceResolver);
        if (this.attributeChildren != null) {
            int x = 0;
            int size = this.attributeChildren.size();
            while (x < size) {
                XPathNode attributeNode = this.attributeChildren.get(x);
                hasValue = attributeNode.marshal(marshalRecord, object, session, namespaceResolver, null, ObjectMarshalContext.getInstance(), null) || hasValue;
                ++x;
            }
        }
        if (this.anyAttributeNode != null) {
            boolean bl = hasValue = this.anyAttributeNode.marshal(marshalRecord, object, session, namespaceResolver, null, ObjectMarshalContext.getInstance(), null) || hasValue;
        }
        if (compositeObjectBuilder != null) {
            hasValue = compositeObjectBuilder.marshalAttributes(marshalRecord, compositeObject, session) || hasValue;
        }
        marshalRecord.closeStartElement();
        return hasValue;
    }

    public boolean marshalSelfAttributes(MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, XMLMarshaller marshaller) {
        if (this.marshalNodeValue == null) {
            return false;
        }
        return this.marshalNodeValue.marshalSelfAttributes(this.xPathFragment, marshalRecord, object, session, namespaceResolver, marshaller);
    }

    public boolean isWhitespaceAware() {
        return this.unmarshalNodeValue.isWhitespaceAware();
    }
}

